// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Contains the notebook instance lifecycle configuration script.
 *
 * Each lifecycle configuration script has a limit of 16384 characters.
 *
 * The value of the `$PATH` environment variable that is available to both scripts is `/sbin:bin:/usr/sbin:/usr/bin`.
 *
 * View CloudWatch Logs for notebook instance lifecycle configurations in log group `/aws/sagemaker/NotebookInstances` in log stream `[notebook-instance-name]/[LifecycleConfigHook]`.
 *
 * Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs for longer than 5 minutes, it fails and the notebook instance is not created or started.
 *
 * For information about notebook instance lifestyle configurations, see [Step 2.1: (Optional) Customize a Notebook Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
 */
class NotebookInstanceLifecycleHook private constructor(builder: Builder) {
    /**
     * A base64-encoded string that contains a shell script for a notebook instance lifecycle configuration.
     */
    val content: kotlin.String? = builder.content

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.NotebookInstanceLifecycleHook = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NotebookInstanceLifecycleHook(")
        append("content=$content)")
    }

    override fun hashCode(): kotlin.Int {
        var result = content?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NotebookInstanceLifecycleHook

        if (content != other.content) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.NotebookInstanceLifecycleHook = Builder(this).apply(block).build()

    class Builder {
        /**
         * A base64-encoded string that contains a shell script for a notebook instance lifecycle configuration.
         */
        var content: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.NotebookInstanceLifecycleHook) : this() {
            this.content = x.content
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.NotebookInstanceLifecycleHook = NotebookInstanceLifecycleHook(this)
    }
}
