// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides summary information for an SageMaker notebook instance.
 */
class NotebookInstanceSummary private constructor(builder: Builder) {
    /**
     * An array of up to three Git repositories associated with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in [Amazon Web Services CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see [Associating Git Repositories with SageMaker Notebook Instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
     */
    val additionalCodeRepositories: List<String>? = builder.additionalCodeRepositories
    /**
     * A timestamp that shows when the notebook instance was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in [Amazon Web Services CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see [Associating Git Repositories with SageMaker Notebook Instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
     */
    val defaultCodeRepository: kotlin.String? = builder.defaultCodeRepository
    /**
     * The type of ML compute instance that the notebook instance is running on.
     */
    val instanceType: aws.sdk.kotlin.services.sagemaker.model.InstanceType? = builder.instanceType
    /**
     * A timestamp that shows when the notebook instance was last modified.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The Amazon Resource Name (ARN) of the notebook instance.
     */
    val notebookInstanceArn: kotlin.String? = builder.notebookInstanceArn
    /**
     * The name of a notebook instance lifecycle configuration associated with this notebook instance.
     *
     * For information about notebook instance lifestyle configurations, see [Step 2.1: (Optional) Customize a Notebook Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
     */
    val notebookInstanceLifecycleConfigName: kotlin.String? = builder.notebookInstanceLifecycleConfigName
    /**
     * The name of the notebook instance that you want a summary for.
     */
    val notebookInstanceName: kotlin.String? = builder.notebookInstanceName
    /**
     * The status of the notebook instance.
     */
    val notebookInstanceStatus: aws.sdk.kotlin.services.sagemaker.model.NotebookInstanceStatus? = builder.notebookInstanceStatus
    /**
     * The URL that you use to connect to the Jupyter notebook running in your notebook instance.
     */
    val url: kotlin.String? = builder.url

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.NotebookInstanceSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NotebookInstanceSummary(")
        append("additionalCodeRepositories=$additionalCodeRepositories,")
        append("creationTime=$creationTime,")
        append("defaultCodeRepository=$defaultCodeRepository,")
        append("instanceType=$instanceType,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("notebookInstanceArn=$notebookInstanceArn,")
        append("notebookInstanceLifecycleConfigName=$notebookInstanceLifecycleConfigName,")
        append("notebookInstanceName=$notebookInstanceName,")
        append("notebookInstanceStatus=$notebookInstanceStatus,")
        append("url=$url)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalCodeRepositories?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (defaultCodeRepository?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (notebookInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (notebookInstanceLifecycleConfigName?.hashCode() ?: 0)
        result = 31 * result + (notebookInstanceName?.hashCode() ?: 0)
        result = 31 * result + (notebookInstanceStatus?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NotebookInstanceSummary

        if (additionalCodeRepositories != other.additionalCodeRepositories) return false
        if (creationTime != other.creationTime) return false
        if (defaultCodeRepository != other.defaultCodeRepository) return false
        if (instanceType != other.instanceType) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (notebookInstanceArn != other.notebookInstanceArn) return false
        if (notebookInstanceLifecycleConfigName != other.notebookInstanceLifecycleConfigName) return false
        if (notebookInstanceName != other.notebookInstanceName) return false
        if (notebookInstanceStatus != other.notebookInstanceStatus) return false
        if (url != other.url) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.NotebookInstanceSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * An array of up to three Git repositories associated with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in [Amazon Web Services CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see [Associating Git Repositories with SageMaker Notebook Instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
         */
        var additionalCodeRepositories: List<String>? = null
        /**
         * A timestamp that shows when the notebook instance was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in [Amazon Web Services CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see [Associating Git Repositories with SageMaker Notebook Instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
         */
        var defaultCodeRepository: kotlin.String? = null
        /**
         * The type of ML compute instance that the notebook instance is running on.
         */
        var instanceType: aws.sdk.kotlin.services.sagemaker.model.InstanceType? = null
        /**
         * A timestamp that shows when the notebook instance was last modified.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the notebook instance.
         */
        var notebookInstanceArn: kotlin.String? = null
        /**
         * The name of a notebook instance lifecycle configuration associated with this notebook instance.
         *
         * For information about notebook instance lifestyle configurations, see [Step 2.1: (Optional) Customize a Notebook Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
         */
        var notebookInstanceLifecycleConfigName: kotlin.String? = null
        /**
         * The name of the notebook instance that you want a summary for.
         */
        var notebookInstanceName: kotlin.String? = null
        /**
         * The status of the notebook instance.
         */
        var notebookInstanceStatus: aws.sdk.kotlin.services.sagemaker.model.NotebookInstanceStatus? = null
        /**
         * The URL that you use to connect to the Jupyter notebook running in your notebook instance.
         */
        var url: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.NotebookInstanceSummary) : this() {
            this.additionalCodeRepositories = x.additionalCodeRepositories
            this.creationTime = x.creationTime
            this.defaultCodeRepository = x.defaultCodeRepository
            this.instanceType = x.instanceType
            this.lastModifiedTime = x.lastModifiedTime
            this.notebookInstanceArn = x.notebookInstanceArn
            this.notebookInstanceLifecycleConfigName = x.notebookInstanceLifecycleConfigName
            this.notebookInstanceName = x.notebookInstanceName
            this.notebookInstanceStatus = x.notebookInstanceStatus
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.NotebookInstanceSummary = NotebookInstanceSummary(this)
    }
}
