// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * The production variant summary for a deployment when an endpoint is creating or updating with the ` <a>CreateEndpoint</a> ` or ` <a>UpdateEndpoint</a> ` operations. Describes the `VariantStatus `, weight and capacity for a production variant associated with an endpoint.
 */
class PendingProductionVariantSummary private constructor(builder: Builder) {
    /**
     * The size of the Elastic Inference (EI) instance to use for the production variant. EI instances provide on-demand GPU computing for inference. For more information, see [Using Elastic Inference in Amazon SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html).
     */
    val acceleratorType: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantAcceleratorType? = builder.acceleratorType
    /**
     * The number of instances associated with the variant.
     */
    val currentInstanceCount: kotlin.Int? = builder.currentInstanceCount
    /**
     * The serverless configuration for the endpoint.
     */
    val currentServerlessConfig: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig? = builder.currentServerlessConfig
    /**
     * The weight associated with the variant.
     */
    val currentWeight: kotlin.Float? = builder.currentWeight
    /**
     * An array of `DeployedImage` objects that specify the Amazon EC2 Container Registry paths of the inference images deployed on instances of this `ProductionVariant`.
     */
    val deployedImages: List<DeployedImage>? = builder.deployedImages
    /**
     * The number of instances requested in this deployment, as specified in the endpoint configuration for the endpoint. The value is taken from the request to the ` <a>CreateEndpointConfig</a> ` operation.
     */
    val desiredInstanceCount: kotlin.Int? = builder.desiredInstanceCount
    /**
     * The serverless configuration requested for this deployment, as specified in the endpoint configuration for the endpoint.
     */
    val desiredServerlessConfig: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig? = builder.desiredServerlessConfig
    /**
     * The requested weight for the variant in this deployment, as specified in the endpoint configuration for the endpoint. The value is taken from the request to the ` <a>CreateEndpointConfig</a> ` operation.
     */
    val desiredWeight: kotlin.Float? = builder.desiredWeight
    /**
     * The type of instances associated with the variant.
     */
    val instanceType: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantInstanceType? = builder.instanceType
    /**
     * The name of the variant.
     */
    val variantName: kotlin.String? = builder.variantName
    /**
     * The endpoint variant status which describes the current deployment stage status or operational status.
     */
    val variantStatus: List<ProductionVariantStatus>? = builder.variantStatus

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.PendingProductionVariantSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PendingProductionVariantSummary(")
        append("acceleratorType=$acceleratorType,")
        append("currentInstanceCount=$currentInstanceCount,")
        append("currentServerlessConfig=$currentServerlessConfig,")
        append("currentWeight=$currentWeight,")
        append("deployedImages=$deployedImages,")
        append("desiredInstanceCount=$desiredInstanceCount,")
        append("desiredServerlessConfig=$desiredServerlessConfig,")
        append("desiredWeight=$desiredWeight,")
        append("instanceType=$instanceType,")
        append("variantName=$variantName,")
        append("variantStatus=$variantStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceleratorType?.hashCode() ?: 0
        result = 31 * result + (currentInstanceCount ?: 0)
        result = 31 * result + (currentServerlessConfig?.hashCode() ?: 0)
        result = 31 * result + (currentWeight?.hashCode() ?: 0)
        result = 31 * result + (deployedImages?.hashCode() ?: 0)
        result = 31 * result + (desiredInstanceCount ?: 0)
        result = 31 * result + (desiredServerlessConfig?.hashCode() ?: 0)
        result = 31 * result + (desiredWeight?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (variantName?.hashCode() ?: 0)
        result = 31 * result + (variantStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PendingProductionVariantSummary

        if (acceleratorType != other.acceleratorType) return false
        if (currentInstanceCount != other.currentInstanceCount) return false
        if (currentServerlessConfig != other.currentServerlessConfig) return false
        if (currentWeight != other.currentWeight) return false
        if (deployedImages != other.deployedImages) return false
        if (desiredInstanceCount != other.desiredInstanceCount) return false
        if (desiredServerlessConfig != other.desiredServerlessConfig) return false
        if (desiredWeight != other.desiredWeight) return false
        if (instanceType != other.instanceType) return false
        if (variantName != other.variantName) return false
        if (variantStatus != other.variantStatus) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.PendingProductionVariantSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The size of the Elastic Inference (EI) instance to use for the production variant. EI instances provide on-demand GPU computing for inference. For more information, see [Using Elastic Inference in Amazon SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html).
         */
        var acceleratorType: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantAcceleratorType? = null
        /**
         * The number of instances associated with the variant.
         */
        var currentInstanceCount: kotlin.Int? = null
        /**
         * The serverless configuration for the endpoint.
         */
        var currentServerlessConfig: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig? = null
        /**
         * The weight associated with the variant.
         */
        var currentWeight: kotlin.Float? = null
        /**
         * An array of `DeployedImage` objects that specify the Amazon EC2 Container Registry paths of the inference images deployed on instances of this `ProductionVariant`.
         */
        var deployedImages: List<DeployedImage>? = null
        /**
         * The number of instances requested in this deployment, as specified in the endpoint configuration for the endpoint. The value is taken from the request to the ` <a>CreateEndpointConfig</a> ` operation.
         */
        var desiredInstanceCount: kotlin.Int? = null
        /**
         * The serverless configuration requested for this deployment, as specified in the endpoint configuration for the endpoint.
         */
        var desiredServerlessConfig: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig? = null
        /**
         * The requested weight for the variant in this deployment, as specified in the endpoint configuration for the endpoint. The value is taken from the request to the ` <a>CreateEndpointConfig</a> ` operation.
         */
        var desiredWeight: kotlin.Float? = null
        /**
         * The type of instances associated with the variant.
         */
        var instanceType: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantInstanceType? = null
        /**
         * The name of the variant.
         */
        var variantName: kotlin.String? = null
        /**
         * The endpoint variant status which describes the current deployment stage status or operational status.
         */
        var variantStatus: List<ProductionVariantStatus>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.PendingProductionVariantSummary) : this() {
            this.acceleratorType = x.acceleratorType
            this.currentInstanceCount = x.currentInstanceCount
            this.currentServerlessConfig = x.currentServerlessConfig
            this.currentWeight = x.currentWeight
            this.deployedImages = x.deployedImages
            this.desiredInstanceCount = x.desiredInstanceCount
            this.desiredServerlessConfig = x.desiredServerlessConfig
            this.desiredWeight = x.desiredWeight
            this.instanceType = x.instanceType
            this.variantName = x.variantName
            this.variantStatus = x.variantStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.PendingProductionVariantSummary = PendingProductionVariantSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig] inside the given [block]
         */
        fun currentServerlessConfig(block: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig.Builder.() -> kotlin.Unit) {
            this.currentServerlessConfig = aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig] inside the given [block]
         */
        fun desiredServerlessConfig(block: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig.Builder.() -> kotlin.Unit) {
            this.desiredServerlessConfig = aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig.invoke(block)
        }
    }
}
