// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * The Amazon Simple Storage (Amazon S3) location and and security configuration for `OfflineStore`.
 */
class S3StorageConfig private constructor(builder: Builder) {
    /**
     * The Amazon Web Services Key Management Service (KMS) key ID of the key used to encrypt any objects written into the `OfflineStore` S3 location.
     *
     * The IAM `roleARN` that is passed as a parameter to `CreateFeatureGroup` must have below permissions to the `KmsKeyId`:
     * + `"kms:GenerateDataKey"`
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The S3 path where offline records are written.
     */
    val resolvedOutputS3Uri: kotlin.String? = builder.resolvedOutputS3Uri
    /**
     * The S3 URI, or location in Amazon S3, of `OfflineStore`.
     *
     * S3 URIs have a format similar to the following: `s3://example-bucket/prefix/`.
     */
    val s3Uri: kotlin.String? = builder.s3Uri

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.S3StorageConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3StorageConfig(")
        append("kmsKeyId=$kmsKeyId,")
        append("resolvedOutputS3Uri=$resolvedOutputS3Uri,")
        append("s3Uri=$s3Uri)")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (resolvedOutputS3Uri?.hashCode() ?: 0)
        result = 31 * result + (s3Uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3StorageConfig

        if (kmsKeyId != other.kmsKeyId) return false
        if (resolvedOutputS3Uri != other.resolvedOutputS3Uri) return false
        if (s3Uri != other.s3Uri) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.S3StorageConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Web Services Key Management Service (KMS) key ID of the key used to encrypt any objects written into the `OfflineStore` S3 location.
         *
         * The IAM `roleARN` that is passed as a parameter to `CreateFeatureGroup` must have below permissions to the `KmsKeyId`:
         * + `"kms:GenerateDataKey"`
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The S3 path where offline records are written.
         */
        var resolvedOutputS3Uri: kotlin.String? = null
        /**
         * The S3 URI, or location in Amazon S3, of `OfflineStore`.
         *
         * S3 URIs have a format similar to the following: `s3://example-bucket/prefix/`.
         */
        var s3Uri: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.S3StorageConfig) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.resolvedOutputS3Uri = x.resolvedOutputS3Uri
            this.s3Uri = x.s3Uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.S3StorageConfig = S3StorageConfig(this)
    }
}
