// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * A list of IP address ranges ([CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)). Used to create an allow list of IP addresses for a private workforce. Workers will only be able to login to their worker portal from an IP address within this range. By default, a workforce isn't restricted to specific IP addresses.
 */
class SourceIpConfig private constructor(builder: Builder) {
    /**
     * A list of one to ten [Classless Inter-Domain Routing](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) (CIDR) values.
     *
     * Maximum: Ten CIDR values
     *
     * The following Length Constraints apply to individual CIDR values in the CIDR value list.
     */
    val cidrs: List<String>? = builder.cidrs

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SourceIpConfig(")
        append("cidrs=$cidrs)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidrs?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SourceIpConfig

        if (cidrs != other.cidrs) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of one to ten [Classless Inter-Domain Routing](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) (CIDR) values.
         *
         * Maximum: Ten CIDR values
         *
         * The following Length Constraints apply to individual CIDR values in the CIDR value list.
         */
        var cidrs: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig) : this() {
            this.cidrs = x.cidrs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig = SourceIpConfig(this)
    }
}
