// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Contains information about a target platform that you want your model to run on, such as OS, architecture, and accelerators. It is an alternative of `TargetDevice`.
 */
class TargetPlatform private constructor(builder: Builder) {
    /**
     * Specifies a target platform accelerator (optional).
     * + `NVIDIA`: Nvidia graphics processing unit. It also requires `gpu-code`, `trt-ver`, `cuda-ver` compiler options
     * + `MALI`: ARM Mali graphics processor
     * + `INTEL_GRAPHICS`: Integrated Intel graphics
     */
    val accelerator: aws.sdk.kotlin.services.sagemaker.model.TargetPlatformAccelerator? = builder.accelerator
    /**
     * Specifies a target platform architecture.
     * + `X86_64`: 64-bit version of the x86 instruction set.
     * + `X86`: 32-bit version of the x86 instruction set.
     * + `ARM64`: ARMv8 64-bit CPU.
     * + `ARM_EABIHF`: ARMv7 32-bit, Hard Float.
     * + `ARM_EABI`: ARMv7 32-bit, Soft Float. Used by Android 32-bit ARM platform.
     */
    val arch: aws.sdk.kotlin.services.sagemaker.model.TargetPlatformArch? = builder.arch
    /**
     * Specifies a target platform OS.
     * + `LINUX`: Linux-based operating systems.
     * + `ANDROID`: Android operating systems. Android API level can be specified using the `ANDROID_PLATFORM` compiler option. For example, `"CompilerOptions": {'ANDROID_PLATFORM': 28}`
     */
    val os: aws.sdk.kotlin.services.sagemaker.model.TargetPlatformOs? = builder.os

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.TargetPlatform = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetPlatform(")
        append("accelerator=$accelerator,")
        append("arch=$arch,")
        append("os=$os)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accelerator?.hashCode() ?: 0
        result = 31 * result + (arch?.hashCode() ?: 0)
        result = 31 * result + (os?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetPlatform

        if (accelerator != other.accelerator) return false
        if (arch != other.arch) return false
        if (os != other.os) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.TargetPlatform = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies a target platform accelerator (optional).
         * + `NVIDIA`: Nvidia graphics processing unit. It also requires `gpu-code`, `trt-ver`, `cuda-ver` compiler options
         * + `MALI`: ARM Mali graphics processor
         * + `INTEL_GRAPHICS`: Integrated Intel graphics
         */
        var accelerator: aws.sdk.kotlin.services.sagemaker.model.TargetPlatformAccelerator? = null
        /**
         * Specifies a target platform architecture.
         * + `X86_64`: 64-bit version of the x86 instruction set.
         * + `X86`: 32-bit version of the x86 instruction set.
         * + `ARM64`: ARMv8 64-bit CPU.
         * + `ARM_EABIHF`: ARMv7 32-bit, Hard Float.
         * + `ARM_EABI`: ARMv7 32-bit, Soft Float. Used by Android 32-bit ARM platform.
         */
        var arch: aws.sdk.kotlin.services.sagemaker.model.TargetPlatformArch? = null
        /**
         * Specifies a target platform OS.
         * + `LINUX`: Linux-based operating systems.
         * + `ANDROID`: Android operating systems. Android API level can be specified using the `ANDROID_PLATFORM` compiler option. For example, `"CompilerOptions": {'ANDROID_PLATFORM': 28}`
         */
        var os: aws.sdk.kotlin.services.sagemaker.model.TargetPlatformOs? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.TargetPlatform) : this() {
            this.accelerator = x.accelerator
            this.arch = x.arch
            this.os = x.os
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.TargetPlatform = TargetPlatform(this)
    }
}
