// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The properties of a trial component as returned by the Search API.
 */
class TrialComponent private constructor(builder: Builder) {
    /**
     * Who created the trial component.
     */
    val createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = builder.createdBy
    /**
     * When the component was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The name of the component as displayed. If `DisplayName` isn't specified, `TrialComponentName` is displayed.
     */
    val displayName: kotlin.String? = builder.displayName
    /**
     * When the component ended.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The input artifacts of the component.
     */
    val inputArtifacts: Map<String, TrialComponentArtifact>? = builder.inputArtifacts
    /**
     * Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.
     */
    val lastModifiedBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = builder.lastModifiedBy
    /**
     * When the component was last modified.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The Amazon Resource Name (ARN) of the lineage group resource.
     */
    val lineageGroupArn: kotlin.String? = builder.lineageGroupArn
    /**
     * Metadata properties of the tracking entity, trial, or trial component.
     */
    val metadataProperties: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties? = builder.metadataProperties
    /**
     * The metrics for the component.
     */
    val metrics: List<TrialComponentMetricSummary>? = builder.metrics
    /**
     * The output artifacts of the component.
     */
    val outputArtifacts: Map<String, TrialComponentArtifact>? = builder.outputArtifacts
    /**
     * The hyperparameters of the component.
     */
    val parameters: Map<String, TrialComponentParameterValue>? = builder.parameters
    /**
     * An array of the parents of the component. A parent is a trial the component is associated with and the experiment the trial is part of. A component might not have any parents.
     */
    val parents: List<Parent>? = builder.parents
    /**
     * The Amazon Resource Name (ARN) and job type of the source of the component.
     */
    val source: aws.sdk.kotlin.services.sagemaker.model.TrialComponentSource? = builder.source
    /**
     * Details of the source of the component.
     */
    val sourceDetail: aws.sdk.kotlin.services.sagemaker.model.TrialComponentSourceDetail? = builder.sourceDetail
    /**
     * When the component started.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The status of the trial component.
     */
    val status: aws.sdk.kotlin.services.sagemaker.model.TrialComponentStatus? = builder.status
    /**
     * The list of tags that are associated with the component. You can use Search API to search on the tags.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The Amazon Resource Name (ARN) of the trial component.
     */
    val trialComponentArn: kotlin.String? = builder.trialComponentArn
    /**
     * The name of the trial component.
     */
    val trialComponentName: kotlin.String? = builder.trialComponentName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.TrialComponent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrialComponent(")
        append("createdBy=$createdBy,")
        append("creationTime=$creationTime,")
        append("displayName=$displayName,")
        append("endTime=$endTime,")
        append("inputArtifacts=$inputArtifacts,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("lineageGroupArn=$lineageGroupArn,")
        append("metadataProperties=$metadataProperties,")
        append("metrics=$metrics,")
        append("outputArtifacts=$outputArtifacts,")
        append("parameters=$parameters,")
        append("parents=$parents,")
        append("source=$source,")
        append("sourceDetail=$sourceDetail,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("tags=$tags,")
        append("trialComponentArn=$trialComponentArn,")
        append("trialComponentName=$trialComponentName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdBy?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (inputArtifacts?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedBy?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (lineageGroupArn?.hashCode() ?: 0)
        result = 31 * result + (metadataProperties?.hashCode() ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        result = 31 * result + (outputArtifacts?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (parents?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (sourceDetail?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trialComponentArn?.hashCode() ?: 0)
        result = 31 * result + (trialComponentName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrialComponent

        if (createdBy != other.createdBy) return false
        if (creationTime != other.creationTime) return false
        if (displayName != other.displayName) return false
        if (endTime != other.endTime) return false
        if (inputArtifacts != other.inputArtifacts) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (lineageGroupArn != other.lineageGroupArn) return false
        if (metadataProperties != other.metadataProperties) return false
        if (metrics != other.metrics) return false
        if (outputArtifacts != other.outputArtifacts) return false
        if (parameters != other.parameters) return false
        if (parents != other.parents) return false
        if (source != other.source) return false
        if (sourceDetail != other.sourceDetail) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (trialComponentArn != other.trialComponentArn) return false
        if (trialComponentName != other.trialComponentName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.TrialComponent = Builder(this).apply(block).build()

    class Builder {
        /**
         * Who created the trial component.
         */
        var createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = null
        /**
         * When the component was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the component as displayed. If `DisplayName` isn't specified, `TrialComponentName` is displayed.
         */
        var displayName: kotlin.String? = null
        /**
         * When the component ended.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The input artifacts of the component.
         */
        var inputArtifacts: Map<String, TrialComponentArtifact>? = null
        /**
         * Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.
         */
        var lastModifiedBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = null
        /**
         * When the component was last modified.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the lineage group resource.
         */
        var lineageGroupArn: kotlin.String? = null
        /**
         * Metadata properties of the tracking entity, trial, or trial component.
         */
        var metadataProperties: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties? = null
        /**
         * The metrics for the component.
         */
        var metrics: List<TrialComponentMetricSummary>? = null
        /**
         * The output artifacts of the component.
         */
        var outputArtifacts: Map<String, TrialComponentArtifact>? = null
        /**
         * The hyperparameters of the component.
         */
        var parameters: Map<String, TrialComponentParameterValue>? = null
        /**
         * An array of the parents of the component. A parent is a trial the component is associated with and the experiment the trial is part of. A component might not have any parents.
         */
        var parents: List<Parent>? = null
        /**
         * The Amazon Resource Name (ARN) and job type of the source of the component.
         */
        var source: aws.sdk.kotlin.services.sagemaker.model.TrialComponentSource? = null
        /**
         * Details of the source of the component.
         */
        var sourceDetail: aws.sdk.kotlin.services.sagemaker.model.TrialComponentSourceDetail? = null
        /**
         * When the component started.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the trial component.
         */
        var status: aws.sdk.kotlin.services.sagemaker.model.TrialComponentStatus? = null
        /**
         * The list of tags that are associated with the component. You can use Search API to search on the tags.
         */
        var tags: List<Tag>? = null
        /**
         * The Amazon Resource Name (ARN) of the trial component.
         */
        var trialComponentArn: kotlin.String? = null
        /**
         * The name of the trial component.
         */
        var trialComponentName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.TrialComponent) : this() {
            this.createdBy = x.createdBy
            this.creationTime = x.creationTime
            this.displayName = x.displayName
            this.endTime = x.endTime
            this.inputArtifacts = x.inputArtifacts
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedTime = x.lastModifiedTime
            this.lineageGroupArn = x.lineageGroupArn
            this.metadataProperties = x.metadataProperties
            this.metrics = x.metrics
            this.outputArtifacts = x.outputArtifacts
            this.parameters = x.parameters
            this.parents = x.parents
            this.source = x.source
            this.sourceDetail = x.sourceDetail
            this.startTime = x.startTime
            this.status = x.status
            this.tags = x.tags
            this.trialComponentArn = x.trialComponentArn
            this.trialComponentName = x.trialComponentName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.TrialComponent = TrialComponent(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserContext] inside the given [block]
         */
        fun createdBy(block: aws.sdk.kotlin.services.sagemaker.model.UserContext.Builder.() -> kotlin.Unit) {
            this.createdBy = aws.sdk.kotlin.services.sagemaker.model.UserContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserContext] inside the given [block]
         */
        fun lastModifiedBy(block: aws.sdk.kotlin.services.sagemaker.model.UserContext.Builder.() -> kotlin.Unit) {
            this.lastModifiedBy = aws.sdk.kotlin.services.sagemaker.model.UserContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MetadataProperties] inside the given [block]
         */
        fun metadataProperties(block: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties.Builder.() -> kotlin.Unit) {
            this.metadataProperties = aws.sdk.kotlin.services.sagemaker.model.MetadataProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TrialComponentSource] inside the given [block]
         */
        fun source(block: aws.sdk.kotlin.services.sagemaker.model.TrialComponentSource.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.sagemaker.model.TrialComponentSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TrialComponentSourceDetail] inside the given [block]
         */
        fun sourceDetail(block: aws.sdk.kotlin.services.sagemaker.model.TrialComponentSourceDetail.Builder.() -> kotlin.Unit) {
            this.sourceDetail = aws.sdk.kotlin.services.sagemaker.model.TrialComponentSourceDetail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TrialComponentStatus] inside the given [block]
         */
        fun status(block: aws.sdk.kotlin.services.sagemaker.model.TrialComponentStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.sagemaker.model.TrialComponentStatus.invoke(block)
        }
    }
}
