// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



class UpdateDeviceFleetRequest private constructor(builder: Builder) {
    /**
     * Description of the fleet.
     */
    val description: kotlin.String? = builder.description
    /**
     * The name of the fleet.
     */
    val deviceFleetName: kotlin.String? = builder.deviceFleetName
    /**
     * Whether to create an Amazon Web Services IoT Role Alias during device fleet creation. The name of the role alias generated will match this pattern: "SageMakerEdge-{DeviceFleetName}".
     *
     * For example, if your device fleet is called "demo-fleet", the name of the role alias will be "SageMakerEdge-demo-fleet".
     */
    val enableIotRoleAlias: kotlin.Boolean? = builder.enableIotRoleAlias
    /**
     * Output configuration for storing sample data collected by the fleet.
     */
    val outputConfig: aws.sdk.kotlin.services.sagemaker.model.EdgeOutputConfig? = builder.outputConfig
    /**
     * The Amazon Resource Name (ARN) of the device.
     */
    val roleArn: kotlin.String? = builder.roleArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.UpdateDeviceFleetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDeviceFleetRequest(")
        append("description=$description,")
        append("deviceFleetName=$deviceFleetName,")
        append("enableIotRoleAlias=$enableIotRoleAlias,")
        append("outputConfig=$outputConfig,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (deviceFleetName?.hashCode() ?: 0)
        result = 31 * result + (enableIotRoleAlias?.hashCode() ?: 0)
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateDeviceFleetRequest

        if (description != other.description) return false
        if (deviceFleetName != other.deviceFleetName) return false
        if (enableIotRoleAlias != other.enableIotRoleAlias) return false
        if (outputConfig != other.outputConfig) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.UpdateDeviceFleetRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Description of the fleet.
         */
        var description: kotlin.String? = null
        /**
         * The name of the fleet.
         */
        var deviceFleetName: kotlin.String? = null
        /**
         * Whether to create an Amazon Web Services IoT Role Alias during device fleet creation. The name of the role alias generated will match this pattern: "SageMakerEdge-{DeviceFleetName}".
         *
         * For example, if your device fleet is called "demo-fleet", the name of the role alias will be "SageMakerEdge-demo-fleet".
         */
        var enableIotRoleAlias: kotlin.Boolean? = null
        /**
         * Output configuration for storing sample data collected by the fleet.
         */
        var outputConfig: aws.sdk.kotlin.services.sagemaker.model.EdgeOutputConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the device.
         */
        var roleArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.UpdateDeviceFleetRequest) : this() {
            this.description = x.description
            this.deviceFleetName = x.deviceFleetName
            this.enableIotRoleAlias = x.enableIotRoleAlias
            this.outputConfig = x.outputConfig
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.UpdateDeviceFleetRequest = UpdateDeviceFleetRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.EdgeOutputConfig] inside the given [block]
         */
        fun outputConfig(block: aws.sdk.kotlin.services.sagemaker.model.EdgeOutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.sagemaker.model.EdgeOutputConfig.invoke(block)
        }
    }
}
