// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A single private workforce, which is automatically created when you create your first private work team. You can create one private work force in each Amazon Web Services Region. By default, any workforce-related API operation used in a specific region will apply to the workforce created in that region. To learn how to create a private workforce, see [Create a Private Workforce](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html).
 */
class Workforce private constructor(builder: Builder) {
    /**
     * The configuration of an Amazon Cognito workforce. A single Cognito workforce is created using and corresponds to a single [ Amazon Cognito user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html).
     */
    val cognitoConfig: aws.sdk.kotlin.services.sagemaker.model.CognitoConfig? = builder.cognitoConfig
    /**
     * The date that the workforce is created.
     */
    val createDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createDate
    /**
     * The most recent date that was used to successfully add one or more IP address ranges ([CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)) to a private workforce's allow list.
     */
    val lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDate
    /**
     * The configuration of an OIDC Identity Provider (IdP) private workforce.
     */
    val oidcConfig: aws.sdk.kotlin.services.sagemaker.model.OidcConfigForResponse? = builder.oidcConfig
    /**
     * A list of one to ten IP address ranges ([CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)) to be added to the workforce allow list. By default, a workforce isn't restricted to specific IP addresses.
     */
    val sourceIpConfig: aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig? = builder.sourceIpConfig
    /**
     * The subdomain for your OIDC Identity Provider.
     */
    val subDomain: kotlin.String? = builder.subDomain
    /**
     * The Amazon Resource Name (ARN) of the private workforce.
     */
    val workforceArn: kotlin.String? = builder.workforceArn
    /**
     * The name of the private workforce.
     */
    val workforceName: kotlin.String? = builder.workforceName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.Workforce = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Workforce(")
        append("cognitoConfig=$cognitoConfig,")
        append("createDate=$createDate,")
        append("lastUpdatedDate=$lastUpdatedDate,")
        append("oidcConfig=$oidcConfig,")
        append("sourceIpConfig=$sourceIpConfig,")
        append("subDomain=$subDomain,")
        append("workforceArn=$workforceArn,")
        append("workforceName=$workforceName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cognitoConfig?.hashCode() ?: 0
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDate?.hashCode() ?: 0)
        result = 31 * result + (oidcConfig?.hashCode() ?: 0)
        result = 31 * result + (sourceIpConfig?.hashCode() ?: 0)
        result = 31 * result + (subDomain?.hashCode() ?: 0)
        result = 31 * result + (workforceArn?.hashCode() ?: 0)
        result = 31 * result + (workforceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Workforce

        if (cognitoConfig != other.cognitoConfig) return false
        if (createDate != other.createDate) return false
        if (lastUpdatedDate != other.lastUpdatedDate) return false
        if (oidcConfig != other.oidcConfig) return false
        if (sourceIpConfig != other.sourceIpConfig) return false
        if (subDomain != other.subDomain) return false
        if (workforceArn != other.workforceArn) return false
        if (workforceName != other.workforceName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.Workforce = Builder(this).apply(block).build()

    class Builder {
        /**
         * The configuration of an Amazon Cognito workforce. A single Cognito workforce is created using and corresponds to a single [ Amazon Cognito user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html).
         */
        var cognitoConfig: aws.sdk.kotlin.services.sagemaker.model.CognitoConfig? = null
        /**
         * The date that the workforce is created.
         */
        var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The most recent date that was used to successfully add one or more IP address ranges ([CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)) to a private workforce's allow list.
         */
        var lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The configuration of an OIDC Identity Provider (IdP) private workforce.
         */
        var oidcConfig: aws.sdk.kotlin.services.sagemaker.model.OidcConfigForResponse? = null
        /**
         * A list of one to ten IP address ranges ([CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)) to be added to the workforce allow list. By default, a workforce isn't restricted to specific IP addresses.
         */
        var sourceIpConfig: aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig? = null
        /**
         * The subdomain for your OIDC Identity Provider.
         */
        var subDomain: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the private workforce.
         */
        var workforceArn: kotlin.String? = null
        /**
         * The name of the private workforce.
         */
        var workforceName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.Workforce) : this() {
            this.cognitoConfig = x.cognitoConfig
            this.createDate = x.createDate
            this.lastUpdatedDate = x.lastUpdatedDate
            this.oidcConfig = x.oidcConfig
            this.sourceIpConfig = x.sourceIpConfig
            this.subDomain = x.subDomain
            this.workforceArn = x.workforceArn
            this.workforceName = x.workforceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.Workforce = Workforce(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.CognitoConfig] inside the given [block]
         */
        fun cognitoConfig(block: aws.sdk.kotlin.services.sagemaker.model.CognitoConfig.Builder.() -> kotlin.Unit) {
            this.cognitoConfig = aws.sdk.kotlin.services.sagemaker.model.CognitoConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OidcConfigForResponse] inside the given [block]
         */
        fun oidcConfig(block: aws.sdk.kotlin.services.sagemaker.model.OidcConfigForResponse.Builder.() -> kotlin.Unit) {
            this.oidcConfig = aws.sdk.kotlin.services.sagemaker.model.OidcConfigForResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig] inside the given [block]
         */
        fun sourceIpConfig(block: aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig.Builder.() -> kotlin.Unit) {
            this.sourceIpConfig = aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig.invoke(block)
        }
    }
}
