// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides details about a labeling work team.
 */
class Workteam private constructor(builder: Builder) {
    /**
     * The date and time that the work team was created (timestamp).
     */
    val createDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createDate
    /**
     * A description of the work team.
     */
    val description: kotlin.String? = builder.description
    /**
     * The date and time that the work team was last updated (timestamp).
     */
    val lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDate
    /**
     * A list of `MemberDefinition` objects that contains objects that identify the workers that make up the work team.
     *
     * Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `CognitoMemberDefinition`. For workforces created using your own OIDC identity provider (IdP) use `OidcMemberDefinition`.
     */
    val memberDefinitions: List<MemberDefinition>? = builder.memberDefinitions
    /**
     * Configures SNS notifications of available or expiring work items for work teams.
     */
    val notificationConfiguration: aws.sdk.kotlin.services.sagemaker.model.NotificationConfiguration? = builder.notificationConfiguration
    /**
     * The Amazon Marketplace identifier for a vendor's work team.
     */
    val productListingIds: List<String>? = builder.productListingIds
    /**
     * The URI of the labeling job's user interface. Workers open this URI to start labeling your data objects.
     */
    val subDomain: kotlin.String? = builder.subDomain
    /**
     * The Amazon Resource Name (ARN) of the workforce.
     */
    val workforceArn: kotlin.String? = builder.workforceArn
    /**
     * The Amazon Resource Name (ARN) that identifies the work team.
     */
    val workteamArn: kotlin.String? = builder.workteamArn
    /**
     * The name of the work team.
     */
    val workteamName: kotlin.String? = builder.workteamName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.Workteam = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Workteam(")
        append("createDate=$createDate,")
        append("description=$description,")
        append("lastUpdatedDate=$lastUpdatedDate,")
        append("memberDefinitions=$memberDefinitions,")
        append("notificationConfiguration=$notificationConfiguration,")
        append("productListingIds=$productListingIds,")
        append("subDomain=$subDomain,")
        append("workforceArn=$workforceArn,")
        append("workteamArn=$workteamArn,")
        append("workteamName=$workteamName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createDate?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDate?.hashCode() ?: 0)
        result = 31 * result + (memberDefinitions?.hashCode() ?: 0)
        result = 31 * result + (notificationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (productListingIds?.hashCode() ?: 0)
        result = 31 * result + (subDomain?.hashCode() ?: 0)
        result = 31 * result + (workforceArn?.hashCode() ?: 0)
        result = 31 * result + (workteamArn?.hashCode() ?: 0)
        result = 31 * result + (workteamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Workteam

        if (createDate != other.createDate) return false
        if (description != other.description) return false
        if (lastUpdatedDate != other.lastUpdatedDate) return false
        if (memberDefinitions != other.memberDefinitions) return false
        if (notificationConfiguration != other.notificationConfiguration) return false
        if (productListingIds != other.productListingIds) return false
        if (subDomain != other.subDomain) return false
        if (workforceArn != other.workforceArn) return false
        if (workteamArn != other.workteamArn) return false
        if (workteamName != other.workteamName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.Workteam = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time that the work team was created (timestamp).
         */
        var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description of the work team.
         */
        var description: kotlin.String? = null
        /**
         * The date and time that the work team was last updated (timestamp).
         */
        var lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of `MemberDefinition` objects that contains objects that identify the workers that make up the work team.
         *
         * Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `CognitoMemberDefinition`. For workforces created using your own OIDC identity provider (IdP) use `OidcMemberDefinition`.
         */
        var memberDefinitions: List<MemberDefinition>? = null
        /**
         * Configures SNS notifications of available or expiring work items for work teams.
         */
        var notificationConfiguration: aws.sdk.kotlin.services.sagemaker.model.NotificationConfiguration? = null
        /**
         * The Amazon Marketplace identifier for a vendor's work team.
         */
        var productListingIds: List<String>? = null
        /**
         * The URI of the labeling job's user interface. Workers open this URI to start labeling your data objects.
         */
        var subDomain: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the workforce.
         */
        var workforceArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) that identifies the work team.
         */
        var workteamArn: kotlin.String? = null
        /**
         * The name of the work team.
         */
        var workteamName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.Workteam) : this() {
            this.createDate = x.createDate
            this.description = x.description
            this.lastUpdatedDate = x.lastUpdatedDate
            this.memberDefinitions = x.memberDefinitions
            this.notificationConfiguration = x.notificationConfiguration
            this.productListingIds = x.productListingIds
            this.subDomain = x.subDomain
            this.workforceArn = x.workforceArn
            this.workteamArn = x.workteamArn
            this.workteamName = x.workteamName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.Workteam = Workteam(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.NotificationConfiguration] inside the given [block]
         */
        fun notificationConfiguration(block: aws.sdk.kotlin.services.sagemaker.model.NotificationConfiguration.Builder.() -> kotlin.Unit) {
            this.notificationConfiguration = aws.sdk.kotlin.services.sagemaker.model.NotificationConfiguration.invoke(block)
        }
    }
}
