// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.DescribeDeviceFleetResponse
import aws.sdk.kotlin.services.sagemaker.model.EdgeOutputConfig
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeDeviceFleetOperationDeserializer: HttpDeserialize<DescribeDeviceFleetResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeDeviceFleetResponse {
        if (!response.status.isSuccess()) {
            throwDescribeDeviceFleetError(context, response)
        }
        val builder = DescribeDeviceFleetResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeDeviceFleetOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeDeviceFleetError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDeviceFleetOperationBody(builder: DescribeDeviceFleetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DEVICEFLEETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeviceFleetArn"))
    val DEVICEFLEETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeviceFleetName"))
    val IOTROLEALIAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IotRoleAlias"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val OUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OutputConfig"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DEVICEFLEETARN_DESCRIPTOR)
        field(DEVICEFLEETNAME_DESCRIPTOR)
        field(IOTROLEALIAS_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(OUTPUTCONFIG_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DEVICEFLEETARN_DESCRIPTOR.index -> builder.deviceFleetArn = deserializeString()
                DEVICEFLEETNAME_DESCRIPTOR.index -> builder.deviceFleetName = deserializeString()
                IOTROLEALIAS_DESCRIPTOR.index -> builder.iotRoleAlias = deserializeString()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                OUTPUTCONFIG_DESCRIPTOR.index -> builder.outputConfig = deserializeEdgeOutputConfigDocument(deserializer)
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
