// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.DescribeLabelingJobResponse
import aws.sdk.kotlin.services.sagemaker.model.HumanTaskConfig
import aws.sdk.kotlin.services.sagemaker.model.LabelCounters
import aws.sdk.kotlin.services.sagemaker.model.LabelingJobAlgorithmsConfig
import aws.sdk.kotlin.services.sagemaker.model.LabelingJobInputConfig
import aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutput
import aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutputConfig
import aws.sdk.kotlin.services.sagemaker.model.LabelingJobStatus
import aws.sdk.kotlin.services.sagemaker.model.LabelingJobStoppingConditions
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeLabelingJobOperationDeserializer: HttpDeserialize<DescribeLabelingJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeLabelingJobResponse {
        if (!response.status.isSuccess()) {
            throwDescribeLabelingJobError(context, response)
        }
        val builder = DescribeLabelingJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeLabelingJobOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeLabelingJobError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeLabelingJobOperationBody(builder: DescribeLabelingJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val HUMANTASKCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("HumanTaskConfig"))
    val INPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InputConfig"))
    val JOBREFERENCECODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobReferenceCode"))
    val LABELATTRIBUTENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LabelAttributeName"))
    val LABELCATEGORYCONFIGS3URI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LabelCategoryConfigS3Uri"))
    val LABELCOUNTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LabelCounters"))
    val LABELINGJOBALGORITHMSCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LabelingJobAlgorithmsConfig"))
    val LABELINGJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LabelingJobArn"))
    val LABELINGJOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LabelingJobName"))
    val LABELINGJOBOUTPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LabelingJobOutput"))
    val LABELINGJOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LabelingJobStatus"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val OUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OutputConfig"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val STOPPINGCONDITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("StoppingConditions"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(HUMANTASKCONFIG_DESCRIPTOR)
        field(INPUTCONFIG_DESCRIPTOR)
        field(JOBREFERENCECODE_DESCRIPTOR)
        field(LABELATTRIBUTENAME_DESCRIPTOR)
        field(LABELCATEGORYCONFIGS3URI_DESCRIPTOR)
        field(LABELCOUNTERS_DESCRIPTOR)
        field(LABELINGJOBALGORITHMSCONFIG_DESCRIPTOR)
        field(LABELINGJOBARN_DESCRIPTOR)
        field(LABELINGJOBNAME_DESCRIPTOR)
        field(LABELINGJOBOUTPUT_DESCRIPTOR)
        field(LABELINGJOBSTATUS_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(OUTPUTCONFIG_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STOPPINGCONDITIONS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                HUMANTASKCONFIG_DESCRIPTOR.index -> builder.humanTaskConfig = deserializeHumanTaskConfigDocument(deserializer)
                INPUTCONFIG_DESCRIPTOR.index -> builder.inputConfig = deserializeLabelingJobInputConfigDocument(deserializer)
                JOBREFERENCECODE_DESCRIPTOR.index -> builder.jobReferenceCode = deserializeString()
                LABELATTRIBUTENAME_DESCRIPTOR.index -> builder.labelAttributeName = deserializeString()
                LABELCATEGORYCONFIGS3URI_DESCRIPTOR.index -> builder.labelCategoryConfigS3Uri = deserializeString()
                LABELCOUNTERS_DESCRIPTOR.index -> builder.labelCounters = deserializeLabelCountersDocument(deserializer)
                LABELINGJOBALGORITHMSCONFIG_DESCRIPTOR.index -> builder.labelingJobAlgorithmsConfig = deserializeLabelingJobAlgorithmsConfigDocument(deserializer)
                LABELINGJOBARN_DESCRIPTOR.index -> builder.labelingJobArn = deserializeString()
                LABELINGJOBNAME_DESCRIPTOR.index -> builder.labelingJobName = deserializeString()
                LABELINGJOBOUTPUT_DESCRIPTOR.index -> builder.labelingJobOutput = deserializeLabelingJobOutputDocument(deserializer)
                LABELINGJOBSTATUS_DESCRIPTOR.index -> builder.labelingJobStatus = deserializeString().let { LabelingJobStatus.fromValue(it) }
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                OUTPUTCONFIG_DESCRIPTOR.index -> builder.outputConfig = deserializeLabelingJobOutputConfigDocument(deserializer)
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STOPPINGCONDITIONS_DESCRIPTOR.index -> builder.stoppingConditions = deserializeLabelingJobStoppingConditionsDocument(deserializer)
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
