// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.DescribeStudioLifecycleConfigResponse
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.StudioLifecycleConfigAppType
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeStudioLifecycleConfigOperationDeserializer: HttpDeserialize<DescribeStudioLifecycleConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeStudioLifecycleConfigResponse {
        if (!response.status.isSuccess()) {
            throwDescribeStudioLifecycleConfigError(context, response)
        }
        val builder = DescribeStudioLifecycleConfigResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeStudioLifecycleConfigOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeStudioLifecycleConfigError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeStudioLifecycleConfigOperationBody(builder: DescribeStudioLifecycleConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val STUDIOLIFECYCLECONFIGAPPTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StudioLifecycleConfigAppType"))
    val STUDIOLIFECYCLECONFIGARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StudioLifecycleConfigArn"))
    val STUDIOLIFECYCLECONFIGCONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StudioLifecycleConfigContent"))
    val STUDIOLIFECYCLECONFIGNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StudioLifecycleConfigName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(STUDIOLIFECYCLECONFIGAPPTYPE_DESCRIPTOR)
        field(STUDIOLIFECYCLECONFIGARN_DESCRIPTOR)
        field(STUDIOLIFECYCLECONFIGCONTENT_DESCRIPTOR)
        field(STUDIOLIFECYCLECONFIGNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                STUDIOLIFECYCLECONFIGAPPTYPE_DESCRIPTOR.index -> builder.studioLifecycleConfigAppType = deserializeString().let { StudioLifecycleConfigAppType.fromValue(it) }
                STUDIOLIFECYCLECONFIGARN_DESCRIPTOR.index -> builder.studioLifecycleConfigArn = deserializeString()
                STUDIOLIFECYCLECONFIGCONTENT_DESCRIPTOR.index -> builder.studioLifecycleConfigContent = deserializeString()
                STUDIOLIFECYCLECONFIGNAME_DESCRIPTOR.index -> builder.studioLifecycleConfigName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
