// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.AlgorithmSpecification
import aws.sdk.kotlin.services.sagemaker.model.Channel
import aws.sdk.kotlin.services.sagemaker.model.CheckpointConfig
import aws.sdk.kotlin.services.sagemaker.model.DebugHookConfig
import aws.sdk.kotlin.services.sagemaker.model.DebugRuleConfiguration
import aws.sdk.kotlin.services.sagemaker.model.DebugRuleEvaluationStatus
import aws.sdk.kotlin.services.sagemaker.model.DescribeTrainingJobResponse
import aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig
import aws.sdk.kotlin.services.sagemaker.model.MetricData
import aws.sdk.kotlin.services.sagemaker.model.ModelArtifacts
import aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig
import aws.sdk.kotlin.services.sagemaker.model.ProfilerConfig
import aws.sdk.kotlin.services.sagemaker.model.ProfilerRuleConfiguration
import aws.sdk.kotlin.services.sagemaker.model.ProfilerRuleEvaluationStatus
import aws.sdk.kotlin.services.sagemaker.model.ProfilingStatus
import aws.sdk.kotlin.services.sagemaker.model.ResourceConfig
import aws.sdk.kotlin.services.sagemaker.model.RetryStrategy
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.SecondaryStatus
import aws.sdk.kotlin.services.sagemaker.model.SecondaryStatusTransition
import aws.sdk.kotlin.services.sagemaker.model.StoppingCondition
import aws.sdk.kotlin.services.sagemaker.model.TensorBoardOutputConfig
import aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatus
import aws.sdk.kotlin.services.sagemaker.model.VpcConfig
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeTrainingJobOperationDeserializer: HttpDeserialize<DescribeTrainingJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeTrainingJobResponse {
        if (!response.status.isSuccess()) {
            throwDescribeTrainingJobError(context, response)
        }
        val builder = DescribeTrainingJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeTrainingJobOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeTrainingJobError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeTrainingJobOperationBody(builder: DescribeTrainingJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALGORITHMSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AlgorithmSpecification"))
    val AUTOMLJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AutoMLJobArn"))
    val BILLABLETIMEINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("BillableTimeInSeconds"))
    val CHECKPOINTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CheckpointConfig"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DEBUGHOOKCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DebugHookConfig"))
    val DEBUGRULECONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DebugRuleConfigurations"))
    val DEBUGRULEEVALUATIONSTATUSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DebugRuleEvaluationStatuses"))
    val ENABLEINTERCONTAINERTRAFFICENCRYPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("EnableInterContainerTrafficEncryption"))
    val ENABLEMANAGEDSPOTTRAINING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("EnableManagedSpotTraining"))
    val ENABLENETWORKISOLATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("EnableNetworkIsolation"))
    val ENVIRONMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Environment"))
    val EXPERIMENTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExperimentConfig"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val FINALMETRICDATALIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FinalMetricDataList"))
    val HYPERPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("HyperParameters"))
    val INPUTDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("InputDataConfig"))
    val LABELINGJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LabelingJobArn"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val MODELARTIFACTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelArtifacts"))
    val OUTPUTDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OutputDataConfig"))
    val PROFILERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProfilerConfig"))
    val PROFILERRULECONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProfilerRuleConfigurations"))
    val PROFILERRULEEVALUATIONSTATUSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProfilerRuleEvaluationStatuses"))
    val PROFILINGSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProfilingStatus"))
    val RESOURCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ResourceConfig"))
    val RETRYSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RetryStrategy"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val SECONDARYSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SecondaryStatus"))
    val SECONDARYSTATUSTRANSITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SecondaryStatusTransitions"))
    val STOPPINGCONDITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("StoppingCondition"))
    val TENSORBOARDOUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TensorBoardOutputConfig"))
    val TRAININGENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("TrainingEndTime"))
    val TRAININGJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrainingJobArn"))
    val TRAININGJOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrainingJobName"))
    val TRAININGJOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrainingJobStatus"))
    val TRAININGSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("TrainingStartTime"))
    val TRAININGTIMEINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("TrainingTimeInSeconds"))
    val TUNINGJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TuningJobArn"))
    val VPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VpcConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALGORITHMSPECIFICATION_DESCRIPTOR)
        field(AUTOMLJOBARN_DESCRIPTOR)
        field(BILLABLETIMEINSECONDS_DESCRIPTOR)
        field(CHECKPOINTCONFIG_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DEBUGHOOKCONFIG_DESCRIPTOR)
        field(DEBUGRULECONFIGURATIONS_DESCRIPTOR)
        field(DEBUGRULEEVALUATIONSTATUSES_DESCRIPTOR)
        field(ENABLEINTERCONTAINERTRAFFICENCRYPTION_DESCRIPTOR)
        field(ENABLEMANAGEDSPOTTRAINING_DESCRIPTOR)
        field(ENABLENETWORKISOLATION_DESCRIPTOR)
        field(ENVIRONMENT_DESCRIPTOR)
        field(EXPERIMENTCONFIG_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(FINALMETRICDATALIST_DESCRIPTOR)
        field(HYPERPARAMETERS_DESCRIPTOR)
        field(INPUTDATACONFIG_DESCRIPTOR)
        field(LABELINGJOBARN_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(MODELARTIFACTS_DESCRIPTOR)
        field(OUTPUTDATACONFIG_DESCRIPTOR)
        field(PROFILERCONFIG_DESCRIPTOR)
        field(PROFILERRULECONFIGURATIONS_DESCRIPTOR)
        field(PROFILERRULEEVALUATIONSTATUSES_DESCRIPTOR)
        field(PROFILINGSTATUS_DESCRIPTOR)
        field(RESOURCECONFIG_DESCRIPTOR)
        field(RETRYSTRATEGY_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(SECONDARYSTATUS_DESCRIPTOR)
        field(SECONDARYSTATUSTRANSITIONS_DESCRIPTOR)
        field(STOPPINGCONDITION_DESCRIPTOR)
        field(TENSORBOARDOUTPUTCONFIG_DESCRIPTOR)
        field(TRAININGENDTIME_DESCRIPTOR)
        field(TRAININGJOBARN_DESCRIPTOR)
        field(TRAININGJOBNAME_DESCRIPTOR)
        field(TRAININGJOBSTATUS_DESCRIPTOR)
        field(TRAININGSTARTTIME_DESCRIPTOR)
        field(TRAININGTIMEINSECONDS_DESCRIPTOR)
        field(TUNINGJOBARN_DESCRIPTOR)
        field(VPCCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALGORITHMSPECIFICATION_DESCRIPTOR.index -> builder.algorithmSpecification = deserializeAlgorithmSpecificationDocument(deserializer)
                AUTOMLJOBARN_DESCRIPTOR.index -> builder.autoMlJobArn = deserializeString()
                BILLABLETIMEINSECONDS_DESCRIPTOR.index -> builder.billableTimeInSeconds = deserializeInt()
                CHECKPOINTCONFIG_DESCRIPTOR.index -> builder.checkpointConfig = deserializeCheckpointConfigDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DEBUGHOOKCONFIG_DESCRIPTOR.index -> builder.debugHookConfig = deserializeDebugHookConfigDocument(deserializer)
                DEBUGRULECONFIGURATIONS_DESCRIPTOR.index -> builder.debugRuleConfigurations =
                    deserializer.deserializeList(DEBUGRULECONFIGURATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<DebugRuleConfiguration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDebugRuleConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DEBUGRULEEVALUATIONSTATUSES_DESCRIPTOR.index -> builder.debugRuleEvaluationStatuses =
                    deserializer.deserializeList(DEBUGRULEEVALUATIONSTATUSES_DESCRIPTOR) {
                        val col0 = mutableListOf<DebugRuleEvaluationStatus>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDebugRuleEvaluationStatusDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ENABLEINTERCONTAINERTRAFFICENCRYPTION_DESCRIPTOR.index -> builder.enableInterContainerTrafficEncryption = deserializeBoolean()
                ENABLEMANAGEDSPOTTRAINING_DESCRIPTOR.index -> builder.enableManagedSpotTraining = deserializeBoolean()
                ENABLENETWORKISOLATION_DESCRIPTOR.index -> builder.enableNetworkIsolation = deserializeBoolean()
                ENVIRONMENT_DESCRIPTOR.index -> builder.environment =
                    deserializer.deserializeMap(ENVIRONMENT_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                EXPERIMENTCONFIG_DESCRIPTOR.index -> builder.experimentConfig = deserializeExperimentConfigDocument(deserializer)
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                FINALMETRICDATALIST_DESCRIPTOR.index -> builder.finalMetricDataList =
                    deserializer.deserializeList(FINALMETRICDATALIST_DESCRIPTOR) {
                        val col0 = mutableListOf<MetricData>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMetricDataDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                HYPERPARAMETERS_DESCRIPTOR.index -> builder.hyperParameters =
                    deserializer.deserializeMap(HYPERPARAMETERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                INPUTDATACONFIG_DESCRIPTOR.index -> builder.inputDataConfig =
                    deserializer.deserializeList(INPUTDATACONFIG_DESCRIPTOR) {
                        val col0 = mutableListOf<Channel>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeChannelDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LABELINGJOBARN_DESCRIPTOR.index -> builder.labelingJobArn = deserializeString()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                MODELARTIFACTS_DESCRIPTOR.index -> builder.modelArtifacts = deserializeModelArtifactsDocument(deserializer)
                OUTPUTDATACONFIG_DESCRIPTOR.index -> builder.outputDataConfig = deserializeOutputDataConfigDocument(deserializer)
                PROFILERCONFIG_DESCRIPTOR.index -> builder.profilerConfig = deserializeProfilerConfigDocument(deserializer)
                PROFILERRULECONFIGURATIONS_DESCRIPTOR.index -> builder.profilerRuleConfigurations =
                    deserializer.deserializeList(PROFILERRULECONFIGURATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<ProfilerRuleConfiguration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProfilerRuleConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PROFILERRULEEVALUATIONSTATUSES_DESCRIPTOR.index -> builder.profilerRuleEvaluationStatuses =
                    deserializer.deserializeList(PROFILERRULEEVALUATIONSTATUSES_DESCRIPTOR) {
                        val col0 = mutableListOf<ProfilerRuleEvaluationStatus>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProfilerRuleEvaluationStatusDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PROFILINGSTATUS_DESCRIPTOR.index -> builder.profilingStatus = deserializeString().let { ProfilingStatus.fromValue(it) }
                RESOURCECONFIG_DESCRIPTOR.index -> builder.resourceConfig = deserializeResourceConfigDocument(deserializer)
                RETRYSTRATEGY_DESCRIPTOR.index -> builder.retryStrategy = deserializeRetryStrategyDocument(deserializer)
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                SECONDARYSTATUS_DESCRIPTOR.index -> builder.secondaryStatus = deserializeString().let { SecondaryStatus.fromValue(it) }
                SECONDARYSTATUSTRANSITIONS_DESCRIPTOR.index -> builder.secondaryStatusTransitions =
                    deserializer.deserializeList(SECONDARYSTATUSTRANSITIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<SecondaryStatusTransition>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSecondaryStatusTransitionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STOPPINGCONDITION_DESCRIPTOR.index -> builder.stoppingCondition = deserializeStoppingConditionDocument(deserializer)
                TENSORBOARDOUTPUTCONFIG_DESCRIPTOR.index -> builder.tensorBoardOutputConfig = deserializeTensorBoardOutputConfigDocument(deserializer)
                TRAININGENDTIME_DESCRIPTOR.index -> builder.trainingEndTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                TRAININGJOBARN_DESCRIPTOR.index -> builder.trainingJobArn = deserializeString()
                TRAININGJOBNAME_DESCRIPTOR.index -> builder.trainingJobName = deserializeString()
                TRAININGJOBSTATUS_DESCRIPTOR.index -> builder.trainingJobStatus = deserializeString().let { TrainingJobStatus.fromValue(it) }
                TRAININGSTARTTIME_DESCRIPTOR.index -> builder.trainingStartTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                TRAININGTIMEINSECONDS_DESCRIPTOR.index -> builder.trainingTimeInSeconds = deserializeInt()
                TUNINGJOBARN_DESCRIPTOR.index -> builder.tuningJobArn = deserializeString()
                VPCCONFIG_DESCRIPTOR.index -> builder.vpcConfig = deserializeVpcConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
