// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.DisassociateTrialComponentResponse
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DisassociateTrialComponentOperationDeserializer: HttpDeserialize<DisassociateTrialComponentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DisassociateTrialComponentResponse {
        if (!response.status.isSuccess()) {
            throwDisassociateTrialComponentError(context, response)
        }
        val builder = DisassociateTrialComponentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDisassociateTrialComponentOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDisassociateTrialComponentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDisassociateTrialComponentOperationBody(builder: DisassociateTrialComponentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val TRIALARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrialArn"))
    val TRIALCOMPONENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrialComponentArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TRIALARN_DESCRIPTOR)
        field(TRIALCOMPONENTARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TRIALARN_DESCRIPTOR.index -> builder.trialArn = deserializeString()
                TRIALCOMPONENTARN_DESCRIPTOR.index -> builder.trialComponentArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
