// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.services.sagemaker.model.Direction
import aws.sdk.kotlin.services.sagemaker.model.QueryFilters
import aws.sdk.kotlin.services.sagemaker.model.QueryLineageRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class QueryLineageOperationSerializer: HttpSerialize<QueryLineageRequest> {
    override suspend fun serialize(context: ExecutionContext, input: QueryLineageRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeQueryLineageOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeQueryLineageOperationBody(context: ExecutionContext, input: QueryLineageRequest): ByteArray {
    val serializer = JsonSerializer()
    val DIRECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Direction"))
    val FILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Filters"))
    val INCLUDEEDGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IncludeEdges"))
    val MAXDEPTH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxDepth"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val STARTARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("StartArns"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DIRECTION_DESCRIPTOR)
        field(FILTERS_DESCRIPTOR)
        field(INCLUDEEDGES_DESCRIPTOR)
        field(MAXDEPTH_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(STARTARNS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.direction?.let { field(DIRECTION_DESCRIPTOR, it.value) }
        input.filters?.let { field(FILTERS_DESCRIPTOR, it, ::serializeQueryFiltersDocument) }
        if (input.includeEdges != false) field(INCLUDEEDGES_DESCRIPTOR, input.includeEdges)
        input.maxDepth?.let { field(MAXDEPTH_DESCRIPTOR, it) }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        if (input.startArns != null) {
            listField(STARTARNS_DESCRIPTOR) {
                for (el0 in input.startArns) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
