// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.sagemaker.model.*
import aws.sdk.kotlin.services.sagemaker.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "SageMaker"
const val ServiceApiVersion: String = "2017-07-24"
const val SdkVersion: String = "0.16.3-beta"

internal class DefaultSageMakerClient(override val config: SageMakerClient.Config) : SageMakerClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates an *association* between the source and the destination. A source can be associated with multiple destinations, and a destination can be associated with multiple sources. An association is a lineage tracking entity. For more information, see [Amazon SageMaker ML Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
     */
    override suspend fun addAssociation(input: AddAssociationRequest): AddAssociationResponse {
        val op = SdkHttpOperation.build<AddAssociationRequest, AddAssociationResponse> {
            serializer = AddAssociationOperationSerializer()
            deserializer = AddAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddAssociation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds or overwrites one or more tags for the specified SageMaker resource. You can add tags to notebook instances, training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint configurations, and endpoints.
     *
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information about tags, see For more information, see [Amazon Web Services Tagging Strategies](https://aws.amazon.com/answers/account-management/aws-tagging-strategies/).
     *
     * Tags that you add to a hyperparameter tuning job by calling this API are also added to any training jobs that the hyperparameter tuning job launches after you call this API, but not to training jobs that the hyperparameter tuning job launched before you called this API. To make sure that the tags associated with a hyperparameter tuning job are also added to all training jobs that the hyperparameter tuning job launches, add the tags when you first create the tuning job by specifying them in the `Tags` parameter of CreateHyperParameterTuningJob
     *
     * Tags that you add to a SageMaker Studio Domain or User Profile by calling this API are also added to any Apps that the Domain or User Profile launches after you call this API, but not to Apps that the Domain or User Profile launched before you called this API. To make sure that the tags associated with a Domain or User Profile are also added to all Apps that the Domain or User Profile launches, add the tags when you first create the Domain or User Profile by specifying them in the `Tags` parameter of CreateDomain or CreateUserProfile.
     */
    override suspend fun addTags(input: AddTagsRequest): AddTagsResponse {
        val op = SdkHttpOperation.build<AddTagsRequest, AddTagsResponse> {
            serializer = AddTagsOperationSerializer()
            deserializer = AddTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a trial component with a trial. A trial component can be associated with multiple trials. To disassociate a trial component from a trial, call the DisassociateTrialComponent API.
     */
    override suspend fun associateTrialComponent(input: AssociateTrialComponentRequest): AssociateTrialComponentResponse {
        val op = SdkHttpOperation.build<AssociateTrialComponentRequest, AssociateTrialComponentResponse> {
            serializer = AssociateTrialComponentOperationSerializer()
            deserializer = AssociateTrialComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateTrialComponent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This action batch describes a list of versioned model packages
     */
    override suspend fun batchDescribeModelPackage(input: BatchDescribeModelPackageRequest): BatchDescribeModelPackageResponse {
        val op = SdkHttpOperation.build<BatchDescribeModelPackageRequest, BatchDescribeModelPackageResponse> {
            serializer = BatchDescribeModelPackageOperationSerializer()
            deserializer = BatchDescribeModelPackageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDescribeModelPackage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an *action*. An action is a lineage tracking entity that represents an action or activity. For example, a model deployment or an HPO job. Generally, an action involves at least one input or output artifact. For more information, see [Amazon SageMaker ML Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
     */
    override suspend fun createAction(input: CreateActionRequest): CreateActionResponse {
        val op = SdkHttpOperation.build<CreateActionRequest, CreateActionResponse> {
            serializer = CreateActionOperationSerializer()
            deserializer = CreateActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a machine learning algorithm that you can use in SageMaker and list in the Amazon Web Services Marketplace.
     */
    override suspend fun createAlgorithm(input: CreateAlgorithmRequest): CreateAlgorithmResponse {
        val op = SdkHttpOperation.build<CreateAlgorithmRequest, CreateAlgorithmResponse> {
            serializer = CreateAlgorithmOperationSerializer()
            deserializer = CreateAlgorithmOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAlgorithm"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a running app for the specified UserProfile. Supported apps are `JupyterServer` and `KernelGateway`. This operation is automatically invoked by Amazon SageMaker Studio upon access to the associated Domain, and when new kernel configurations are selected by the user. A user may have multiple Apps active simultaneously.
     */
    override suspend fun createApp(input: CreateAppRequest): CreateAppResponse {
        val op = SdkHttpOperation.build<CreateAppRequest, CreateAppResponse> {
            serializer = CreateAppOperationSerializer()
            deserializer = CreateAppOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateApp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a configuration for running a SageMaker image as a KernelGateway app. The configuration specifies the Amazon Elastic File System (EFS) storage volume on the image, and a list of the kernels in the image.
     */
    override suspend fun createAppImageConfig(input: CreateAppImageConfigRequest): CreateAppImageConfigResponse {
        val op = SdkHttpOperation.build<CreateAppImageConfigRequest, CreateAppImageConfigResponse> {
            serializer = CreateAppImageConfigOperationSerializer()
            deserializer = CreateAppImageConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAppImageConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an *artifact*. An artifact is a lineage tracking entity that represents a URI addressable object or data. Some examples are the S3 URI of a dataset and the ECR registry path of an image. For more information, see [Amazon SageMaker ML Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
     */
    override suspend fun createArtifact(input: CreateArtifactRequest): CreateArtifactResponse {
        val op = SdkHttpOperation.build<CreateArtifactRequest, CreateArtifactResponse> {
            serializer = CreateArtifactOperationSerializer()
            deserializer = CreateArtifactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateArtifact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Autopilot job.
     *
     * Find the best-performing model after you run an Autopilot job by calling .
     *
     * For information about how to use Autopilot, see [Automate Model Development with Amazon SageMaker Autopilot](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html).
     */
    override suspend fun createAutoMlJob(input: CreateAutoMlJobRequest): CreateAutoMlJobResponse {
        val op = SdkHttpOperation.build<CreateAutoMlJobRequest, CreateAutoMlJobResponse> {
            serializer = CreateAutoMLJobOperationSerializer()
            deserializer = CreateAutoMLJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAutoMLJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Git repository as a resource in your SageMaker account. You can associate the repository with notebook instances so that you can use Git source control for the notebooks you create. The Git repository is a resource in your SageMaker account, so it can be associated with more than one notebook instance, and it persists independently from the lifecycle of any notebook instances it is associated with.
     *
     * The repository can be hosted either in [Amazon Web Services CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository.
     */
    override suspend fun createCodeRepository(input: CreateCodeRepositoryRequest): CreateCodeRepositoryResponse {
        val op = SdkHttpOperation.build<CreateCodeRepositoryRequest, CreateCodeRepositoryResponse> {
            serializer = CreateCodeRepositoryOperationSerializer()
            deserializer = CreateCodeRepositoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCodeRepository"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a model compilation job. After the model has been compiled, Amazon SageMaker saves the resulting model artifacts to an Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     *
     * If you choose to host your model using Amazon SageMaker hosting services, you can use the resulting model artifacts as part of the model. You can also use the artifacts with Amazon Web Services IoT Greengrass. In that case, deploy them as an ML resource.
     *
     * In the request body, you provide the following:
     * + A name for the compilation job
     * +  Information about the input model artifacts
     * + The output location for the compiled model and the device (target) that the model runs on
     * + The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker assumes to perform the model compilation job.
     *
     * You can also provide a `Tag` to track the model compilation job's resource use and costs. The response body contains the `CompilationJobArn` for the compiled job.
     *
     * To stop a model compilation job, use StopCompilationJob. To get information about a particular model compilation job, use DescribeCompilationJob. To get information about multiple model compilation jobs, use ListCompilationJobs.
     */
    override suspend fun createCompilationJob(input: CreateCompilationJobRequest): CreateCompilationJobResponse {
        val op = SdkHttpOperation.build<CreateCompilationJobRequest, CreateCompilationJobResponse> {
            serializer = CreateCompilationJobOperationSerializer()
            deserializer = CreateCompilationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCompilationJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a *context*. A context is a lineage tracking entity that represents a logical grouping of other tracking or experiment entities. Some examples are an endpoint and a model package. For more information, see [Amazon SageMaker ML Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
     */
    override suspend fun createContext(input: CreateContextRequest): CreateContextResponse {
        val op = SdkHttpOperation.build<CreateContextRequest, CreateContextResponse> {
            serializer = CreateContextOperationSerializer()
            deserializer = CreateContextOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateContext"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a definition for a job that monitors data quality and drift. For information about model monitor, see [Amazon SageMaker Model Monitor](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html).
     */
    override suspend fun createDataQualityJobDefinition(input: CreateDataQualityJobDefinitionRequest): CreateDataQualityJobDefinitionResponse {
        val op = SdkHttpOperation.build<CreateDataQualityJobDefinitionRequest, CreateDataQualityJobDefinitionResponse> {
            serializer = CreateDataQualityJobDefinitionOperationSerializer()
            deserializer = CreateDataQualityJobDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDataQualityJobDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a device fleet.
     */
    override suspend fun createDeviceFleet(input: CreateDeviceFleetRequest): CreateDeviceFleetResponse {
        val op = SdkHttpOperation.build<CreateDeviceFleetRequest, CreateDeviceFleetResponse> {
            serializer = CreateDeviceFleetOperationSerializer()
            deserializer = CreateDeviceFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDeviceFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a `Domain` used by Amazon SageMaker Studio. A domain consists of an associated Amazon Elastic File System (EFS) volume, a list of authorized users, and a variety of security, application, policy, and Amazon Virtual Private Cloud (VPC) configurations. An Amazon Web Services account is limited to one domain per region. Users within a domain can share notebook files and other artifacts with each other.
     *
     * **EFS storage**
     *
     * When a domain is created, an EFS volume is created for use by all of the users within the domain. Each user receives a private home directory within the EFS volume for notebooks, Git repositories, and data files.
     *
     * SageMaker uses the Amazon Web Services Key Management Service (Amazon Web Services KMS) to encrypt the EFS volume attached to the domain with an Amazon Web Services managed key by default. For more control, you can specify a customer managed key. For more information, see [Protect Data at Rest Using Encryption](https://docs.aws.amazon.com/sagemaker/latest/dg/encryption-at-rest.html).
     *
     * **VPC configuration**
     *
     * All SageMaker Studio traffic between the domain and the EFS volume is through the specified VPC and subnets. For other Studio traffic, you can specify the `AppNetworkAccessType` parameter. `AppNetworkAccessType` corresponds to the network access type that you choose when you onboard to Studio. The following options are available:
     * + `PublicInternetOnly` - Non-EFS traffic goes through a VPC managed by Amazon SageMaker, which allows internet access. This is the default value.
     * + `VpcOnly` - All Studio traffic is through the specified VPC and subnets. Internet access is disabled by default. To allow internet access, you must specify a NAT gateway.When internet access is disabled, you won't be able to run a Studio notebook or to train or host models unless your VPC has an interface endpoint to the SageMaker API and runtime or a NAT gateway and your security groups allow outbound connections.
     *
     * NFS traffic over TCP on port 2049 needs to be allowed in both inbound and outbound rules in order to launch a SageMaker Studio app successfully.
     *
     * For more information, see [Connect SageMaker Studio Notebooks to Resources in a VPC](https://docs.aws.amazon.com/sagemaker/latest/dg/studio-notebooks-and-internet-access.html).
     */
    override suspend fun createDomain(input: CreateDomainRequest): CreateDomainResponse {
        val op = SdkHttpOperation.build<CreateDomainRequest, CreateDomainResponse> {
            serializer = CreateDomainOperationSerializer()
            deserializer = CreateDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a SageMaker Edge Manager model packaging job. Edge Manager will use the model artifacts from the Amazon Simple Storage Service bucket that you specify. After the model has been packaged, Amazon SageMaker saves the resulting artifacts to an S3 bucket that you specify.
     */
    override suspend fun createEdgePackagingJob(input: CreateEdgePackagingJobRequest): CreateEdgePackagingJobResponse {
        val op = SdkHttpOperation.build<CreateEdgePackagingJobRequest, CreateEdgePackagingJobResponse> {
            serializer = CreateEdgePackagingJobOperationSerializer()
            deserializer = CreateEdgePackagingJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEdgePackagingJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an endpoint using the endpoint configuration specified in the request. SageMaker uses the endpoint to provision resources and deploy models. You create the endpoint configuration with the CreateEndpointConfig API.
     *
     *  Use this API to deploy models using SageMaker hosting services.
     *
     * For an example that calls this method when deploying a model to SageMaker hosting services, see the [Create Endpoint example notebook.](https://github.com/aws/amazon-sagemaker-examples/blob/master/sagemaker-fundamentals/create-endpoint/create_endpoint.ipynb)
     *
     *  You must not delete an `EndpointConfig` that is in use by an endpoint that is live or while the `UpdateEndpoint` or `CreateEndpoint` operations are being performed on the endpoint. To update an endpoint, you must create a new `EndpointConfig`.
     *
     * The endpoint name must be unique within an Amazon Web Services Region in your Amazon Web Services account.
     *
     * When it receives the request, SageMaker creates the endpoint, launches the resources (ML compute instances), and deploys the model(s) on them.
     *
     * When you call CreateEndpoint, a load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a DynamoDB table supporting `Eventually Consistent Reads`[](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html), the response might not reflect the results of a recently completed write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB, this causes a validation error. If you repeat your read request after a short time, the response should return the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers call DescribeEndpointConfig before calling CreateEndpoint to minimize the potential impact of a DynamoDB eventually consistent read.
     *
     * When SageMaker receives the request, it sets the endpoint status to `Creating`. After it creates the endpoint, it sets the status to `InService`. SageMaker can then process incoming requests for inferences. To check the status of an endpoint, use the DescribeEndpoint API.
     *
     * If any of the models hosted at this endpoint get model data from an Amazon S3 location, SageMaker uses Amazon Web Services Security Token Service to download model artifacts from the S3 path you provided. Amazon Web Services STS is activated in your IAM user account by default. If you previously deactivated Amazon Web Services STS for a region, you need to reactivate Amazon Web Services STS for that region. For more information, see [Activating and Deactivating Amazon Web Services STS in an Amazon Web Services Region](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html) in the *Amazon Web Services Identity and Access Management User Guide*.
     *
     *  To add the IAM role policies for using this API operation, go to the [IAM console](https://console.aws.amazon.com/iam/), and choose Roles in the left navigation pane. Search the IAM role that you want to grant access to use the CreateEndpoint and CreateEndpointConfig API operations, add the following policies to the role.
     * + Option 1: For a full SageMaker access, search and attach the `AmazonSageMakerFullAccess` policy.
     * + Option 2: For granting a limited access to an IAM role, paste the following Action elements manually into the JSON file of the IAM role: `"Action": ["sagemaker:CreateEndpoint", "sagemaker:CreateEndpointConfig"]``"Resource": [``"arn:aws:sagemaker:region:account-id:endpoint/endpointName"``"arn:aws:sagemaker:region:account-id:endpoint-config/endpointConfigName"``]`For more information, see [SageMaker API Permissions: Actions, Permissions, and Resources Reference](https://docs.aws.amazon.com/sagemaker/latest/dg/api-permissions-reference.html).
     */
    override suspend fun createEndpoint(input: CreateEndpointRequest): CreateEndpointResponse {
        val op = SdkHttpOperation.build<CreateEndpointRequest, CreateEndpointResponse> {
            serializer = CreateEndpointOperationSerializer()
            deserializer = CreateEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an endpoint configuration that SageMaker hosting services uses to deploy models. In the configuration, you identify one or more models, created using the `CreateModel` API, to deploy and the resources that you want SageMaker to provision. Then you call the CreateEndpoint API.
     *
     *  Use this API if you want to use SageMaker hosting services to deploy models into production.
     *
     * In the request, you define a `ProductionVariant`, for each model that you want to deploy. Each `ProductionVariant` parameter also describes the resources that you want SageMaker to provision. This includes the number and type of ML compute instances to deploy.
     *
     * If you are hosting multiple models, you also assign a `VariantWeight` to specify how much traffic you want to allocate to each model. For example, suppose that you want to host two models, A and B, and you assign traffic weight 2 for model A and 1 for model B. SageMaker distributes two-thirds of the traffic to Model A, and one-third to model B.
     *
     * When you call CreateEndpoint, a load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a DynamoDB table supporting `Eventually Consistent Reads`[](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html), the response might not reflect the results of a recently completed write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB, this causes a validation error. If you repeat your read request after a short time, the response should return the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers call DescribeEndpointConfig before calling CreateEndpoint to minimize the potential impact of a DynamoDB eventually consistent read.
     */
    override suspend fun createEndpointConfig(input: CreateEndpointConfigRequest): CreateEndpointConfigResponse {
        val op = SdkHttpOperation.build<CreateEndpointConfigRequest, CreateEndpointConfigResponse> {
            serializer = CreateEndpointConfigOperationSerializer()
            deserializer = CreateEndpointConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEndpointConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an SageMaker *experiment*. An experiment is a collection of *trials* that are observed, compared and evaluated as a group. A trial is a set of steps, called *trial components*, that produce a machine learning model.
     *
     * The goal of an experiment is to determine the components that produce the best model. Multiple trials are performed, each one isolating and measuring the impact of a change to one or more inputs, while keeping the remaining inputs constant.
     *
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must use the logging APIs provided by the SDK.
     *
     * You can add tags to experiments, trials, trial components and then use the Search API to search for the tags.
     *
     * To add a description to an experiment, specify the optional `Description` parameter. To add a description later, or to change the description, call the UpdateExperiment API.
     *
     * To get a list of all your experiments, call the ListExperiments API. To view an experiment's properties, call the DescribeExperiment API. To get a list of all the trials associated with an experiment, call the ListTrials API. To create a trial call the CreateTrial API.
     */
    override suspend fun createExperiment(input: CreateExperimentRequest): CreateExperimentResponse {
        val op = SdkHttpOperation.build<CreateExperimentRequest, CreateExperimentResponse> {
            serializer = CreateExperimentOperationSerializer()
            deserializer = CreateExperimentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateExperiment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a new `FeatureGroup`. A `FeatureGroup` is a group of `Features` defined in the `FeatureStore` to describe a `Record`.
     *
     * The `FeatureGroup` defines the schema and features contained in the FeatureGroup. A `FeatureGroup` definition is composed of a list of `Features`, a `RecordIdentifierFeatureName`, an `EventTimeFeatureName` and configurations for its `OnlineStore` and `OfflineStore`. Check [Amazon Web Services service quotas](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) to see the `FeatureGroup`s quota for your Amazon Web Services account.
     *
     * You must include at least one of `OnlineStoreConfig` and `OfflineStoreConfig` to create a `FeatureGroup`.
     */
    override suspend fun createFeatureGroup(input: CreateFeatureGroupRequest): CreateFeatureGroupResponse {
        val op = SdkHttpOperation.build<CreateFeatureGroupRequest, CreateFeatureGroupResponse> {
            serializer = CreateFeatureGroupOperationSerializer()
            deserializer = CreateFeatureGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFeatureGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a flow definition.
     */
    override suspend fun createFlowDefinition(input: CreateFlowDefinitionRequest): CreateFlowDefinitionResponse {
        val op = SdkHttpOperation.build<CreateFlowDefinitionRequest, CreateFlowDefinitionResponse> {
            serializer = CreateFlowDefinitionOperationSerializer()
            deserializer = CreateFlowDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFlowDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Defines the settings you will use for the human review workflow user interface. Reviewers will see a three-panel interface with an instruction area, the item to review, and an input area.
     */
    override suspend fun createHumanTaskUi(input: CreateHumanTaskUiRequest): CreateHumanTaskUiResponse {
        val op = SdkHttpOperation.build<CreateHumanTaskUiRequest, CreateHumanTaskUiResponse> {
            serializer = CreateHumanTaskUiOperationSerializer()
            deserializer = CreateHumanTaskUiOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateHumanTaskUi"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a hyperparameter tuning job. A hyperparameter tuning job finds the best version of a model by running many training jobs on your dataset using the algorithm you choose and values for hyperparameters within ranges that you specify. It then chooses the hyperparameter values that result in a model that performs the best, as measured by an objective metric that you choose.
     */
    override suspend fun createHyperParameterTuningJob(input: CreateHyperParameterTuningJobRequest): CreateHyperParameterTuningJobResponse {
        val op = SdkHttpOperation.build<CreateHyperParameterTuningJobRequest, CreateHyperParameterTuningJobResponse> {
            serializer = CreateHyperParameterTuningJobOperationSerializer()
            deserializer = CreateHyperParameterTuningJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateHyperParameterTuningJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a custom SageMaker image. A SageMaker image is a set of image versions. Each image version represents a container image stored in Amazon Elastic Container Registry (ECR). For more information, see [Bring your own SageMaker image](https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html).
     */
    override suspend fun createImage(input: CreateImageRequest): CreateImageResponse {
        val op = SdkHttpOperation.build<CreateImageRequest, CreateImageResponse> {
            serializer = CreateImageOperationSerializer()
            deserializer = CreateImageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateImage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a version of the SageMaker image specified by `ImageName`. The version represents the Amazon Elastic Container Registry (ECR) container image specified by `BaseImage`.
     */
    override suspend fun createImageVersion(input: CreateImageVersionRequest): CreateImageVersionResponse {
        val op = SdkHttpOperation.build<CreateImageVersionRequest, CreateImageVersionResponse> {
            serializer = CreateImageVersionOperationSerializer()
            deserializer = CreateImageVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateImageVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a recommendation job. You can create either an instance recommendation or load test job.
     */
    override suspend fun createInferenceRecommendationsJob(input: CreateInferenceRecommendationsJobRequest): CreateInferenceRecommendationsJobResponse {
        val op = SdkHttpOperation.build<CreateInferenceRecommendationsJobRequest, CreateInferenceRecommendationsJobResponse> {
            serializer = CreateInferenceRecommendationsJobOperationSerializer()
            deserializer = CreateInferenceRecommendationsJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateInferenceRecommendationsJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a job that uses workers to label the data objects in your input dataset. You can use the labeled data to train machine learning models.
     *
     * You can select your workforce from one of three providers:
     * + A private workforce that you create. It can include employees, contractors, and outside experts. Use a private workforce when want the data to stay within your organization or when a specific set of skills is required.
     * + One or more vendors that you select from the Amazon Web Services Marketplace. Vendors provide expertise in specific areas.
     * + The Amazon Mechanical Turk workforce. This is the largest workforce, but it should only be used for public data or data that has been stripped of any personally identifiable information.
     *
     * You can also use *automated data labeling* to reduce the number of data objects that need to be labeled by a human. Automated data labeling uses *active learning* to determine if a data object can be labeled by machine or if it needs to be sent to a human worker. For more information, see [Using Automated Data Labeling](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-automated-labeling.html).
     *
     * The data objects to be labeled are contained in an Amazon S3 bucket. You create a *manifest file* that describes the location of each object. For more information, see [Using Input and Output Data](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data.html).
     *
     * The output can be used as the manifest file for another labeling job or as training data for your machine learning models.
     *
     * You can use this operation to create a static labeling job or a streaming labeling job. A static labeling job stops if all data objects in the input manifest file identified in `ManifestS3Uri` have been labeled. A streaming labeling job runs perpetually until it is manually stopped, or remains idle for 10 days. You can send new data objects to an active (`InProgress`) streaming labeling job in real time. To learn how to create a static labeling job, see [Create a Labeling Job (API) ](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-create-labeling-job-api.html) in the Amazon SageMaker Developer Guide. To learn how to create a streaming labeling job, see [Create a Streaming Labeling Job](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-create-job.html).
     */
    override suspend fun createLabelingJob(input: CreateLabelingJobRequest): CreateLabelingJobResponse {
        val op = SdkHttpOperation.build<CreateLabelingJobRequest, CreateLabelingJobResponse> {
            serializer = CreateLabelingJobOperationSerializer()
            deserializer = CreateLabelingJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLabelingJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a model in SageMaker. In the request, you name the model and describe a primary container. For the primary container, you specify the Docker image that contains inference code, artifacts (from prior training), and a custom environment map that the inference code uses when you deploy the model for predictions.
     *
     * Use this API to create a model if you want to use SageMaker hosting services or run a batch transform job.
     *
     * To host your model, you create an endpoint configuration with the `CreateEndpointConfig` API, and then create an endpoint with the `CreateEndpoint` API. SageMaker then deploys all of the containers that you defined for the model in the hosting environment.
     *
     * For an example that calls this method when deploying a model to SageMaker hosting services, see [Deploy the Model to Amazon SageMaker Hosting Services (Amazon Web Services SDK for Python (Boto 3)).](https://docs.aws.amazon.com/sagemaker/latest/dg/ex1-deploy-model.html#ex1-deploy-model-boto)
     *
     * To run a batch transform using your model, you start a job with the `CreateTransformJob` API. SageMaker uses your model and your dataset to get inferences which are then saved to a specified S3 location.
     *
     * In the request, you also provide an IAM role that SageMaker can assume to access model artifacts and docker image for deployment on ML compute hosting instances or for batch transform jobs. In addition, you also use the IAM role to manage permissions the inference code needs. For example, if the inference code access any other Amazon Web Services resources, you grant necessary permissions via this role.
     */
    override suspend fun createModel(input: CreateModelRequest): CreateModelResponse {
        val op = SdkHttpOperation.build<CreateModelRequest, CreateModelResponse> {
            serializer = CreateModelOperationSerializer()
            deserializer = CreateModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateModel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates the definition for a model bias job.
     */
    override suspend fun createModelBiasJobDefinition(input: CreateModelBiasJobDefinitionRequest): CreateModelBiasJobDefinitionResponse {
        val op = SdkHttpOperation.build<CreateModelBiasJobDefinitionRequest, CreateModelBiasJobDefinitionResponse> {
            serializer = CreateModelBiasJobDefinitionOperationSerializer()
            deserializer = CreateModelBiasJobDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateModelBiasJobDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates the definition for a model explainability job.
     */
    override suspend fun createModelExplainabilityJobDefinition(input: CreateModelExplainabilityJobDefinitionRequest): CreateModelExplainabilityJobDefinitionResponse {
        val op = SdkHttpOperation.build<CreateModelExplainabilityJobDefinitionRequest, CreateModelExplainabilityJobDefinitionResponse> {
            serializer = CreateModelExplainabilityJobDefinitionOperationSerializer()
            deserializer = CreateModelExplainabilityJobDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateModelExplainabilityJobDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a model package that you can use to create SageMaker models or list on Amazon Web Services Marketplace, or a versioned model that is part of a model group. Buyers can subscribe to model packages listed on Amazon Web Services Marketplace to create models in SageMaker.
     *
     * To create a model package by specifying a Docker container that contains your inference code and the Amazon S3 location of your model artifacts, provide values for `InferenceSpecification`. To create a model from an algorithm resource that you created or subscribed to in Amazon Web Services Marketplace, provide a value for `SourceAlgorithmSpecification`.
     *
     * There are two types of model packages:
     * + Versioned - a model that is part of a model group in the model registry.
     * + Unversioned - a model package that is not part of a model group.
     */
    override suspend fun createModelPackage(input: CreateModelPackageRequest): CreateModelPackageResponse {
        val op = SdkHttpOperation.build<CreateModelPackageRequest, CreateModelPackageResponse> {
            serializer = CreateModelPackageOperationSerializer()
            deserializer = CreateModelPackageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateModelPackage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a model group. A model group contains a group of model versions.
     */
    override suspend fun createModelPackageGroup(input: CreateModelPackageGroupRequest): CreateModelPackageGroupResponse {
        val op = SdkHttpOperation.build<CreateModelPackageGroupRequest, CreateModelPackageGroupResponse> {
            serializer = CreateModelPackageGroupOperationSerializer()
            deserializer = CreateModelPackageGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateModelPackageGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a definition for a job that monitors model quality and drift. For information about model monitor, see [Amazon SageMaker Model Monitor](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html).
     */
    override suspend fun createModelQualityJobDefinition(input: CreateModelQualityJobDefinitionRequest): CreateModelQualityJobDefinitionResponse {
        val op = SdkHttpOperation.build<CreateModelQualityJobDefinitionRequest, CreateModelQualityJobDefinitionResponse> {
            serializer = CreateModelQualityJobDefinitionOperationSerializer()
            deserializer = CreateModelQualityJobDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateModelQualityJobDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a schedule that regularly starts Amazon SageMaker Processing Jobs to monitor the data captured for an Amazon SageMaker Endoint.
     */
    override suspend fun createMonitoringSchedule(input: CreateMonitoringScheduleRequest): CreateMonitoringScheduleResponse {
        val op = SdkHttpOperation.build<CreateMonitoringScheduleRequest, CreateMonitoringScheduleResponse> {
            serializer = CreateMonitoringScheduleOperationSerializer()
            deserializer = CreateMonitoringScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateMonitoringSchedule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an SageMaker notebook instance. A notebook instance is a machine learning (ML) compute instance running on a Jupyter notebook.
     *
     * In a `CreateNotebookInstance` request, specify the type of ML compute instance that you want to run. SageMaker launches the instance, installs common libraries that you can use to explore datasets for model training, and attaches an ML storage volume to the notebook instance.
     *
     * SageMaker also provides a set of example notebooks. Each notebook demonstrates how to use SageMaker with a specific algorithm or with a machine learning framework.
     *
     * After receiving the request, SageMaker does the following:
     * + Creates a network interface in the SageMaker VPC.
     * + (Option) If you specified `SubnetId`, SageMaker creates a network interface in your own VPC, which is inferred from the subnet ID that you provide in the input. When creating this network interface, SageMaker attaches the security group that you specified in the request to the network interface that it creates in your VPC.
     * + Launches an EC2 instance of the type specified in the request in the SageMaker VPC. If you specified `SubnetId` of your VPC, SageMaker specifies both network interfaces when launching this instance. This enables inbound traffic from your own VPC to the notebook instance, assuming that the security groups allow it.
     *
     * After creating the notebook instance, SageMaker returns its Amazon Resource Name (ARN). You can't change the name of a notebook instance after you create it.
     *
     * After SageMaker creates the notebook instance, you can connect to the Jupyter server and work in Jupyter notebooks. For example, you can write code to explore a dataset that you can use for model training, train a model, host models by creating SageMaker endpoints, and validate hosted models.
     *
     * For more information, see [How It Works](https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html).
     */
    override suspend fun createNotebookInstance(input: CreateNotebookInstanceRequest): CreateNotebookInstanceResponse {
        val op = SdkHttpOperation.build<CreateNotebookInstanceRequest, CreateNotebookInstanceResponse> {
            serializer = CreateNotebookInstanceOperationSerializer()
            deserializer = CreateNotebookInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateNotebookInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a lifecycle configuration that you can associate with a notebook instance. A *lifecycle configuration* is a collection of shell scripts that run when you create or start a notebook instance.
     *
     * Each lifecycle configuration script has a limit of 16384 characters.
     *
     * The value of the `$PATH` environment variable that is available to both scripts is `/sbin:bin:/usr/sbin:/usr/bin`.
     *
     * View CloudWatch Logs for notebook instance lifecycle configurations in log group `/aws/sagemaker/NotebookInstances` in log stream `[notebook-instance-name]/[LifecycleConfigHook]`.
     *
     * Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs for longer than 5 minutes, it fails and the notebook instance is not created or started.
     *
     * For information about notebook instance lifestyle configurations, see [Step 2.1: (Optional) Customize a Notebook Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
     */
    override suspend fun createNotebookInstanceLifecycleConfig(input: CreateNotebookInstanceLifecycleConfigRequest): CreateNotebookInstanceLifecycleConfigResponse {
        val op = SdkHttpOperation.build<CreateNotebookInstanceLifecycleConfigRequest, CreateNotebookInstanceLifecycleConfigResponse> {
            serializer = CreateNotebookInstanceLifecycleConfigOperationSerializer()
            deserializer = CreateNotebookInstanceLifecycleConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateNotebookInstanceLifecycleConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a pipeline using a JSON pipeline definition.
     */
    override suspend fun createPipeline(input: CreatePipelineRequest): CreatePipelineResponse {
        val op = SdkHttpOperation.build<CreatePipelineRequest, CreatePipelineResponse> {
            serializer = CreatePipelineOperationSerializer()
            deserializer = CreatePipelineOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePipeline"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a URL for a specified UserProfile in a Domain. When accessed in a web browser, the user will be automatically signed in to Amazon SageMaker Studio, and granted access to all of the Apps and files associated with the Domain's Amazon Elastic File System (EFS) volume. This operation can only be called when the authentication mode equals IAM.
     *
     * The IAM role or user used to call this API defines the permissions to access the app. Once the presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for this API are also enforced for every HTTP request and WebSocket frame that attempts to connect to the app.
     *
     * You can restrict access to this API and to the URL that it returns to a list of IP addresses, Amazon VPCs or Amazon VPC Endpoints that you specify. For more information, see [Connect to SageMaker Studio Through an Interface VPC Endpoint](https://docs.aws.amazon.com/sagemaker/latest/dg/studio-interface-endpoint.html) .
     *
     * The URL that you get from a call to `CreatePresignedDomainUrl` has a default timeout of 5 minutes. You can configure this value using `ExpiresInSeconds`. If you try to use the URL after the timeout limit expires, you are directed to the Amazon Web Services console sign-in page.
     */
    override suspend fun createPresignedDomainUrl(input: CreatePresignedDomainUrlRequest): CreatePresignedDomainUrlResponse {
        val op = SdkHttpOperation.build<CreatePresignedDomainUrlRequest, CreatePresignedDomainUrlResponse> {
            serializer = CreatePresignedDomainUrlOperationSerializer()
            deserializer = CreatePresignedDomainUrlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePresignedDomainUrl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a URL that you can use to connect to the Jupyter server from a notebook instance. In the SageMaker console, when you choose `Open` next to a notebook instance, SageMaker opens a new tab showing the Jupyter server home page from the notebook instance. The console uses this API to get the URL and show the page.
     *
     *  The IAM role or user used to call this API defines the permissions to access the notebook instance. Once the presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for this API are also enforced for every HTTP request and WebSocket frame that attempts to connect to the notebook instance.
     *
     * You can restrict access to this API and to the URL that it returns to a list of IP addresses that you specify. Use the `NotIpAddress` condition operator and the `aws:SourceIP` condition context key to specify the list of IP addresses that you want to have access to the notebook instance. For more information, see [Limit Access to a Notebook Instance by IP Address](https://docs.aws.amazon.com/sagemaker/latest/dg/security_iam_id-based-policy-examples.html#nbi-ip-filter).
     *
     * The URL that you get from a call to CreatePresignedNotebookInstanceUrl is valid only for 5 minutes. If you try to use the URL after the 5-minute limit expires, you are directed to the Amazon Web Services console sign-in page.
     */
    override suspend fun createPresignedNotebookInstanceUrl(input: CreatePresignedNotebookInstanceUrlRequest): CreatePresignedNotebookInstanceUrlResponse {
        val op = SdkHttpOperation.build<CreatePresignedNotebookInstanceUrlRequest, CreatePresignedNotebookInstanceUrlResponse> {
            serializer = CreatePresignedNotebookInstanceUrlOperationSerializer()
            deserializer = CreatePresignedNotebookInstanceUrlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePresignedNotebookInstanceUrl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a processing job.
     */
    override suspend fun createProcessingJob(input: CreateProcessingJobRequest): CreateProcessingJobResponse {
        val op = SdkHttpOperation.build<CreateProcessingJobRequest, CreateProcessingJobResponse> {
            serializer = CreateProcessingJobOperationSerializer()
            deserializer = CreateProcessingJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateProcessingJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a machine learning (ML) project that can contain one or more templates that set up an ML pipeline from training to deploying an approved model.
     */
    override suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse {
        val op = SdkHttpOperation.build<CreateProjectRequest, CreateProjectResponse> {
            serializer = CreateProjectOperationSerializer()
            deserializer = CreateProjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateProject"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Studio Lifecycle Configuration.
     */
    override suspend fun createStudioLifecycleConfig(input: CreateStudioLifecycleConfigRequest): CreateStudioLifecycleConfigResponse {
        val op = SdkHttpOperation.build<CreateStudioLifecycleConfigRequest, CreateStudioLifecycleConfigResponse> {
            serializer = CreateStudioLifecycleConfigOperationSerializer()
            deserializer = CreateStudioLifecycleConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateStudioLifecycleConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a model training job. After training completes, SageMaker saves the resulting model artifacts to an Amazon S3 location that you specify.
     *
     * If you choose to host your model using SageMaker hosting services, you can use the resulting model artifacts as part of the model. You can also use the artifacts in a machine learning service other than SageMaker, provided that you know how to use them for inference.
     *
     * In the request body, you provide the following:
     * + `AlgorithmSpecification` - Identifies the training algorithm to use.
     * + `HyperParameters` - Specify these algorithm-specific parameters to enable the estimation of model parameters during training. Hyperparameters can be tuned to optimize this learning process. For a list of hyperparameters for each training algorithm provided by SageMaker, see [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
     * + `InputDataConfig` - Describes the training dataset and the Amazon S3, EFS, or FSx location where it is stored.
     * + `OutputDataConfig` - Identifies the Amazon S3 bucket where you want SageMaker to save the results of model training.
     * + `ResourceConfig` - Identifies the resources, ML compute instances, and ML storage volumes to deploy for model training. In distributed training, you specify more than one instance.
     * + `EnableManagedSpotTraining` - Optimize the cost of training machine learning models by up to 80% by using Amazon EC2 Spot instances. For more information, see [Managed Spot Training](https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html).
     * + `RoleArn` - The Amazon Resource Name (ARN) that SageMaker assumes to perform tasks on your behalf during model training. You must grant this role the necessary permissions so that SageMaker can successfully complete model training.
     * + `StoppingCondition` - To help cap training costs, use `MaxRuntimeInSeconds` to set a time limit for training. Use `MaxWaitTimeInSeconds` to specify how long a managed spot training job has to complete.
     * + `Environment` - The environment variables to set in the Docker container.
     * + `RetryStrategy` - The number of times to retry the job when the job fails due to an `InternalServerError`.
     *
     *  For more information about SageMaker, see [How It Works](https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html).
     */
    override suspend fun createTrainingJob(input: CreateTrainingJobRequest): CreateTrainingJobResponse {
        val op = SdkHttpOperation.build<CreateTrainingJobRequest, CreateTrainingJobResponse> {
            serializer = CreateTrainingJobOperationSerializer()
            deserializer = CreateTrainingJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTrainingJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a transform job. A transform job uses a trained model to get inferences on a dataset and saves these results to an Amazon S3 location that you specify.
     *
     * To perform batch transformations, you create a transform job and use the data that you have readily available.
     *
     * In the request body, you provide the following:
     * + `TransformJobName` - Identifies the transform job. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account.
     * + `ModelName` - Identifies the model to use. `ModelName` must be the name of an existing Amazon SageMaker model in the same Amazon Web Services Region and Amazon Web Services account. For information on creating a model, see [CreateModel](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html).
     * + `TransformInput` - Describes the dataset to be transformed and the Amazon S3 location where it is stored.
     * + `TransformOutput` - Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.
     * + `TransformResources` - Identifies the ML compute instances for the transform job.
     *
     * For more information about how batch transformation works, see [Batch Transform](https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html).
     */
    override suspend fun createTransformJob(input: CreateTransformJobRequest): CreateTransformJobResponse {
        val op = SdkHttpOperation.build<CreateTransformJobRequest, CreateTransformJobResponse> {
            serializer = CreateTransformJobOperationSerializer()
            deserializer = CreateTransformJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTransformJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an SageMaker *trial*. A trial is a set of steps called *trial components* that produce a machine learning model. A trial is part of a single SageMaker *experiment*.
     *
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must use the logging APIs provided by the SDK.
     *
     * You can add tags to a trial and then use the Search API to search for the tags.
     *
     * To get a list of all your trials, call the ListTrials API. To view a trial's properties, call the DescribeTrial API. To create a trial component, call the CreateTrialComponent API.
     */
    override suspend fun createTrial(input: CreateTrialRequest): CreateTrialResponse {
        val op = SdkHttpOperation.build<CreateTrialRequest, CreateTrialResponse> {
            serializer = CreateTrialOperationSerializer()
            deserializer = CreateTrialOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTrial"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a *trial component*, which is a stage of a machine learning *trial*. A trial is composed of one or more trial components. A trial component can be used in multiple trials.
     *
     * Trial components include pre-processing jobs, training jobs, and batch transform jobs.
     *
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must use the logging APIs provided by the SDK.
     *
     * You can add tags to a trial component and then use the Search API to search for the tags.
     */
    override suspend fun createTrialComponent(input: CreateTrialComponentRequest): CreateTrialComponentResponse {
        val op = SdkHttpOperation.build<CreateTrialComponentRequest, CreateTrialComponentResponse> {
            serializer = CreateTrialComponentOperationSerializer()
            deserializer = CreateTrialComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTrialComponent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a user profile. A user profile represents a single user within a domain, and is the main way to reference a "person" for the purposes of sharing, reporting, and other user-oriented features. This entity is created when a user onboards to Amazon SageMaker Studio. If an administrator invites a person by email or imports them from SSO, a user profile is automatically created. A user profile is the primary holder of settings for an individual user and has a reference to the user's private Amazon Elastic File System (EFS) home directory.
     */
    override suspend fun createUserProfile(input: CreateUserProfileRequest): CreateUserProfileResponse {
        val op = SdkHttpOperation.build<CreateUserProfileRequest, CreateUserProfileResponse> {
            serializer = CreateUserProfileOperationSerializer()
            deserializer = CreateUserProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateUserProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Use this operation to create a workforce. This operation will return an error if a workforce already exists in the Amazon Web Services Region that you specify. You can only create one workforce in each Amazon Web Services Region per Amazon Web Services account.
     *
     * If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use the API operation to delete the existing workforce and then use `CreateWorkforce` to create a new workforce.
     *
     * To create a private workforce using Amazon Cognito, you must specify a Cognito user pool in `CognitoConfig`. You can also create an Amazon Cognito workforce using the Amazon SageMaker console. For more information, see [ Create a Private Workforce (Amazon Cognito)](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html).
     *
     * To create a private workforce using your own OIDC Identity Provider (IdP), specify your IdP configuration in `OidcConfig`. Your OIDC IdP must support *groups* because groups are used by Ground Truth and Amazon A2I to create work teams. For more information, see [ Create a Private Workforce (OIDC IdP)](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private-oidc.html).
     */
    override suspend fun createWorkforce(input: CreateWorkforceRequest): CreateWorkforceResponse {
        val op = SdkHttpOperation.build<CreateWorkforceRequest, CreateWorkforceResponse> {
            serializer = CreateWorkforceOperationSerializer()
            deserializer = CreateWorkforceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateWorkforce"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new work team for labeling your data. A work team is defined by one or more Amazon Cognito user pools. You must first create the user pools before you can create a work team.
     *
     * You cannot create more than 25 work teams in an account and region.
     */
    override suspend fun createWorkteam(input: CreateWorkteamRequest): CreateWorkteamResponse {
        val op = SdkHttpOperation.build<CreateWorkteamRequest, CreateWorkteamResponse> {
            serializer = CreateWorkteamOperationSerializer()
            deserializer = CreateWorkteamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateWorkteam"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an action.
     */
    override suspend fun deleteAction(input: DeleteActionRequest): DeleteActionResponse {
        val op = SdkHttpOperation.build<DeleteActionRequest, DeleteActionResponse> {
            serializer = DeleteActionOperationSerializer()
            deserializer = DeleteActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified algorithm from your account.
     */
    override suspend fun deleteAlgorithm(input: DeleteAlgorithmRequest): DeleteAlgorithmResponse {
        val op = SdkHttpOperation.build<DeleteAlgorithmRequest, DeleteAlgorithmResponse> {
            serializer = DeleteAlgorithmOperationSerializer()
            deserializer = DeleteAlgorithmOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAlgorithm"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Used to stop and delete an app.
     */
    override suspend fun deleteApp(input: DeleteAppRequest): DeleteAppResponse {
        val op = SdkHttpOperation.build<DeleteAppRequest, DeleteAppResponse> {
            serializer = DeleteAppOperationSerializer()
            deserializer = DeleteAppOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an AppImageConfig.
     */
    override suspend fun deleteAppImageConfig(input: DeleteAppImageConfigRequest): DeleteAppImageConfigResponse {
        val op = SdkHttpOperation.build<DeleteAppImageConfigRequest, DeleteAppImageConfigResponse> {
            serializer = DeleteAppImageConfigOperationSerializer()
            deserializer = DeleteAppImageConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAppImageConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an artifact. Either `ArtifactArn` or `Source` must be specified.
     */
    override suspend fun deleteArtifact(input: DeleteArtifactRequest): DeleteArtifactResponse {
        val op = SdkHttpOperation.build<DeleteArtifactRequest, DeleteArtifactResponse> {
            serializer = DeleteArtifactOperationSerializer()
            deserializer = DeleteArtifactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteArtifact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an association.
     */
    override suspend fun deleteAssociation(input: DeleteAssociationRequest): DeleteAssociationResponse {
        val op = SdkHttpOperation.build<DeleteAssociationRequest, DeleteAssociationResponse> {
            serializer = DeleteAssociationOperationSerializer()
            deserializer = DeleteAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAssociation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Git repository from your account.
     */
    override suspend fun deleteCodeRepository(input: DeleteCodeRepositoryRequest): DeleteCodeRepositoryResponse {
        val op = SdkHttpOperation.build<DeleteCodeRepositoryRequest, DeleteCodeRepositoryResponse> {
            serializer = DeleteCodeRepositoryOperationSerializer()
            deserializer = DeleteCodeRepositoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCodeRepository"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an context.
     */
    override suspend fun deleteContext(input: DeleteContextRequest): DeleteContextResponse {
        val op = SdkHttpOperation.build<DeleteContextRequest, DeleteContextResponse> {
            serializer = DeleteContextOperationSerializer()
            deserializer = DeleteContextOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteContext"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a data quality monitoring job definition.
     */
    override suspend fun deleteDataQualityJobDefinition(input: DeleteDataQualityJobDefinitionRequest): DeleteDataQualityJobDefinitionResponse {
        val op = SdkHttpOperation.build<DeleteDataQualityJobDefinitionRequest, DeleteDataQualityJobDefinitionResponse> {
            serializer = DeleteDataQualityJobDefinitionOperationSerializer()
            deserializer = DeleteDataQualityJobDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDataQualityJobDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a fleet.
     */
    override suspend fun deleteDeviceFleet(input: DeleteDeviceFleetRequest): DeleteDeviceFleetResponse {
        val op = SdkHttpOperation.build<DeleteDeviceFleetRequest, DeleteDeviceFleetResponse> {
            serializer = DeleteDeviceFleetOperationSerializer()
            deserializer = DeleteDeviceFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDeviceFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Used to delete a domain. If you onboarded with IAM mode, you will need to delete your domain to onboard again using SSO. Use with caution. All of the members of the domain will lose access to their EFS volume, including data, notebooks, and other artifacts.
     */
    override suspend fun deleteDomain(input: DeleteDomainRequest): DeleteDomainResponse {
        val op = SdkHttpOperation.build<DeleteDomainRequest, DeleteDomainResponse> {
            serializer = DeleteDomainOperationSerializer()
            deserializer = DeleteDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an endpoint. SageMaker frees up all of the resources that were deployed when the endpoint was created.
     *
     * SageMaker retires any custom KMS key grants associated with the endpoint, meaning you don't need to use the [RevokeGrant](http://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html) API call.
     *
     * When you delete your endpoint, SageMaker asynchronously deletes associated endpoint resources such as KMS key grants. You might still see these resources in your account for a few minutes after deleting your endpoint. Do not delete or revoke the permissions for your ` <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html#sagemaker-CreateModel-request-ExecutionRoleArn">ExecutionRoleArn</a> `, otherwise SageMaker cannot delete these resources.
     */
    override suspend fun deleteEndpoint(input: DeleteEndpointRequest): DeleteEndpointResponse {
        val op = SdkHttpOperation.build<DeleteEndpointRequest, DeleteEndpointResponse> {
            serializer = DeleteEndpointOperationSerializer()
            deserializer = DeleteEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an endpoint configuration. The `DeleteEndpointConfig` API deletes only the specified configuration. It does not delete endpoints created using the configuration.
     *
     * You must not delete an `EndpointConfig` in use by an endpoint that is live or while the `UpdateEndpoint` or `CreateEndpoint` operations are being performed on the endpoint. If you delete the `EndpointConfig` of an endpoint that is active or being created or updated you may lose visibility into the instance type the endpoint is using. The endpoint must be deleted in order to stop incurring charges.
     */
    override suspend fun deleteEndpointConfig(input: DeleteEndpointConfigRequest): DeleteEndpointConfigResponse {
        val op = SdkHttpOperation.build<DeleteEndpointConfigRequest, DeleteEndpointConfigResponse> {
            serializer = DeleteEndpointConfigOperationSerializer()
            deserializer = DeleteEndpointConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEndpointConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an SageMaker experiment. All trials associated with the experiment must be deleted first. Use the ListTrials API to get a list of the trials associated with the experiment.
     */
    override suspend fun deleteExperiment(input: DeleteExperimentRequest): DeleteExperimentResponse {
        val op = SdkHttpOperation.build<DeleteExperimentRequest, DeleteExperimentResponse> {
            serializer = DeleteExperimentOperationSerializer()
            deserializer = DeleteExperimentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteExperiment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete the `FeatureGroup` and any data that was written to the `OnlineStore` of the `FeatureGroup`. Data cannot be accessed from the `OnlineStore` immediately after `DeleteFeatureGroup` is called.
     *
     * Data written into the `OfflineStore` will not be deleted. The Amazon Web Services Glue database and tables that are automatically created for your `OfflineStore` are not deleted.
     */
    override suspend fun deleteFeatureGroup(input: DeleteFeatureGroupRequest): DeleteFeatureGroupResponse {
        val op = SdkHttpOperation.build<DeleteFeatureGroupRequest, DeleteFeatureGroupResponse> {
            serializer = DeleteFeatureGroupOperationSerializer()
            deserializer = DeleteFeatureGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFeatureGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified flow definition.
     */
    override suspend fun deleteFlowDefinition(input: DeleteFlowDefinitionRequest): DeleteFlowDefinitionResponse {
        val op = SdkHttpOperation.build<DeleteFlowDefinitionRequest, DeleteFlowDefinitionResponse> {
            serializer = DeleteFlowDefinitionOperationSerializer()
            deserializer = DeleteFlowDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFlowDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Use this operation to delete a human task user interface (worker task template).
     *
     *  To see a list of human task user interfaces (work task templates) in your account, use . When you delete a worker task template, it no longer appears when you call `ListHumanTaskUis`.
     */
    override suspend fun deleteHumanTaskUi(input: DeleteHumanTaskUiRequest): DeleteHumanTaskUiResponse {
        val op = SdkHttpOperation.build<DeleteHumanTaskUiRequest, DeleteHumanTaskUiResponse> {
            serializer = DeleteHumanTaskUiOperationSerializer()
            deserializer = DeleteHumanTaskUiOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteHumanTaskUi"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a SageMaker image and all versions of the image. The container images aren't deleted.
     */
    override suspend fun deleteImage(input: DeleteImageRequest): DeleteImageResponse {
        val op = SdkHttpOperation.build<DeleteImageRequest, DeleteImageResponse> {
            serializer = DeleteImageOperationSerializer()
            deserializer = DeleteImageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteImage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a version of a SageMaker image. The container image the version represents isn't deleted.
     */
    override suspend fun deleteImageVersion(input: DeleteImageVersionRequest): DeleteImageVersionResponse {
        val op = SdkHttpOperation.build<DeleteImageVersionRequest, DeleteImageVersionResponse> {
            serializer = DeleteImageVersionOperationSerializer()
            deserializer = DeleteImageVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteImageVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a model. The `DeleteModel` API deletes only the model entry that was created in SageMaker when you called the `CreateModel` API. It does not delete model artifacts, inference code, or the IAM role that you specified when creating the model.
     */
    override suspend fun deleteModel(input: DeleteModelRequest): DeleteModelResponse {
        val op = SdkHttpOperation.build<DeleteModelRequest, DeleteModelResponse> {
            serializer = DeleteModelOperationSerializer()
            deserializer = DeleteModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteModel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon SageMaker model bias job definition.
     */
    override suspend fun deleteModelBiasJobDefinition(input: DeleteModelBiasJobDefinitionRequest): DeleteModelBiasJobDefinitionResponse {
        val op = SdkHttpOperation.build<DeleteModelBiasJobDefinitionRequest, DeleteModelBiasJobDefinitionResponse> {
            serializer = DeleteModelBiasJobDefinitionOperationSerializer()
            deserializer = DeleteModelBiasJobDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteModelBiasJobDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon SageMaker model explainability job definition.
     */
    override suspend fun deleteModelExplainabilityJobDefinition(input: DeleteModelExplainabilityJobDefinitionRequest): DeleteModelExplainabilityJobDefinitionResponse {
        val op = SdkHttpOperation.build<DeleteModelExplainabilityJobDefinitionRequest, DeleteModelExplainabilityJobDefinitionResponse> {
            serializer = DeleteModelExplainabilityJobDefinitionOperationSerializer()
            deserializer = DeleteModelExplainabilityJobDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteModelExplainabilityJobDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a model package.
     *
     * A model package is used to create SageMaker models or list on Amazon Web Services Marketplace. Buyers can subscribe to model packages listed on Amazon Web Services Marketplace to create models in SageMaker.
     */
    override suspend fun deleteModelPackage(input: DeleteModelPackageRequest): DeleteModelPackageResponse {
        val op = SdkHttpOperation.build<DeleteModelPackageRequest, DeleteModelPackageResponse> {
            serializer = DeleteModelPackageOperationSerializer()
            deserializer = DeleteModelPackageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteModelPackage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified model group.
     */
    override suspend fun deleteModelPackageGroup(input: DeleteModelPackageGroupRequest): DeleteModelPackageGroupResponse {
        val op = SdkHttpOperation.build<DeleteModelPackageGroupRequest, DeleteModelPackageGroupResponse> {
            serializer = DeleteModelPackageGroupOperationSerializer()
            deserializer = DeleteModelPackageGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteModelPackageGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a model group resource policy.
     */
    override suspend fun deleteModelPackageGroupPolicy(input: DeleteModelPackageGroupPolicyRequest): DeleteModelPackageGroupPolicyResponse {
        val op = SdkHttpOperation.build<DeleteModelPackageGroupPolicyRequest, DeleteModelPackageGroupPolicyResponse> {
            serializer = DeleteModelPackageGroupPolicyOperationSerializer()
            deserializer = DeleteModelPackageGroupPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteModelPackageGroupPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the secified model quality monitoring job definition.
     */
    override suspend fun deleteModelQualityJobDefinition(input: DeleteModelQualityJobDefinitionRequest): DeleteModelQualityJobDefinitionResponse {
        val op = SdkHttpOperation.build<DeleteModelQualityJobDefinitionRequest, DeleteModelQualityJobDefinitionResponse> {
            serializer = DeleteModelQualityJobDefinitionOperationSerializer()
            deserializer = DeleteModelQualityJobDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteModelQualityJobDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a monitoring schedule. Also stops the schedule had not already been stopped. This does not delete the job execution history of the monitoring schedule.
     */
    override suspend fun deleteMonitoringSchedule(input: DeleteMonitoringScheduleRequest): DeleteMonitoringScheduleResponse {
        val op = SdkHttpOperation.build<DeleteMonitoringScheduleRequest, DeleteMonitoringScheduleResponse> {
            serializer = DeleteMonitoringScheduleOperationSerializer()
            deserializer = DeleteMonitoringScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteMonitoringSchedule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an SageMaker notebook instance. Before you can delete a notebook instance, you must call the `StopNotebookInstance` API.
     *
     * When you delete a notebook instance, you lose all of your data. SageMaker removes the ML compute instance, and deletes the ML storage volume and the network interface associated with the notebook instance.
     */
    override suspend fun deleteNotebookInstance(input: DeleteNotebookInstanceRequest): DeleteNotebookInstanceResponse {
        val op = SdkHttpOperation.build<DeleteNotebookInstanceRequest, DeleteNotebookInstanceResponse> {
            serializer = DeleteNotebookInstanceOperationSerializer()
            deserializer = DeleteNotebookInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNotebookInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a notebook instance lifecycle configuration.
     */
    override suspend fun deleteNotebookInstanceLifecycleConfig(input: DeleteNotebookInstanceLifecycleConfigRequest): DeleteNotebookInstanceLifecycleConfigResponse {
        val op = SdkHttpOperation.build<DeleteNotebookInstanceLifecycleConfigRequest, DeleteNotebookInstanceLifecycleConfigResponse> {
            serializer = DeleteNotebookInstanceLifecycleConfigOperationSerializer()
            deserializer = DeleteNotebookInstanceLifecycleConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNotebookInstanceLifecycleConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a pipeline if there are no running instances of the pipeline. To delete a pipeline, you must stop all running instances of the pipeline using the `StopPipelineExecution` API. When you delete a pipeline, all instances of the pipeline are deleted.
     */
    override suspend fun deletePipeline(input: DeletePipelineRequest): DeletePipelineResponse {
        val op = SdkHttpOperation.build<DeletePipelineRequest, DeletePipelineResponse> {
            serializer = DeletePipelineOperationSerializer()
            deserializer = DeletePipelineOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePipeline"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete the specified project.
     */
    override suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse {
        val op = SdkHttpOperation.build<DeleteProjectRequest, DeleteProjectResponse> {
            serializer = DeleteProjectOperationSerializer()
            deserializer = DeleteProjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteProject"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the Studio Lifecycle Configuration. In order to delete the Lifecycle Configuration, there must be no running apps using the Lifecycle Configuration. You must also remove the Lifecycle Configuration from UserSettings in all Domains and UserProfiles.
     */
    override suspend fun deleteStudioLifecycleConfig(input: DeleteStudioLifecycleConfigRequest): DeleteStudioLifecycleConfigResponse {
        val op = SdkHttpOperation.build<DeleteStudioLifecycleConfigRequest, DeleteStudioLifecycleConfigResponse> {
            serializer = DeleteStudioLifecycleConfigOperationSerializer()
            deserializer = DeleteStudioLifecycleConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteStudioLifecycleConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified tags from an SageMaker resource.
     *
     * To list a resource's tags, use the `ListTags` API.
     *
     * When you call this API to delete tags from a hyperparameter tuning job, the deleted tags are not removed from training jobs that the hyperparameter tuning job launched before you called this API.
     *
     * When you call this API to delete tags from a SageMaker Studio Domain or User Profile, the deleted tags are not removed from Apps that the SageMaker Studio Domain or User Profile launched before you called this API.
     */
    override suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse {
        val op = SdkHttpOperation.build<DeleteTagsRequest, DeleteTagsResponse> {
            serializer = DeleteTagsOperationSerializer()
            deserializer = DeleteTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified trial. All trial components that make up the trial must be deleted first. Use the DescribeTrialComponent API to get the list of trial components.
     */
    override suspend fun deleteTrial(input: DeleteTrialRequest): DeleteTrialResponse {
        val op = SdkHttpOperation.build<DeleteTrialRequest, DeleteTrialResponse> {
            serializer = DeleteTrialOperationSerializer()
            deserializer = DeleteTrialOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTrial"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified trial component. A trial component must be disassociated from all trials before the trial component can be deleted. To disassociate a trial component from a trial, call the DisassociateTrialComponent API.
     */
    override suspend fun deleteTrialComponent(input: DeleteTrialComponentRequest): DeleteTrialComponentResponse {
        val op = SdkHttpOperation.build<DeleteTrialComponentRequest, DeleteTrialComponentResponse> {
            serializer = DeleteTrialComponentOperationSerializer()
            deserializer = DeleteTrialComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTrialComponent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a user profile. When a user profile is deleted, the user loses access to their EFS volume, including data, notebooks, and other artifacts.
     */
    override suspend fun deleteUserProfile(input: DeleteUserProfileRequest): DeleteUserProfileResponse {
        val op = SdkHttpOperation.build<DeleteUserProfileRequest, DeleteUserProfileResponse> {
            serializer = DeleteUserProfileOperationSerializer()
            deserializer = DeleteUserProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteUserProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Use this operation to delete a workforce.
     *
     * If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use this operation to delete the existing workforce and then use to create a new workforce.
     *
     * If a private workforce contains one or more work teams, you must use the operation to delete all work teams before you delete the workforce. If you try to delete a workforce that contains one or more work teams, you will recieve a `ResourceInUse` error.
     */
    override suspend fun deleteWorkforce(input: DeleteWorkforceRequest): DeleteWorkforceResponse {
        val op = SdkHttpOperation.build<DeleteWorkforceRequest, DeleteWorkforceResponse> {
            serializer = DeleteWorkforceOperationSerializer()
            deserializer = DeleteWorkforceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteWorkforce"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing work team. This operation can't be undone.
     */
    override suspend fun deleteWorkteam(input: DeleteWorkteamRequest): DeleteWorkteamResponse {
        val op = SdkHttpOperation.build<DeleteWorkteamRequest, DeleteWorkteamResponse> {
            serializer = DeleteWorkteamOperationSerializer()
            deserializer = DeleteWorkteamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteWorkteam"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deregisters the specified devices. After you deregister a device, you will need to re-register the devices.
     */
    override suspend fun deregisterDevices(input: DeregisterDevicesRequest): DeregisterDevicesResponse {
        val op = SdkHttpOperation.build<DeregisterDevicesRequest, DeregisterDevicesResponse> {
            serializer = DeregisterDevicesOperationSerializer()
            deserializer = DeregisterDevicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterDevices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes an action.
     */
    override suspend fun describeAction(input: DescribeActionRequest): DescribeActionResponse {
        val op = SdkHttpOperation.build<DescribeActionRequest, DescribeActionResponse> {
            serializer = DescribeActionOperationSerializer()
            deserializer = DescribeActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a description of the specified algorithm that is in your account.
     */
    override suspend fun describeAlgorithm(input: DescribeAlgorithmRequest): DescribeAlgorithmResponse {
        val op = SdkHttpOperation.build<DescribeAlgorithmRequest, DescribeAlgorithmResponse> {
            serializer = DescribeAlgorithmOperationSerializer()
            deserializer = DescribeAlgorithmOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAlgorithm"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the app.
     */
    override suspend fun describeApp(input: DescribeAppRequest): DescribeAppResponse {
        val op = SdkHttpOperation.build<DescribeAppRequest, DescribeAppResponse> {
            serializer = DescribeAppOperationSerializer()
            deserializer = DescribeAppOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeApp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes an AppImageConfig.
     */
    override suspend fun describeAppImageConfig(input: DescribeAppImageConfigRequest): DescribeAppImageConfigResponse {
        val op = SdkHttpOperation.build<DescribeAppImageConfigRequest, DescribeAppImageConfigResponse> {
            serializer = DescribeAppImageConfigOperationSerializer()
            deserializer = DescribeAppImageConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAppImageConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes an artifact.
     */
    override suspend fun describeArtifact(input: DescribeArtifactRequest): DescribeArtifactResponse {
        val op = SdkHttpOperation.build<DescribeArtifactRequest, DescribeArtifactResponse> {
            serializer = DescribeArtifactOperationSerializer()
            deserializer = DescribeArtifactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeArtifact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about an Amazon SageMaker AutoML job.
     */
    override suspend fun describeAutoMlJob(input: DescribeAutoMlJobRequest): DescribeAutoMlJobResponse {
        val op = SdkHttpOperation.build<DescribeAutoMlJobRequest, DescribeAutoMlJobResponse> {
            serializer = DescribeAutoMLJobOperationSerializer()
            deserializer = DescribeAutoMLJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAutoMLJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets details about the specified Git repository.
     */
    override suspend fun describeCodeRepository(input: DescribeCodeRepositoryRequest): DescribeCodeRepositoryResponse {
        val op = SdkHttpOperation.build<DescribeCodeRepositoryRequest, DescribeCodeRepositoryResponse> {
            serializer = DescribeCodeRepositoryOperationSerializer()
            deserializer = DescribeCodeRepositoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCodeRepository"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a model compilation job.
     *
     * To create a model compilation job, use CreateCompilationJob. To get information about multiple model compilation jobs, use ListCompilationJobs.
     */
    override suspend fun describeCompilationJob(input: DescribeCompilationJobRequest): DescribeCompilationJobResponse {
        val op = SdkHttpOperation.build<DescribeCompilationJobRequest, DescribeCompilationJobResponse> {
            serializer = DescribeCompilationJobOperationSerializer()
            deserializer = DescribeCompilationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCompilationJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a context.
     */
    override suspend fun describeContext(input: DescribeContextRequest): DescribeContextResponse {
        val op = SdkHttpOperation.build<DescribeContextRequest, DescribeContextResponse> {
            serializer = DescribeContextOperationSerializer()
            deserializer = DescribeContextOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeContext"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the details of a data quality monitoring job definition.
     */
    override suspend fun describeDataQualityJobDefinition(input: DescribeDataQualityJobDefinitionRequest): DescribeDataQualityJobDefinitionResponse {
        val op = SdkHttpOperation.build<DescribeDataQualityJobDefinitionRequest, DescribeDataQualityJobDefinitionResponse> {
            serializer = DescribeDataQualityJobDefinitionOperationSerializer()
            deserializer = DescribeDataQualityJobDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDataQualityJobDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the device.
     */
    override suspend fun describeDevice(input: DescribeDeviceRequest): DescribeDeviceResponse {
        val op = SdkHttpOperation.build<DescribeDeviceRequest, DescribeDeviceResponse> {
            serializer = DescribeDeviceOperationSerializer()
            deserializer = DescribeDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * A description of the fleet the device belongs to.
     */
    override suspend fun describeDeviceFleet(input: DescribeDeviceFleetRequest): DescribeDeviceFleetResponse {
        val op = SdkHttpOperation.build<DescribeDeviceFleetRequest, DescribeDeviceFleetResponse> {
            serializer = DescribeDeviceFleetOperationSerializer()
            deserializer = DescribeDeviceFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDeviceFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The description of the domain.
     */
    override suspend fun describeDomain(input: DescribeDomainRequest): DescribeDomainResponse {
        val op = SdkHttpOperation.build<DescribeDomainRequest, DescribeDomainResponse> {
            serializer = DescribeDomainOperationSerializer()
            deserializer = DescribeDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * A description of edge packaging jobs.
     */
    override suspend fun describeEdgePackagingJob(input: DescribeEdgePackagingJobRequest): DescribeEdgePackagingJobResponse {
        val op = SdkHttpOperation.build<DescribeEdgePackagingJobRequest, DescribeEdgePackagingJobResponse> {
            serializer = DescribeEdgePackagingJobOperationSerializer()
            deserializer = DescribeEdgePackagingJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEdgePackagingJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the description of an endpoint.
     */
    override suspend fun describeEndpoint(input: DescribeEndpointRequest): DescribeEndpointResponse {
        val op = SdkHttpOperation.build<DescribeEndpointRequest, DescribeEndpointResponse> {
            serializer = DescribeEndpointOperationSerializer()
            deserializer = DescribeEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the description of an endpoint configuration created using the `CreateEndpointConfig` API.
     */
    override suspend fun describeEndpointConfig(input: DescribeEndpointConfigRequest): DescribeEndpointConfigResponse {
        val op = SdkHttpOperation.build<DescribeEndpointConfigRequest, DescribeEndpointConfigResponse> {
            serializer = DescribeEndpointConfigOperationSerializer()
            deserializer = DescribeEndpointConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEndpointConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides a list of an experiment's properties.
     */
    override suspend fun describeExperiment(input: DescribeExperimentRequest): DescribeExperimentResponse {
        val op = SdkHttpOperation.build<DescribeExperimentRequest, DescribeExperimentResponse> {
            serializer = DescribeExperimentOperationSerializer()
            deserializer = DescribeExperimentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeExperiment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Use this operation to describe a `FeatureGroup`. The response includes information on the creation time, `FeatureGroup` name, the unique identifier for each `FeatureGroup`, and more.
     */
    override suspend fun describeFeatureGroup(input: DescribeFeatureGroupRequest): DescribeFeatureGroupResponse {
        val op = SdkHttpOperation.build<DescribeFeatureGroupRequest, DescribeFeatureGroupResponse> {
            serializer = DescribeFeatureGroupOperationSerializer()
            deserializer = DescribeFeatureGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFeatureGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the specified flow definition.
     */
    override suspend fun describeFlowDefinition(input: DescribeFlowDefinitionRequest): DescribeFlowDefinitionResponse {
        val op = SdkHttpOperation.build<DescribeFlowDefinitionRequest, DescribeFlowDefinitionResponse> {
            serializer = DescribeFlowDefinitionOperationSerializer()
            deserializer = DescribeFlowDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFlowDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the requested human task user interface (worker task template).
     */
    override suspend fun describeHumanTaskUi(input: DescribeHumanTaskUiRequest): DescribeHumanTaskUiResponse {
        val op = SdkHttpOperation.build<DescribeHumanTaskUiRequest, DescribeHumanTaskUiResponse> {
            serializer = DescribeHumanTaskUiOperationSerializer()
            deserializer = DescribeHumanTaskUiOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeHumanTaskUi"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a description of a hyperparameter tuning job.
     */
    override suspend fun describeHyperParameterTuningJob(input: DescribeHyperParameterTuningJobRequest): DescribeHyperParameterTuningJobResponse {
        val op = SdkHttpOperation.build<DescribeHyperParameterTuningJobRequest, DescribeHyperParameterTuningJobResponse> {
            serializer = DescribeHyperParameterTuningJobOperationSerializer()
            deserializer = DescribeHyperParameterTuningJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeHyperParameterTuningJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a SageMaker image.
     */
    override suspend fun describeImage(input: DescribeImageRequest): DescribeImageResponse {
        val op = SdkHttpOperation.build<DescribeImageRequest, DescribeImageResponse> {
            serializer = DescribeImageOperationSerializer()
            deserializer = DescribeImageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeImage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a version of a SageMaker image.
     */
    override suspend fun describeImageVersion(input: DescribeImageVersionRequest): DescribeImageVersionResponse {
        val op = SdkHttpOperation.build<DescribeImageVersionRequest, DescribeImageVersionResponse> {
            serializer = DescribeImageVersionOperationSerializer()
            deserializer = DescribeImageVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeImageVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides the results of the Inference Recommender job. One or more recommendation jobs are returned.
     */
    override suspend fun describeInferenceRecommendationsJob(input: DescribeInferenceRecommendationsJobRequest): DescribeInferenceRecommendationsJobResponse {
        val op = SdkHttpOperation.build<DescribeInferenceRecommendationsJobRequest, DescribeInferenceRecommendationsJobResponse> {
            serializer = DescribeInferenceRecommendationsJobOperationSerializer()
            deserializer = DescribeInferenceRecommendationsJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInferenceRecommendationsJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a labeling job.
     */
    override suspend fun describeLabelingJob(input: DescribeLabelingJobRequest): DescribeLabelingJobResponse {
        val op = SdkHttpOperation.build<DescribeLabelingJobRequest, DescribeLabelingJobResponse> {
            serializer = DescribeLabelingJobOperationSerializer()
            deserializer = DescribeLabelingJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLabelingJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides a list of properties for the requested lineage group. For more information, see [ Cross-Account Lineage Tracking ](https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html) in the *Amazon SageMaker Developer Guide*.
     */
    override suspend fun describeLineageGroup(input: DescribeLineageGroupRequest): DescribeLineageGroupResponse {
        val op = SdkHttpOperation.build<DescribeLineageGroupRequest, DescribeLineageGroupResponse> {
            serializer = DescribeLineageGroupOperationSerializer()
            deserializer = DescribeLineageGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLineageGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a model that you created using the `CreateModel` API.
     */
    override suspend fun describeModel(input: DescribeModelRequest): DescribeModelResponse {
        val op = SdkHttpOperation.build<DescribeModelRequest, DescribeModelResponse> {
            serializer = DescribeModelOperationSerializer()
            deserializer = DescribeModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeModel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a description of a model bias job definition.
     */
    override suspend fun describeModelBiasJobDefinition(input: DescribeModelBiasJobDefinitionRequest): DescribeModelBiasJobDefinitionResponse {
        val op = SdkHttpOperation.build<DescribeModelBiasJobDefinitionRequest, DescribeModelBiasJobDefinitionResponse> {
            serializer = DescribeModelBiasJobDefinitionOperationSerializer()
            deserializer = DescribeModelBiasJobDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeModelBiasJobDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a description of a model explainability job definition.
     */
    override suspend fun describeModelExplainabilityJobDefinition(input: DescribeModelExplainabilityJobDefinitionRequest): DescribeModelExplainabilityJobDefinitionResponse {
        val op = SdkHttpOperation.build<DescribeModelExplainabilityJobDefinitionRequest, DescribeModelExplainabilityJobDefinitionResponse> {
            serializer = DescribeModelExplainabilityJobDefinitionOperationSerializer()
            deserializer = DescribeModelExplainabilityJobDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeModelExplainabilityJobDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a description of the specified model package, which is used to create SageMaker models or list them on Amazon Web Services Marketplace.
     *
     * To create models in SageMaker, buyers can subscribe to model packages listed on Amazon Web Services Marketplace.
     */
    override suspend fun describeModelPackage(input: DescribeModelPackageRequest): DescribeModelPackageResponse {
        val op = SdkHttpOperation.build<DescribeModelPackageRequest, DescribeModelPackageResponse> {
            serializer = DescribeModelPackageOperationSerializer()
            deserializer = DescribeModelPackageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeModelPackage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a description for the specified model group.
     */
    override suspend fun describeModelPackageGroup(input: DescribeModelPackageGroupRequest): DescribeModelPackageGroupResponse {
        val op = SdkHttpOperation.build<DescribeModelPackageGroupRequest, DescribeModelPackageGroupResponse> {
            serializer = DescribeModelPackageGroupOperationSerializer()
            deserializer = DescribeModelPackageGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeModelPackageGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a description of a model quality job definition.
     */
    override suspend fun describeModelQualityJobDefinition(input: DescribeModelQualityJobDefinitionRequest): DescribeModelQualityJobDefinitionResponse {
        val op = SdkHttpOperation.build<DescribeModelQualityJobDefinitionRequest, DescribeModelQualityJobDefinitionResponse> {
            serializer = DescribeModelQualityJobDefinitionOperationSerializer()
            deserializer = DescribeModelQualityJobDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeModelQualityJobDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the schedule for a monitoring job.
     */
    override suspend fun describeMonitoringSchedule(input: DescribeMonitoringScheduleRequest): DescribeMonitoringScheduleResponse {
        val op = SdkHttpOperation.build<DescribeMonitoringScheduleRequest, DescribeMonitoringScheduleResponse> {
            serializer = DescribeMonitoringScheduleOperationSerializer()
            deserializer = DescribeMonitoringScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeMonitoringSchedule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a notebook instance.
     */
    override suspend fun describeNotebookInstance(input: DescribeNotebookInstanceRequest): DescribeNotebookInstanceResponse {
        val op = SdkHttpOperation.build<DescribeNotebookInstanceRequest, DescribeNotebookInstanceResponse> {
            serializer = DescribeNotebookInstanceOperationSerializer()
            deserializer = DescribeNotebookInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeNotebookInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a description of a notebook instance lifecycle configuration.
     *
     * For information about notebook instance lifestyle configurations, see [Step 2.1: (Optional) Customize a Notebook Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
     */
    override suspend fun describeNotebookInstanceLifecycleConfig(input: DescribeNotebookInstanceLifecycleConfigRequest): DescribeNotebookInstanceLifecycleConfigResponse {
        val op = SdkHttpOperation.build<DescribeNotebookInstanceLifecycleConfigRequest, DescribeNotebookInstanceLifecycleConfigResponse> {
            serializer = DescribeNotebookInstanceLifecycleConfigOperationSerializer()
            deserializer = DescribeNotebookInstanceLifecycleConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeNotebookInstanceLifecycleConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the details of a pipeline.
     */
    override suspend fun describePipeline(input: DescribePipelineRequest): DescribePipelineResponse {
        val op = SdkHttpOperation.build<DescribePipelineRequest, DescribePipelineResponse> {
            serializer = DescribePipelineOperationSerializer()
            deserializer = DescribePipelineOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePipeline"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the details of an execution's pipeline definition.
     */
    override suspend fun describePipelineDefinitionForExecution(input: DescribePipelineDefinitionForExecutionRequest): DescribePipelineDefinitionForExecutionResponse {
        val op = SdkHttpOperation.build<DescribePipelineDefinitionForExecutionRequest, DescribePipelineDefinitionForExecutionResponse> {
            serializer = DescribePipelineDefinitionForExecutionOperationSerializer()
            deserializer = DescribePipelineDefinitionForExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePipelineDefinitionForExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the details of a pipeline execution.
     */
    override suspend fun describePipelineExecution(input: DescribePipelineExecutionRequest): DescribePipelineExecutionResponse {
        val op = SdkHttpOperation.build<DescribePipelineExecutionRequest, DescribePipelineExecutionResponse> {
            serializer = DescribePipelineExecutionOperationSerializer()
            deserializer = DescribePipelineExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePipelineExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a description of a processing job.
     */
    override suspend fun describeProcessingJob(input: DescribeProcessingJobRequest): DescribeProcessingJobResponse {
        val op = SdkHttpOperation.build<DescribeProcessingJobRequest, DescribeProcessingJobResponse> {
            serializer = DescribeProcessingJobOperationSerializer()
            deserializer = DescribeProcessingJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeProcessingJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the details of a project.
     */
    override suspend fun describeProject(input: DescribeProjectRequest): DescribeProjectResponse {
        val op = SdkHttpOperation.build<DescribeProjectRequest, DescribeProjectResponse> {
            serializer = DescribeProjectOperationSerializer()
            deserializer = DescribeProjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeProject"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the Studio Lifecycle Configuration.
     */
    override suspend fun describeStudioLifecycleConfig(input: DescribeStudioLifecycleConfigRequest): DescribeStudioLifecycleConfigResponse {
        val op = SdkHttpOperation.build<DescribeStudioLifecycleConfigRequest, DescribeStudioLifecycleConfigResponse> {
            serializer = DescribeStudioLifecycleConfigOperationSerializer()
            deserializer = DescribeStudioLifecycleConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStudioLifecycleConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a work team provided by a vendor. It returns details about the subscription with a vendor in the Amazon Web Services Marketplace.
     */
    override suspend fun describeSubscribedWorkteam(input: DescribeSubscribedWorkteamRequest): DescribeSubscribedWorkteamResponse {
        val op = SdkHttpOperation.build<DescribeSubscribedWorkteamRequest, DescribeSubscribedWorkteamResponse> {
            serializer = DescribeSubscribedWorkteamOperationSerializer()
            deserializer = DescribeSubscribedWorkteamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSubscribedWorkteam"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a training job.
     *
     * Some of the attributes below only appear if the training job successfully starts. If the training job fails, `TrainingJobStatus` is `Failed` and, depending on the `FailureReason`, attributes like `TrainingStartTime`, `TrainingTimeInSeconds`, `TrainingEndTime`, and `BillableTimeInSeconds` may not be present in the response.
     */
    override suspend fun describeTrainingJob(input: DescribeTrainingJobRequest): DescribeTrainingJobResponse {
        val op = SdkHttpOperation.build<DescribeTrainingJobRequest, DescribeTrainingJobResponse> {
            serializer = DescribeTrainingJobOperationSerializer()
            deserializer = DescribeTrainingJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTrainingJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a transform job.
     */
    override suspend fun describeTransformJob(input: DescribeTransformJobRequest): DescribeTransformJobResponse {
        val op = SdkHttpOperation.build<DescribeTransformJobRequest, DescribeTransformJobResponse> {
            serializer = DescribeTransformJobOperationSerializer()
            deserializer = DescribeTransformJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTransformJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides a list of a trial's properties.
     */
    override suspend fun describeTrial(input: DescribeTrialRequest): DescribeTrialResponse {
        val op = SdkHttpOperation.build<DescribeTrialRequest, DescribeTrialResponse> {
            serializer = DescribeTrialOperationSerializer()
            deserializer = DescribeTrialOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTrial"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides a list of a trials component's properties.
     */
    override suspend fun describeTrialComponent(input: DescribeTrialComponentRequest): DescribeTrialComponentResponse {
        val op = SdkHttpOperation.build<DescribeTrialComponentRequest, DescribeTrialComponentResponse> {
            serializer = DescribeTrialComponentOperationSerializer()
            deserializer = DescribeTrialComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTrialComponent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a user profile. For more information, see `CreateUserProfile`.
     */
    override suspend fun describeUserProfile(input: DescribeUserProfileRequest): DescribeUserProfileResponse {
        val op = SdkHttpOperation.build<DescribeUserProfileRequest, DescribeUserProfileResponse> {
            serializer = DescribeUserProfileOperationSerializer()
            deserializer = DescribeUserProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeUserProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists private workforce information, including workforce name, Amazon Resource Name (ARN), and, if applicable, allowed IP address ranges ([CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)). Allowable IP address ranges are the IP addresses that workers can use to access tasks.
     *
     * This operation applies only to private workforces.
     */
    override suspend fun describeWorkforce(input: DescribeWorkforceRequest): DescribeWorkforceResponse {
        val op = SdkHttpOperation.build<DescribeWorkforceRequest, DescribeWorkforceResponse> {
            serializer = DescribeWorkforceOperationSerializer()
            deserializer = DescribeWorkforceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeWorkforce"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a specific work team. You can see information such as the create date, the last updated date, membership information, and the work team's Amazon Resource Name (ARN).
     */
    override suspend fun describeWorkteam(input: DescribeWorkteamRequest): DescribeWorkteamResponse {
        val op = SdkHttpOperation.build<DescribeWorkteamRequest, DescribeWorkteamResponse> {
            serializer = DescribeWorkteamOperationSerializer()
            deserializer = DescribeWorkteamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeWorkteam"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     */
    override suspend fun disableSagemakerServicecatalogPortfolio(input: DisableSagemakerServicecatalogPortfolioRequest): DisableSagemakerServicecatalogPortfolioResponse {
        val op = SdkHttpOperation.build<DisableSagemakerServicecatalogPortfolioRequest, DisableSagemakerServicecatalogPortfolioResponse> {
            serializer = DisableSagemakerServicecatalogPortfolioOperationSerializer()
            deserializer = DisableSagemakerServicecatalogPortfolioOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableSagemakerServicecatalogPortfolio"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a trial component from a trial. This doesn't effect other trials the component is associated with. Before you can delete a component, you must disassociate the component from all trials it is associated with. To associate a trial component with a trial, call the AssociateTrialComponent API.
     *
     * To get a list of the trials a component is associated with, use the Search API. Specify `ExperimentTrialComponent` for the `Resource` parameter. The list appears in the response under `Results.TrialComponent.Parents`.
     */
    override suspend fun disassociateTrialComponent(input: DisassociateTrialComponentRequest): DisassociateTrialComponentResponse {
        val op = SdkHttpOperation.build<DisassociateTrialComponentRequest, DisassociateTrialComponentResponse> {
            serializer = DisassociateTrialComponentOperationSerializer()
            deserializer = DisassociateTrialComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateTrialComponent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     */
    override suspend fun enableSagemakerServicecatalogPortfolio(input: EnableSagemakerServicecatalogPortfolioRequest): EnableSagemakerServicecatalogPortfolioResponse {
        val op = SdkHttpOperation.build<EnableSagemakerServicecatalogPortfolioRequest, EnableSagemakerServicecatalogPortfolioResponse> {
            serializer = EnableSagemakerServicecatalogPortfolioOperationSerializer()
            deserializer = EnableSagemakerServicecatalogPortfolioOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableSagemakerServicecatalogPortfolio"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a fleet.
     */
    override suspend fun getDeviceFleetReport(input: GetDeviceFleetReportRequest): GetDeviceFleetReportResponse {
        val op = SdkHttpOperation.build<GetDeviceFleetReportRequest, GetDeviceFleetReportResponse> {
            serializer = GetDeviceFleetReportOperationSerializer()
            deserializer = GetDeviceFleetReportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDeviceFleetReport"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The resource policy for the lineage group.
     */
    override suspend fun getLineageGroupPolicy(input: GetLineageGroupPolicyRequest): GetLineageGroupPolicyResponse {
        val op = SdkHttpOperation.build<GetLineageGroupPolicyRequest, GetLineageGroupPolicyResponse> {
            serializer = GetLineageGroupPolicyOperationSerializer()
            deserializer = GetLineageGroupPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLineageGroupPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a resource policy that manages access for a model group. For information about resource policies, see [Identity-based policies and resource-based policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html) in the *Amazon Web Services Identity and Access Management User Guide.*.
     */
    override suspend fun getModelPackageGroupPolicy(input: GetModelPackageGroupPolicyRequest): GetModelPackageGroupPolicyResponse {
        val op = SdkHttpOperation.build<GetModelPackageGroupPolicyRequest, GetModelPackageGroupPolicyResponse> {
            serializer = GetModelPackageGroupPolicyOperationSerializer()
            deserializer = GetModelPackageGroupPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetModelPackageGroupPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the status of Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     */
    override suspend fun getSagemakerServicecatalogPortfolioStatus(input: GetSagemakerServicecatalogPortfolioStatusRequest): GetSagemakerServicecatalogPortfolioStatusResponse {
        val op = SdkHttpOperation.build<GetSagemakerServicecatalogPortfolioStatusRequest, GetSagemakerServicecatalogPortfolioStatusResponse> {
            serializer = GetSagemakerServicecatalogPortfolioStatusOperationSerializer()
            deserializer = GetSagemakerServicecatalogPortfolioStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSagemakerServicecatalogPortfolioStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * An auto-complete API for the search functionality in the Amazon SageMaker console. It returns suggestions of possible matches for the property name to use in `Search` queries. Provides suggestions for `HyperParameters`, `Tags`, and `Metrics`.
     */
    override suspend fun getSearchSuggestions(input: GetSearchSuggestionsRequest): GetSearchSuggestionsResponse {
        val op = SdkHttpOperation.build<GetSearchSuggestionsRequest, GetSearchSuggestionsResponse> {
            serializer = GetSearchSuggestionsOperationSerializer()
            deserializer = GetSearchSuggestionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSearchSuggestions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the actions in your account and their properties.
     */
    override suspend fun listActions(input: ListActionsRequest): ListActionsResponse {
        val op = SdkHttpOperation.build<ListActionsRequest, ListActionsResponse> {
            serializer = ListActionsOperationSerializer()
            deserializer = ListActionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListActions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the machine learning algorithms that have been created.
     */
    override suspend fun listAlgorithms(input: ListAlgorithmsRequest): ListAlgorithmsResponse {
        val op = SdkHttpOperation.build<ListAlgorithmsRequest, ListAlgorithmsResponse> {
            serializer = ListAlgorithmsOperationSerializer()
            deserializer = ListAlgorithmsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAlgorithms"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the AppImageConfigs in your account and their properties. The list can be filtered by creation time or modified time, and whether the AppImageConfig name contains a specified string.
     */
    override suspend fun listAppImageConfigs(input: ListAppImageConfigsRequest): ListAppImageConfigsResponse {
        val op = SdkHttpOperation.build<ListAppImageConfigsRequest, ListAppImageConfigsResponse> {
            serializer = ListAppImageConfigsOperationSerializer()
            deserializer = ListAppImageConfigsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAppImageConfigs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists apps.
     */
    override suspend fun listApps(input: ListAppsRequest): ListAppsResponse {
        val op = SdkHttpOperation.build<ListAppsRequest, ListAppsResponse> {
            serializer = ListAppsOperationSerializer()
            deserializer = ListAppsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListApps"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the artifacts in your account and their properties.
     */
    override suspend fun listArtifacts(input: ListArtifactsRequest): ListArtifactsResponse {
        val op = SdkHttpOperation.build<ListArtifactsRequest, ListArtifactsResponse> {
            serializer = ListArtifactsOperationSerializer()
            deserializer = ListArtifactsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListArtifacts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the associations in your account and their properties.
     */
    override suspend fun listAssociations(input: ListAssociationsRequest): ListAssociationsResponse {
        val op = SdkHttpOperation.build<ListAssociationsRequest, ListAssociationsResponse> {
            serializer = ListAssociationsOperationSerializer()
            deserializer = ListAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAssociations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Request a list of jobs.
     */
    override suspend fun listAutoMlJobs(input: ListAutoMlJobsRequest): ListAutoMlJobsResponse {
        val op = SdkHttpOperation.build<ListAutoMlJobsRequest, ListAutoMlJobsResponse> {
            serializer = ListAutoMLJobsOperationSerializer()
            deserializer = ListAutoMLJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAutoMLJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the candidates created for the job.
     */
    override suspend fun listCandidatesForAutoMlJob(input: ListCandidatesForAutoMlJobRequest): ListCandidatesForAutoMlJobResponse {
        val op = SdkHttpOperation.build<ListCandidatesForAutoMlJobRequest, ListCandidatesForAutoMlJobResponse> {
            serializer = ListCandidatesForAutoMLJobOperationSerializer()
            deserializer = ListCandidatesForAutoMLJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCandidatesForAutoMLJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of the Git repositories in your account.
     */
    override suspend fun listCodeRepositories(input: ListCodeRepositoriesRequest): ListCodeRepositoriesResponse {
        val op = SdkHttpOperation.build<ListCodeRepositoriesRequest, ListCodeRepositoriesResponse> {
            serializer = ListCodeRepositoriesOperationSerializer()
            deserializer = ListCodeRepositoriesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCodeRepositories"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists model compilation jobs that satisfy various filters.
     *
     * To create a model compilation job, use CreateCompilationJob. To get information about a particular model compilation job you have created, use DescribeCompilationJob.
     */
    override suspend fun listCompilationJobs(input: ListCompilationJobsRequest): ListCompilationJobsResponse {
        val op = SdkHttpOperation.build<ListCompilationJobsRequest, ListCompilationJobsResponse> {
            serializer = ListCompilationJobsOperationSerializer()
            deserializer = ListCompilationJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCompilationJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the contexts in your account and their properties.
     */
    override suspend fun listContexts(input: ListContextsRequest): ListContextsResponse {
        val op = SdkHttpOperation.build<ListContextsRequest, ListContextsResponse> {
            serializer = ListContextsOperationSerializer()
            deserializer = ListContextsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListContexts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the data quality job definitions in your account.
     */
    override suspend fun listDataQualityJobDefinitions(input: ListDataQualityJobDefinitionsRequest): ListDataQualityJobDefinitionsResponse {
        val op = SdkHttpOperation.build<ListDataQualityJobDefinitionsRequest, ListDataQualityJobDefinitionsResponse> {
            serializer = ListDataQualityJobDefinitionsOperationSerializer()
            deserializer = ListDataQualityJobDefinitionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDataQualityJobDefinitions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of devices in the fleet.
     */
    override suspend fun listDeviceFleets(input: ListDeviceFleetsRequest): ListDeviceFleetsResponse {
        val op = SdkHttpOperation.build<ListDeviceFleetsRequest, ListDeviceFleetsResponse> {
            serializer = ListDeviceFleetsOperationSerializer()
            deserializer = ListDeviceFleetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDeviceFleets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * A list of devices.
     */
    override suspend fun listDevices(input: ListDevicesRequest): ListDevicesResponse {
        val op = SdkHttpOperation.build<ListDevicesRequest, ListDevicesResponse> {
            serializer = ListDevicesOperationSerializer()
            deserializer = ListDevicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDevices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the domains.
     */
    override suspend fun listDomains(input: ListDomainsRequest): ListDomainsResponse {
        val op = SdkHttpOperation.build<ListDomainsRequest, ListDomainsResponse> {
            serializer = ListDomainsOperationSerializer()
            deserializer = ListDomainsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDomains"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of edge packaging jobs.
     */
    override suspend fun listEdgePackagingJobs(input: ListEdgePackagingJobsRequest): ListEdgePackagingJobsResponse {
        val op = SdkHttpOperation.build<ListEdgePackagingJobsRequest, ListEdgePackagingJobsResponse> {
            serializer = ListEdgePackagingJobsOperationSerializer()
            deserializer = ListEdgePackagingJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEdgePackagingJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists endpoint configurations.
     */
    override suspend fun listEndpointConfigs(input: ListEndpointConfigsRequest): ListEndpointConfigsResponse {
        val op = SdkHttpOperation.build<ListEndpointConfigsRequest, ListEndpointConfigsResponse> {
            serializer = ListEndpointConfigsOperationSerializer()
            deserializer = ListEndpointConfigsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEndpointConfigs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists endpoints.
     */
    override suspend fun listEndpoints(input: ListEndpointsRequest): ListEndpointsResponse {
        val op = SdkHttpOperation.build<ListEndpointsRequest, ListEndpointsResponse> {
            serializer = ListEndpointsOperationSerializer()
            deserializer = ListEndpointsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEndpoints"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the experiments in your account. The list can be filtered to show only experiments that were created in a specific time range. The list can be sorted by experiment name or creation time.
     */
    override suspend fun listExperiments(input: ListExperimentsRequest): ListExperimentsResponse {
        val op = SdkHttpOperation.build<ListExperimentsRequest, ListExperimentsResponse> {
            serializer = ListExperimentsOperationSerializer()
            deserializer = ListExperimentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListExperiments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List `FeatureGroup`s based on given filter and order.
     */
    override suspend fun listFeatureGroups(input: ListFeatureGroupsRequest): ListFeatureGroupsResponse {
        val op = SdkHttpOperation.build<ListFeatureGroupsRequest, ListFeatureGroupsResponse> {
            serializer = ListFeatureGroupsOperationSerializer()
            deserializer = ListFeatureGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFeatureGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the flow definitions in your account.
     */
    override suspend fun listFlowDefinitions(input: ListFlowDefinitionsRequest): ListFlowDefinitionsResponse {
        val op = SdkHttpOperation.build<ListFlowDefinitionsRequest, ListFlowDefinitionsResponse> {
            serializer = ListFlowDefinitionsOperationSerializer()
            deserializer = ListFlowDefinitionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFlowDefinitions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the human task user interfaces in your account.
     */
    override suspend fun listHumanTaskUis(input: ListHumanTaskUisRequest): ListHumanTaskUisResponse {
        val op = SdkHttpOperation.build<ListHumanTaskUisRequest, ListHumanTaskUisResponse> {
            serializer = ListHumanTaskUisOperationSerializer()
            deserializer = ListHumanTaskUisOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListHumanTaskUis"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of HyperParameterTuningJobSummary objects that describe the hyperparameter tuning jobs launched in your account.
     */
    override suspend fun listHyperParameterTuningJobs(input: ListHyperParameterTuningJobsRequest): ListHyperParameterTuningJobsResponse {
        val op = SdkHttpOperation.build<ListHyperParameterTuningJobsRequest, ListHyperParameterTuningJobsResponse> {
            serializer = ListHyperParameterTuningJobsOperationSerializer()
            deserializer = ListHyperParameterTuningJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListHyperParameterTuningJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the versions of a specified image and their properties. The list can be filtered by creation time or modified time.
     */
    override suspend fun listImageVersions(input: ListImageVersionsRequest): ListImageVersionsResponse {
        val op = SdkHttpOperation.build<ListImageVersionsRequest, ListImageVersionsResponse> {
            serializer = ListImageVersionsOperationSerializer()
            deserializer = ListImageVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListImageVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the images in your account and their properties. The list can be filtered by creation time or modified time, and whether the image name contains a specified string.
     */
    override suspend fun listImages(input: ListImagesRequest): ListImagesResponse {
        val op = SdkHttpOperation.build<ListImagesRequest, ListImagesResponse> {
            serializer = ListImagesOperationSerializer()
            deserializer = ListImagesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListImages"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists recommendation jobs that satisfy various filters.
     */
    override suspend fun listInferenceRecommendationsJobs(input: ListInferenceRecommendationsJobsRequest): ListInferenceRecommendationsJobsResponse {
        val op = SdkHttpOperation.build<ListInferenceRecommendationsJobsRequest, ListInferenceRecommendationsJobsResponse> {
            serializer = ListInferenceRecommendationsJobsOperationSerializer()
            deserializer = ListInferenceRecommendationsJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInferenceRecommendationsJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of labeling jobs.
     */
    override suspend fun listLabelingJobs(input: ListLabelingJobsRequest): ListLabelingJobsResponse {
        val op = SdkHttpOperation.build<ListLabelingJobsRequest, ListLabelingJobsResponse> {
            serializer = ListLabelingJobsOperationSerializer()
            deserializer = ListLabelingJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListLabelingJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of labeling jobs assigned to a specified work team.
     */
    override suspend fun listLabelingJobsForWorkteam(input: ListLabelingJobsForWorkteamRequest): ListLabelingJobsForWorkteamResponse {
        val op = SdkHttpOperation.build<ListLabelingJobsForWorkteamRequest, ListLabelingJobsForWorkteamResponse> {
            serializer = ListLabelingJobsForWorkteamOperationSerializer()
            deserializer = ListLabelingJobsForWorkteamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListLabelingJobsForWorkteam"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * A list of lineage groups shared with your Amazon Web Services account. For more information, see [ Cross-Account Lineage Tracking ](https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html) in the *Amazon SageMaker Developer Guide*.
     */
    override suspend fun listLineageGroups(input: ListLineageGroupsRequest): ListLineageGroupsResponse {
        val op = SdkHttpOperation.build<ListLineageGroupsRequest, ListLineageGroupsResponse> {
            serializer = ListLineageGroupsOperationSerializer()
            deserializer = ListLineageGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListLineageGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists model bias jobs definitions that satisfy various filters.
     */
    override suspend fun listModelBiasJobDefinitions(input: ListModelBiasJobDefinitionsRequest): ListModelBiasJobDefinitionsResponse {
        val op = SdkHttpOperation.build<ListModelBiasJobDefinitionsRequest, ListModelBiasJobDefinitionsResponse> {
            serializer = ListModelBiasJobDefinitionsOperationSerializer()
            deserializer = ListModelBiasJobDefinitionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListModelBiasJobDefinitions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists model explainability job definitions that satisfy various filters.
     */
    override suspend fun listModelExplainabilityJobDefinitions(input: ListModelExplainabilityJobDefinitionsRequest): ListModelExplainabilityJobDefinitionsResponse {
        val op = SdkHttpOperation.build<ListModelExplainabilityJobDefinitionsRequest, ListModelExplainabilityJobDefinitionsResponse> {
            serializer = ListModelExplainabilityJobDefinitionsOperationSerializer()
            deserializer = ListModelExplainabilityJobDefinitionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListModelExplainabilityJobDefinitions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the domain, framework, task, and model name of standard machine learning models found in common model zoos.
     */
    override suspend fun listModelMetadata(input: ListModelMetadataRequest): ListModelMetadataResponse {
        val op = SdkHttpOperation.build<ListModelMetadataRequest, ListModelMetadataResponse> {
            serializer = ListModelMetadataOperationSerializer()
            deserializer = ListModelMetadataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListModelMetadata"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of the model groups in your Amazon Web Services account.
     */
    override suspend fun listModelPackageGroups(input: ListModelPackageGroupsRequest): ListModelPackageGroupsResponse {
        val op = SdkHttpOperation.build<ListModelPackageGroupsRequest, ListModelPackageGroupsResponse> {
            serializer = ListModelPackageGroupsOperationSerializer()
            deserializer = ListModelPackageGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListModelPackageGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the model packages that have been created.
     */
    override suspend fun listModelPackages(input: ListModelPackagesRequest): ListModelPackagesResponse {
        val op = SdkHttpOperation.build<ListModelPackagesRequest, ListModelPackagesResponse> {
            serializer = ListModelPackagesOperationSerializer()
            deserializer = ListModelPackagesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListModelPackages"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of model quality monitoring job definitions in your account.
     */
    override suspend fun listModelQualityJobDefinitions(input: ListModelQualityJobDefinitionsRequest): ListModelQualityJobDefinitionsResponse {
        val op = SdkHttpOperation.build<ListModelQualityJobDefinitionsRequest, ListModelQualityJobDefinitionsResponse> {
            serializer = ListModelQualityJobDefinitionsOperationSerializer()
            deserializer = ListModelQualityJobDefinitionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListModelQualityJobDefinitions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists models created with the `CreateModel` API.
     */
    override suspend fun listModels(input: ListModelsRequest): ListModelsResponse {
        val op = SdkHttpOperation.build<ListModelsRequest, ListModelsResponse> {
            serializer = ListModelsOperationSerializer()
            deserializer = ListModelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListModels"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns list of all monitoring job executions.
     */
    override suspend fun listMonitoringExecutions(input: ListMonitoringExecutionsRequest): ListMonitoringExecutionsResponse {
        val op = SdkHttpOperation.build<ListMonitoringExecutionsRequest, ListMonitoringExecutionsResponse> {
            serializer = ListMonitoringExecutionsOperationSerializer()
            deserializer = ListMonitoringExecutionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMonitoringExecutions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns list of all monitoring schedules.
     */
    override suspend fun listMonitoringSchedules(input: ListMonitoringSchedulesRequest): ListMonitoringSchedulesResponse {
        val op = SdkHttpOperation.build<ListMonitoringSchedulesRequest, ListMonitoringSchedulesResponse> {
            serializer = ListMonitoringSchedulesOperationSerializer()
            deserializer = ListMonitoringSchedulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMonitoringSchedules"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists notebook instance lifestyle configurations created with the CreateNotebookInstanceLifecycleConfig API.
     */
    override suspend fun listNotebookInstanceLifecycleConfigs(input: ListNotebookInstanceLifecycleConfigsRequest): ListNotebookInstanceLifecycleConfigsResponse {
        val op = SdkHttpOperation.build<ListNotebookInstanceLifecycleConfigsRequest, ListNotebookInstanceLifecycleConfigsResponse> {
            serializer = ListNotebookInstanceLifecycleConfigsOperationSerializer()
            deserializer = ListNotebookInstanceLifecycleConfigsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListNotebookInstanceLifecycleConfigs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the SageMaker notebook instances in the requester's account in an Amazon Web Services Region.
     */
    override suspend fun listNotebookInstances(input: ListNotebookInstancesRequest): ListNotebookInstancesResponse {
        val op = SdkHttpOperation.build<ListNotebookInstancesRequest, ListNotebookInstancesResponse> {
            serializer = ListNotebookInstancesOperationSerializer()
            deserializer = ListNotebookInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListNotebookInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of `PipeLineExecutionStep` objects.
     */
    override suspend fun listPipelineExecutionSteps(input: ListPipelineExecutionStepsRequest): ListPipelineExecutionStepsResponse {
        val op = SdkHttpOperation.build<ListPipelineExecutionStepsRequest, ListPipelineExecutionStepsResponse> {
            serializer = ListPipelineExecutionStepsOperationSerializer()
            deserializer = ListPipelineExecutionStepsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPipelineExecutionSteps"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of the pipeline executions.
     */
    override suspend fun listPipelineExecutions(input: ListPipelineExecutionsRequest): ListPipelineExecutionsResponse {
        val op = SdkHttpOperation.build<ListPipelineExecutionsRequest, ListPipelineExecutionsResponse> {
            serializer = ListPipelineExecutionsOperationSerializer()
            deserializer = ListPipelineExecutionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPipelineExecutions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of parameters for a pipeline execution.
     */
    override suspend fun listPipelineParametersForExecution(input: ListPipelineParametersForExecutionRequest): ListPipelineParametersForExecutionResponse {
        val op = SdkHttpOperation.build<ListPipelineParametersForExecutionRequest, ListPipelineParametersForExecutionResponse> {
            serializer = ListPipelineParametersForExecutionOperationSerializer()
            deserializer = ListPipelineParametersForExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPipelineParametersForExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of pipelines.
     */
    override suspend fun listPipelines(input: ListPipelinesRequest): ListPipelinesResponse {
        val op = SdkHttpOperation.build<ListPipelinesRequest, ListPipelinesResponse> {
            serializer = ListPipelinesOperationSerializer()
            deserializer = ListPipelinesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPipelines"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists processing jobs that satisfy various filters.
     */
    override suspend fun listProcessingJobs(input: ListProcessingJobsRequest): ListProcessingJobsResponse {
        val op = SdkHttpOperation.build<ListProcessingJobsRequest, ListProcessingJobsResponse> {
            serializer = ListProcessingJobsOperationSerializer()
            deserializer = ListProcessingJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProcessingJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of the projects in an Amazon Web Services account.
     */
    override suspend fun listProjects(input: ListProjectsRequest): ListProjectsResponse {
        val op = SdkHttpOperation.build<ListProjectsRequest, ListProjectsResponse> {
            serializer = ListProjectsOperationSerializer()
            deserializer = ListProjectsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProjects"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the Studio Lifecycle Configurations in your Amazon Web Services Account.
     */
    override suspend fun listStudioLifecycleConfigs(input: ListStudioLifecycleConfigsRequest): ListStudioLifecycleConfigsResponse {
        val op = SdkHttpOperation.build<ListStudioLifecycleConfigsRequest, ListStudioLifecycleConfigsResponse> {
            serializer = ListStudioLifecycleConfigsOperationSerializer()
            deserializer = ListStudioLifecycleConfigsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListStudioLifecycleConfigs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of the work teams that you are subscribed to in the Amazon Web Services Marketplace. The list may be empty if no work team satisfies the filter specified in the `NameContains` parameter.
     */
    override suspend fun listSubscribedWorkteams(input: ListSubscribedWorkteamsRequest): ListSubscribedWorkteamsResponse {
        val op = SdkHttpOperation.build<ListSubscribedWorkteamsRequest, ListSubscribedWorkteamsResponse> {
            serializer = ListSubscribedWorkteamsOperationSerializer()
            deserializer = ListSubscribedWorkteamsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSubscribedWorkteams"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the tags for the specified SageMaker resource.
     */
    override suspend fun listTags(input: ListTagsRequest): ListTagsResponse {
        val op = SdkHttpOperation.build<ListTagsRequest, ListTagsResponse> {
            serializer = ListTagsOperationSerializer()
            deserializer = ListTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists training jobs.
     *
     * When `StatusEquals` and `MaxResults` are set at the same time, the `MaxResults` number of training jobs are first retrieved ignoring the `StatusEquals` parameter and then they are filtered by the `StatusEquals` parameter, which is returned as a response.
     *
     * For example, if `ListTrainingJobs` is invoked with the following parameters:
     *
     * `{ ... MaxResults: 100, StatusEquals: InProgress ... }`
     *
     * First, 100 trainings jobs with any status, including those other than `InProgress`, are selected (sorted according to the creation time, from the most current to the oldest). Next, those with a status of `InProgress` are returned.
     *
     * You can quickly test the API using the following Amazon Web Services CLI code.
     *
     * `aws sagemaker list-training-jobs --max-results 100 --status-equals InProgress`
     */
    override suspend fun listTrainingJobs(input: ListTrainingJobsRequest): ListTrainingJobsResponse {
        val op = SdkHttpOperation.build<ListTrainingJobsRequest, ListTrainingJobsResponse> {
            serializer = ListTrainingJobsOperationSerializer()
            deserializer = ListTrainingJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTrainingJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of TrainingJobSummary objects that describe the training jobs that a hyperparameter tuning job launched.
     */
    override suspend fun listTrainingJobsForHyperParameterTuningJob(input: ListTrainingJobsForHyperParameterTuningJobRequest): ListTrainingJobsForHyperParameterTuningJobResponse {
        val op = SdkHttpOperation.build<ListTrainingJobsForHyperParameterTuningJobRequest, ListTrainingJobsForHyperParameterTuningJobResponse> {
            serializer = ListTrainingJobsForHyperParameterTuningJobOperationSerializer()
            deserializer = ListTrainingJobsForHyperParameterTuningJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTrainingJobsForHyperParameterTuningJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists transform jobs.
     */
    override suspend fun listTransformJobs(input: ListTransformJobsRequest): ListTransformJobsResponse {
        val op = SdkHttpOperation.build<ListTransformJobsRequest, ListTransformJobsResponse> {
            serializer = ListTransformJobsOperationSerializer()
            deserializer = ListTransformJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTransformJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the trial components in your account. You can sort the list by trial component name or creation time. You can filter the list to show only components that were created in a specific time range. You can also filter on one of the following:
     * + `ExperimentName`
     * + `SourceArn`
     * + `TrialName`
     */
    override suspend fun listTrialComponents(input: ListTrialComponentsRequest): ListTrialComponentsResponse {
        val op = SdkHttpOperation.build<ListTrialComponentsRequest, ListTrialComponentsResponse> {
            serializer = ListTrialComponentsOperationSerializer()
            deserializer = ListTrialComponentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTrialComponents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the trials in your account. Specify an experiment name to limit the list to the trials that are part of that experiment. Specify a trial component name to limit the list to the trials that associated with that trial component. The list can be filtered to show only trials that were created in a specific time range. The list can be sorted by trial name or creation time.
     */
    override suspend fun listTrials(input: ListTrialsRequest): ListTrialsResponse {
        val op = SdkHttpOperation.build<ListTrialsRequest, ListTrialsResponse> {
            serializer = ListTrialsOperationSerializer()
            deserializer = ListTrialsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTrials"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists user profiles.
     */
    override suspend fun listUserProfiles(input: ListUserProfilesRequest): ListUserProfilesResponse {
        val op = SdkHttpOperation.build<ListUserProfilesRequest, ListUserProfilesResponse> {
            serializer = ListUserProfilesOperationSerializer()
            deserializer = ListUserProfilesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListUserProfiles"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Use this operation to list all private and vendor workforces in an Amazon Web Services Region. Note that you can only have one private workforce per Amazon Web Services Region.
     */
    override suspend fun listWorkforces(input: ListWorkforcesRequest): ListWorkforcesResponse {
        val op = SdkHttpOperation.build<ListWorkforcesRequest, ListWorkforcesResponse> {
            serializer = ListWorkforcesOperationSerializer()
            deserializer = ListWorkforcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWorkforces"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of private work teams that you have defined in a region. The list may be empty if no work team satisfies the filter specified in the `NameContains` parameter.
     */
    override suspend fun listWorkteams(input: ListWorkteamsRequest): ListWorkteamsResponse {
        val op = SdkHttpOperation.build<ListWorkteamsRequest, ListWorkteamsResponse> {
            serializer = ListWorkteamsOperationSerializer()
            deserializer = ListWorkteamsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWorkteams"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a resouce policy to control access to a model group. For information about resoure policies, see [Identity-based policies and resource-based policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html) in the *Amazon Web Services Identity and Access Management User Guide.*.
     */
    override suspend fun putModelPackageGroupPolicy(input: PutModelPackageGroupPolicyRequest): PutModelPackageGroupPolicyResponse {
        val op = SdkHttpOperation.build<PutModelPackageGroupPolicyRequest, PutModelPackageGroupPolicyResponse> {
            serializer = PutModelPackageGroupPolicyOperationSerializer()
            deserializer = PutModelPackageGroupPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutModelPackageGroupPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Use this action to inspect your lineage and discover relationships between entities. For more information, see [ Querying Lineage Entities](https://docs.aws.amazon.com/sagemaker/latest/dg/querying-lineage-entities.html) in the *Amazon SageMaker Developer Guide*.
     */
    override suspend fun queryLineage(input: QueryLineageRequest): QueryLineageResponse {
        val op = SdkHttpOperation.build<QueryLineageRequest, QueryLineageResponse> {
            serializer = QueryLineageOperationSerializer()
            deserializer = QueryLineageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "QueryLineage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Register devices.
     */
    override suspend fun registerDevices(input: RegisterDevicesRequest): RegisterDevicesResponse {
        val op = SdkHttpOperation.build<RegisterDevicesRequest, RegisterDevicesResponse> {
            serializer = RegisterDevicesOperationSerializer()
            deserializer = RegisterDevicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterDevices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Renders the UI template so that you can preview the worker's experience.
     */
    override suspend fun renderUiTemplate(input: RenderUiTemplateRequest): RenderUiTemplateResponse {
        val op = SdkHttpOperation.build<RenderUiTemplateRequest, RenderUiTemplateResponse> {
            serializer = RenderUiTemplateOperationSerializer()
            deserializer = RenderUiTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RenderUiTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retry the execution of the pipeline.
     */
    override suspend fun retryPipelineExecution(input: RetryPipelineExecutionRequest): RetryPipelineExecutionResponse {
        val op = SdkHttpOperation.build<RetryPipelineExecutionRequest, RetryPipelineExecutionResponse> {
            serializer = RetryPipelineExecutionOperationSerializer()
            deserializer = RetryPipelineExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RetryPipelineExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Finds Amazon SageMaker resources that match a search query. Matching resources are returned as a list of `SearchRecord` objects in the response. You can sort the search results by any resource property in a ascending or descending order.
     *
     * You can query against the following value types: numeric, text, Boolean, and timestamp.
     */
    override suspend fun search(input: SearchRequest): SearchResponse {
        val op = SdkHttpOperation.build<SearchRequest, SearchResponse> {
            serializer = SearchOperationSerializer()
            deserializer = SearchOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "Search"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Notifies the pipeline that the execution of a callback step failed, along with a message describing why. When a callback step is run, the pipeline generates a callback token and includes the token in a message sent to Amazon Simple Queue Service (Amazon SQS).
     */
    override suspend fun sendPipelineExecutionStepFailure(input: SendPipelineExecutionStepFailureRequest): SendPipelineExecutionStepFailureResponse {
        val op = SdkHttpOperation.build<SendPipelineExecutionStepFailureRequest, SendPipelineExecutionStepFailureResponse> {
            serializer = SendPipelineExecutionStepFailureOperationSerializer()
            deserializer = SendPipelineExecutionStepFailureOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SendPipelineExecutionStepFailure"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Notifies the pipeline that the execution of a callback step succeeded and provides a list of the step's output parameters. When a callback step is run, the pipeline generates a callback token and includes the token in a message sent to Amazon Simple Queue Service (Amazon SQS).
     */
    override suspend fun sendPipelineExecutionStepSuccess(input: SendPipelineExecutionStepSuccessRequest): SendPipelineExecutionStepSuccessResponse {
        val op = SdkHttpOperation.build<SendPipelineExecutionStepSuccessRequest, SendPipelineExecutionStepSuccessResponse> {
            serializer = SendPipelineExecutionStepSuccessOperationSerializer()
            deserializer = SendPipelineExecutionStepSuccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SendPipelineExecutionStepSuccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a previously stopped monitoring schedule.
     *
     * By default, when you successfully create a new schedule, the status of a monitoring schedule is `scheduled`.
     */
    override suspend fun startMonitoringSchedule(input: StartMonitoringScheduleRequest): StartMonitoringScheduleResponse {
        val op = SdkHttpOperation.build<StartMonitoringScheduleRequest, StartMonitoringScheduleResponse> {
            serializer = StartMonitoringScheduleOperationSerializer()
            deserializer = StartMonitoringScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartMonitoringSchedule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Launches an ML compute instance with the latest version of the libraries and attaches your ML storage volume. After configuring the notebook instance, SageMaker sets the notebook instance status to `InService`. A notebook instance's status must be `InService` before you can connect to your Jupyter notebook.
     */
    override suspend fun startNotebookInstance(input: StartNotebookInstanceRequest): StartNotebookInstanceResponse {
        val op = SdkHttpOperation.build<StartNotebookInstanceRequest, StartNotebookInstanceResponse> {
            serializer = StartNotebookInstanceOperationSerializer()
            deserializer = StartNotebookInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartNotebookInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a pipeline execution.
     */
    override suspend fun startPipelineExecution(input: StartPipelineExecutionRequest): StartPipelineExecutionResponse {
        val op = SdkHttpOperation.build<StartPipelineExecutionRequest, StartPipelineExecutionResponse> {
            serializer = StartPipelineExecutionOperationSerializer()
            deserializer = StartPipelineExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartPipelineExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * A method for forcing the termination of a running job.
     */
    override suspend fun stopAutoMlJob(input: StopAutoMlJobRequest): StopAutoMlJobResponse {
        val op = SdkHttpOperation.build<StopAutoMlJobRequest, StopAutoMlJobResponse> {
            serializer = StopAutoMLJobOperationSerializer()
            deserializer = StopAutoMLJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopAutoMLJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a model compilation job.
     *
     *  To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal. This gracefully shuts the job down. If the job hasn't stopped, it sends the SIGKILL signal.
     *
     * When it receives a `StopCompilationJob` request, Amazon SageMaker changes the CompilationJobSummary$CompilationJobStatus of the job to `Stopping`. After Amazon SageMaker stops the job, it sets the CompilationJobSummary$CompilationJobStatus to `Stopped`.
     */
    override suspend fun stopCompilationJob(input: StopCompilationJobRequest): StopCompilationJobResponse {
        val op = SdkHttpOperation.build<StopCompilationJobRequest, StopCompilationJobResponse> {
            serializer = StopCompilationJobOperationSerializer()
            deserializer = StopCompilationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopCompilationJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Request to stop an edge packaging job.
     */
    override suspend fun stopEdgePackagingJob(input: StopEdgePackagingJobRequest): StopEdgePackagingJobResponse {
        val op = SdkHttpOperation.build<StopEdgePackagingJobRequest, StopEdgePackagingJobResponse> {
            serializer = StopEdgePackagingJobOperationSerializer()
            deserializer = StopEdgePackagingJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopEdgePackagingJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a running hyperparameter tuning job and all running training jobs that the tuning job launched.
     *
     * All model artifacts output from the training jobs are stored in Amazon Simple Storage Service (Amazon S3). All data that the training jobs write to Amazon CloudWatch Logs are still available in CloudWatch. After the tuning job moves to the `Stopped` state, it releases all reserved resources for the tuning job.
     */
    override suspend fun stopHyperParameterTuningJob(input: StopHyperParameterTuningJobRequest): StopHyperParameterTuningJobResponse {
        val op = SdkHttpOperation.build<StopHyperParameterTuningJobRequest, StopHyperParameterTuningJobResponse> {
            serializer = StopHyperParameterTuningJobOperationSerializer()
            deserializer = StopHyperParameterTuningJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopHyperParameterTuningJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops an Inference Recommender job.
     */
    override suspend fun stopInferenceRecommendationsJob(input: StopInferenceRecommendationsJobRequest): StopInferenceRecommendationsJobResponse {
        val op = SdkHttpOperation.build<StopInferenceRecommendationsJobRequest, StopInferenceRecommendationsJobResponse> {
            serializer = StopInferenceRecommendationsJobOperationSerializer()
            deserializer = StopInferenceRecommendationsJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopInferenceRecommendationsJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a running labeling job. A job that is stopped cannot be restarted. Any results obtained before the job is stopped are placed in the Amazon S3 output bucket.
     */
    override suspend fun stopLabelingJob(input: StopLabelingJobRequest): StopLabelingJobResponse {
        val op = SdkHttpOperation.build<StopLabelingJobRequest, StopLabelingJobResponse> {
            serializer = StopLabelingJobOperationSerializer()
            deserializer = StopLabelingJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopLabelingJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a previously started monitoring schedule.
     */
    override suspend fun stopMonitoringSchedule(input: StopMonitoringScheduleRequest): StopMonitoringScheduleResponse {
        val op = SdkHttpOperation.build<StopMonitoringScheduleRequest, StopMonitoringScheduleResponse> {
            serializer = StopMonitoringScheduleOperationSerializer()
            deserializer = StopMonitoringScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopMonitoringSchedule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Terminates the ML compute instance. Before terminating the instance, SageMaker disconnects the ML storage volume from it. SageMaker preserves the ML storage volume. SageMaker stops charging you for the ML compute instance when you call `StopNotebookInstance`.
     *
     * To access data on the ML storage volume for a notebook instance that has been terminated, call the `StartNotebookInstance` API. `StartNotebookInstance` launches another ML compute instance, configures it, and attaches the preserved ML storage volume so you can continue your work.
     */
    override suspend fun stopNotebookInstance(input: StopNotebookInstanceRequest): StopNotebookInstanceResponse {
        val op = SdkHttpOperation.build<StopNotebookInstanceRequest, StopNotebookInstanceResponse> {
            serializer = StopNotebookInstanceOperationSerializer()
            deserializer = StopNotebookInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopNotebookInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a pipeline execution.
     *
     * **Callback Step**
     *
     * A pipeline execution won't stop while a callback step is running. When you call `StopPipelineExecution` on a pipeline execution with a running callback step, SageMaker Pipelines sends an additional Amazon SQS message to the specified SQS queue. The body of the SQS message contains a "Status" field which is set to "Stopping".
     *
     * You should add logic to your Amazon SQS message consumer to take any needed action (for example, resource cleanup) upon receipt of the message followed by a call to `SendPipelineExecutionStepSuccess` or `SendPipelineExecutionStepFailure`.
     *
     * Only when SageMaker Pipelines receives one of these calls will it stop the pipeline execution.
     *
     * **Lambda Step**
     *
     * A pipeline execution can't be stopped while a lambda step is running because the Lambda function invoked by the lambda step can't be stopped. If you attempt to stop the execution while the Lambda function is running, the pipeline waits for the Lambda function to finish or until the timeout is hit, whichever occurs first, and then stops. If the Lambda function finishes, the pipeline execution status is `Stopped`. If the timeout is hit the pipeline execution status is `Failed`.
     */
    override suspend fun stopPipelineExecution(input: StopPipelineExecutionRequest): StopPipelineExecutionResponse {
        val op = SdkHttpOperation.build<StopPipelineExecutionRequest, StopPipelineExecutionResponse> {
            serializer = StopPipelineExecutionOperationSerializer()
            deserializer = StopPipelineExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopPipelineExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a processing job.
     */
    override suspend fun stopProcessingJob(input: StopProcessingJobRequest): StopProcessingJobResponse {
        val op = SdkHttpOperation.build<StopProcessingJobRequest, StopProcessingJobResponse> {
            serializer = StopProcessingJobOperationSerializer()
            deserializer = StopProcessingJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopProcessingJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a training job. To stop a job, SageMaker sends the algorithm the `SIGTERM` signal, which delays job termination for 120 seconds. Algorithms might use this 120-second window to save the model artifacts, so the results of the training is not lost.
     *
     * When it receives a `StopTrainingJob` request, SageMaker changes the status of the job to `Stopping`. After SageMaker stops the job, it sets the status to `Stopped`.
     */
    override suspend fun stopTrainingJob(input: StopTrainingJobRequest): StopTrainingJobResponse {
        val op = SdkHttpOperation.build<StopTrainingJobRequest, StopTrainingJobResponse> {
            serializer = StopTrainingJobOperationSerializer()
            deserializer = StopTrainingJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopTrainingJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a batch transform job.
     *
     * When Amazon SageMaker receives a `StopTransformJob` request, the status of the job changes to `Stopping`. After Amazon SageMaker stops the job, the status is set to `Stopped`. When you stop a batch transform job before it is completed, Amazon SageMaker doesn't store the job's output in Amazon S3.
     */
    override suspend fun stopTransformJob(input: StopTransformJobRequest): StopTransformJobResponse {
        val op = SdkHttpOperation.build<StopTransformJobRequest, StopTransformJobResponse> {
            serializer = StopTransformJobOperationSerializer()
            deserializer = StopTransformJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopTransformJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an action.
     */
    override suspend fun updateAction(input: UpdateActionRequest): UpdateActionResponse {
        val op = SdkHttpOperation.build<UpdateActionRequest, UpdateActionResponse> {
            serializer = UpdateActionOperationSerializer()
            deserializer = UpdateActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the properties of an AppImageConfig.
     */
    override suspend fun updateAppImageConfig(input: UpdateAppImageConfigRequest): UpdateAppImageConfigResponse {
        val op = SdkHttpOperation.build<UpdateAppImageConfigRequest, UpdateAppImageConfigResponse> {
            serializer = UpdateAppImageConfigOperationSerializer()
            deserializer = UpdateAppImageConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAppImageConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an artifact.
     */
    override suspend fun updateArtifact(input: UpdateArtifactRequest): UpdateArtifactResponse {
        val op = SdkHttpOperation.build<UpdateArtifactRequest, UpdateArtifactResponse> {
            serializer = UpdateArtifactOperationSerializer()
            deserializer = UpdateArtifactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateArtifact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified Git repository with the specified values.
     */
    override suspend fun updateCodeRepository(input: UpdateCodeRepositoryRequest): UpdateCodeRepositoryResponse {
        val op = SdkHttpOperation.build<UpdateCodeRepositoryRequest, UpdateCodeRepositoryResponse> {
            serializer = UpdateCodeRepositoryOperationSerializer()
            deserializer = UpdateCodeRepositoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCodeRepository"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a context.
     */
    override suspend fun updateContext(input: UpdateContextRequest): UpdateContextResponse {
        val op = SdkHttpOperation.build<UpdateContextRequest, UpdateContextResponse> {
            serializer = UpdateContextOperationSerializer()
            deserializer = UpdateContextOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateContext"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a fleet of devices.
     */
    override suspend fun updateDeviceFleet(input: UpdateDeviceFleetRequest): UpdateDeviceFleetResponse {
        val op = SdkHttpOperation.build<UpdateDeviceFleetRequest, UpdateDeviceFleetResponse> {
            serializer = UpdateDeviceFleetOperationSerializer()
            deserializer = UpdateDeviceFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDeviceFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates one or more devices in a fleet.
     */
    override suspend fun updateDevices(input: UpdateDevicesRequest): UpdateDevicesResponse {
        val op = SdkHttpOperation.build<UpdateDevicesRequest, UpdateDevicesResponse> {
            serializer = UpdateDevicesOperationSerializer()
            deserializer = UpdateDevicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDevices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the default settings for new user profiles in the domain.
     */
    override suspend fun updateDomain(input: UpdateDomainRequest): UpdateDomainResponse {
        val op = SdkHttpOperation.build<UpdateDomainRequest, UpdateDomainResponse> {
            serializer = UpdateDomainOperationSerializer()
            deserializer = UpdateDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deploys the new `EndpointConfig` specified in the request, switches to using newly created endpoint, and then deletes resources provisioned for the endpoint using the previous `EndpointConfig` (there is no availability loss).
     *
     * When SageMaker receives the request, it sets the endpoint status to `Updating`. After updating the endpoint, it sets the status to `InService`. To check the status of an endpoint, use the DescribeEndpoint API.
     *
     * You must not delete an `EndpointConfig` in use by an endpoint that is live or while the `UpdateEndpoint` or `CreateEndpoint` operations are being performed on the endpoint. To update an endpoint, you must create a new `EndpointConfig`.
     *
     * If you delete the `EndpointConfig` of an endpoint that is active or being created or updated you may lose visibility into the instance type the endpoint is using. The endpoint must be deleted in order to stop incurring charges.
     */
    override suspend fun updateEndpoint(input: UpdateEndpointRequest): UpdateEndpointResponse {
        val op = SdkHttpOperation.build<UpdateEndpointRequest, UpdateEndpointResponse> {
            serializer = UpdateEndpointOperationSerializer()
            deserializer = UpdateEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates variant weight of one or more variants associated with an existing endpoint, or capacity of one variant associated with an existing endpoint. When it receives the request, SageMaker sets the endpoint status to `Updating`. After updating the endpoint, it sets the status to `InService`. To check the status of an endpoint, use the DescribeEndpoint API.
     */
    override suspend fun updateEndpointWeightsAndCapacities(input: UpdateEndpointWeightsAndCapacitiesRequest): UpdateEndpointWeightsAndCapacitiesResponse {
        val op = SdkHttpOperation.build<UpdateEndpointWeightsAndCapacitiesRequest, UpdateEndpointWeightsAndCapacitiesResponse> {
            serializer = UpdateEndpointWeightsAndCapacitiesOperationSerializer()
            deserializer = UpdateEndpointWeightsAndCapacitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEndpointWeightsAndCapacities"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds, updates, or removes the description of an experiment. Updates the display name of an experiment.
     */
    override suspend fun updateExperiment(input: UpdateExperimentRequest): UpdateExperimentResponse {
        val op = SdkHttpOperation.build<UpdateExperimentRequest, UpdateExperimentResponse> {
            serializer = UpdateExperimentOperationSerializer()
            deserializer = UpdateExperimentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateExperiment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the properties of a SageMaker image. To change the image's tags, use the AddTags and DeleteTags APIs.
     */
    override suspend fun updateImage(input: UpdateImageRequest): UpdateImageResponse {
        val op = SdkHttpOperation.build<UpdateImageRequest, UpdateImageResponse> {
            serializer = UpdateImageOperationSerializer()
            deserializer = UpdateImageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateImage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a versioned model.
     */
    override suspend fun updateModelPackage(input: UpdateModelPackageRequest): UpdateModelPackageResponse {
        val op = SdkHttpOperation.build<UpdateModelPackageRequest, UpdateModelPackageResponse> {
            serializer = UpdateModelPackageOperationSerializer()
            deserializer = UpdateModelPackageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateModelPackage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a previously created schedule.
     */
    override suspend fun updateMonitoringSchedule(input: UpdateMonitoringScheduleRequest): UpdateMonitoringScheduleResponse {
        val op = SdkHttpOperation.build<UpdateMonitoringScheduleRequest, UpdateMonitoringScheduleResponse> {
            serializer = UpdateMonitoringScheduleOperationSerializer()
            deserializer = UpdateMonitoringScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateMonitoringSchedule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a notebook instance. NotebookInstance updates include upgrading or downgrading the ML compute instance used for your notebook instance to accommodate changes in your workload requirements.
     */
    override suspend fun updateNotebookInstance(input: UpdateNotebookInstanceRequest): UpdateNotebookInstanceResponse {
        val op = SdkHttpOperation.build<UpdateNotebookInstanceRequest, UpdateNotebookInstanceResponse> {
            serializer = UpdateNotebookInstanceOperationSerializer()
            deserializer = UpdateNotebookInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateNotebookInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a notebook instance lifecycle configuration created with the CreateNotebookInstanceLifecycleConfig API.
     */
    override suspend fun updateNotebookInstanceLifecycleConfig(input: UpdateNotebookInstanceLifecycleConfigRequest): UpdateNotebookInstanceLifecycleConfigResponse {
        val op = SdkHttpOperation.build<UpdateNotebookInstanceLifecycleConfigRequest, UpdateNotebookInstanceLifecycleConfigResponse> {
            serializer = UpdateNotebookInstanceLifecycleConfigOperationSerializer()
            deserializer = UpdateNotebookInstanceLifecycleConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateNotebookInstanceLifecycleConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a pipeline.
     */
    override suspend fun updatePipeline(input: UpdatePipelineRequest): UpdatePipelineResponse {
        val op = SdkHttpOperation.build<UpdatePipelineRequest, UpdatePipelineResponse> {
            serializer = UpdatePipelineOperationSerializer()
            deserializer = UpdatePipelineOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePipeline"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a pipeline execution.
     */
    override suspend fun updatePipelineExecution(input: UpdatePipelineExecutionRequest): UpdatePipelineExecutionResponse {
        val op = SdkHttpOperation.build<UpdatePipelineExecutionRequest, UpdatePipelineExecutionResponse> {
            serializer = UpdatePipelineExecutionOperationSerializer()
            deserializer = UpdatePipelineExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePipelineExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a machine learning (ML) project that is created from a template that sets up an ML pipeline from training to deploying an approved model.
     *
     * You must not update a project that is in use. If you update the `ServiceCatalogProvisioningUpdateDetails` of a project that is active or being created, or updated, you may lose resources already created by the project.
     */
    override suspend fun updateProject(input: UpdateProjectRequest): UpdateProjectResponse {
        val op = SdkHttpOperation.build<UpdateProjectRequest, UpdateProjectResponse> {
            serializer = UpdateProjectOperationSerializer()
            deserializer = UpdateProjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateProject"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update a model training job to request a new Debugger profiling configuration.
     */
    override suspend fun updateTrainingJob(input: UpdateTrainingJobRequest): UpdateTrainingJobResponse {
        val op = SdkHttpOperation.build<UpdateTrainingJobRequest, UpdateTrainingJobResponse> {
            serializer = UpdateTrainingJobOperationSerializer()
            deserializer = UpdateTrainingJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateTrainingJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the display name of a trial.
     */
    override suspend fun updateTrial(input: UpdateTrialRequest): UpdateTrialResponse {
        val op = SdkHttpOperation.build<UpdateTrialRequest, UpdateTrialResponse> {
            serializer = UpdateTrialOperationSerializer()
            deserializer = UpdateTrialOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateTrial"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates one or more properties of a trial component.
     */
    override suspend fun updateTrialComponent(input: UpdateTrialComponentRequest): UpdateTrialComponentResponse {
        val op = SdkHttpOperation.build<UpdateTrialComponentRequest, UpdateTrialComponentResponse> {
            serializer = UpdateTrialComponentOperationSerializer()
            deserializer = UpdateTrialComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateTrialComponent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a user profile.
     */
    override suspend fun updateUserProfile(input: UpdateUserProfileRequest): UpdateUserProfileResponse {
        val op = SdkHttpOperation.build<UpdateUserProfileRequest, UpdateUserProfileResponse> {
            serializer = UpdateUserProfileOperationSerializer()
            deserializer = UpdateUserProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateUserProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Use this operation to update your workforce. You can use this operation to require that workers use specific IP addresses to work on tasks and to update your OpenID Connect (OIDC) Identity Provider (IdP) workforce configuration.
     *
     *  Use `SourceIpConfig` to restrict worker access to tasks to a specific range of IP addresses. You specify allowed IP addresses by creating a list of up to ten [CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html). By default, a workforce isn't restricted to specific IP addresses. If you specify a range of IP addresses, workers who attempt to access tasks using any IP address outside the specified range are denied and get a `Not Found` error message on the worker portal.
     *
     * Use `OidcConfig` to update the configuration of a workforce created using your own OIDC IdP.
     *
     * You can only update your OIDC IdP configuration when there are no work teams associated with your workforce. You can delete work teams using the operation.
     *
     * After restricting access to a range of IP addresses or updating your OIDC IdP configuration with this operation, you can view details about your update workforce using the operation.
     *
     * This operation only applies to private workforces.
     */
    override suspend fun updateWorkforce(input: UpdateWorkforceRequest): UpdateWorkforceResponse {
        val op = SdkHttpOperation.build<UpdateWorkforceRequest, UpdateWorkforceResponse> {
            serializer = UpdateWorkforceOperationSerializer()
            deserializer = UpdateWorkforceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateWorkforce"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing work team with new member definitions or description.
     */
    override suspend fun updateWorkteam(input: UpdateWorkteamRequest): UpdateWorkteamResponse {
        val op = SdkHttpOperation.build<UpdateWorkteamRequest, UpdateWorkteamResponse> {
            serializer = UpdateWorkteamOperationSerializer()
            deserializer = UpdateWorkteamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateWorkteam"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SageMaker", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "sagemaker")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
