// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.sagemaker.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.sagemaker.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Provides APIs for creating and managing SageMaker resources.
 *
 * Other Resources:
 * + [SageMaker Developer Guide](https://docs.aws.amazon.com/sagemaker/latest/dg/whatis.html#first-time-user)
 * + [Amazon Augmented AI Runtime API Reference](https://docs.aws.amazon.com/augmented-ai/2019-11-07/APIReference/Welcome.html)
 */
interface SageMakerClient : SdkClient {

    override val serviceName: String
        get() = "SageMaker"
    /**
     * SageMakerClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): SageMakerClient {
            val config = Config.Builder().apply(block).build()
            return DefaultSageMakerClient(config)
        }

        operator fun invoke(config: Config): SageMakerClient = DefaultSageMakerClient(config)

        /**
         * Construct a [SageMakerClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): SageMakerClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultSageMakerClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an *association* between the source and the destination. A source can be associated with multiple destinations, and a destination can be associated with multiple sources. An association is a lineage tracking entity. For more information, see [Amazon SageMaker ML Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
     */
    suspend fun addAssociation(input: AddAssociationRequest): AddAssociationResponse

    /**
     * Creates an *association* between the source and the destination. A source can be associated with multiple destinations, and a destination can be associated with multiple sources. An association is a lineage tracking entity. For more information, see [Amazon SageMaker ML Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
     */
    suspend fun addAssociation(block: AddAssociationRequest.Builder.() -> Unit) = addAssociation(AddAssociationRequest.Builder().apply(block).build())

    /**
     * Adds or overwrites one or more tags for the specified SageMaker resource. You can add tags to notebook instances, training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint configurations, and endpoints.
     *
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information about tags, see For more information, see [Amazon Web Services Tagging Strategies](https://aws.amazon.com/answers/account-management/aws-tagging-strategies/).
     *
     * Tags that you add to a hyperparameter tuning job by calling this API are also added to any training jobs that the hyperparameter tuning job launches after you call this API, but not to training jobs that the hyperparameter tuning job launched before you called this API. To make sure that the tags associated with a hyperparameter tuning job are also added to all training jobs that the hyperparameter tuning job launches, add the tags when you first create the tuning job by specifying them in the `Tags` parameter of CreateHyperParameterTuningJob
     *
     * Tags that you add to a SageMaker Studio Domain or User Profile by calling this API are also added to any Apps that the Domain or User Profile launches after you call this API, but not to Apps that the Domain or User Profile launched before you called this API. To make sure that the tags associated with a Domain or User Profile are also added to all Apps that the Domain or User Profile launches, add the tags when you first create the Domain or User Profile by specifying them in the `Tags` parameter of CreateDomain or CreateUserProfile.
     */
    suspend fun addTags(input: AddTagsRequest): AddTagsResponse

    /**
     * Adds or overwrites one or more tags for the specified SageMaker resource. You can add tags to notebook instances, training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint configurations, and endpoints.
     *
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information about tags, see For more information, see [Amazon Web Services Tagging Strategies](https://aws.amazon.com/answers/account-management/aws-tagging-strategies/).
     *
     * Tags that you add to a hyperparameter tuning job by calling this API are also added to any training jobs that the hyperparameter tuning job launches after you call this API, but not to training jobs that the hyperparameter tuning job launched before you called this API. To make sure that the tags associated with a hyperparameter tuning job are also added to all training jobs that the hyperparameter tuning job launches, add the tags when you first create the tuning job by specifying them in the `Tags` parameter of CreateHyperParameterTuningJob
     *
     * Tags that you add to a SageMaker Studio Domain or User Profile by calling this API are also added to any Apps that the Domain or User Profile launches after you call this API, but not to Apps that the Domain or User Profile launched before you called this API. To make sure that the tags associated with a Domain or User Profile are also added to all Apps that the Domain or User Profile launches, add the tags when you first create the Domain or User Profile by specifying them in the `Tags` parameter of CreateDomain or CreateUserProfile.
     */
    suspend fun addTags(block: AddTagsRequest.Builder.() -> Unit) = addTags(AddTagsRequest.Builder().apply(block).build())

    /**
     * Associates a trial component with a trial. A trial component can be associated with multiple trials. To disassociate a trial component from a trial, call the DisassociateTrialComponent API.
     */
    suspend fun associateTrialComponent(input: AssociateTrialComponentRequest): AssociateTrialComponentResponse

    /**
     * Associates a trial component with a trial. A trial component can be associated with multiple trials. To disassociate a trial component from a trial, call the DisassociateTrialComponent API.
     */
    suspend fun associateTrialComponent(block: AssociateTrialComponentRequest.Builder.() -> Unit) = associateTrialComponent(AssociateTrialComponentRequest.Builder().apply(block).build())

    /**
     * This action batch describes a list of versioned model packages
     */
    suspend fun batchDescribeModelPackage(input: BatchDescribeModelPackageRequest): BatchDescribeModelPackageResponse

    /**
     * This action batch describes a list of versioned model packages
     */
    suspend fun batchDescribeModelPackage(block: BatchDescribeModelPackageRequest.Builder.() -> Unit) = batchDescribeModelPackage(BatchDescribeModelPackageRequest.Builder().apply(block).build())

    /**
     * Creates an *action*. An action is a lineage tracking entity that represents an action or activity. For example, a model deployment or an HPO job. Generally, an action involves at least one input or output artifact. For more information, see [Amazon SageMaker ML Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
     */
    suspend fun createAction(input: CreateActionRequest): CreateActionResponse

    /**
     * Creates an *action*. An action is a lineage tracking entity that represents an action or activity. For example, a model deployment or an HPO job. Generally, an action involves at least one input or output artifact. For more information, see [Amazon SageMaker ML Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
     */
    suspend fun createAction(block: CreateActionRequest.Builder.() -> Unit) = createAction(CreateActionRequest.Builder().apply(block).build())

    /**
     * Create a machine learning algorithm that you can use in SageMaker and list in the Amazon Web Services Marketplace.
     */
    suspend fun createAlgorithm(input: CreateAlgorithmRequest): CreateAlgorithmResponse

    /**
     * Create a machine learning algorithm that you can use in SageMaker and list in the Amazon Web Services Marketplace.
     */
    suspend fun createAlgorithm(block: CreateAlgorithmRequest.Builder.() -> Unit) = createAlgorithm(CreateAlgorithmRequest.Builder().apply(block).build())

    /**
     * Creates a running app for the specified UserProfile. Supported apps are `JupyterServer` and `KernelGateway`. This operation is automatically invoked by Amazon SageMaker Studio upon access to the associated Domain, and when new kernel configurations are selected by the user. A user may have multiple Apps active simultaneously.
     */
    suspend fun createApp(input: CreateAppRequest): CreateAppResponse

    /**
     * Creates a running app for the specified UserProfile. Supported apps are `JupyterServer` and `KernelGateway`. This operation is automatically invoked by Amazon SageMaker Studio upon access to the associated Domain, and when new kernel configurations are selected by the user. A user may have multiple Apps active simultaneously.
     */
    suspend fun createApp(block: CreateAppRequest.Builder.() -> Unit) = createApp(CreateAppRequest.Builder().apply(block).build())

    /**
     * Creates a configuration for running a SageMaker image as a KernelGateway app. The configuration specifies the Amazon Elastic File System (EFS) storage volume on the image, and a list of the kernels in the image.
     */
    suspend fun createAppImageConfig(input: CreateAppImageConfigRequest): CreateAppImageConfigResponse

    /**
     * Creates a configuration for running a SageMaker image as a KernelGateway app. The configuration specifies the Amazon Elastic File System (EFS) storage volume on the image, and a list of the kernels in the image.
     */
    suspend fun createAppImageConfig(block: CreateAppImageConfigRequest.Builder.() -> Unit) = createAppImageConfig(CreateAppImageConfigRequest.Builder().apply(block).build())

    /**
     * Creates an *artifact*. An artifact is a lineage tracking entity that represents a URI addressable object or data. Some examples are the S3 URI of a dataset and the ECR registry path of an image. For more information, see [Amazon SageMaker ML Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
     */
    suspend fun createArtifact(input: CreateArtifactRequest): CreateArtifactResponse

    /**
     * Creates an *artifact*. An artifact is a lineage tracking entity that represents a URI addressable object or data. Some examples are the S3 URI of a dataset and the ECR registry path of an image. For more information, see [Amazon SageMaker ML Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
     */
    suspend fun createArtifact(block: CreateArtifactRequest.Builder.() -> Unit) = createArtifact(CreateArtifactRequest.Builder().apply(block).build())

    /**
     * Creates an Autopilot job.
     *
     * Find the best-performing model after you run an Autopilot job by calling .
     *
     * For information about how to use Autopilot, see [Automate Model Development with Amazon SageMaker Autopilot](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html).
     */
    suspend fun createAutoMlJob(input: CreateAutoMlJobRequest): CreateAutoMlJobResponse

    /**
     * Creates an Autopilot job.
     *
     * Find the best-performing model after you run an Autopilot job by calling .
     *
     * For information about how to use Autopilot, see [Automate Model Development with Amazon SageMaker Autopilot](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html).
     */
    suspend fun createAutoMlJob(block: CreateAutoMlJobRequest.Builder.() -> Unit) = createAutoMlJob(CreateAutoMlJobRequest.Builder().apply(block).build())

    /**
     * Creates a Git repository as a resource in your SageMaker account. You can associate the repository with notebook instances so that you can use Git source control for the notebooks you create. The Git repository is a resource in your SageMaker account, so it can be associated with more than one notebook instance, and it persists independently from the lifecycle of any notebook instances it is associated with.
     *
     * The repository can be hosted either in [Amazon Web Services CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository.
     */
    suspend fun createCodeRepository(input: CreateCodeRepositoryRequest): CreateCodeRepositoryResponse

    /**
     * Creates a Git repository as a resource in your SageMaker account. You can associate the repository with notebook instances so that you can use Git source control for the notebooks you create. The Git repository is a resource in your SageMaker account, so it can be associated with more than one notebook instance, and it persists independently from the lifecycle of any notebook instances it is associated with.
     *
     * The repository can be hosted either in [Amazon Web Services CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository.
     */
    suspend fun createCodeRepository(block: CreateCodeRepositoryRequest.Builder.() -> Unit) = createCodeRepository(CreateCodeRepositoryRequest.Builder().apply(block).build())

    /**
     * Starts a model compilation job. After the model has been compiled, Amazon SageMaker saves the resulting model artifacts to an Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     *
     * If you choose to host your model using Amazon SageMaker hosting services, you can use the resulting model artifacts as part of the model. You can also use the artifacts with Amazon Web Services IoT Greengrass. In that case, deploy them as an ML resource.
     *
     * In the request body, you provide the following:
     * + A name for the compilation job
     * +  Information about the input model artifacts
     * + The output location for the compiled model and the device (target) that the model runs on
     * + The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker assumes to perform the model compilation job.
     *
     * You can also provide a `Tag` to track the model compilation job's resource use and costs. The response body contains the `CompilationJobArn` for the compiled job.
     *
     * To stop a model compilation job, use StopCompilationJob. To get information about a particular model compilation job, use DescribeCompilationJob. To get information about multiple model compilation jobs, use ListCompilationJobs.
     */
    suspend fun createCompilationJob(input: CreateCompilationJobRequest): CreateCompilationJobResponse

    /**
     * Starts a model compilation job. After the model has been compiled, Amazon SageMaker saves the resulting model artifacts to an Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     *
     * If you choose to host your model using Amazon SageMaker hosting services, you can use the resulting model artifacts as part of the model. You can also use the artifacts with Amazon Web Services IoT Greengrass. In that case, deploy them as an ML resource.
     *
     * In the request body, you provide the following:
     * + A name for the compilation job
     * +  Information about the input model artifacts
     * + The output location for the compiled model and the device (target) that the model runs on
     * + The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker assumes to perform the model compilation job.
     *
     * You can also provide a `Tag` to track the model compilation job's resource use and costs. The response body contains the `CompilationJobArn` for the compiled job.
     *
     * To stop a model compilation job, use StopCompilationJob. To get information about a particular model compilation job, use DescribeCompilationJob. To get information about multiple model compilation jobs, use ListCompilationJobs.
     */
    suspend fun createCompilationJob(block: CreateCompilationJobRequest.Builder.() -> Unit) = createCompilationJob(CreateCompilationJobRequest.Builder().apply(block).build())

    /**
     * Creates a *context*. A context is a lineage tracking entity that represents a logical grouping of other tracking or experiment entities. Some examples are an endpoint and a model package. For more information, see [Amazon SageMaker ML Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
     */
    suspend fun createContext(input: CreateContextRequest): CreateContextResponse

    /**
     * Creates a *context*. A context is a lineage tracking entity that represents a logical grouping of other tracking or experiment entities. Some examples are an endpoint and a model package. For more information, see [Amazon SageMaker ML Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
     */
    suspend fun createContext(block: CreateContextRequest.Builder.() -> Unit) = createContext(CreateContextRequest.Builder().apply(block).build())

    /**
     * Creates a definition for a job that monitors data quality and drift. For information about model monitor, see [Amazon SageMaker Model Monitor](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html).
     */
    suspend fun createDataQualityJobDefinition(input: CreateDataQualityJobDefinitionRequest): CreateDataQualityJobDefinitionResponse

    /**
     * Creates a definition for a job that monitors data quality and drift. For information about model monitor, see [Amazon SageMaker Model Monitor](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html).
     */
    suspend fun createDataQualityJobDefinition(block: CreateDataQualityJobDefinitionRequest.Builder.() -> Unit) = createDataQualityJobDefinition(CreateDataQualityJobDefinitionRequest.Builder().apply(block).build())

    /**
     * Creates a device fleet.
     */
    suspend fun createDeviceFleet(input: CreateDeviceFleetRequest): CreateDeviceFleetResponse

    /**
     * Creates a device fleet.
     */
    suspend fun createDeviceFleet(block: CreateDeviceFleetRequest.Builder.() -> Unit) = createDeviceFleet(CreateDeviceFleetRequest.Builder().apply(block).build())

    /**
     * Creates a `Domain` used by Amazon SageMaker Studio. A domain consists of an associated Amazon Elastic File System (EFS) volume, a list of authorized users, and a variety of security, application, policy, and Amazon Virtual Private Cloud (VPC) configurations. An Amazon Web Services account is limited to one domain per region. Users within a domain can share notebook files and other artifacts with each other.
     *
     * **EFS storage**
     *
     * When a domain is created, an EFS volume is created for use by all of the users within the domain. Each user receives a private home directory within the EFS volume for notebooks, Git repositories, and data files.
     *
     * SageMaker uses the Amazon Web Services Key Management Service (Amazon Web Services KMS) to encrypt the EFS volume attached to the domain with an Amazon Web Services managed key by default. For more control, you can specify a customer managed key. For more information, see [Protect Data at Rest Using Encryption](https://docs.aws.amazon.com/sagemaker/latest/dg/encryption-at-rest.html).
     *
     * **VPC configuration**
     *
     * All SageMaker Studio traffic between the domain and the EFS volume is through the specified VPC and subnets. For other Studio traffic, you can specify the `AppNetworkAccessType` parameter. `AppNetworkAccessType` corresponds to the network access type that you choose when you onboard to Studio. The following options are available:
     * + `PublicInternetOnly` - Non-EFS traffic goes through a VPC managed by Amazon SageMaker, which allows internet access. This is the default value.
     * + `VpcOnly` - All Studio traffic is through the specified VPC and subnets. Internet access is disabled by default. To allow internet access, you must specify a NAT gateway.When internet access is disabled, you won't be able to run a Studio notebook or to train or host models unless your VPC has an interface endpoint to the SageMaker API and runtime or a NAT gateway and your security groups allow outbound connections.
     *
     * NFS traffic over TCP on port 2049 needs to be allowed in both inbound and outbound rules in order to launch a SageMaker Studio app successfully.
     *
     * For more information, see [Connect SageMaker Studio Notebooks to Resources in a VPC](https://docs.aws.amazon.com/sagemaker/latest/dg/studio-notebooks-and-internet-access.html).
     */
    suspend fun createDomain(input: CreateDomainRequest): CreateDomainResponse

    /**
     * Creates a `Domain` used by Amazon SageMaker Studio. A domain consists of an associated Amazon Elastic File System (EFS) volume, a list of authorized users, and a variety of security, application, policy, and Amazon Virtual Private Cloud (VPC) configurations. An Amazon Web Services account is limited to one domain per region. Users within a domain can share notebook files and other artifacts with each other.
     *
     * **EFS storage**
     *
     * When a domain is created, an EFS volume is created for use by all of the users within the domain. Each user receives a private home directory within the EFS volume for notebooks, Git repositories, and data files.
     *
     * SageMaker uses the Amazon Web Services Key Management Service (Amazon Web Services KMS) to encrypt the EFS volume attached to the domain with an Amazon Web Services managed key by default. For more control, you can specify a customer managed key. For more information, see [Protect Data at Rest Using Encryption](https://docs.aws.amazon.com/sagemaker/latest/dg/encryption-at-rest.html).
     *
     * **VPC configuration**
     *
     * All SageMaker Studio traffic between the domain and the EFS volume is through the specified VPC and subnets. For other Studio traffic, you can specify the `AppNetworkAccessType` parameter. `AppNetworkAccessType` corresponds to the network access type that you choose when you onboard to Studio. The following options are available:
     * + `PublicInternetOnly` - Non-EFS traffic goes through a VPC managed by Amazon SageMaker, which allows internet access. This is the default value.
     * + `VpcOnly` - All Studio traffic is through the specified VPC and subnets. Internet access is disabled by default. To allow internet access, you must specify a NAT gateway.When internet access is disabled, you won't be able to run a Studio notebook or to train or host models unless your VPC has an interface endpoint to the SageMaker API and runtime or a NAT gateway and your security groups allow outbound connections.
     *
     * NFS traffic over TCP on port 2049 needs to be allowed in both inbound and outbound rules in order to launch a SageMaker Studio app successfully.
     *
     * For more information, see [Connect SageMaker Studio Notebooks to Resources in a VPC](https://docs.aws.amazon.com/sagemaker/latest/dg/studio-notebooks-and-internet-access.html).
     */
    suspend fun createDomain(block: CreateDomainRequest.Builder.() -> Unit) = createDomain(CreateDomainRequest.Builder().apply(block).build())

    /**
     * Starts a SageMaker Edge Manager model packaging job. Edge Manager will use the model artifacts from the Amazon Simple Storage Service bucket that you specify. After the model has been packaged, Amazon SageMaker saves the resulting artifacts to an S3 bucket that you specify.
     */
    suspend fun createEdgePackagingJob(input: CreateEdgePackagingJobRequest): CreateEdgePackagingJobResponse

    /**
     * Starts a SageMaker Edge Manager model packaging job. Edge Manager will use the model artifacts from the Amazon Simple Storage Service bucket that you specify. After the model has been packaged, Amazon SageMaker saves the resulting artifacts to an S3 bucket that you specify.
     */
    suspend fun createEdgePackagingJob(block: CreateEdgePackagingJobRequest.Builder.() -> Unit) = createEdgePackagingJob(CreateEdgePackagingJobRequest.Builder().apply(block).build())

    /**
     * Creates an endpoint using the endpoint configuration specified in the request. SageMaker uses the endpoint to provision resources and deploy models. You create the endpoint configuration with the CreateEndpointConfig API.
     *
     *  Use this API to deploy models using SageMaker hosting services.
     *
     * For an example that calls this method when deploying a model to SageMaker hosting services, see the [Create Endpoint example notebook.](https://github.com/aws/amazon-sagemaker-examples/blob/master/sagemaker-fundamentals/create-endpoint/create_endpoint.ipynb)
     *
     *  You must not delete an `EndpointConfig` that is in use by an endpoint that is live or while the `UpdateEndpoint` or `CreateEndpoint` operations are being performed on the endpoint. To update an endpoint, you must create a new `EndpointConfig`.
     *
     * The endpoint name must be unique within an Amazon Web Services Region in your Amazon Web Services account.
     *
     * When it receives the request, SageMaker creates the endpoint, launches the resources (ML compute instances), and deploys the model(s) on them.
     *
     * When you call CreateEndpoint, a load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a DynamoDB table supporting `Eventually Consistent Reads`[](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html), the response might not reflect the results of a recently completed write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB, this causes a validation error. If you repeat your read request after a short time, the response should return the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers call DescribeEndpointConfig before calling CreateEndpoint to minimize the potential impact of a DynamoDB eventually consistent read.
     *
     * When SageMaker receives the request, it sets the endpoint status to `Creating`. After it creates the endpoint, it sets the status to `InService`. SageMaker can then process incoming requests for inferences. To check the status of an endpoint, use the DescribeEndpoint API.
     *
     * If any of the models hosted at this endpoint get model data from an Amazon S3 location, SageMaker uses Amazon Web Services Security Token Service to download model artifacts from the S3 path you provided. Amazon Web Services STS is activated in your IAM user account by default. If you previously deactivated Amazon Web Services STS for a region, you need to reactivate Amazon Web Services STS for that region. For more information, see [Activating and Deactivating Amazon Web Services STS in an Amazon Web Services Region](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html) in the *Amazon Web Services Identity and Access Management User Guide*.
     *
     *  To add the IAM role policies for using this API operation, go to the [IAM console](https://console.aws.amazon.com/iam/), and choose Roles in the left navigation pane. Search the IAM role that you want to grant access to use the CreateEndpoint and CreateEndpointConfig API operations, add the following policies to the role.
     * + Option 1: For a full SageMaker access, search and attach the `AmazonSageMakerFullAccess` policy.
     * + Option 2: For granting a limited access to an IAM role, paste the following Action elements manually into the JSON file of the IAM role: `"Action": ["sagemaker:CreateEndpoint", "sagemaker:CreateEndpointConfig"]``"Resource": [``"arn:aws:sagemaker:region:account-id:endpoint/endpointName"``"arn:aws:sagemaker:region:account-id:endpoint-config/endpointConfigName"``]`For more information, see [SageMaker API Permissions: Actions, Permissions, and Resources Reference](https://docs.aws.amazon.com/sagemaker/latest/dg/api-permissions-reference.html).
     */
    suspend fun createEndpoint(input: CreateEndpointRequest): CreateEndpointResponse

    /**
     * Creates an endpoint using the endpoint configuration specified in the request. SageMaker uses the endpoint to provision resources and deploy models. You create the endpoint configuration with the CreateEndpointConfig API.
     *
     *  Use this API to deploy models using SageMaker hosting services.
     *
     * For an example that calls this method when deploying a model to SageMaker hosting services, see the [Create Endpoint example notebook.](https://github.com/aws/amazon-sagemaker-examples/blob/master/sagemaker-fundamentals/create-endpoint/create_endpoint.ipynb)
     *
     *  You must not delete an `EndpointConfig` that is in use by an endpoint that is live or while the `UpdateEndpoint` or `CreateEndpoint` operations are being performed on the endpoint. To update an endpoint, you must create a new `EndpointConfig`.
     *
     * The endpoint name must be unique within an Amazon Web Services Region in your Amazon Web Services account.
     *
     * When it receives the request, SageMaker creates the endpoint, launches the resources (ML compute instances), and deploys the model(s) on them.
     *
     * When you call CreateEndpoint, a load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a DynamoDB table supporting `Eventually Consistent Reads`[](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html), the response might not reflect the results of a recently completed write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB, this causes a validation error. If you repeat your read request after a short time, the response should return the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers call DescribeEndpointConfig before calling CreateEndpoint to minimize the potential impact of a DynamoDB eventually consistent read.
     *
     * When SageMaker receives the request, it sets the endpoint status to `Creating`. After it creates the endpoint, it sets the status to `InService`. SageMaker can then process incoming requests for inferences. To check the status of an endpoint, use the DescribeEndpoint API.
     *
     * If any of the models hosted at this endpoint get model data from an Amazon S3 location, SageMaker uses Amazon Web Services Security Token Service to download model artifacts from the S3 path you provided. Amazon Web Services STS is activated in your IAM user account by default. If you previously deactivated Amazon Web Services STS for a region, you need to reactivate Amazon Web Services STS for that region. For more information, see [Activating and Deactivating Amazon Web Services STS in an Amazon Web Services Region](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html) in the *Amazon Web Services Identity and Access Management User Guide*.
     *
     *  To add the IAM role policies for using this API operation, go to the [IAM console](https://console.aws.amazon.com/iam/), and choose Roles in the left navigation pane. Search the IAM role that you want to grant access to use the CreateEndpoint and CreateEndpointConfig API operations, add the following policies to the role.
     * + Option 1: For a full SageMaker access, search and attach the `AmazonSageMakerFullAccess` policy.
     * + Option 2: For granting a limited access to an IAM role, paste the following Action elements manually into the JSON file of the IAM role: `"Action": ["sagemaker:CreateEndpoint", "sagemaker:CreateEndpointConfig"]``"Resource": [``"arn:aws:sagemaker:region:account-id:endpoint/endpointName"``"arn:aws:sagemaker:region:account-id:endpoint-config/endpointConfigName"``]`For more information, see [SageMaker API Permissions: Actions, Permissions, and Resources Reference](https://docs.aws.amazon.com/sagemaker/latest/dg/api-permissions-reference.html).
     */
    suspend fun createEndpoint(block: CreateEndpointRequest.Builder.() -> Unit) = createEndpoint(CreateEndpointRequest.Builder().apply(block).build())

    /**
     * Creates an endpoint configuration that SageMaker hosting services uses to deploy models. In the configuration, you identify one or more models, created using the `CreateModel` API, to deploy and the resources that you want SageMaker to provision. Then you call the CreateEndpoint API.
     *
     *  Use this API if you want to use SageMaker hosting services to deploy models into production.
     *
     * In the request, you define a `ProductionVariant`, for each model that you want to deploy. Each `ProductionVariant` parameter also describes the resources that you want SageMaker to provision. This includes the number and type of ML compute instances to deploy.
     *
     * If you are hosting multiple models, you also assign a `VariantWeight` to specify how much traffic you want to allocate to each model. For example, suppose that you want to host two models, A and B, and you assign traffic weight 2 for model A and 1 for model B. SageMaker distributes two-thirds of the traffic to Model A, and one-third to model B.
     *
     * When you call CreateEndpoint, a load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a DynamoDB table supporting `Eventually Consistent Reads`[](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html), the response might not reflect the results of a recently completed write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB, this causes a validation error. If you repeat your read request after a short time, the response should return the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers call DescribeEndpointConfig before calling CreateEndpoint to minimize the potential impact of a DynamoDB eventually consistent read.
     */
    suspend fun createEndpointConfig(input: CreateEndpointConfigRequest): CreateEndpointConfigResponse

    /**
     * Creates an endpoint configuration that SageMaker hosting services uses to deploy models. In the configuration, you identify one or more models, created using the `CreateModel` API, to deploy and the resources that you want SageMaker to provision. Then you call the CreateEndpoint API.
     *
     *  Use this API if you want to use SageMaker hosting services to deploy models into production.
     *
     * In the request, you define a `ProductionVariant`, for each model that you want to deploy. Each `ProductionVariant` parameter also describes the resources that you want SageMaker to provision. This includes the number and type of ML compute instances to deploy.
     *
     * If you are hosting multiple models, you also assign a `VariantWeight` to specify how much traffic you want to allocate to each model. For example, suppose that you want to host two models, A and B, and you assign traffic weight 2 for model A and 1 for model B. SageMaker distributes two-thirds of the traffic to Model A, and one-third to model B.
     *
     * When you call CreateEndpoint, a load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a DynamoDB table supporting `Eventually Consistent Reads`[](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html), the response might not reflect the results of a recently completed write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB, this causes a validation error. If you repeat your read request after a short time, the response should return the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers call DescribeEndpointConfig before calling CreateEndpoint to minimize the potential impact of a DynamoDB eventually consistent read.
     */
    suspend fun createEndpointConfig(block: CreateEndpointConfigRequest.Builder.() -> Unit) = createEndpointConfig(CreateEndpointConfigRequest.Builder().apply(block).build())

    /**
     * Creates an SageMaker *experiment*. An experiment is a collection of *trials* that are observed, compared and evaluated as a group. A trial is a set of steps, called *trial components*, that produce a machine learning model.
     *
     * The goal of an experiment is to determine the components that produce the best model. Multiple trials are performed, each one isolating and measuring the impact of a change to one or more inputs, while keeping the remaining inputs constant.
     *
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must use the logging APIs provided by the SDK.
     *
     * You can add tags to experiments, trials, trial components and then use the Search API to search for the tags.
     *
     * To add a description to an experiment, specify the optional `Description` parameter. To add a description later, or to change the description, call the UpdateExperiment API.
     *
     * To get a list of all your experiments, call the ListExperiments API. To view an experiment's properties, call the DescribeExperiment API. To get a list of all the trials associated with an experiment, call the ListTrials API. To create a trial call the CreateTrial API.
     */
    suspend fun createExperiment(input: CreateExperimentRequest): CreateExperimentResponse

    /**
     * Creates an SageMaker *experiment*. An experiment is a collection of *trials* that are observed, compared and evaluated as a group. A trial is a set of steps, called *trial components*, that produce a machine learning model.
     *
     * The goal of an experiment is to determine the components that produce the best model. Multiple trials are performed, each one isolating and measuring the impact of a change to one or more inputs, while keeping the remaining inputs constant.
     *
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must use the logging APIs provided by the SDK.
     *
     * You can add tags to experiments, trials, trial components and then use the Search API to search for the tags.
     *
     * To add a description to an experiment, specify the optional `Description` parameter. To add a description later, or to change the description, call the UpdateExperiment API.
     *
     * To get a list of all your experiments, call the ListExperiments API. To view an experiment's properties, call the DescribeExperiment API. To get a list of all the trials associated with an experiment, call the ListTrials API. To create a trial call the CreateTrial API.
     */
    suspend fun createExperiment(block: CreateExperimentRequest.Builder.() -> Unit) = createExperiment(CreateExperimentRequest.Builder().apply(block).build())

    /**
     * Create a new `FeatureGroup`. A `FeatureGroup` is a group of `Features` defined in the `FeatureStore` to describe a `Record`.
     *
     * The `FeatureGroup` defines the schema and features contained in the FeatureGroup. A `FeatureGroup` definition is composed of a list of `Features`, a `RecordIdentifierFeatureName`, an `EventTimeFeatureName` and configurations for its `OnlineStore` and `OfflineStore`. Check [Amazon Web Services service quotas](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) to see the `FeatureGroup`s quota for your Amazon Web Services account.
     *
     * You must include at least one of `OnlineStoreConfig` and `OfflineStoreConfig` to create a `FeatureGroup`.
     */
    suspend fun createFeatureGroup(input: CreateFeatureGroupRequest): CreateFeatureGroupResponse

    /**
     * Create a new `FeatureGroup`. A `FeatureGroup` is a group of `Features` defined in the `FeatureStore` to describe a `Record`.
     *
     * The `FeatureGroup` defines the schema and features contained in the FeatureGroup. A `FeatureGroup` definition is composed of a list of `Features`, a `RecordIdentifierFeatureName`, an `EventTimeFeatureName` and configurations for its `OnlineStore` and `OfflineStore`. Check [Amazon Web Services service quotas](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) to see the `FeatureGroup`s quota for your Amazon Web Services account.
     *
     * You must include at least one of `OnlineStoreConfig` and `OfflineStoreConfig` to create a `FeatureGroup`.
     */
    suspend fun createFeatureGroup(block: CreateFeatureGroupRequest.Builder.() -> Unit) = createFeatureGroup(CreateFeatureGroupRequest.Builder().apply(block).build())

    /**
     * Creates a flow definition.
     */
    suspend fun createFlowDefinition(input: CreateFlowDefinitionRequest): CreateFlowDefinitionResponse

    /**
     * Creates a flow definition.
     */
    suspend fun createFlowDefinition(block: CreateFlowDefinitionRequest.Builder.() -> Unit) = createFlowDefinition(CreateFlowDefinitionRequest.Builder().apply(block).build())

    /**
     * Defines the settings you will use for the human review workflow user interface. Reviewers will see a three-panel interface with an instruction area, the item to review, and an input area.
     */
    suspend fun createHumanTaskUi(input: CreateHumanTaskUiRequest): CreateHumanTaskUiResponse

    /**
     * Defines the settings you will use for the human review workflow user interface. Reviewers will see a three-panel interface with an instruction area, the item to review, and an input area.
     */
    suspend fun createHumanTaskUi(block: CreateHumanTaskUiRequest.Builder.() -> Unit) = createHumanTaskUi(CreateHumanTaskUiRequest.Builder().apply(block).build())

    /**
     * Starts a hyperparameter tuning job. A hyperparameter tuning job finds the best version of a model by running many training jobs on your dataset using the algorithm you choose and values for hyperparameters within ranges that you specify. It then chooses the hyperparameter values that result in a model that performs the best, as measured by an objective metric that you choose.
     */
    suspend fun createHyperParameterTuningJob(input: CreateHyperParameterTuningJobRequest): CreateHyperParameterTuningJobResponse

    /**
     * Starts a hyperparameter tuning job. A hyperparameter tuning job finds the best version of a model by running many training jobs on your dataset using the algorithm you choose and values for hyperparameters within ranges that you specify. It then chooses the hyperparameter values that result in a model that performs the best, as measured by an objective metric that you choose.
     */
    suspend fun createHyperParameterTuningJob(block: CreateHyperParameterTuningJobRequest.Builder.() -> Unit) = createHyperParameterTuningJob(CreateHyperParameterTuningJobRequest.Builder().apply(block).build())

    /**
     * Creates a custom SageMaker image. A SageMaker image is a set of image versions. Each image version represents a container image stored in Amazon Elastic Container Registry (ECR). For more information, see [Bring your own SageMaker image](https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html).
     */
    suspend fun createImage(input: CreateImageRequest): CreateImageResponse

    /**
     * Creates a custom SageMaker image. A SageMaker image is a set of image versions. Each image version represents a container image stored in Amazon Elastic Container Registry (ECR). For more information, see [Bring your own SageMaker image](https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html).
     */
    suspend fun createImage(block: CreateImageRequest.Builder.() -> Unit) = createImage(CreateImageRequest.Builder().apply(block).build())

    /**
     * Creates a version of the SageMaker image specified by `ImageName`. The version represents the Amazon Elastic Container Registry (ECR) container image specified by `BaseImage`.
     */
    suspend fun createImageVersion(input: CreateImageVersionRequest): CreateImageVersionResponse

    /**
     * Creates a version of the SageMaker image specified by `ImageName`. The version represents the Amazon Elastic Container Registry (ECR) container image specified by `BaseImage`.
     */
    suspend fun createImageVersion(block: CreateImageVersionRequest.Builder.() -> Unit) = createImageVersion(CreateImageVersionRequest.Builder().apply(block).build())

    /**
     * Starts a recommendation job. You can create either an instance recommendation or load test job.
     */
    suspend fun createInferenceRecommendationsJob(input: CreateInferenceRecommendationsJobRequest): CreateInferenceRecommendationsJobResponse

    /**
     * Starts a recommendation job. You can create either an instance recommendation or load test job.
     */
    suspend fun createInferenceRecommendationsJob(block: CreateInferenceRecommendationsJobRequest.Builder.() -> Unit) = createInferenceRecommendationsJob(CreateInferenceRecommendationsJobRequest.Builder().apply(block).build())

    /**
     * Creates a job that uses workers to label the data objects in your input dataset. You can use the labeled data to train machine learning models.
     *
     * You can select your workforce from one of three providers:
     * + A private workforce that you create. It can include employees, contractors, and outside experts. Use a private workforce when want the data to stay within your organization or when a specific set of skills is required.
     * + One or more vendors that you select from the Amazon Web Services Marketplace. Vendors provide expertise in specific areas.
     * + The Amazon Mechanical Turk workforce. This is the largest workforce, but it should only be used for public data or data that has been stripped of any personally identifiable information.
     *
     * You can also use *automated data labeling* to reduce the number of data objects that need to be labeled by a human. Automated data labeling uses *active learning* to determine if a data object can be labeled by machine or if it needs to be sent to a human worker. For more information, see [Using Automated Data Labeling](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-automated-labeling.html).
     *
     * The data objects to be labeled are contained in an Amazon S3 bucket. You create a *manifest file* that describes the location of each object. For more information, see [Using Input and Output Data](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data.html).
     *
     * The output can be used as the manifest file for another labeling job or as training data for your machine learning models.
     *
     * You can use this operation to create a static labeling job or a streaming labeling job. A static labeling job stops if all data objects in the input manifest file identified in `ManifestS3Uri` have been labeled. A streaming labeling job runs perpetually until it is manually stopped, or remains idle for 10 days. You can send new data objects to an active (`InProgress`) streaming labeling job in real time. To learn how to create a static labeling job, see [Create a Labeling Job (API) ](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-create-labeling-job-api.html) in the Amazon SageMaker Developer Guide. To learn how to create a streaming labeling job, see [Create a Streaming Labeling Job](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-create-job.html).
     */
    suspend fun createLabelingJob(input: CreateLabelingJobRequest): CreateLabelingJobResponse

    /**
     * Creates a job that uses workers to label the data objects in your input dataset. You can use the labeled data to train machine learning models.
     *
     * You can select your workforce from one of three providers:
     * + A private workforce that you create. It can include employees, contractors, and outside experts. Use a private workforce when want the data to stay within your organization or when a specific set of skills is required.
     * + One or more vendors that you select from the Amazon Web Services Marketplace. Vendors provide expertise in specific areas.
     * + The Amazon Mechanical Turk workforce. This is the largest workforce, but it should only be used for public data or data that has been stripped of any personally identifiable information.
     *
     * You can also use *automated data labeling* to reduce the number of data objects that need to be labeled by a human. Automated data labeling uses *active learning* to determine if a data object can be labeled by machine or if it needs to be sent to a human worker. For more information, see [Using Automated Data Labeling](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-automated-labeling.html).
     *
     * The data objects to be labeled are contained in an Amazon S3 bucket. You create a *manifest file* that describes the location of each object. For more information, see [Using Input and Output Data](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data.html).
     *
     * The output can be used as the manifest file for another labeling job or as training data for your machine learning models.
     *
     * You can use this operation to create a static labeling job or a streaming labeling job. A static labeling job stops if all data objects in the input manifest file identified in `ManifestS3Uri` have been labeled. A streaming labeling job runs perpetually until it is manually stopped, or remains idle for 10 days. You can send new data objects to an active (`InProgress`) streaming labeling job in real time. To learn how to create a static labeling job, see [Create a Labeling Job (API) ](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-create-labeling-job-api.html) in the Amazon SageMaker Developer Guide. To learn how to create a streaming labeling job, see [Create a Streaming Labeling Job](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-create-job.html).
     */
    suspend fun createLabelingJob(block: CreateLabelingJobRequest.Builder.() -> Unit) = createLabelingJob(CreateLabelingJobRequest.Builder().apply(block).build())

    /**
     * Creates a model in SageMaker. In the request, you name the model and describe a primary container. For the primary container, you specify the Docker image that contains inference code, artifacts (from prior training), and a custom environment map that the inference code uses when you deploy the model for predictions.
     *
     * Use this API to create a model if you want to use SageMaker hosting services or run a batch transform job.
     *
     * To host your model, you create an endpoint configuration with the `CreateEndpointConfig` API, and then create an endpoint with the `CreateEndpoint` API. SageMaker then deploys all of the containers that you defined for the model in the hosting environment.
     *
     * For an example that calls this method when deploying a model to SageMaker hosting services, see [Deploy the Model to Amazon SageMaker Hosting Services (Amazon Web Services SDK for Python (Boto 3)).](https://docs.aws.amazon.com/sagemaker/latest/dg/ex1-deploy-model.html#ex1-deploy-model-boto)
     *
     * To run a batch transform using your model, you start a job with the `CreateTransformJob` API. SageMaker uses your model and your dataset to get inferences which are then saved to a specified S3 location.
     *
     * In the request, you also provide an IAM role that SageMaker can assume to access model artifacts and docker image for deployment on ML compute hosting instances or for batch transform jobs. In addition, you also use the IAM role to manage permissions the inference code needs. For example, if the inference code access any other Amazon Web Services resources, you grant necessary permissions via this role.
     */
    suspend fun createModel(input: CreateModelRequest): CreateModelResponse

    /**
     * Creates a model in SageMaker. In the request, you name the model and describe a primary container. For the primary container, you specify the Docker image that contains inference code, artifacts (from prior training), and a custom environment map that the inference code uses when you deploy the model for predictions.
     *
     * Use this API to create a model if you want to use SageMaker hosting services or run a batch transform job.
     *
     * To host your model, you create an endpoint configuration with the `CreateEndpointConfig` API, and then create an endpoint with the `CreateEndpoint` API. SageMaker then deploys all of the containers that you defined for the model in the hosting environment.
     *
     * For an example that calls this method when deploying a model to SageMaker hosting services, see [Deploy the Model to Amazon SageMaker Hosting Services (Amazon Web Services SDK for Python (Boto 3)).](https://docs.aws.amazon.com/sagemaker/latest/dg/ex1-deploy-model.html#ex1-deploy-model-boto)
     *
     * To run a batch transform using your model, you start a job with the `CreateTransformJob` API. SageMaker uses your model and your dataset to get inferences which are then saved to a specified S3 location.
     *
     * In the request, you also provide an IAM role that SageMaker can assume to access model artifacts and docker image for deployment on ML compute hosting instances or for batch transform jobs. In addition, you also use the IAM role to manage permissions the inference code needs. For example, if the inference code access any other Amazon Web Services resources, you grant necessary permissions via this role.
     */
    suspend fun createModel(block: CreateModelRequest.Builder.() -> Unit) = createModel(CreateModelRequest.Builder().apply(block).build())

    /**
     * Creates the definition for a model bias job.
     */
    suspend fun createModelBiasJobDefinition(input: CreateModelBiasJobDefinitionRequest): CreateModelBiasJobDefinitionResponse

    /**
     * Creates the definition for a model bias job.
     */
    suspend fun createModelBiasJobDefinition(block: CreateModelBiasJobDefinitionRequest.Builder.() -> Unit) = createModelBiasJobDefinition(CreateModelBiasJobDefinitionRequest.Builder().apply(block).build())

    /**
     * Creates the definition for a model explainability job.
     */
    suspend fun createModelExplainabilityJobDefinition(input: CreateModelExplainabilityJobDefinitionRequest): CreateModelExplainabilityJobDefinitionResponse

    /**
     * Creates the definition for a model explainability job.
     */
    suspend fun createModelExplainabilityJobDefinition(block: CreateModelExplainabilityJobDefinitionRequest.Builder.() -> Unit) = createModelExplainabilityJobDefinition(CreateModelExplainabilityJobDefinitionRequest.Builder().apply(block).build())

    /**
     * Creates a model package that you can use to create SageMaker models or list on Amazon Web Services Marketplace, or a versioned model that is part of a model group. Buyers can subscribe to model packages listed on Amazon Web Services Marketplace to create models in SageMaker.
     *
     * To create a model package by specifying a Docker container that contains your inference code and the Amazon S3 location of your model artifacts, provide values for `InferenceSpecification`. To create a model from an algorithm resource that you created or subscribed to in Amazon Web Services Marketplace, provide a value for `SourceAlgorithmSpecification`.
     *
     * There are two types of model packages:
     * + Versioned - a model that is part of a model group in the model registry.
     * + Unversioned - a model package that is not part of a model group.
     */
    suspend fun createModelPackage(input: CreateModelPackageRequest = CreateModelPackageRequest {}): CreateModelPackageResponse

    /**
     * Creates a model package that you can use to create SageMaker models or list on Amazon Web Services Marketplace, or a versioned model that is part of a model group. Buyers can subscribe to model packages listed on Amazon Web Services Marketplace to create models in SageMaker.
     *
     * To create a model package by specifying a Docker container that contains your inference code and the Amazon S3 location of your model artifacts, provide values for `InferenceSpecification`. To create a model from an algorithm resource that you created or subscribed to in Amazon Web Services Marketplace, provide a value for `SourceAlgorithmSpecification`.
     *
     * There are two types of model packages:
     * + Versioned - a model that is part of a model group in the model registry.
     * + Unversioned - a model package that is not part of a model group.
     */
    suspend fun createModelPackage(block: CreateModelPackageRequest.Builder.() -> Unit) = createModelPackage(CreateModelPackageRequest.Builder().apply(block).build())

    /**
     * Creates a model group. A model group contains a group of model versions.
     */
    suspend fun createModelPackageGroup(input: CreateModelPackageGroupRequest): CreateModelPackageGroupResponse

    /**
     * Creates a model group. A model group contains a group of model versions.
     */
    suspend fun createModelPackageGroup(block: CreateModelPackageGroupRequest.Builder.() -> Unit) = createModelPackageGroup(CreateModelPackageGroupRequest.Builder().apply(block).build())

    /**
     * Creates a definition for a job that monitors model quality and drift. For information about model monitor, see [Amazon SageMaker Model Monitor](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html).
     */
    suspend fun createModelQualityJobDefinition(input: CreateModelQualityJobDefinitionRequest): CreateModelQualityJobDefinitionResponse

    /**
     * Creates a definition for a job that monitors model quality and drift. For information about model monitor, see [Amazon SageMaker Model Monitor](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html).
     */
    suspend fun createModelQualityJobDefinition(block: CreateModelQualityJobDefinitionRequest.Builder.() -> Unit) = createModelQualityJobDefinition(CreateModelQualityJobDefinitionRequest.Builder().apply(block).build())

    /**
     * Creates a schedule that regularly starts Amazon SageMaker Processing Jobs to monitor the data captured for an Amazon SageMaker Endoint.
     */
    suspend fun createMonitoringSchedule(input: CreateMonitoringScheduleRequest): CreateMonitoringScheduleResponse

    /**
     * Creates a schedule that regularly starts Amazon SageMaker Processing Jobs to monitor the data captured for an Amazon SageMaker Endoint.
     */
    suspend fun createMonitoringSchedule(block: CreateMonitoringScheduleRequest.Builder.() -> Unit) = createMonitoringSchedule(CreateMonitoringScheduleRequest.Builder().apply(block).build())

    /**
     * Creates an SageMaker notebook instance. A notebook instance is a machine learning (ML) compute instance running on a Jupyter notebook.
     *
     * In a `CreateNotebookInstance` request, specify the type of ML compute instance that you want to run. SageMaker launches the instance, installs common libraries that you can use to explore datasets for model training, and attaches an ML storage volume to the notebook instance.
     *
     * SageMaker also provides a set of example notebooks. Each notebook demonstrates how to use SageMaker with a specific algorithm or with a machine learning framework.
     *
     * After receiving the request, SageMaker does the following:
     * + Creates a network interface in the SageMaker VPC.
     * + (Option) If you specified `SubnetId`, SageMaker creates a network interface in your own VPC, which is inferred from the subnet ID that you provide in the input. When creating this network interface, SageMaker attaches the security group that you specified in the request to the network interface that it creates in your VPC.
     * + Launches an EC2 instance of the type specified in the request in the SageMaker VPC. If you specified `SubnetId` of your VPC, SageMaker specifies both network interfaces when launching this instance. This enables inbound traffic from your own VPC to the notebook instance, assuming that the security groups allow it.
     *
     * After creating the notebook instance, SageMaker returns its Amazon Resource Name (ARN). You can't change the name of a notebook instance after you create it.
     *
     * After SageMaker creates the notebook instance, you can connect to the Jupyter server and work in Jupyter notebooks. For example, you can write code to explore a dataset that you can use for model training, train a model, host models by creating SageMaker endpoints, and validate hosted models.
     *
     * For more information, see [How It Works](https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html).
     */
    suspend fun createNotebookInstance(input: CreateNotebookInstanceRequest): CreateNotebookInstanceResponse

    /**
     * Creates an SageMaker notebook instance. A notebook instance is a machine learning (ML) compute instance running on a Jupyter notebook.
     *
     * In a `CreateNotebookInstance` request, specify the type of ML compute instance that you want to run. SageMaker launches the instance, installs common libraries that you can use to explore datasets for model training, and attaches an ML storage volume to the notebook instance.
     *
     * SageMaker also provides a set of example notebooks. Each notebook demonstrates how to use SageMaker with a specific algorithm or with a machine learning framework.
     *
     * After receiving the request, SageMaker does the following:
     * + Creates a network interface in the SageMaker VPC.
     * + (Option) If you specified `SubnetId`, SageMaker creates a network interface in your own VPC, which is inferred from the subnet ID that you provide in the input. When creating this network interface, SageMaker attaches the security group that you specified in the request to the network interface that it creates in your VPC.
     * + Launches an EC2 instance of the type specified in the request in the SageMaker VPC. If you specified `SubnetId` of your VPC, SageMaker specifies both network interfaces when launching this instance. This enables inbound traffic from your own VPC to the notebook instance, assuming that the security groups allow it.
     *
     * After creating the notebook instance, SageMaker returns its Amazon Resource Name (ARN). You can't change the name of a notebook instance after you create it.
     *
     * After SageMaker creates the notebook instance, you can connect to the Jupyter server and work in Jupyter notebooks. For example, you can write code to explore a dataset that you can use for model training, train a model, host models by creating SageMaker endpoints, and validate hosted models.
     *
     * For more information, see [How It Works](https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html).
     */
    suspend fun createNotebookInstance(block: CreateNotebookInstanceRequest.Builder.() -> Unit) = createNotebookInstance(CreateNotebookInstanceRequest.Builder().apply(block).build())

    /**
     * Creates a lifecycle configuration that you can associate with a notebook instance. A *lifecycle configuration* is a collection of shell scripts that run when you create or start a notebook instance.
     *
     * Each lifecycle configuration script has a limit of 16384 characters.
     *
     * The value of the `$PATH` environment variable that is available to both scripts is `/sbin:bin:/usr/sbin:/usr/bin`.
     *
     * View CloudWatch Logs for notebook instance lifecycle configurations in log group `/aws/sagemaker/NotebookInstances` in log stream `[notebook-instance-name]/[LifecycleConfigHook]`.
     *
     * Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs for longer than 5 minutes, it fails and the notebook instance is not created or started.
     *
     * For information about notebook instance lifestyle configurations, see [Step 2.1: (Optional) Customize a Notebook Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
     */
    suspend fun createNotebookInstanceLifecycleConfig(input: CreateNotebookInstanceLifecycleConfigRequest): CreateNotebookInstanceLifecycleConfigResponse

    /**
     * Creates a lifecycle configuration that you can associate with a notebook instance. A *lifecycle configuration* is a collection of shell scripts that run when you create or start a notebook instance.
     *
     * Each lifecycle configuration script has a limit of 16384 characters.
     *
     * The value of the `$PATH` environment variable that is available to both scripts is `/sbin:bin:/usr/sbin:/usr/bin`.
     *
     * View CloudWatch Logs for notebook instance lifecycle configurations in log group `/aws/sagemaker/NotebookInstances` in log stream `[notebook-instance-name]/[LifecycleConfigHook]`.
     *
     * Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs for longer than 5 minutes, it fails and the notebook instance is not created or started.
     *
     * For information about notebook instance lifestyle configurations, see [Step 2.1: (Optional) Customize a Notebook Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
     */
    suspend fun createNotebookInstanceLifecycleConfig(block: CreateNotebookInstanceLifecycleConfigRequest.Builder.() -> Unit) = createNotebookInstanceLifecycleConfig(CreateNotebookInstanceLifecycleConfigRequest.Builder().apply(block).build())

    /**
     * Creates a pipeline using a JSON pipeline definition.
     */
    suspend fun createPipeline(input: CreatePipelineRequest): CreatePipelineResponse

    /**
     * Creates a pipeline using a JSON pipeline definition.
     */
    suspend fun createPipeline(block: CreatePipelineRequest.Builder.() -> Unit) = createPipeline(CreatePipelineRequest.Builder().apply(block).build())

    /**
     * Creates a URL for a specified UserProfile in a Domain. When accessed in a web browser, the user will be automatically signed in to Amazon SageMaker Studio, and granted access to all of the Apps and files associated with the Domain's Amazon Elastic File System (EFS) volume. This operation can only be called when the authentication mode equals IAM.
     *
     * The IAM role or user used to call this API defines the permissions to access the app. Once the presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for this API are also enforced for every HTTP request and WebSocket frame that attempts to connect to the app.
     *
     * You can restrict access to this API and to the URL that it returns to a list of IP addresses, Amazon VPCs or Amazon VPC Endpoints that you specify. For more information, see [Connect to SageMaker Studio Through an Interface VPC Endpoint](https://docs.aws.amazon.com/sagemaker/latest/dg/studio-interface-endpoint.html) .
     *
     * The URL that you get from a call to `CreatePresignedDomainUrl` has a default timeout of 5 minutes. You can configure this value using `ExpiresInSeconds`. If you try to use the URL after the timeout limit expires, you are directed to the Amazon Web Services console sign-in page.
     */
    suspend fun createPresignedDomainUrl(input: CreatePresignedDomainUrlRequest): CreatePresignedDomainUrlResponse

    /**
     * Creates a URL for a specified UserProfile in a Domain. When accessed in a web browser, the user will be automatically signed in to Amazon SageMaker Studio, and granted access to all of the Apps and files associated with the Domain's Amazon Elastic File System (EFS) volume. This operation can only be called when the authentication mode equals IAM.
     *
     * The IAM role or user used to call this API defines the permissions to access the app. Once the presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for this API are also enforced for every HTTP request and WebSocket frame that attempts to connect to the app.
     *
     * You can restrict access to this API and to the URL that it returns to a list of IP addresses, Amazon VPCs or Amazon VPC Endpoints that you specify. For more information, see [Connect to SageMaker Studio Through an Interface VPC Endpoint](https://docs.aws.amazon.com/sagemaker/latest/dg/studio-interface-endpoint.html) .
     *
     * The URL that you get from a call to `CreatePresignedDomainUrl` has a default timeout of 5 minutes. You can configure this value using `ExpiresInSeconds`. If you try to use the URL after the timeout limit expires, you are directed to the Amazon Web Services console sign-in page.
     */
    suspend fun createPresignedDomainUrl(block: CreatePresignedDomainUrlRequest.Builder.() -> Unit) = createPresignedDomainUrl(CreatePresignedDomainUrlRequest.Builder().apply(block).build())

    /**
     * Returns a URL that you can use to connect to the Jupyter server from a notebook instance. In the SageMaker console, when you choose `Open` next to a notebook instance, SageMaker opens a new tab showing the Jupyter server home page from the notebook instance. The console uses this API to get the URL and show the page.
     *
     *  The IAM role or user used to call this API defines the permissions to access the notebook instance. Once the presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for this API are also enforced for every HTTP request and WebSocket frame that attempts to connect to the notebook instance.
     *
     * You can restrict access to this API and to the URL that it returns to a list of IP addresses that you specify. Use the `NotIpAddress` condition operator and the `aws:SourceIP` condition context key to specify the list of IP addresses that you want to have access to the notebook instance. For more information, see [Limit Access to a Notebook Instance by IP Address](https://docs.aws.amazon.com/sagemaker/latest/dg/security_iam_id-based-policy-examples.html#nbi-ip-filter).
     *
     * The URL that you get from a call to CreatePresignedNotebookInstanceUrl is valid only for 5 minutes. If you try to use the URL after the 5-minute limit expires, you are directed to the Amazon Web Services console sign-in page.
     */
    suspend fun createPresignedNotebookInstanceUrl(input: CreatePresignedNotebookInstanceUrlRequest): CreatePresignedNotebookInstanceUrlResponse

    /**
     * Returns a URL that you can use to connect to the Jupyter server from a notebook instance. In the SageMaker console, when you choose `Open` next to a notebook instance, SageMaker opens a new tab showing the Jupyter server home page from the notebook instance. The console uses this API to get the URL and show the page.
     *
     *  The IAM role or user used to call this API defines the permissions to access the notebook instance. Once the presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for this API are also enforced for every HTTP request and WebSocket frame that attempts to connect to the notebook instance.
     *
     * You can restrict access to this API and to the URL that it returns to a list of IP addresses that you specify. Use the `NotIpAddress` condition operator and the `aws:SourceIP` condition context key to specify the list of IP addresses that you want to have access to the notebook instance. For more information, see [Limit Access to a Notebook Instance by IP Address](https://docs.aws.amazon.com/sagemaker/latest/dg/security_iam_id-based-policy-examples.html#nbi-ip-filter).
     *
     * The URL that you get from a call to CreatePresignedNotebookInstanceUrl is valid only for 5 minutes. If you try to use the URL after the 5-minute limit expires, you are directed to the Amazon Web Services console sign-in page.
     */
    suspend fun createPresignedNotebookInstanceUrl(block: CreatePresignedNotebookInstanceUrlRequest.Builder.() -> Unit) = createPresignedNotebookInstanceUrl(CreatePresignedNotebookInstanceUrlRequest.Builder().apply(block).build())

    /**
     * Creates a processing job.
     */
    suspend fun createProcessingJob(input: CreateProcessingJobRequest): CreateProcessingJobResponse

    /**
     * Creates a processing job.
     */
    suspend fun createProcessingJob(block: CreateProcessingJobRequest.Builder.() -> Unit) = createProcessingJob(CreateProcessingJobRequest.Builder().apply(block).build())

    /**
     * Creates a machine learning (ML) project that can contain one or more templates that set up an ML pipeline from training to deploying an approved model.
     */
    suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse

    /**
     * Creates a machine learning (ML) project that can contain one or more templates that set up an ML pipeline from training to deploying an approved model.
     */
    suspend fun createProject(block: CreateProjectRequest.Builder.() -> Unit) = createProject(CreateProjectRequest.Builder().apply(block).build())

    /**
     * Creates a new Studio Lifecycle Configuration.
     */
    suspend fun createStudioLifecycleConfig(input: CreateStudioLifecycleConfigRequest): CreateStudioLifecycleConfigResponse

    /**
     * Creates a new Studio Lifecycle Configuration.
     */
    suspend fun createStudioLifecycleConfig(block: CreateStudioLifecycleConfigRequest.Builder.() -> Unit) = createStudioLifecycleConfig(CreateStudioLifecycleConfigRequest.Builder().apply(block).build())

    /**
     * Starts a model training job. After training completes, SageMaker saves the resulting model artifacts to an Amazon S3 location that you specify.
     *
     * If you choose to host your model using SageMaker hosting services, you can use the resulting model artifacts as part of the model. You can also use the artifacts in a machine learning service other than SageMaker, provided that you know how to use them for inference.
     *
     * In the request body, you provide the following:
     * + `AlgorithmSpecification` - Identifies the training algorithm to use.
     * + `HyperParameters` - Specify these algorithm-specific parameters to enable the estimation of model parameters during training. Hyperparameters can be tuned to optimize this learning process. For a list of hyperparameters for each training algorithm provided by SageMaker, see [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
     * + `InputDataConfig` - Describes the training dataset and the Amazon S3, EFS, or FSx location where it is stored.
     * + `OutputDataConfig` - Identifies the Amazon S3 bucket where you want SageMaker to save the results of model training.
     * + `ResourceConfig` - Identifies the resources, ML compute instances, and ML storage volumes to deploy for model training. In distributed training, you specify more than one instance.
     * + `EnableManagedSpotTraining` - Optimize the cost of training machine learning models by up to 80% by using Amazon EC2 Spot instances. For more information, see [Managed Spot Training](https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html).
     * + `RoleArn` - The Amazon Resource Name (ARN) that SageMaker assumes to perform tasks on your behalf during model training. You must grant this role the necessary permissions so that SageMaker can successfully complete model training.
     * + `StoppingCondition` - To help cap training costs, use `MaxRuntimeInSeconds` to set a time limit for training. Use `MaxWaitTimeInSeconds` to specify how long a managed spot training job has to complete.
     * + `Environment` - The environment variables to set in the Docker container.
     * + `RetryStrategy` - The number of times to retry the job when the job fails due to an `InternalServerError`.
     *
     *  For more information about SageMaker, see [How It Works](https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html).
     */
    suspend fun createTrainingJob(input: CreateTrainingJobRequest): CreateTrainingJobResponse

    /**
     * Starts a model training job. After training completes, SageMaker saves the resulting model artifacts to an Amazon S3 location that you specify.
     *
     * If you choose to host your model using SageMaker hosting services, you can use the resulting model artifacts as part of the model. You can also use the artifacts in a machine learning service other than SageMaker, provided that you know how to use them for inference.
     *
     * In the request body, you provide the following:
     * + `AlgorithmSpecification` - Identifies the training algorithm to use.
     * + `HyperParameters` - Specify these algorithm-specific parameters to enable the estimation of model parameters during training. Hyperparameters can be tuned to optimize this learning process. For a list of hyperparameters for each training algorithm provided by SageMaker, see [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
     * + `InputDataConfig` - Describes the training dataset and the Amazon S3, EFS, or FSx location where it is stored.
     * + `OutputDataConfig` - Identifies the Amazon S3 bucket where you want SageMaker to save the results of model training.
     * + `ResourceConfig` - Identifies the resources, ML compute instances, and ML storage volumes to deploy for model training. In distributed training, you specify more than one instance.
     * + `EnableManagedSpotTraining` - Optimize the cost of training machine learning models by up to 80% by using Amazon EC2 Spot instances. For more information, see [Managed Spot Training](https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html).
     * + `RoleArn` - The Amazon Resource Name (ARN) that SageMaker assumes to perform tasks on your behalf during model training. You must grant this role the necessary permissions so that SageMaker can successfully complete model training.
     * + `StoppingCondition` - To help cap training costs, use `MaxRuntimeInSeconds` to set a time limit for training. Use `MaxWaitTimeInSeconds` to specify how long a managed spot training job has to complete.
     * + `Environment` - The environment variables to set in the Docker container.
     * + `RetryStrategy` - The number of times to retry the job when the job fails due to an `InternalServerError`.
     *
     *  For more information about SageMaker, see [How It Works](https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html).
     */
    suspend fun createTrainingJob(block: CreateTrainingJobRequest.Builder.() -> Unit) = createTrainingJob(CreateTrainingJobRequest.Builder().apply(block).build())

    /**
     * Starts a transform job. A transform job uses a trained model to get inferences on a dataset and saves these results to an Amazon S3 location that you specify.
     *
     * To perform batch transformations, you create a transform job and use the data that you have readily available.
     *
     * In the request body, you provide the following:
     * + `TransformJobName` - Identifies the transform job. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account.
     * + `ModelName` - Identifies the model to use. `ModelName` must be the name of an existing Amazon SageMaker model in the same Amazon Web Services Region and Amazon Web Services account. For information on creating a model, see [CreateModel](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html).
     * + `TransformInput` - Describes the dataset to be transformed and the Amazon S3 location where it is stored.
     * + `TransformOutput` - Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.
     * + `TransformResources` - Identifies the ML compute instances for the transform job.
     *
     * For more information about how batch transformation works, see [Batch Transform](https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html).
     */
    suspend fun createTransformJob(input: CreateTransformJobRequest): CreateTransformJobResponse

    /**
     * Starts a transform job. A transform job uses a trained model to get inferences on a dataset and saves these results to an Amazon S3 location that you specify.
     *
     * To perform batch transformations, you create a transform job and use the data that you have readily available.
     *
     * In the request body, you provide the following:
     * + `TransformJobName` - Identifies the transform job. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account.
     * + `ModelName` - Identifies the model to use. `ModelName` must be the name of an existing Amazon SageMaker model in the same Amazon Web Services Region and Amazon Web Services account. For information on creating a model, see [CreateModel](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html).
     * + `TransformInput` - Describes the dataset to be transformed and the Amazon S3 location where it is stored.
     * + `TransformOutput` - Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.
     * + `TransformResources` - Identifies the ML compute instances for the transform job.
     *
     * For more information about how batch transformation works, see [Batch Transform](https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html).
     */
    suspend fun createTransformJob(block: CreateTransformJobRequest.Builder.() -> Unit) = createTransformJob(CreateTransformJobRequest.Builder().apply(block).build())

    /**
     * Creates an SageMaker *trial*. A trial is a set of steps called *trial components* that produce a machine learning model. A trial is part of a single SageMaker *experiment*.
     *
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must use the logging APIs provided by the SDK.
     *
     * You can add tags to a trial and then use the Search API to search for the tags.
     *
     * To get a list of all your trials, call the ListTrials API. To view a trial's properties, call the DescribeTrial API. To create a trial component, call the CreateTrialComponent API.
     */
    suspend fun createTrial(input: CreateTrialRequest): CreateTrialResponse

    /**
     * Creates an SageMaker *trial*. A trial is a set of steps called *trial components* that produce a machine learning model. A trial is part of a single SageMaker *experiment*.
     *
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must use the logging APIs provided by the SDK.
     *
     * You can add tags to a trial and then use the Search API to search for the tags.
     *
     * To get a list of all your trials, call the ListTrials API. To view a trial's properties, call the DescribeTrial API. To create a trial component, call the CreateTrialComponent API.
     */
    suspend fun createTrial(block: CreateTrialRequest.Builder.() -> Unit) = createTrial(CreateTrialRequest.Builder().apply(block).build())

    /**
     * Creates a *trial component*, which is a stage of a machine learning *trial*. A trial is composed of one or more trial components. A trial component can be used in multiple trials.
     *
     * Trial components include pre-processing jobs, training jobs, and batch transform jobs.
     *
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must use the logging APIs provided by the SDK.
     *
     * You can add tags to a trial component and then use the Search API to search for the tags.
     */
    suspend fun createTrialComponent(input: CreateTrialComponentRequest): CreateTrialComponentResponse

    /**
     * Creates a *trial component*, which is a stage of a machine learning *trial*. A trial is composed of one or more trial components. A trial component can be used in multiple trials.
     *
     * Trial components include pre-processing jobs, training jobs, and batch transform jobs.
     *
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must use the logging APIs provided by the SDK.
     *
     * You can add tags to a trial component and then use the Search API to search for the tags.
     */
    suspend fun createTrialComponent(block: CreateTrialComponentRequest.Builder.() -> Unit) = createTrialComponent(CreateTrialComponentRequest.Builder().apply(block).build())

    /**
     * Creates a user profile. A user profile represents a single user within a domain, and is the main way to reference a "person" for the purposes of sharing, reporting, and other user-oriented features. This entity is created when a user onboards to Amazon SageMaker Studio. If an administrator invites a person by email or imports them from SSO, a user profile is automatically created. A user profile is the primary holder of settings for an individual user and has a reference to the user's private Amazon Elastic File System (EFS) home directory.
     */
    suspend fun createUserProfile(input: CreateUserProfileRequest): CreateUserProfileResponse

    /**
     * Creates a user profile. A user profile represents a single user within a domain, and is the main way to reference a "person" for the purposes of sharing, reporting, and other user-oriented features. This entity is created when a user onboards to Amazon SageMaker Studio. If an administrator invites a person by email or imports them from SSO, a user profile is automatically created. A user profile is the primary holder of settings for an individual user and has a reference to the user's private Amazon Elastic File System (EFS) home directory.
     */
    suspend fun createUserProfile(block: CreateUserProfileRequest.Builder.() -> Unit) = createUserProfile(CreateUserProfileRequest.Builder().apply(block).build())

    /**
     * Use this operation to create a workforce. This operation will return an error if a workforce already exists in the Amazon Web Services Region that you specify. You can only create one workforce in each Amazon Web Services Region per Amazon Web Services account.
     *
     * If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use the API operation to delete the existing workforce and then use `CreateWorkforce` to create a new workforce.
     *
     * To create a private workforce using Amazon Cognito, you must specify a Cognito user pool in `CognitoConfig`. You can also create an Amazon Cognito workforce using the Amazon SageMaker console. For more information, see [ Create a Private Workforce (Amazon Cognito)](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html).
     *
     * To create a private workforce using your own OIDC Identity Provider (IdP), specify your IdP configuration in `OidcConfig`. Your OIDC IdP must support *groups* because groups are used by Ground Truth and Amazon A2I to create work teams. For more information, see [ Create a Private Workforce (OIDC IdP)](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private-oidc.html).
     */
    suspend fun createWorkforce(input: CreateWorkforceRequest): CreateWorkforceResponse

    /**
     * Use this operation to create a workforce. This operation will return an error if a workforce already exists in the Amazon Web Services Region that you specify. You can only create one workforce in each Amazon Web Services Region per Amazon Web Services account.
     *
     * If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use the API operation to delete the existing workforce and then use `CreateWorkforce` to create a new workforce.
     *
     * To create a private workforce using Amazon Cognito, you must specify a Cognito user pool in `CognitoConfig`. You can also create an Amazon Cognito workforce using the Amazon SageMaker console. For more information, see [ Create a Private Workforce (Amazon Cognito)](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html).
     *
     * To create a private workforce using your own OIDC Identity Provider (IdP), specify your IdP configuration in `OidcConfig`. Your OIDC IdP must support *groups* because groups are used by Ground Truth and Amazon A2I to create work teams. For more information, see [ Create a Private Workforce (OIDC IdP)](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private-oidc.html).
     */
    suspend fun createWorkforce(block: CreateWorkforceRequest.Builder.() -> Unit) = createWorkforce(CreateWorkforceRequest.Builder().apply(block).build())

    /**
     * Creates a new work team for labeling your data. A work team is defined by one or more Amazon Cognito user pools. You must first create the user pools before you can create a work team.
     *
     * You cannot create more than 25 work teams in an account and region.
     */
    suspend fun createWorkteam(input: CreateWorkteamRequest): CreateWorkteamResponse

    /**
     * Creates a new work team for labeling your data. A work team is defined by one or more Amazon Cognito user pools. You must first create the user pools before you can create a work team.
     *
     * You cannot create more than 25 work teams in an account and region.
     */
    suspend fun createWorkteam(block: CreateWorkteamRequest.Builder.() -> Unit) = createWorkteam(CreateWorkteamRequest.Builder().apply(block).build())

    /**
     * Deletes an action.
     */
    suspend fun deleteAction(input: DeleteActionRequest): DeleteActionResponse

    /**
     * Deletes an action.
     */
    suspend fun deleteAction(block: DeleteActionRequest.Builder.() -> Unit) = deleteAction(DeleteActionRequest.Builder().apply(block).build())

    /**
     * Removes the specified algorithm from your account.
     */
    suspend fun deleteAlgorithm(input: DeleteAlgorithmRequest): DeleteAlgorithmResponse

    /**
     * Removes the specified algorithm from your account.
     */
    suspend fun deleteAlgorithm(block: DeleteAlgorithmRequest.Builder.() -> Unit) = deleteAlgorithm(DeleteAlgorithmRequest.Builder().apply(block).build())

    /**
     * Used to stop and delete an app.
     */
    suspend fun deleteApp(input: DeleteAppRequest): DeleteAppResponse

    /**
     * Used to stop and delete an app.
     */
    suspend fun deleteApp(block: DeleteAppRequest.Builder.() -> Unit) = deleteApp(DeleteAppRequest.Builder().apply(block).build())

    /**
     * Deletes an AppImageConfig.
     */
    suspend fun deleteAppImageConfig(input: DeleteAppImageConfigRequest): DeleteAppImageConfigResponse

    /**
     * Deletes an AppImageConfig.
     */
    suspend fun deleteAppImageConfig(block: DeleteAppImageConfigRequest.Builder.() -> Unit) = deleteAppImageConfig(DeleteAppImageConfigRequest.Builder().apply(block).build())

    /**
     * Deletes an artifact. Either `ArtifactArn` or `Source` must be specified.
     */
    suspend fun deleteArtifact(input: DeleteArtifactRequest = DeleteArtifactRequest {}): DeleteArtifactResponse

    /**
     * Deletes an artifact. Either `ArtifactArn` or `Source` must be specified.
     */
    suspend fun deleteArtifact(block: DeleteArtifactRequest.Builder.() -> Unit) = deleteArtifact(DeleteArtifactRequest.Builder().apply(block).build())

    /**
     * Deletes an association.
     */
    suspend fun deleteAssociation(input: DeleteAssociationRequest): DeleteAssociationResponse

    /**
     * Deletes an association.
     */
    suspend fun deleteAssociation(block: DeleteAssociationRequest.Builder.() -> Unit) = deleteAssociation(DeleteAssociationRequest.Builder().apply(block).build())

    /**
     * Deletes the specified Git repository from your account.
     */
    suspend fun deleteCodeRepository(input: DeleteCodeRepositoryRequest): DeleteCodeRepositoryResponse

    /**
     * Deletes the specified Git repository from your account.
     */
    suspend fun deleteCodeRepository(block: DeleteCodeRepositoryRequest.Builder.() -> Unit) = deleteCodeRepository(DeleteCodeRepositoryRequest.Builder().apply(block).build())

    /**
     * Deletes an context.
     */
    suspend fun deleteContext(input: DeleteContextRequest): DeleteContextResponse

    /**
     * Deletes an context.
     */
    suspend fun deleteContext(block: DeleteContextRequest.Builder.() -> Unit) = deleteContext(DeleteContextRequest.Builder().apply(block).build())

    /**
     * Deletes a data quality monitoring job definition.
     */
    suspend fun deleteDataQualityJobDefinition(input: DeleteDataQualityJobDefinitionRequest): DeleteDataQualityJobDefinitionResponse

    /**
     * Deletes a data quality monitoring job definition.
     */
    suspend fun deleteDataQualityJobDefinition(block: DeleteDataQualityJobDefinitionRequest.Builder.() -> Unit) = deleteDataQualityJobDefinition(DeleteDataQualityJobDefinitionRequest.Builder().apply(block).build())

    /**
     * Deletes a fleet.
     */
    suspend fun deleteDeviceFleet(input: DeleteDeviceFleetRequest): DeleteDeviceFleetResponse

    /**
     * Deletes a fleet.
     */
    suspend fun deleteDeviceFleet(block: DeleteDeviceFleetRequest.Builder.() -> Unit) = deleteDeviceFleet(DeleteDeviceFleetRequest.Builder().apply(block).build())

    /**
     * Used to delete a domain. If you onboarded with IAM mode, you will need to delete your domain to onboard again using SSO. Use with caution. All of the members of the domain will lose access to their EFS volume, including data, notebooks, and other artifacts.
     */
    suspend fun deleteDomain(input: DeleteDomainRequest): DeleteDomainResponse

    /**
     * Used to delete a domain. If you onboarded with IAM mode, you will need to delete your domain to onboard again using SSO. Use with caution. All of the members of the domain will lose access to their EFS volume, including data, notebooks, and other artifacts.
     */
    suspend fun deleteDomain(block: DeleteDomainRequest.Builder.() -> Unit) = deleteDomain(DeleteDomainRequest.Builder().apply(block).build())

    /**
     * Deletes an endpoint. SageMaker frees up all of the resources that were deployed when the endpoint was created.
     *
     * SageMaker retires any custom KMS key grants associated with the endpoint, meaning you don't need to use the [RevokeGrant](http://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html) API call.
     *
     * When you delete your endpoint, SageMaker asynchronously deletes associated endpoint resources such as KMS key grants. You might still see these resources in your account for a few minutes after deleting your endpoint. Do not delete or revoke the permissions for your ` <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html#sagemaker-CreateModel-request-ExecutionRoleArn">ExecutionRoleArn</a> `, otherwise SageMaker cannot delete these resources.
     */
    suspend fun deleteEndpoint(input: DeleteEndpointRequest): DeleteEndpointResponse

    /**
     * Deletes an endpoint. SageMaker frees up all of the resources that were deployed when the endpoint was created.
     *
     * SageMaker retires any custom KMS key grants associated with the endpoint, meaning you don't need to use the [RevokeGrant](http://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html) API call.
     *
     * When you delete your endpoint, SageMaker asynchronously deletes associated endpoint resources such as KMS key grants. You might still see these resources in your account for a few minutes after deleting your endpoint. Do not delete or revoke the permissions for your ` <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html#sagemaker-CreateModel-request-ExecutionRoleArn">ExecutionRoleArn</a> `, otherwise SageMaker cannot delete these resources.
     */
    suspend fun deleteEndpoint(block: DeleteEndpointRequest.Builder.() -> Unit) = deleteEndpoint(DeleteEndpointRequest.Builder().apply(block).build())

    /**
     * Deletes an endpoint configuration. The `DeleteEndpointConfig` API deletes only the specified configuration. It does not delete endpoints created using the configuration.
     *
     * You must not delete an `EndpointConfig` in use by an endpoint that is live or while the `UpdateEndpoint` or `CreateEndpoint` operations are being performed on the endpoint. If you delete the `EndpointConfig` of an endpoint that is active or being created or updated you may lose visibility into the instance type the endpoint is using. The endpoint must be deleted in order to stop incurring charges.
     */
    suspend fun deleteEndpointConfig(input: DeleteEndpointConfigRequest): DeleteEndpointConfigResponse

    /**
     * Deletes an endpoint configuration. The `DeleteEndpointConfig` API deletes only the specified configuration. It does not delete endpoints created using the configuration.
     *
     * You must not delete an `EndpointConfig` in use by an endpoint that is live or while the `UpdateEndpoint` or `CreateEndpoint` operations are being performed on the endpoint. If you delete the `EndpointConfig` of an endpoint that is active or being created or updated you may lose visibility into the instance type the endpoint is using. The endpoint must be deleted in order to stop incurring charges.
     */
    suspend fun deleteEndpointConfig(block: DeleteEndpointConfigRequest.Builder.() -> Unit) = deleteEndpointConfig(DeleteEndpointConfigRequest.Builder().apply(block).build())

    /**
     * Deletes an SageMaker experiment. All trials associated with the experiment must be deleted first. Use the ListTrials API to get a list of the trials associated with the experiment.
     */
    suspend fun deleteExperiment(input: DeleteExperimentRequest): DeleteExperimentResponse

    /**
     * Deletes an SageMaker experiment. All trials associated with the experiment must be deleted first. Use the ListTrials API to get a list of the trials associated with the experiment.
     */
    suspend fun deleteExperiment(block: DeleteExperimentRequest.Builder.() -> Unit) = deleteExperiment(DeleteExperimentRequest.Builder().apply(block).build())

    /**
     * Delete the `FeatureGroup` and any data that was written to the `OnlineStore` of the `FeatureGroup`. Data cannot be accessed from the `OnlineStore` immediately after `DeleteFeatureGroup` is called.
     *
     * Data written into the `OfflineStore` will not be deleted. The Amazon Web Services Glue database and tables that are automatically created for your `OfflineStore` are not deleted.
     */
    suspend fun deleteFeatureGroup(input: DeleteFeatureGroupRequest): DeleteFeatureGroupResponse

    /**
     * Delete the `FeatureGroup` and any data that was written to the `OnlineStore` of the `FeatureGroup`. Data cannot be accessed from the `OnlineStore` immediately after `DeleteFeatureGroup` is called.
     *
     * Data written into the `OfflineStore` will not be deleted. The Amazon Web Services Glue database and tables that are automatically created for your `OfflineStore` are not deleted.
     */
    suspend fun deleteFeatureGroup(block: DeleteFeatureGroupRequest.Builder.() -> Unit) = deleteFeatureGroup(DeleteFeatureGroupRequest.Builder().apply(block).build())

    /**
     * Deletes the specified flow definition.
     */
    suspend fun deleteFlowDefinition(input: DeleteFlowDefinitionRequest): DeleteFlowDefinitionResponse

    /**
     * Deletes the specified flow definition.
     */
    suspend fun deleteFlowDefinition(block: DeleteFlowDefinitionRequest.Builder.() -> Unit) = deleteFlowDefinition(DeleteFlowDefinitionRequest.Builder().apply(block).build())

    /**
     * Use this operation to delete a human task user interface (worker task template).
     *
     *  To see a list of human task user interfaces (work task templates) in your account, use . When you delete a worker task template, it no longer appears when you call `ListHumanTaskUis`.
     */
    suspend fun deleteHumanTaskUi(input: DeleteHumanTaskUiRequest): DeleteHumanTaskUiResponse

    /**
     * Use this operation to delete a human task user interface (worker task template).
     *
     *  To see a list of human task user interfaces (work task templates) in your account, use . When you delete a worker task template, it no longer appears when you call `ListHumanTaskUis`.
     */
    suspend fun deleteHumanTaskUi(block: DeleteHumanTaskUiRequest.Builder.() -> Unit) = deleteHumanTaskUi(DeleteHumanTaskUiRequest.Builder().apply(block).build())

    /**
     * Deletes a SageMaker image and all versions of the image. The container images aren't deleted.
     */
    suspend fun deleteImage(input: DeleteImageRequest): DeleteImageResponse

    /**
     * Deletes a SageMaker image and all versions of the image. The container images aren't deleted.
     */
    suspend fun deleteImage(block: DeleteImageRequest.Builder.() -> Unit) = deleteImage(DeleteImageRequest.Builder().apply(block).build())

    /**
     * Deletes a version of a SageMaker image. The container image the version represents isn't deleted.
     */
    suspend fun deleteImageVersion(input: DeleteImageVersionRequest): DeleteImageVersionResponse

    /**
     * Deletes a version of a SageMaker image. The container image the version represents isn't deleted.
     */
    suspend fun deleteImageVersion(block: DeleteImageVersionRequest.Builder.() -> Unit) = deleteImageVersion(DeleteImageVersionRequest.Builder().apply(block).build())

    /**
     * Deletes a model. The `DeleteModel` API deletes only the model entry that was created in SageMaker when you called the `CreateModel` API. It does not delete model artifacts, inference code, or the IAM role that you specified when creating the model.
     */
    suspend fun deleteModel(input: DeleteModelRequest): DeleteModelResponse

    /**
     * Deletes a model. The `DeleteModel` API deletes only the model entry that was created in SageMaker when you called the `CreateModel` API. It does not delete model artifacts, inference code, or the IAM role that you specified when creating the model.
     */
    suspend fun deleteModel(block: DeleteModelRequest.Builder.() -> Unit) = deleteModel(DeleteModelRequest.Builder().apply(block).build())

    /**
     * Deletes an Amazon SageMaker model bias job definition.
     */
    suspend fun deleteModelBiasJobDefinition(input: DeleteModelBiasJobDefinitionRequest): DeleteModelBiasJobDefinitionResponse

    /**
     * Deletes an Amazon SageMaker model bias job definition.
     */
    suspend fun deleteModelBiasJobDefinition(block: DeleteModelBiasJobDefinitionRequest.Builder.() -> Unit) = deleteModelBiasJobDefinition(DeleteModelBiasJobDefinitionRequest.Builder().apply(block).build())

    /**
     * Deletes an Amazon SageMaker model explainability job definition.
     */
    suspend fun deleteModelExplainabilityJobDefinition(input: DeleteModelExplainabilityJobDefinitionRequest): DeleteModelExplainabilityJobDefinitionResponse

    /**
     * Deletes an Amazon SageMaker model explainability job definition.
     */
    suspend fun deleteModelExplainabilityJobDefinition(block: DeleteModelExplainabilityJobDefinitionRequest.Builder.() -> Unit) = deleteModelExplainabilityJobDefinition(DeleteModelExplainabilityJobDefinitionRequest.Builder().apply(block).build())

    /**
     * Deletes a model package.
     *
     * A model package is used to create SageMaker models or list on Amazon Web Services Marketplace. Buyers can subscribe to model packages listed on Amazon Web Services Marketplace to create models in SageMaker.
     */
    suspend fun deleteModelPackage(input: DeleteModelPackageRequest): DeleteModelPackageResponse

    /**
     * Deletes a model package.
     *
     * A model package is used to create SageMaker models or list on Amazon Web Services Marketplace. Buyers can subscribe to model packages listed on Amazon Web Services Marketplace to create models in SageMaker.
     */
    suspend fun deleteModelPackage(block: DeleteModelPackageRequest.Builder.() -> Unit) = deleteModelPackage(DeleteModelPackageRequest.Builder().apply(block).build())

    /**
     * Deletes the specified model group.
     */
    suspend fun deleteModelPackageGroup(input: DeleteModelPackageGroupRequest): DeleteModelPackageGroupResponse

    /**
     * Deletes the specified model group.
     */
    suspend fun deleteModelPackageGroup(block: DeleteModelPackageGroupRequest.Builder.() -> Unit) = deleteModelPackageGroup(DeleteModelPackageGroupRequest.Builder().apply(block).build())

    /**
     * Deletes a model group resource policy.
     */
    suspend fun deleteModelPackageGroupPolicy(input: DeleteModelPackageGroupPolicyRequest): DeleteModelPackageGroupPolicyResponse

    /**
     * Deletes a model group resource policy.
     */
    suspend fun deleteModelPackageGroupPolicy(block: DeleteModelPackageGroupPolicyRequest.Builder.() -> Unit) = deleteModelPackageGroupPolicy(DeleteModelPackageGroupPolicyRequest.Builder().apply(block).build())

    /**
     * Deletes the secified model quality monitoring job definition.
     */
    suspend fun deleteModelQualityJobDefinition(input: DeleteModelQualityJobDefinitionRequest): DeleteModelQualityJobDefinitionResponse

    /**
     * Deletes the secified model quality monitoring job definition.
     */
    suspend fun deleteModelQualityJobDefinition(block: DeleteModelQualityJobDefinitionRequest.Builder.() -> Unit) = deleteModelQualityJobDefinition(DeleteModelQualityJobDefinitionRequest.Builder().apply(block).build())

    /**
     * Deletes a monitoring schedule. Also stops the schedule had not already been stopped. This does not delete the job execution history of the monitoring schedule.
     */
    suspend fun deleteMonitoringSchedule(input: DeleteMonitoringScheduleRequest): DeleteMonitoringScheduleResponse

    /**
     * Deletes a monitoring schedule. Also stops the schedule had not already been stopped. This does not delete the job execution history of the monitoring schedule.
     */
    suspend fun deleteMonitoringSchedule(block: DeleteMonitoringScheduleRequest.Builder.() -> Unit) = deleteMonitoringSchedule(DeleteMonitoringScheduleRequest.Builder().apply(block).build())

    /**
     * Deletes an SageMaker notebook instance. Before you can delete a notebook instance, you must call the `StopNotebookInstance` API.
     *
     * When you delete a notebook instance, you lose all of your data. SageMaker removes the ML compute instance, and deletes the ML storage volume and the network interface associated with the notebook instance.
     */
    suspend fun deleteNotebookInstance(input: DeleteNotebookInstanceRequest): DeleteNotebookInstanceResponse

    /**
     * Deletes an SageMaker notebook instance. Before you can delete a notebook instance, you must call the `StopNotebookInstance` API.
     *
     * When you delete a notebook instance, you lose all of your data. SageMaker removes the ML compute instance, and deletes the ML storage volume and the network interface associated with the notebook instance.
     */
    suspend fun deleteNotebookInstance(block: DeleteNotebookInstanceRequest.Builder.() -> Unit) = deleteNotebookInstance(DeleteNotebookInstanceRequest.Builder().apply(block).build())

    /**
     * Deletes a notebook instance lifecycle configuration.
     */
    suspend fun deleteNotebookInstanceLifecycleConfig(input: DeleteNotebookInstanceLifecycleConfigRequest): DeleteNotebookInstanceLifecycleConfigResponse

    /**
     * Deletes a notebook instance lifecycle configuration.
     */
    suspend fun deleteNotebookInstanceLifecycleConfig(block: DeleteNotebookInstanceLifecycleConfigRequest.Builder.() -> Unit) = deleteNotebookInstanceLifecycleConfig(DeleteNotebookInstanceLifecycleConfigRequest.Builder().apply(block).build())

    /**
     * Deletes a pipeline if there are no running instances of the pipeline. To delete a pipeline, you must stop all running instances of the pipeline using the `StopPipelineExecution` API. When you delete a pipeline, all instances of the pipeline are deleted.
     */
    suspend fun deletePipeline(input: DeletePipelineRequest): DeletePipelineResponse

    /**
     * Deletes a pipeline if there are no running instances of the pipeline. To delete a pipeline, you must stop all running instances of the pipeline using the `StopPipelineExecution` API. When you delete a pipeline, all instances of the pipeline are deleted.
     */
    suspend fun deletePipeline(block: DeletePipelineRequest.Builder.() -> Unit) = deletePipeline(DeletePipelineRequest.Builder().apply(block).build())

    /**
     * Delete the specified project.
     */
    suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse

    /**
     * Delete the specified project.
     */
    suspend fun deleteProject(block: DeleteProjectRequest.Builder.() -> Unit) = deleteProject(DeleteProjectRequest.Builder().apply(block).build())

    /**
     * Deletes the Studio Lifecycle Configuration. In order to delete the Lifecycle Configuration, there must be no running apps using the Lifecycle Configuration. You must also remove the Lifecycle Configuration from UserSettings in all Domains and UserProfiles.
     */
    suspend fun deleteStudioLifecycleConfig(input: DeleteStudioLifecycleConfigRequest): DeleteStudioLifecycleConfigResponse

    /**
     * Deletes the Studio Lifecycle Configuration. In order to delete the Lifecycle Configuration, there must be no running apps using the Lifecycle Configuration. You must also remove the Lifecycle Configuration from UserSettings in all Domains and UserProfiles.
     */
    suspend fun deleteStudioLifecycleConfig(block: DeleteStudioLifecycleConfigRequest.Builder.() -> Unit) = deleteStudioLifecycleConfig(DeleteStudioLifecycleConfigRequest.Builder().apply(block).build())

    /**
     * Deletes the specified tags from an SageMaker resource.
     *
     * To list a resource's tags, use the `ListTags` API.
     *
     * When you call this API to delete tags from a hyperparameter tuning job, the deleted tags are not removed from training jobs that the hyperparameter tuning job launched before you called this API.
     *
     * When you call this API to delete tags from a SageMaker Studio Domain or User Profile, the deleted tags are not removed from Apps that the SageMaker Studio Domain or User Profile launched before you called this API.
     */
    suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse

    /**
     * Deletes the specified tags from an SageMaker resource.
     *
     * To list a resource's tags, use the `ListTags` API.
     *
     * When you call this API to delete tags from a hyperparameter tuning job, the deleted tags are not removed from training jobs that the hyperparameter tuning job launched before you called this API.
     *
     * When you call this API to delete tags from a SageMaker Studio Domain or User Profile, the deleted tags are not removed from Apps that the SageMaker Studio Domain or User Profile launched before you called this API.
     */
    suspend fun deleteTags(block: DeleteTagsRequest.Builder.() -> Unit) = deleteTags(DeleteTagsRequest.Builder().apply(block).build())

    /**
     * Deletes the specified trial. All trial components that make up the trial must be deleted first. Use the DescribeTrialComponent API to get the list of trial components.
     */
    suspend fun deleteTrial(input: DeleteTrialRequest): DeleteTrialResponse

    /**
     * Deletes the specified trial. All trial components that make up the trial must be deleted first. Use the DescribeTrialComponent API to get the list of trial components.
     */
    suspend fun deleteTrial(block: DeleteTrialRequest.Builder.() -> Unit) = deleteTrial(DeleteTrialRequest.Builder().apply(block).build())

    /**
     * Deletes the specified trial component. A trial component must be disassociated from all trials before the trial component can be deleted. To disassociate a trial component from a trial, call the DisassociateTrialComponent API.
     */
    suspend fun deleteTrialComponent(input: DeleteTrialComponentRequest): DeleteTrialComponentResponse

    /**
     * Deletes the specified trial component. A trial component must be disassociated from all trials before the trial component can be deleted. To disassociate a trial component from a trial, call the DisassociateTrialComponent API.
     */
    suspend fun deleteTrialComponent(block: DeleteTrialComponentRequest.Builder.() -> Unit) = deleteTrialComponent(DeleteTrialComponentRequest.Builder().apply(block).build())

    /**
     * Deletes a user profile. When a user profile is deleted, the user loses access to their EFS volume, including data, notebooks, and other artifacts.
     */
    suspend fun deleteUserProfile(input: DeleteUserProfileRequest): DeleteUserProfileResponse

    /**
     * Deletes a user profile. When a user profile is deleted, the user loses access to their EFS volume, including data, notebooks, and other artifacts.
     */
    suspend fun deleteUserProfile(block: DeleteUserProfileRequest.Builder.() -> Unit) = deleteUserProfile(DeleteUserProfileRequest.Builder().apply(block).build())

    /**
     * Use this operation to delete a workforce.
     *
     * If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use this operation to delete the existing workforce and then use to create a new workforce.
     *
     * If a private workforce contains one or more work teams, you must use the operation to delete all work teams before you delete the workforce. If you try to delete a workforce that contains one or more work teams, you will recieve a `ResourceInUse` error.
     */
    suspend fun deleteWorkforce(input: DeleteWorkforceRequest): DeleteWorkforceResponse

    /**
     * Use this operation to delete a workforce.
     *
     * If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use this operation to delete the existing workforce and then use to create a new workforce.
     *
     * If a private workforce contains one or more work teams, you must use the operation to delete all work teams before you delete the workforce. If you try to delete a workforce that contains one or more work teams, you will recieve a `ResourceInUse` error.
     */
    suspend fun deleteWorkforce(block: DeleteWorkforceRequest.Builder.() -> Unit) = deleteWorkforce(DeleteWorkforceRequest.Builder().apply(block).build())

    /**
     * Deletes an existing work team. This operation can't be undone.
     */
    suspend fun deleteWorkteam(input: DeleteWorkteamRequest): DeleteWorkteamResponse

    /**
     * Deletes an existing work team. This operation can't be undone.
     */
    suspend fun deleteWorkteam(block: DeleteWorkteamRequest.Builder.() -> Unit) = deleteWorkteam(DeleteWorkteamRequest.Builder().apply(block).build())

    /**
     * Deregisters the specified devices. After you deregister a device, you will need to re-register the devices.
     */
    suspend fun deregisterDevices(input: DeregisterDevicesRequest): DeregisterDevicesResponse

    /**
     * Deregisters the specified devices. After you deregister a device, you will need to re-register the devices.
     */
    suspend fun deregisterDevices(block: DeregisterDevicesRequest.Builder.() -> Unit) = deregisterDevices(DeregisterDevicesRequest.Builder().apply(block).build())

    /**
     * Describes an action.
     */
    suspend fun describeAction(input: DescribeActionRequest): DescribeActionResponse

    /**
     * Describes an action.
     */
    suspend fun describeAction(block: DescribeActionRequest.Builder.() -> Unit) = describeAction(DescribeActionRequest.Builder().apply(block).build())

    /**
     * Returns a description of the specified algorithm that is in your account.
     */
    suspend fun describeAlgorithm(input: DescribeAlgorithmRequest): DescribeAlgorithmResponse

    /**
     * Returns a description of the specified algorithm that is in your account.
     */
    suspend fun describeAlgorithm(block: DescribeAlgorithmRequest.Builder.() -> Unit) = describeAlgorithm(DescribeAlgorithmRequest.Builder().apply(block).build())

    /**
     * Describes the app.
     */
    suspend fun describeApp(input: DescribeAppRequest): DescribeAppResponse

    /**
     * Describes the app.
     */
    suspend fun describeApp(block: DescribeAppRequest.Builder.() -> Unit) = describeApp(DescribeAppRequest.Builder().apply(block).build())

    /**
     * Describes an AppImageConfig.
     */
    suspend fun describeAppImageConfig(input: DescribeAppImageConfigRequest): DescribeAppImageConfigResponse

    /**
     * Describes an AppImageConfig.
     */
    suspend fun describeAppImageConfig(block: DescribeAppImageConfigRequest.Builder.() -> Unit) = describeAppImageConfig(DescribeAppImageConfigRequest.Builder().apply(block).build())

    /**
     * Describes an artifact.
     */
    suspend fun describeArtifact(input: DescribeArtifactRequest): DescribeArtifactResponse

    /**
     * Describes an artifact.
     */
    suspend fun describeArtifact(block: DescribeArtifactRequest.Builder.() -> Unit) = describeArtifact(DescribeArtifactRequest.Builder().apply(block).build())

    /**
     * Returns information about an Amazon SageMaker AutoML job.
     */
    suspend fun describeAutoMlJob(input: DescribeAutoMlJobRequest): DescribeAutoMlJobResponse

    /**
     * Returns information about an Amazon SageMaker AutoML job.
     */
    suspend fun describeAutoMlJob(block: DescribeAutoMlJobRequest.Builder.() -> Unit) = describeAutoMlJob(DescribeAutoMlJobRequest.Builder().apply(block).build())

    /**
     * Gets details about the specified Git repository.
     */
    suspend fun describeCodeRepository(input: DescribeCodeRepositoryRequest): DescribeCodeRepositoryResponse

    /**
     * Gets details about the specified Git repository.
     */
    suspend fun describeCodeRepository(block: DescribeCodeRepositoryRequest.Builder.() -> Unit) = describeCodeRepository(DescribeCodeRepositoryRequest.Builder().apply(block).build())

    /**
     * Returns information about a model compilation job.
     *
     * To create a model compilation job, use CreateCompilationJob. To get information about multiple model compilation jobs, use ListCompilationJobs.
     */
    suspend fun describeCompilationJob(input: DescribeCompilationJobRequest): DescribeCompilationJobResponse

    /**
     * Returns information about a model compilation job.
     *
     * To create a model compilation job, use CreateCompilationJob. To get information about multiple model compilation jobs, use ListCompilationJobs.
     */
    suspend fun describeCompilationJob(block: DescribeCompilationJobRequest.Builder.() -> Unit) = describeCompilationJob(DescribeCompilationJobRequest.Builder().apply(block).build())

    /**
     * Describes a context.
     */
    suspend fun describeContext(input: DescribeContextRequest): DescribeContextResponse

    /**
     * Describes a context.
     */
    suspend fun describeContext(block: DescribeContextRequest.Builder.() -> Unit) = describeContext(DescribeContextRequest.Builder().apply(block).build())

    /**
     * Gets the details of a data quality monitoring job definition.
     */
    suspend fun describeDataQualityJobDefinition(input: DescribeDataQualityJobDefinitionRequest): DescribeDataQualityJobDefinitionResponse

    /**
     * Gets the details of a data quality monitoring job definition.
     */
    suspend fun describeDataQualityJobDefinition(block: DescribeDataQualityJobDefinitionRequest.Builder.() -> Unit) = describeDataQualityJobDefinition(DescribeDataQualityJobDefinitionRequest.Builder().apply(block).build())

    /**
     * Describes the device.
     */
    suspend fun describeDevice(input: DescribeDeviceRequest): DescribeDeviceResponse

    /**
     * Describes the device.
     */
    suspend fun describeDevice(block: DescribeDeviceRequest.Builder.() -> Unit) = describeDevice(DescribeDeviceRequest.Builder().apply(block).build())

    /**
     * A description of the fleet the device belongs to.
     */
    suspend fun describeDeviceFleet(input: DescribeDeviceFleetRequest): DescribeDeviceFleetResponse

    /**
     * A description of the fleet the device belongs to.
     */
    suspend fun describeDeviceFleet(block: DescribeDeviceFleetRequest.Builder.() -> Unit) = describeDeviceFleet(DescribeDeviceFleetRequest.Builder().apply(block).build())

    /**
     * The description of the domain.
     */
    suspend fun describeDomain(input: DescribeDomainRequest): DescribeDomainResponse

    /**
     * The description of the domain.
     */
    suspend fun describeDomain(block: DescribeDomainRequest.Builder.() -> Unit) = describeDomain(DescribeDomainRequest.Builder().apply(block).build())

    /**
     * A description of edge packaging jobs.
     */
    suspend fun describeEdgePackagingJob(input: DescribeEdgePackagingJobRequest): DescribeEdgePackagingJobResponse

    /**
     * A description of edge packaging jobs.
     */
    suspend fun describeEdgePackagingJob(block: DescribeEdgePackagingJobRequest.Builder.() -> Unit) = describeEdgePackagingJob(DescribeEdgePackagingJobRequest.Builder().apply(block).build())

    /**
     * Returns the description of an endpoint.
     */
    suspend fun describeEndpoint(input: DescribeEndpointRequest): DescribeEndpointResponse

    /**
     * Returns the description of an endpoint.
     */
    suspend fun describeEndpoint(block: DescribeEndpointRequest.Builder.() -> Unit) = describeEndpoint(DescribeEndpointRequest.Builder().apply(block).build())

    /**
     * Returns the description of an endpoint configuration created using the `CreateEndpointConfig` API.
     */
    suspend fun describeEndpointConfig(input: DescribeEndpointConfigRequest): DescribeEndpointConfigResponse

    /**
     * Returns the description of an endpoint configuration created using the `CreateEndpointConfig` API.
     */
    suspend fun describeEndpointConfig(block: DescribeEndpointConfigRequest.Builder.() -> Unit) = describeEndpointConfig(DescribeEndpointConfigRequest.Builder().apply(block).build())

    /**
     * Provides a list of an experiment's properties.
     */
    suspend fun describeExperiment(input: DescribeExperimentRequest): DescribeExperimentResponse

    /**
     * Provides a list of an experiment's properties.
     */
    suspend fun describeExperiment(block: DescribeExperimentRequest.Builder.() -> Unit) = describeExperiment(DescribeExperimentRequest.Builder().apply(block).build())

    /**
     * Use this operation to describe a `FeatureGroup`. The response includes information on the creation time, `FeatureGroup` name, the unique identifier for each `FeatureGroup`, and more.
     */
    suspend fun describeFeatureGroup(input: DescribeFeatureGroupRequest): DescribeFeatureGroupResponse

    /**
     * Use this operation to describe a `FeatureGroup`. The response includes information on the creation time, `FeatureGroup` name, the unique identifier for each `FeatureGroup`, and more.
     */
    suspend fun describeFeatureGroup(block: DescribeFeatureGroupRequest.Builder.() -> Unit) = describeFeatureGroup(DescribeFeatureGroupRequest.Builder().apply(block).build())

    /**
     * Returns information about the specified flow definition.
     */
    suspend fun describeFlowDefinition(input: DescribeFlowDefinitionRequest): DescribeFlowDefinitionResponse

    /**
     * Returns information about the specified flow definition.
     */
    suspend fun describeFlowDefinition(block: DescribeFlowDefinitionRequest.Builder.() -> Unit) = describeFlowDefinition(DescribeFlowDefinitionRequest.Builder().apply(block).build())

    /**
     * Returns information about the requested human task user interface (worker task template).
     */
    suspend fun describeHumanTaskUi(input: DescribeHumanTaskUiRequest): DescribeHumanTaskUiResponse

    /**
     * Returns information about the requested human task user interface (worker task template).
     */
    suspend fun describeHumanTaskUi(block: DescribeHumanTaskUiRequest.Builder.() -> Unit) = describeHumanTaskUi(DescribeHumanTaskUiRequest.Builder().apply(block).build())

    /**
     * Gets a description of a hyperparameter tuning job.
     */
    suspend fun describeHyperParameterTuningJob(input: DescribeHyperParameterTuningJobRequest): DescribeHyperParameterTuningJobResponse

    /**
     * Gets a description of a hyperparameter tuning job.
     */
    suspend fun describeHyperParameterTuningJob(block: DescribeHyperParameterTuningJobRequest.Builder.() -> Unit) = describeHyperParameterTuningJob(DescribeHyperParameterTuningJobRequest.Builder().apply(block).build())

    /**
     * Describes a SageMaker image.
     */
    suspend fun describeImage(input: DescribeImageRequest): DescribeImageResponse

    /**
     * Describes a SageMaker image.
     */
    suspend fun describeImage(block: DescribeImageRequest.Builder.() -> Unit) = describeImage(DescribeImageRequest.Builder().apply(block).build())

    /**
     * Describes a version of a SageMaker image.
     */
    suspend fun describeImageVersion(input: DescribeImageVersionRequest): DescribeImageVersionResponse

    /**
     * Describes a version of a SageMaker image.
     */
    suspend fun describeImageVersion(block: DescribeImageVersionRequest.Builder.() -> Unit) = describeImageVersion(DescribeImageVersionRequest.Builder().apply(block).build())

    /**
     * Provides the results of the Inference Recommender job. One or more recommendation jobs are returned.
     */
    suspend fun describeInferenceRecommendationsJob(input: DescribeInferenceRecommendationsJobRequest): DescribeInferenceRecommendationsJobResponse

    /**
     * Provides the results of the Inference Recommender job. One or more recommendation jobs are returned.
     */
    suspend fun describeInferenceRecommendationsJob(block: DescribeInferenceRecommendationsJobRequest.Builder.() -> Unit) = describeInferenceRecommendationsJob(DescribeInferenceRecommendationsJobRequest.Builder().apply(block).build())

    /**
     * Gets information about a labeling job.
     */
    suspend fun describeLabelingJob(input: DescribeLabelingJobRequest): DescribeLabelingJobResponse

    /**
     * Gets information about a labeling job.
     */
    suspend fun describeLabelingJob(block: DescribeLabelingJobRequest.Builder.() -> Unit) = describeLabelingJob(DescribeLabelingJobRequest.Builder().apply(block).build())

    /**
     * Provides a list of properties for the requested lineage group. For more information, see [ Cross-Account Lineage Tracking ](https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html) in the *Amazon SageMaker Developer Guide*.
     */
    suspend fun describeLineageGroup(input: DescribeLineageGroupRequest): DescribeLineageGroupResponse

    /**
     * Provides a list of properties for the requested lineage group. For more information, see [ Cross-Account Lineage Tracking ](https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html) in the *Amazon SageMaker Developer Guide*.
     */
    suspend fun describeLineageGroup(block: DescribeLineageGroupRequest.Builder.() -> Unit) = describeLineageGroup(DescribeLineageGroupRequest.Builder().apply(block).build())

    /**
     * Describes a model that you created using the `CreateModel` API.
     */
    suspend fun describeModel(input: DescribeModelRequest): DescribeModelResponse

    /**
     * Describes a model that you created using the `CreateModel` API.
     */
    suspend fun describeModel(block: DescribeModelRequest.Builder.() -> Unit) = describeModel(DescribeModelRequest.Builder().apply(block).build())

    /**
     * Returns a description of a model bias job definition.
     */
    suspend fun describeModelBiasJobDefinition(input: DescribeModelBiasJobDefinitionRequest): DescribeModelBiasJobDefinitionResponse

    /**
     * Returns a description of a model bias job definition.
     */
    suspend fun describeModelBiasJobDefinition(block: DescribeModelBiasJobDefinitionRequest.Builder.() -> Unit) = describeModelBiasJobDefinition(DescribeModelBiasJobDefinitionRequest.Builder().apply(block).build())

    /**
     * Returns a description of a model explainability job definition.
     */
    suspend fun describeModelExplainabilityJobDefinition(input: DescribeModelExplainabilityJobDefinitionRequest): DescribeModelExplainabilityJobDefinitionResponse

    /**
     * Returns a description of a model explainability job definition.
     */
    suspend fun describeModelExplainabilityJobDefinition(block: DescribeModelExplainabilityJobDefinitionRequest.Builder.() -> Unit) = describeModelExplainabilityJobDefinition(DescribeModelExplainabilityJobDefinitionRequest.Builder().apply(block).build())

    /**
     * Returns a description of the specified model package, which is used to create SageMaker models or list them on Amazon Web Services Marketplace.
     *
     * To create models in SageMaker, buyers can subscribe to model packages listed on Amazon Web Services Marketplace.
     */
    suspend fun describeModelPackage(input: DescribeModelPackageRequest): DescribeModelPackageResponse

    /**
     * Returns a description of the specified model package, which is used to create SageMaker models or list them on Amazon Web Services Marketplace.
     *
     * To create models in SageMaker, buyers can subscribe to model packages listed on Amazon Web Services Marketplace.
     */
    suspend fun describeModelPackage(block: DescribeModelPackageRequest.Builder.() -> Unit) = describeModelPackage(DescribeModelPackageRequest.Builder().apply(block).build())

    /**
     * Gets a description for the specified model group.
     */
    suspend fun describeModelPackageGroup(input: DescribeModelPackageGroupRequest): DescribeModelPackageGroupResponse

    /**
     * Gets a description for the specified model group.
     */
    suspend fun describeModelPackageGroup(block: DescribeModelPackageGroupRequest.Builder.() -> Unit) = describeModelPackageGroup(DescribeModelPackageGroupRequest.Builder().apply(block).build())

    /**
     * Returns a description of a model quality job definition.
     */
    suspend fun describeModelQualityJobDefinition(input: DescribeModelQualityJobDefinitionRequest): DescribeModelQualityJobDefinitionResponse

    /**
     * Returns a description of a model quality job definition.
     */
    suspend fun describeModelQualityJobDefinition(block: DescribeModelQualityJobDefinitionRequest.Builder.() -> Unit) = describeModelQualityJobDefinition(DescribeModelQualityJobDefinitionRequest.Builder().apply(block).build())

    /**
     * Describes the schedule for a monitoring job.
     */
    suspend fun describeMonitoringSchedule(input: DescribeMonitoringScheduleRequest): DescribeMonitoringScheduleResponse

    /**
     * Describes the schedule for a monitoring job.
     */
    suspend fun describeMonitoringSchedule(block: DescribeMonitoringScheduleRequest.Builder.() -> Unit) = describeMonitoringSchedule(DescribeMonitoringScheduleRequest.Builder().apply(block).build())

    /**
     * Returns information about a notebook instance.
     */
    suspend fun describeNotebookInstance(input: DescribeNotebookInstanceRequest): DescribeNotebookInstanceResponse

    /**
     * Returns information about a notebook instance.
     */
    suspend fun describeNotebookInstance(block: DescribeNotebookInstanceRequest.Builder.() -> Unit) = describeNotebookInstance(DescribeNotebookInstanceRequest.Builder().apply(block).build())

    /**
     * Returns a description of a notebook instance lifecycle configuration.
     *
     * For information about notebook instance lifestyle configurations, see [Step 2.1: (Optional) Customize a Notebook Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
     */
    suspend fun describeNotebookInstanceLifecycleConfig(input: DescribeNotebookInstanceLifecycleConfigRequest): DescribeNotebookInstanceLifecycleConfigResponse

    /**
     * Returns a description of a notebook instance lifecycle configuration.
     *
     * For information about notebook instance lifestyle configurations, see [Step 2.1: (Optional) Customize a Notebook Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
     */
    suspend fun describeNotebookInstanceLifecycleConfig(block: DescribeNotebookInstanceLifecycleConfigRequest.Builder.() -> Unit) = describeNotebookInstanceLifecycleConfig(DescribeNotebookInstanceLifecycleConfigRequest.Builder().apply(block).build())

    /**
     * Describes the details of a pipeline.
     */
    suspend fun describePipeline(input: DescribePipelineRequest): DescribePipelineResponse

    /**
     * Describes the details of a pipeline.
     */
    suspend fun describePipeline(block: DescribePipelineRequest.Builder.() -> Unit) = describePipeline(DescribePipelineRequest.Builder().apply(block).build())

    /**
     * Describes the details of an execution's pipeline definition.
     */
    suspend fun describePipelineDefinitionForExecution(input: DescribePipelineDefinitionForExecutionRequest): DescribePipelineDefinitionForExecutionResponse

    /**
     * Describes the details of an execution's pipeline definition.
     */
    suspend fun describePipelineDefinitionForExecution(block: DescribePipelineDefinitionForExecutionRequest.Builder.() -> Unit) = describePipelineDefinitionForExecution(DescribePipelineDefinitionForExecutionRequest.Builder().apply(block).build())

    /**
     * Describes the details of a pipeline execution.
     */
    suspend fun describePipelineExecution(input: DescribePipelineExecutionRequest): DescribePipelineExecutionResponse

    /**
     * Describes the details of a pipeline execution.
     */
    suspend fun describePipelineExecution(block: DescribePipelineExecutionRequest.Builder.() -> Unit) = describePipelineExecution(DescribePipelineExecutionRequest.Builder().apply(block).build())

    /**
     * Returns a description of a processing job.
     */
    suspend fun describeProcessingJob(input: DescribeProcessingJobRequest): DescribeProcessingJobResponse

    /**
     * Returns a description of a processing job.
     */
    suspend fun describeProcessingJob(block: DescribeProcessingJobRequest.Builder.() -> Unit) = describeProcessingJob(DescribeProcessingJobRequest.Builder().apply(block).build())

    /**
     * Describes the details of a project.
     */
    suspend fun describeProject(input: DescribeProjectRequest): DescribeProjectResponse

    /**
     * Describes the details of a project.
     */
    suspend fun describeProject(block: DescribeProjectRequest.Builder.() -> Unit) = describeProject(DescribeProjectRequest.Builder().apply(block).build())

    /**
     * Describes the Studio Lifecycle Configuration.
     */
    suspend fun describeStudioLifecycleConfig(input: DescribeStudioLifecycleConfigRequest): DescribeStudioLifecycleConfigResponse

    /**
     * Describes the Studio Lifecycle Configuration.
     */
    suspend fun describeStudioLifecycleConfig(block: DescribeStudioLifecycleConfigRequest.Builder.() -> Unit) = describeStudioLifecycleConfig(DescribeStudioLifecycleConfigRequest.Builder().apply(block).build())

    /**
     * Gets information about a work team provided by a vendor. It returns details about the subscription with a vendor in the Amazon Web Services Marketplace.
     */
    suspend fun describeSubscribedWorkteam(input: DescribeSubscribedWorkteamRequest): DescribeSubscribedWorkteamResponse

    /**
     * Gets information about a work team provided by a vendor. It returns details about the subscription with a vendor in the Amazon Web Services Marketplace.
     */
    suspend fun describeSubscribedWorkteam(block: DescribeSubscribedWorkteamRequest.Builder.() -> Unit) = describeSubscribedWorkteam(DescribeSubscribedWorkteamRequest.Builder().apply(block).build())

    /**
     * Returns information about a training job.
     *
     * Some of the attributes below only appear if the training job successfully starts. If the training job fails, `TrainingJobStatus` is `Failed` and, depending on the `FailureReason`, attributes like `TrainingStartTime`, `TrainingTimeInSeconds`, `TrainingEndTime`, and `BillableTimeInSeconds` may not be present in the response.
     */
    suspend fun describeTrainingJob(input: DescribeTrainingJobRequest): DescribeTrainingJobResponse

    /**
     * Returns information about a training job.
     *
     * Some of the attributes below only appear if the training job successfully starts. If the training job fails, `TrainingJobStatus` is `Failed` and, depending on the `FailureReason`, attributes like `TrainingStartTime`, `TrainingTimeInSeconds`, `TrainingEndTime`, and `BillableTimeInSeconds` may not be present in the response.
     */
    suspend fun describeTrainingJob(block: DescribeTrainingJobRequest.Builder.() -> Unit) = describeTrainingJob(DescribeTrainingJobRequest.Builder().apply(block).build())

    /**
     * Returns information about a transform job.
     */
    suspend fun describeTransformJob(input: DescribeTransformJobRequest): DescribeTransformJobResponse

    /**
     * Returns information about a transform job.
     */
    suspend fun describeTransformJob(block: DescribeTransformJobRequest.Builder.() -> Unit) = describeTransformJob(DescribeTransformJobRequest.Builder().apply(block).build())

    /**
     * Provides a list of a trial's properties.
     */
    suspend fun describeTrial(input: DescribeTrialRequest): DescribeTrialResponse

    /**
     * Provides a list of a trial's properties.
     */
    suspend fun describeTrial(block: DescribeTrialRequest.Builder.() -> Unit) = describeTrial(DescribeTrialRequest.Builder().apply(block).build())

    /**
     * Provides a list of a trials component's properties.
     */
    suspend fun describeTrialComponent(input: DescribeTrialComponentRequest): DescribeTrialComponentResponse

    /**
     * Provides a list of a trials component's properties.
     */
    suspend fun describeTrialComponent(block: DescribeTrialComponentRequest.Builder.() -> Unit) = describeTrialComponent(DescribeTrialComponentRequest.Builder().apply(block).build())

    /**
     * Describes a user profile. For more information, see `CreateUserProfile`.
     */
    suspend fun describeUserProfile(input: DescribeUserProfileRequest): DescribeUserProfileResponse

    /**
     * Describes a user profile. For more information, see `CreateUserProfile`.
     */
    suspend fun describeUserProfile(block: DescribeUserProfileRequest.Builder.() -> Unit) = describeUserProfile(DescribeUserProfileRequest.Builder().apply(block).build())

    /**
     * Lists private workforce information, including workforce name, Amazon Resource Name (ARN), and, if applicable, allowed IP address ranges ([CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)). Allowable IP address ranges are the IP addresses that workers can use to access tasks.
     *
     * This operation applies only to private workforces.
     */
    suspend fun describeWorkforce(input: DescribeWorkforceRequest): DescribeWorkforceResponse

    /**
     * Lists private workforce information, including workforce name, Amazon Resource Name (ARN), and, if applicable, allowed IP address ranges ([CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)). Allowable IP address ranges are the IP addresses that workers can use to access tasks.
     *
     * This operation applies only to private workforces.
     */
    suspend fun describeWorkforce(block: DescribeWorkforceRequest.Builder.() -> Unit) = describeWorkforce(DescribeWorkforceRequest.Builder().apply(block).build())

    /**
     * Gets information about a specific work team. You can see information such as the create date, the last updated date, membership information, and the work team's Amazon Resource Name (ARN).
     */
    suspend fun describeWorkteam(input: DescribeWorkteamRequest): DescribeWorkteamResponse

    /**
     * Gets information about a specific work team. You can see information such as the create date, the last updated date, membership information, and the work team's Amazon Resource Name (ARN).
     */
    suspend fun describeWorkteam(block: DescribeWorkteamRequest.Builder.() -> Unit) = describeWorkteam(DescribeWorkteamRequest.Builder().apply(block).build())

    /**
     * Disables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     */
    suspend fun disableSagemakerServicecatalogPortfolio(input: DisableSagemakerServicecatalogPortfolioRequest = DisableSagemakerServicecatalogPortfolioRequest {}): DisableSagemakerServicecatalogPortfolioResponse

    /**
     * Disables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     */
    suspend fun disableSagemakerServicecatalogPortfolio(block: DisableSagemakerServicecatalogPortfolioRequest.Builder.() -> Unit) = disableSagemakerServicecatalogPortfolio(DisableSagemakerServicecatalogPortfolioRequest.Builder().apply(block).build())

    /**
     * Disassociates a trial component from a trial. This doesn't effect other trials the component is associated with. Before you can delete a component, you must disassociate the component from all trials it is associated with. To associate a trial component with a trial, call the AssociateTrialComponent API.
     *
     * To get a list of the trials a component is associated with, use the Search API. Specify `ExperimentTrialComponent` for the `Resource` parameter. The list appears in the response under `Results.TrialComponent.Parents`.
     */
    suspend fun disassociateTrialComponent(input: DisassociateTrialComponentRequest): DisassociateTrialComponentResponse

    /**
     * Disassociates a trial component from a trial. This doesn't effect other trials the component is associated with. Before you can delete a component, you must disassociate the component from all trials it is associated with. To associate a trial component with a trial, call the AssociateTrialComponent API.
     *
     * To get a list of the trials a component is associated with, use the Search API. Specify `ExperimentTrialComponent` for the `Resource` parameter. The list appears in the response under `Results.TrialComponent.Parents`.
     */
    suspend fun disassociateTrialComponent(block: DisassociateTrialComponentRequest.Builder.() -> Unit) = disassociateTrialComponent(DisassociateTrialComponentRequest.Builder().apply(block).build())

    /**
     * Enables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     */
    suspend fun enableSagemakerServicecatalogPortfolio(input: EnableSagemakerServicecatalogPortfolioRequest = EnableSagemakerServicecatalogPortfolioRequest {}): EnableSagemakerServicecatalogPortfolioResponse

    /**
     * Enables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     */
    suspend fun enableSagemakerServicecatalogPortfolio(block: EnableSagemakerServicecatalogPortfolioRequest.Builder.() -> Unit) = enableSagemakerServicecatalogPortfolio(EnableSagemakerServicecatalogPortfolioRequest.Builder().apply(block).build())

    /**
     * Describes a fleet.
     */
    suspend fun getDeviceFleetReport(input: GetDeviceFleetReportRequest): GetDeviceFleetReportResponse

    /**
     * Describes a fleet.
     */
    suspend fun getDeviceFleetReport(block: GetDeviceFleetReportRequest.Builder.() -> Unit) = getDeviceFleetReport(GetDeviceFleetReportRequest.Builder().apply(block).build())

    /**
     * The resource policy for the lineage group.
     */
    suspend fun getLineageGroupPolicy(input: GetLineageGroupPolicyRequest): GetLineageGroupPolicyResponse

    /**
     * The resource policy for the lineage group.
     */
    suspend fun getLineageGroupPolicy(block: GetLineageGroupPolicyRequest.Builder.() -> Unit) = getLineageGroupPolicy(GetLineageGroupPolicyRequest.Builder().apply(block).build())

    /**
     * Gets a resource policy that manages access for a model group. For information about resource policies, see [Identity-based policies and resource-based policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html) in the *Amazon Web Services Identity and Access Management User Guide.*.
     */
    suspend fun getModelPackageGroupPolicy(input: GetModelPackageGroupPolicyRequest): GetModelPackageGroupPolicyResponse

    /**
     * Gets a resource policy that manages access for a model group. For information about resource policies, see [Identity-based policies and resource-based policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html) in the *Amazon Web Services Identity and Access Management User Guide.*.
     */
    suspend fun getModelPackageGroupPolicy(block: GetModelPackageGroupPolicyRequest.Builder.() -> Unit) = getModelPackageGroupPolicy(GetModelPackageGroupPolicyRequest.Builder().apply(block).build())

    /**
     * Gets the status of Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     */
    suspend fun getSagemakerServicecatalogPortfolioStatus(input: GetSagemakerServicecatalogPortfolioStatusRequest = GetSagemakerServicecatalogPortfolioStatusRequest {}): GetSagemakerServicecatalogPortfolioStatusResponse

    /**
     * Gets the status of Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     */
    suspend fun getSagemakerServicecatalogPortfolioStatus(block: GetSagemakerServicecatalogPortfolioStatusRequest.Builder.() -> Unit) = getSagemakerServicecatalogPortfolioStatus(GetSagemakerServicecatalogPortfolioStatusRequest.Builder().apply(block).build())

    /**
     * An auto-complete API for the search functionality in the Amazon SageMaker console. It returns suggestions of possible matches for the property name to use in `Search` queries. Provides suggestions for `HyperParameters`, `Tags`, and `Metrics`.
     */
    suspend fun getSearchSuggestions(input: GetSearchSuggestionsRequest): GetSearchSuggestionsResponse

    /**
     * An auto-complete API for the search functionality in the Amazon SageMaker console. It returns suggestions of possible matches for the property name to use in `Search` queries. Provides suggestions for `HyperParameters`, `Tags`, and `Metrics`.
     */
    suspend fun getSearchSuggestions(block: GetSearchSuggestionsRequest.Builder.() -> Unit) = getSearchSuggestions(GetSearchSuggestionsRequest.Builder().apply(block).build())

    /**
     * Lists the actions in your account and their properties.
     */
    suspend fun listActions(input: ListActionsRequest = ListActionsRequest {}): ListActionsResponse

    /**
     * Lists the actions in your account and their properties.
     */
    suspend fun listActions(block: ListActionsRequest.Builder.() -> Unit) = listActions(ListActionsRequest.Builder().apply(block).build())

    /**
     * Lists the machine learning algorithms that have been created.
     */
    suspend fun listAlgorithms(input: ListAlgorithmsRequest = ListAlgorithmsRequest {}): ListAlgorithmsResponse

    /**
     * Lists the machine learning algorithms that have been created.
     */
    suspend fun listAlgorithms(block: ListAlgorithmsRequest.Builder.() -> Unit) = listAlgorithms(ListAlgorithmsRequest.Builder().apply(block).build())

    /**
     * Lists the AppImageConfigs in your account and their properties. The list can be filtered by creation time or modified time, and whether the AppImageConfig name contains a specified string.
     */
    suspend fun listAppImageConfigs(input: ListAppImageConfigsRequest = ListAppImageConfigsRequest {}): ListAppImageConfigsResponse

    /**
     * Lists the AppImageConfigs in your account and their properties. The list can be filtered by creation time or modified time, and whether the AppImageConfig name contains a specified string.
     */
    suspend fun listAppImageConfigs(block: ListAppImageConfigsRequest.Builder.() -> Unit) = listAppImageConfigs(ListAppImageConfigsRequest.Builder().apply(block).build())

    /**
     * Lists apps.
     */
    suspend fun listApps(input: ListAppsRequest = ListAppsRequest {}): ListAppsResponse

    /**
     * Lists apps.
     */
    suspend fun listApps(block: ListAppsRequest.Builder.() -> Unit) = listApps(ListAppsRequest.Builder().apply(block).build())

    /**
     * Lists the artifacts in your account and their properties.
     */
    suspend fun listArtifacts(input: ListArtifactsRequest = ListArtifactsRequest {}): ListArtifactsResponse

    /**
     * Lists the artifacts in your account and their properties.
     */
    suspend fun listArtifacts(block: ListArtifactsRequest.Builder.() -> Unit) = listArtifacts(ListArtifactsRequest.Builder().apply(block).build())

    /**
     * Lists the associations in your account and their properties.
     */
    suspend fun listAssociations(input: ListAssociationsRequest = ListAssociationsRequest {}): ListAssociationsResponse

    /**
     * Lists the associations in your account and their properties.
     */
    suspend fun listAssociations(block: ListAssociationsRequest.Builder.() -> Unit) = listAssociations(ListAssociationsRequest.Builder().apply(block).build())

    /**
     * Request a list of jobs.
     */
    suspend fun listAutoMlJobs(input: ListAutoMlJobsRequest = ListAutoMlJobsRequest {}): ListAutoMlJobsResponse

    /**
     * Request a list of jobs.
     */
    suspend fun listAutoMlJobs(block: ListAutoMlJobsRequest.Builder.() -> Unit) = listAutoMlJobs(ListAutoMlJobsRequest.Builder().apply(block).build())

    /**
     * List the candidates created for the job.
     */
    suspend fun listCandidatesForAutoMlJob(input: ListCandidatesForAutoMlJobRequest): ListCandidatesForAutoMlJobResponse

    /**
     * List the candidates created for the job.
     */
    suspend fun listCandidatesForAutoMlJob(block: ListCandidatesForAutoMlJobRequest.Builder.() -> Unit) = listCandidatesForAutoMlJob(ListCandidatesForAutoMlJobRequest.Builder().apply(block).build())

    /**
     * Gets a list of the Git repositories in your account.
     */
    suspend fun listCodeRepositories(input: ListCodeRepositoriesRequest = ListCodeRepositoriesRequest {}): ListCodeRepositoriesResponse

    /**
     * Gets a list of the Git repositories in your account.
     */
    suspend fun listCodeRepositories(block: ListCodeRepositoriesRequest.Builder.() -> Unit) = listCodeRepositories(ListCodeRepositoriesRequest.Builder().apply(block).build())

    /**
     * Lists model compilation jobs that satisfy various filters.
     *
     * To create a model compilation job, use CreateCompilationJob. To get information about a particular model compilation job you have created, use DescribeCompilationJob.
     */
    suspend fun listCompilationJobs(input: ListCompilationJobsRequest = ListCompilationJobsRequest {}): ListCompilationJobsResponse

    /**
     * Lists model compilation jobs that satisfy various filters.
     *
     * To create a model compilation job, use CreateCompilationJob. To get information about a particular model compilation job you have created, use DescribeCompilationJob.
     */
    suspend fun listCompilationJobs(block: ListCompilationJobsRequest.Builder.() -> Unit) = listCompilationJobs(ListCompilationJobsRequest.Builder().apply(block).build())

    /**
     * Lists the contexts in your account and their properties.
     */
    suspend fun listContexts(input: ListContextsRequest = ListContextsRequest {}): ListContextsResponse

    /**
     * Lists the contexts in your account and their properties.
     */
    suspend fun listContexts(block: ListContextsRequest.Builder.() -> Unit) = listContexts(ListContextsRequest.Builder().apply(block).build())

    /**
     * Lists the data quality job definitions in your account.
     */
    suspend fun listDataQualityJobDefinitions(input: ListDataQualityJobDefinitionsRequest = ListDataQualityJobDefinitionsRequest {}): ListDataQualityJobDefinitionsResponse

    /**
     * Lists the data quality job definitions in your account.
     */
    suspend fun listDataQualityJobDefinitions(block: ListDataQualityJobDefinitionsRequest.Builder.() -> Unit) = listDataQualityJobDefinitions(ListDataQualityJobDefinitionsRequest.Builder().apply(block).build())

    /**
     * Returns a list of devices in the fleet.
     */
    suspend fun listDeviceFleets(input: ListDeviceFleetsRequest = ListDeviceFleetsRequest {}): ListDeviceFleetsResponse

    /**
     * Returns a list of devices in the fleet.
     */
    suspend fun listDeviceFleets(block: ListDeviceFleetsRequest.Builder.() -> Unit) = listDeviceFleets(ListDeviceFleetsRequest.Builder().apply(block).build())

    /**
     * A list of devices.
     */
    suspend fun listDevices(input: ListDevicesRequest = ListDevicesRequest {}): ListDevicesResponse

    /**
     * A list of devices.
     */
    suspend fun listDevices(block: ListDevicesRequest.Builder.() -> Unit) = listDevices(ListDevicesRequest.Builder().apply(block).build())

    /**
     * Lists the domains.
     */
    suspend fun listDomains(input: ListDomainsRequest = ListDomainsRequest {}): ListDomainsResponse

    /**
     * Lists the domains.
     */
    suspend fun listDomains(block: ListDomainsRequest.Builder.() -> Unit) = listDomains(ListDomainsRequest.Builder().apply(block).build())

    /**
     * Returns a list of edge packaging jobs.
     */
    suspend fun listEdgePackagingJobs(input: ListEdgePackagingJobsRequest = ListEdgePackagingJobsRequest {}): ListEdgePackagingJobsResponse

    /**
     * Returns a list of edge packaging jobs.
     */
    suspend fun listEdgePackagingJobs(block: ListEdgePackagingJobsRequest.Builder.() -> Unit) = listEdgePackagingJobs(ListEdgePackagingJobsRequest.Builder().apply(block).build())

    /**
     * Lists endpoint configurations.
     */
    suspend fun listEndpointConfigs(input: ListEndpointConfigsRequest = ListEndpointConfigsRequest {}): ListEndpointConfigsResponse

    /**
     * Lists endpoint configurations.
     */
    suspend fun listEndpointConfigs(block: ListEndpointConfigsRequest.Builder.() -> Unit) = listEndpointConfigs(ListEndpointConfigsRequest.Builder().apply(block).build())

    /**
     * Lists endpoints.
     */
    suspend fun listEndpoints(input: ListEndpointsRequest = ListEndpointsRequest {}): ListEndpointsResponse

    /**
     * Lists endpoints.
     */
    suspend fun listEndpoints(block: ListEndpointsRequest.Builder.() -> Unit) = listEndpoints(ListEndpointsRequest.Builder().apply(block).build())

    /**
     * Lists all the experiments in your account. The list can be filtered to show only experiments that were created in a specific time range. The list can be sorted by experiment name or creation time.
     */
    suspend fun listExperiments(input: ListExperimentsRequest = ListExperimentsRequest {}): ListExperimentsResponse

    /**
     * Lists all the experiments in your account. The list can be filtered to show only experiments that were created in a specific time range. The list can be sorted by experiment name or creation time.
     */
    suspend fun listExperiments(block: ListExperimentsRequest.Builder.() -> Unit) = listExperiments(ListExperimentsRequest.Builder().apply(block).build())

    /**
     * List `FeatureGroup`s based on given filter and order.
     */
    suspend fun listFeatureGroups(input: ListFeatureGroupsRequest = ListFeatureGroupsRequest {}): ListFeatureGroupsResponse

    /**
     * List `FeatureGroup`s based on given filter and order.
     */
    suspend fun listFeatureGroups(block: ListFeatureGroupsRequest.Builder.() -> Unit) = listFeatureGroups(ListFeatureGroupsRequest.Builder().apply(block).build())

    /**
     * Returns information about the flow definitions in your account.
     */
    suspend fun listFlowDefinitions(input: ListFlowDefinitionsRequest = ListFlowDefinitionsRequest {}): ListFlowDefinitionsResponse

    /**
     * Returns information about the flow definitions in your account.
     */
    suspend fun listFlowDefinitions(block: ListFlowDefinitionsRequest.Builder.() -> Unit) = listFlowDefinitions(ListFlowDefinitionsRequest.Builder().apply(block).build())

    /**
     * Returns information about the human task user interfaces in your account.
     */
    suspend fun listHumanTaskUis(input: ListHumanTaskUisRequest = ListHumanTaskUisRequest {}): ListHumanTaskUisResponse

    /**
     * Returns information about the human task user interfaces in your account.
     */
    suspend fun listHumanTaskUis(block: ListHumanTaskUisRequest.Builder.() -> Unit) = listHumanTaskUis(ListHumanTaskUisRequest.Builder().apply(block).build())

    /**
     * Gets a list of HyperParameterTuningJobSummary objects that describe the hyperparameter tuning jobs launched in your account.
     */
    suspend fun listHyperParameterTuningJobs(input: ListHyperParameterTuningJobsRequest = ListHyperParameterTuningJobsRequest {}): ListHyperParameterTuningJobsResponse

    /**
     * Gets a list of HyperParameterTuningJobSummary objects that describe the hyperparameter tuning jobs launched in your account.
     */
    suspend fun listHyperParameterTuningJobs(block: ListHyperParameterTuningJobsRequest.Builder.() -> Unit) = listHyperParameterTuningJobs(ListHyperParameterTuningJobsRequest.Builder().apply(block).build())

    /**
     * Lists the versions of a specified image and their properties. The list can be filtered by creation time or modified time.
     */
    suspend fun listImageVersions(input: ListImageVersionsRequest): ListImageVersionsResponse

    /**
     * Lists the versions of a specified image and their properties. The list can be filtered by creation time or modified time.
     */
    suspend fun listImageVersions(block: ListImageVersionsRequest.Builder.() -> Unit) = listImageVersions(ListImageVersionsRequest.Builder().apply(block).build())

    /**
     * Lists the images in your account and their properties. The list can be filtered by creation time or modified time, and whether the image name contains a specified string.
     */
    suspend fun listImages(input: ListImagesRequest = ListImagesRequest {}): ListImagesResponse

    /**
     * Lists the images in your account and their properties. The list can be filtered by creation time or modified time, and whether the image name contains a specified string.
     */
    suspend fun listImages(block: ListImagesRequest.Builder.() -> Unit) = listImages(ListImagesRequest.Builder().apply(block).build())

    /**
     * Lists recommendation jobs that satisfy various filters.
     */
    suspend fun listInferenceRecommendationsJobs(input: ListInferenceRecommendationsJobsRequest = ListInferenceRecommendationsJobsRequest {}): ListInferenceRecommendationsJobsResponse

    /**
     * Lists recommendation jobs that satisfy various filters.
     */
    suspend fun listInferenceRecommendationsJobs(block: ListInferenceRecommendationsJobsRequest.Builder.() -> Unit) = listInferenceRecommendationsJobs(ListInferenceRecommendationsJobsRequest.Builder().apply(block).build())

    /**
     * Gets a list of labeling jobs.
     */
    suspend fun listLabelingJobs(input: ListLabelingJobsRequest = ListLabelingJobsRequest {}): ListLabelingJobsResponse

    /**
     * Gets a list of labeling jobs.
     */
    suspend fun listLabelingJobs(block: ListLabelingJobsRequest.Builder.() -> Unit) = listLabelingJobs(ListLabelingJobsRequest.Builder().apply(block).build())

    /**
     * Gets a list of labeling jobs assigned to a specified work team.
     */
    suspend fun listLabelingJobsForWorkteam(input: ListLabelingJobsForWorkteamRequest): ListLabelingJobsForWorkteamResponse

    /**
     * Gets a list of labeling jobs assigned to a specified work team.
     */
    suspend fun listLabelingJobsForWorkteam(block: ListLabelingJobsForWorkteamRequest.Builder.() -> Unit) = listLabelingJobsForWorkteam(ListLabelingJobsForWorkteamRequest.Builder().apply(block).build())

    /**
     * A list of lineage groups shared with your Amazon Web Services account. For more information, see [ Cross-Account Lineage Tracking ](https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html) in the *Amazon SageMaker Developer Guide*.
     */
    suspend fun listLineageGroups(input: ListLineageGroupsRequest = ListLineageGroupsRequest {}): ListLineageGroupsResponse

    /**
     * A list of lineage groups shared with your Amazon Web Services account. For more information, see [ Cross-Account Lineage Tracking ](https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html) in the *Amazon SageMaker Developer Guide*.
     */
    suspend fun listLineageGroups(block: ListLineageGroupsRequest.Builder.() -> Unit) = listLineageGroups(ListLineageGroupsRequest.Builder().apply(block).build())

    /**
     * Lists model bias jobs definitions that satisfy various filters.
     */
    suspend fun listModelBiasJobDefinitions(input: ListModelBiasJobDefinitionsRequest = ListModelBiasJobDefinitionsRequest {}): ListModelBiasJobDefinitionsResponse

    /**
     * Lists model bias jobs definitions that satisfy various filters.
     */
    suspend fun listModelBiasJobDefinitions(block: ListModelBiasJobDefinitionsRequest.Builder.() -> Unit) = listModelBiasJobDefinitions(ListModelBiasJobDefinitionsRequest.Builder().apply(block).build())

    /**
     * Lists model explainability job definitions that satisfy various filters.
     */
    suspend fun listModelExplainabilityJobDefinitions(input: ListModelExplainabilityJobDefinitionsRequest = ListModelExplainabilityJobDefinitionsRequest {}): ListModelExplainabilityJobDefinitionsResponse

    /**
     * Lists model explainability job definitions that satisfy various filters.
     */
    suspend fun listModelExplainabilityJobDefinitions(block: ListModelExplainabilityJobDefinitionsRequest.Builder.() -> Unit) = listModelExplainabilityJobDefinitions(ListModelExplainabilityJobDefinitionsRequest.Builder().apply(block).build())

    /**
     * Lists the domain, framework, task, and model name of standard machine learning models found in common model zoos.
     */
    suspend fun listModelMetadata(input: ListModelMetadataRequest = ListModelMetadataRequest {}): ListModelMetadataResponse

    /**
     * Lists the domain, framework, task, and model name of standard machine learning models found in common model zoos.
     */
    suspend fun listModelMetadata(block: ListModelMetadataRequest.Builder.() -> Unit) = listModelMetadata(ListModelMetadataRequest.Builder().apply(block).build())

    /**
     * Gets a list of the model groups in your Amazon Web Services account.
     */
    suspend fun listModelPackageGroups(input: ListModelPackageGroupsRequest = ListModelPackageGroupsRequest {}): ListModelPackageGroupsResponse

    /**
     * Gets a list of the model groups in your Amazon Web Services account.
     */
    suspend fun listModelPackageGroups(block: ListModelPackageGroupsRequest.Builder.() -> Unit) = listModelPackageGroups(ListModelPackageGroupsRequest.Builder().apply(block).build())

    /**
     * Lists the model packages that have been created.
     */
    suspend fun listModelPackages(input: ListModelPackagesRequest = ListModelPackagesRequest {}): ListModelPackagesResponse

    /**
     * Lists the model packages that have been created.
     */
    suspend fun listModelPackages(block: ListModelPackagesRequest.Builder.() -> Unit) = listModelPackages(ListModelPackagesRequest.Builder().apply(block).build())

    /**
     * Gets a list of model quality monitoring job definitions in your account.
     */
    suspend fun listModelQualityJobDefinitions(input: ListModelQualityJobDefinitionsRequest = ListModelQualityJobDefinitionsRequest {}): ListModelQualityJobDefinitionsResponse

    /**
     * Gets a list of model quality monitoring job definitions in your account.
     */
    suspend fun listModelQualityJobDefinitions(block: ListModelQualityJobDefinitionsRequest.Builder.() -> Unit) = listModelQualityJobDefinitions(ListModelQualityJobDefinitionsRequest.Builder().apply(block).build())

    /**
     * Lists models created with the `CreateModel` API.
     */
    suspend fun listModels(input: ListModelsRequest = ListModelsRequest {}): ListModelsResponse

    /**
     * Lists models created with the `CreateModel` API.
     */
    suspend fun listModels(block: ListModelsRequest.Builder.() -> Unit) = listModels(ListModelsRequest.Builder().apply(block).build())

    /**
     * Returns list of all monitoring job executions.
     */
    suspend fun listMonitoringExecutions(input: ListMonitoringExecutionsRequest = ListMonitoringExecutionsRequest {}): ListMonitoringExecutionsResponse

    /**
     * Returns list of all monitoring job executions.
     */
    suspend fun listMonitoringExecutions(block: ListMonitoringExecutionsRequest.Builder.() -> Unit) = listMonitoringExecutions(ListMonitoringExecutionsRequest.Builder().apply(block).build())

    /**
     * Returns list of all monitoring schedules.
     */
    suspend fun listMonitoringSchedules(input: ListMonitoringSchedulesRequest = ListMonitoringSchedulesRequest {}): ListMonitoringSchedulesResponse

    /**
     * Returns list of all monitoring schedules.
     */
    suspend fun listMonitoringSchedules(block: ListMonitoringSchedulesRequest.Builder.() -> Unit) = listMonitoringSchedules(ListMonitoringSchedulesRequest.Builder().apply(block).build())

    /**
     * Lists notebook instance lifestyle configurations created with the CreateNotebookInstanceLifecycleConfig API.
     */
    suspend fun listNotebookInstanceLifecycleConfigs(input: ListNotebookInstanceLifecycleConfigsRequest = ListNotebookInstanceLifecycleConfigsRequest {}): ListNotebookInstanceLifecycleConfigsResponse

    /**
     * Lists notebook instance lifestyle configurations created with the CreateNotebookInstanceLifecycleConfig API.
     */
    suspend fun listNotebookInstanceLifecycleConfigs(block: ListNotebookInstanceLifecycleConfigsRequest.Builder.() -> Unit) = listNotebookInstanceLifecycleConfigs(ListNotebookInstanceLifecycleConfigsRequest.Builder().apply(block).build())

    /**
     * Returns a list of the SageMaker notebook instances in the requester's account in an Amazon Web Services Region.
     */
    suspend fun listNotebookInstances(input: ListNotebookInstancesRequest = ListNotebookInstancesRequest {}): ListNotebookInstancesResponse

    /**
     * Returns a list of the SageMaker notebook instances in the requester's account in an Amazon Web Services Region.
     */
    suspend fun listNotebookInstances(block: ListNotebookInstancesRequest.Builder.() -> Unit) = listNotebookInstances(ListNotebookInstancesRequest.Builder().apply(block).build())

    /**
     * Gets a list of `PipeLineExecutionStep` objects.
     */
    suspend fun listPipelineExecutionSteps(input: ListPipelineExecutionStepsRequest = ListPipelineExecutionStepsRequest {}): ListPipelineExecutionStepsResponse

    /**
     * Gets a list of `PipeLineExecutionStep` objects.
     */
    suspend fun listPipelineExecutionSteps(block: ListPipelineExecutionStepsRequest.Builder.() -> Unit) = listPipelineExecutionSteps(ListPipelineExecutionStepsRequest.Builder().apply(block).build())

    /**
     * Gets a list of the pipeline executions.
     */
    suspend fun listPipelineExecutions(input: ListPipelineExecutionsRequest): ListPipelineExecutionsResponse

    /**
     * Gets a list of the pipeline executions.
     */
    suspend fun listPipelineExecutions(block: ListPipelineExecutionsRequest.Builder.() -> Unit) = listPipelineExecutions(ListPipelineExecutionsRequest.Builder().apply(block).build())

    /**
     * Gets a list of parameters for a pipeline execution.
     */
    suspend fun listPipelineParametersForExecution(input: ListPipelineParametersForExecutionRequest): ListPipelineParametersForExecutionResponse

    /**
     * Gets a list of parameters for a pipeline execution.
     */
    suspend fun listPipelineParametersForExecution(block: ListPipelineParametersForExecutionRequest.Builder.() -> Unit) = listPipelineParametersForExecution(ListPipelineParametersForExecutionRequest.Builder().apply(block).build())

    /**
     * Gets a list of pipelines.
     */
    suspend fun listPipelines(input: ListPipelinesRequest = ListPipelinesRequest {}): ListPipelinesResponse

    /**
     * Gets a list of pipelines.
     */
    suspend fun listPipelines(block: ListPipelinesRequest.Builder.() -> Unit) = listPipelines(ListPipelinesRequest.Builder().apply(block).build())

    /**
     * Lists processing jobs that satisfy various filters.
     */
    suspend fun listProcessingJobs(input: ListProcessingJobsRequest = ListProcessingJobsRequest {}): ListProcessingJobsResponse

    /**
     * Lists processing jobs that satisfy various filters.
     */
    suspend fun listProcessingJobs(block: ListProcessingJobsRequest.Builder.() -> Unit) = listProcessingJobs(ListProcessingJobsRequest.Builder().apply(block).build())

    /**
     * Gets a list of the projects in an Amazon Web Services account.
     */
    suspend fun listProjects(input: ListProjectsRequest = ListProjectsRequest {}): ListProjectsResponse

    /**
     * Gets a list of the projects in an Amazon Web Services account.
     */
    suspend fun listProjects(block: ListProjectsRequest.Builder.() -> Unit) = listProjects(ListProjectsRequest.Builder().apply(block).build())

    /**
     * Lists the Studio Lifecycle Configurations in your Amazon Web Services Account.
     */
    suspend fun listStudioLifecycleConfigs(input: ListStudioLifecycleConfigsRequest = ListStudioLifecycleConfigsRequest {}): ListStudioLifecycleConfigsResponse

    /**
     * Lists the Studio Lifecycle Configurations in your Amazon Web Services Account.
     */
    suspend fun listStudioLifecycleConfigs(block: ListStudioLifecycleConfigsRequest.Builder.() -> Unit) = listStudioLifecycleConfigs(ListStudioLifecycleConfigsRequest.Builder().apply(block).build())

    /**
     * Gets a list of the work teams that you are subscribed to in the Amazon Web Services Marketplace. The list may be empty if no work team satisfies the filter specified in the `NameContains` parameter.
     */
    suspend fun listSubscribedWorkteams(input: ListSubscribedWorkteamsRequest = ListSubscribedWorkteamsRequest {}): ListSubscribedWorkteamsResponse

    /**
     * Gets a list of the work teams that you are subscribed to in the Amazon Web Services Marketplace. The list may be empty if no work team satisfies the filter specified in the `NameContains` parameter.
     */
    suspend fun listSubscribedWorkteams(block: ListSubscribedWorkteamsRequest.Builder.() -> Unit) = listSubscribedWorkteams(ListSubscribedWorkteamsRequest.Builder().apply(block).build())

    /**
     * Returns the tags for the specified SageMaker resource.
     */
    suspend fun listTags(input: ListTagsRequest): ListTagsResponse

    /**
     * Returns the tags for the specified SageMaker resource.
     */
    suspend fun listTags(block: ListTagsRequest.Builder.() -> Unit) = listTags(ListTagsRequest.Builder().apply(block).build())

    /**
     * Lists training jobs.
     *
     * When `StatusEquals` and `MaxResults` are set at the same time, the `MaxResults` number of training jobs are first retrieved ignoring the `StatusEquals` parameter and then they are filtered by the `StatusEquals` parameter, which is returned as a response.
     *
     * For example, if `ListTrainingJobs` is invoked with the following parameters:
     *
     * `{ ... MaxResults: 100, StatusEquals: InProgress ... }`
     *
     * First, 100 trainings jobs with any status, including those other than `InProgress`, are selected (sorted according to the creation time, from the most current to the oldest). Next, those with a status of `InProgress` are returned.
     *
     * You can quickly test the API using the following Amazon Web Services CLI code.
     *
     * `aws sagemaker list-training-jobs --max-results 100 --status-equals InProgress`
     */
    suspend fun listTrainingJobs(input: ListTrainingJobsRequest = ListTrainingJobsRequest {}): ListTrainingJobsResponse

    /**
     * Lists training jobs.
     *
     * When `StatusEquals` and `MaxResults` are set at the same time, the `MaxResults` number of training jobs are first retrieved ignoring the `StatusEquals` parameter and then they are filtered by the `StatusEquals` parameter, which is returned as a response.
     *
     * For example, if `ListTrainingJobs` is invoked with the following parameters:
     *
     * `{ ... MaxResults: 100, StatusEquals: InProgress ... }`
     *
     * First, 100 trainings jobs with any status, including those other than `InProgress`, are selected (sorted according to the creation time, from the most current to the oldest). Next, those with a status of `InProgress` are returned.
     *
     * You can quickly test the API using the following Amazon Web Services CLI code.
     *
     * `aws sagemaker list-training-jobs --max-results 100 --status-equals InProgress`
     */
    suspend fun listTrainingJobs(block: ListTrainingJobsRequest.Builder.() -> Unit) = listTrainingJobs(ListTrainingJobsRequest.Builder().apply(block).build())

    /**
     * Gets a list of TrainingJobSummary objects that describe the training jobs that a hyperparameter tuning job launched.
     */
    suspend fun listTrainingJobsForHyperParameterTuningJob(input: ListTrainingJobsForHyperParameterTuningJobRequest): ListTrainingJobsForHyperParameterTuningJobResponse

    /**
     * Gets a list of TrainingJobSummary objects that describe the training jobs that a hyperparameter tuning job launched.
     */
    suspend fun listTrainingJobsForHyperParameterTuningJob(block: ListTrainingJobsForHyperParameterTuningJobRequest.Builder.() -> Unit) = listTrainingJobsForHyperParameterTuningJob(ListTrainingJobsForHyperParameterTuningJobRequest.Builder().apply(block).build())

    /**
     * Lists transform jobs.
     */
    suspend fun listTransformJobs(input: ListTransformJobsRequest = ListTransformJobsRequest {}): ListTransformJobsResponse

    /**
     * Lists transform jobs.
     */
    suspend fun listTransformJobs(block: ListTransformJobsRequest.Builder.() -> Unit) = listTransformJobs(ListTransformJobsRequest.Builder().apply(block).build())

    /**
     * Lists the trial components in your account. You can sort the list by trial component name or creation time. You can filter the list to show only components that were created in a specific time range. You can also filter on one of the following:
     * + `ExperimentName`
     * + `SourceArn`
     * + `TrialName`
     */
    suspend fun listTrialComponents(input: ListTrialComponentsRequest = ListTrialComponentsRequest {}): ListTrialComponentsResponse

    /**
     * Lists the trial components in your account. You can sort the list by trial component name or creation time. You can filter the list to show only components that were created in a specific time range. You can also filter on one of the following:
     * + `ExperimentName`
     * + `SourceArn`
     * + `TrialName`
     */
    suspend fun listTrialComponents(block: ListTrialComponentsRequest.Builder.() -> Unit) = listTrialComponents(ListTrialComponentsRequest.Builder().apply(block).build())

    /**
     * Lists the trials in your account. Specify an experiment name to limit the list to the trials that are part of that experiment. Specify a trial component name to limit the list to the trials that associated with that trial component. The list can be filtered to show only trials that were created in a specific time range. The list can be sorted by trial name or creation time.
     */
    suspend fun listTrials(input: ListTrialsRequest = ListTrialsRequest {}): ListTrialsResponse

    /**
     * Lists the trials in your account. Specify an experiment name to limit the list to the trials that are part of that experiment. Specify a trial component name to limit the list to the trials that associated with that trial component. The list can be filtered to show only trials that were created in a specific time range. The list can be sorted by trial name or creation time.
     */
    suspend fun listTrials(block: ListTrialsRequest.Builder.() -> Unit) = listTrials(ListTrialsRequest.Builder().apply(block).build())

    /**
     * Lists user profiles.
     */
    suspend fun listUserProfiles(input: ListUserProfilesRequest = ListUserProfilesRequest {}): ListUserProfilesResponse

    /**
     * Lists user profiles.
     */
    suspend fun listUserProfiles(block: ListUserProfilesRequest.Builder.() -> Unit) = listUserProfiles(ListUserProfilesRequest.Builder().apply(block).build())

    /**
     * Use this operation to list all private and vendor workforces in an Amazon Web Services Region. Note that you can only have one private workforce per Amazon Web Services Region.
     */
    suspend fun listWorkforces(input: ListWorkforcesRequest = ListWorkforcesRequest {}): ListWorkforcesResponse

    /**
     * Use this operation to list all private and vendor workforces in an Amazon Web Services Region. Note that you can only have one private workforce per Amazon Web Services Region.
     */
    suspend fun listWorkforces(block: ListWorkforcesRequest.Builder.() -> Unit) = listWorkforces(ListWorkforcesRequest.Builder().apply(block).build())

    /**
     * Gets a list of private work teams that you have defined in a region. The list may be empty if no work team satisfies the filter specified in the `NameContains` parameter.
     */
    suspend fun listWorkteams(input: ListWorkteamsRequest = ListWorkteamsRequest {}): ListWorkteamsResponse

    /**
     * Gets a list of private work teams that you have defined in a region. The list may be empty if no work team satisfies the filter specified in the `NameContains` parameter.
     */
    suspend fun listWorkteams(block: ListWorkteamsRequest.Builder.() -> Unit) = listWorkteams(ListWorkteamsRequest.Builder().apply(block).build())

    /**
     * Adds a resouce policy to control access to a model group. For information about resoure policies, see [Identity-based policies and resource-based policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html) in the *Amazon Web Services Identity and Access Management User Guide.*.
     */
    suspend fun putModelPackageGroupPolicy(input: PutModelPackageGroupPolicyRequest): PutModelPackageGroupPolicyResponse

    /**
     * Adds a resouce policy to control access to a model group. For information about resoure policies, see [Identity-based policies and resource-based policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html) in the *Amazon Web Services Identity and Access Management User Guide.*.
     */
    suspend fun putModelPackageGroupPolicy(block: PutModelPackageGroupPolicyRequest.Builder.() -> Unit) = putModelPackageGroupPolicy(PutModelPackageGroupPolicyRequest.Builder().apply(block).build())

    /**
     * Use this action to inspect your lineage and discover relationships between entities. For more information, see [ Querying Lineage Entities](https://docs.aws.amazon.com/sagemaker/latest/dg/querying-lineage-entities.html) in the *Amazon SageMaker Developer Guide*.
     */
    suspend fun queryLineage(input: QueryLineageRequest): QueryLineageResponse

    /**
     * Use this action to inspect your lineage and discover relationships between entities. For more information, see [ Querying Lineage Entities](https://docs.aws.amazon.com/sagemaker/latest/dg/querying-lineage-entities.html) in the *Amazon SageMaker Developer Guide*.
     */
    suspend fun queryLineage(block: QueryLineageRequest.Builder.() -> Unit) = queryLineage(QueryLineageRequest.Builder().apply(block).build())

    /**
     * Register devices.
     */
    suspend fun registerDevices(input: RegisterDevicesRequest): RegisterDevicesResponse

    /**
     * Register devices.
     */
    suspend fun registerDevices(block: RegisterDevicesRequest.Builder.() -> Unit) = registerDevices(RegisterDevicesRequest.Builder().apply(block).build())

    /**
     * Renders the UI template so that you can preview the worker's experience.
     */
    suspend fun renderUiTemplate(input: RenderUiTemplateRequest): RenderUiTemplateResponse

    /**
     * Renders the UI template so that you can preview the worker's experience.
     */
    suspend fun renderUiTemplate(block: RenderUiTemplateRequest.Builder.() -> Unit) = renderUiTemplate(RenderUiTemplateRequest.Builder().apply(block).build())

    /**
     * Retry the execution of the pipeline.
     */
    suspend fun retryPipelineExecution(input: RetryPipelineExecutionRequest): RetryPipelineExecutionResponse

    /**
     * Retry the execution of the pipeline.
     */
    suspend fun retryPipelineExecution(block: RetryPipelineExecutionRequest.Builder.() -> Unit) = retryPipelineExecution(RetryPipelineExecutionRequest.Builder().apply(block).build())

    /**
     * Finds Amazon SageMaker resources that match a search query. Matching resources are returned as a list of `SearchRecord` objects in the response. You can sort the search results by any resource property in a ascending or descending order.
     *
     * You can query against the following value types: numeric, text, Boolean, and timestamp.
     */
    suspend fun search(input: SearchRequest): SearchResponse

    /**
     * Finds Amazon SageMaker resources that match a search query. Matching resources are returned as a list of `SearchRecord` objects in the response. You can sort the search results by any resource property in a ascending or descending order.
     *
     * You can query against the following value types: numeric, text, Boolean, and timestamp.
     */
    suspend fun search(block: SearchRequest.Builder.() -> Unit) = search(SearchRequest.Builder().apply(block).build())

    /**
     * Notifies the pipeline that the execution of a callback step failed, along with a message describing why. When a callback step is run, the pipeline generates a callback token and includes the token in a message sent to Amazon Simple Queue Service (Amazon SQS).
     */
    suspend fun sendPipelineExecutionStepFailure(input: SendPipelineExecutionStepFailureRequest): SendPipelineExecutionStepFailureResponse

    /**
     * Notifies the pipeline that the execution of a callback step failed, along with a message describing why. When a callback step is run, the pipeline generates a callback token and includes the token in a message sent to Amazon Simple Queue Service (Amazon SQS).
     */
    suspend fun sendPipelineExecutionStepFailure(block: SendPipelineExecutionStepFailureRequest.Builder.() -> Unit) = sendPipelineExecutionStepFailure(SendPipelineExecutionStepFailureRequest.Builder().apply(block).build())

    /**
     * Notifies the pipeline that the execution of a callback step succeeded and provides a list of the step's output parameters. When a callback step is run, the pipeline generates a callback token and includes the token in a message sent to Amazon Simple Queue Service (Amazon SQS).
     */
    suspend fun sendPipelineExecutionStepSuccess(input: SendPipelineExecutionStepSuccessRequest): SendPipelineExecutionStepSuccessResponse

    /**
     * Notifies the pipeline that the execution of a callback step succeeded and provides a list of the step's output parameters. When a callback step is run, the pipeline generates a callback token and includes the token in a message sent to Amazon Simple Queue Service (Amazon SQS).
     */
    suspend fun sendPipelineExecutionStepSuccess(block: SendPipelineExecutionStepSuccessRequest.Builder.() -> Unit) = sendPipelineExecutionStepSuccess(SendPipelineExecutionStepSuccessRequest.Builder().apply(block).build())

    /**
     * Starts a previously stopped monitoring schedule.
     *
     * By default, when you successfully create a new schedule, the status of a monitoring schedule is `scheduled`.
     */
    suspend fun startMonitoringSchedule(input: StartMonitoringScheduleRequest): StartMonitoringScheduleResponse

    /**
     * Starts a previously stopped monitoring schedule.
     *
     * By default, when you successfully create a new schedule, the status of a monitoring schedule is `scheduled`.
     */
    suspend fun startMonitoringSchedule(block: StartMonitoringScheduleRequest.Builder.() -> Unit) = startMonitoringSchedule(StartMonitoringScheduleRequest.Builder().apply(block).build())

    /**
     * Launches an ML compute instance with the latest version of the libraries and attaches your ML storage volume. After configuring the notebook instance, SageMaker sets the notebook instance status to `InService`. A notebook instance's status must be `InService` before you can connect to your Jupyter notebook.
     */
    suspend fun startNotebookInstance(input: StartNotebookInstanceRequest): StartNotebookInstanceResponse

    /**
     * Launches an ML compute instance with the latest version of the libraries and attaches your ML storage volume. After configuring the notebook instance, SageMaker sets the notebook instance status to `InService`. A notebook instance's status must be `InService` before you can connect to your Jupyter notebook.
     */
    suspend fun startNotebookInstance(block: StartNotebookInstanceRequest.Builder.() -> Unit) = startNotebookInstance(StartNotebookInstanceRequest.Builder().apply(block).build())

    /**
     * Starts a pipeline execution.
     */
    suspend fun startPipelineExecution(input: StartPipelineExecutionRequest): StartPipelineExecutionResponse

    /**
     * Starts a pipeline execution.
     */
    suspend fun startPipelineExecution(block: StartPipelineExecutionRequest.Builder.() -> Unit) = startPipelineExecution(StartPipelineExecutionRequest.Builder().apply(block).build())

    /**
     * A method for forcing the termination of a running job.
     */
    suspend fun stopAutoMlJob(input: StopAutoMlJobRequest): StopAutoMlJobResponse

    /**
     * A method for forcing the termination of a running job.
     */
    suspend fun stopAutoMlJob(block: StopAutoMlJobRequest.Builder.() -> Unit) = stopAutoMlJob(StopAutoMlJobRequest.Builder().apply(block).build())

    /**
     * Stops a model compilation job.
     *
     *  To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal. This gracefully shuts the job down. If the job hasn't stopped, it sends the SIGKILL signal.
     *
     * When it receives a `StopCompilationJob` request, Amazon SageMaker changes the CompilationJobSummary$CompilationJobStatus of the job to `Stopping`. After Amazon SageMaker stops the job, it sets the CompilationJobSummary$CompilationJobStatus to `Stopped`.
     */
    suspend fun stopCompilationJob(input: StopCompilationJobRequest): StopCompilationJobResponse

    /**
     * Stops a model compilation job.
     *
     *  To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal. This gracefully shuts the job down. If the job hasn't stopped, it sends the SIGKILL signal.
     *
     * When it receives a `StopCompilationJob` request, Amazon SageMaker changes the CompilationJobSummary$CompilationJobStatus of the job to `Stopping`. After Amazon SageMaker stops the job, it sets the CompilationJobSummary$CompilationJobStatus to `Stopped`.
     */
    suspend fun stopCompilationJob(block: StopCompilationJobRequest.Builder.() -> Unit) = stopCompilationJob(StopCompilationJobRequest.Builder().apply(block).build())

    /**
     * Request to stop an edge packaging job.
     */
    suspend fun stopEdgePackagingJob(input: StopEdgePackagingJobRequest): StopEdgePackagingJobResponse

    /**
     * Request to stop an edge packaging job.
     */
    suspend fun stopEdgePackagingJob(block: StopEdgePackagingJobRequest.Builder.() -> Unit) = stopEdgePackagingJob(StopEdgePackagingJobRequest.Builder().apply(block).build())

    /**
     * Stops a running hyperparameter tuning job and all running training jobs that the tuning job launched.
     *
     * All model artifacts output from the training jobs are stored in Amazon Simple Storage Service (Amazon S3). All data that the training jobs write to Amazon CloudWatch Logs are still available in CloudWatch. After the tuning job moves to the `Stopped` state, it releases all reserved resources for the tuning job.
     */
    suspend fun stopHyperParameterTuningJob(input: StopHyperParameterTuningJobRequest): StopHyperParameterTuningJobResponse

    /**
     * Stops a running hyperparameter tuning job and all running training jobs that the tuning job launched.
     *
     * All model artifacts output from the training jobs are stored in Amazon Simple Storage Service (Amazon S3). All data that the training jobs write to Amazon CloudWatch Logs are still available in CloudWatch. After the tuning job moves to the `Stopped` state, it releases all reserved resources for the tuning job.
     */
    suspend fun stopHyperParameterTuningJob(block: StopHyperParameterTuningJobRequest.Builder.() -> Unit) = stopHyperParameterTuningJob(StopHyperParameterTuningJobRequest.Builder().apply(block).build())

    /**
     * Stops an Inference Recommender job.
     */
    suspend fun stopInferenceRecommendationsJob(input: StopInferenceRecommendationsJobRequest): StopInferenceRecommendationsJobResponse

    /**
     * Stops an Inference Recommender job.
     */
    suspend fun stopInferenceRecommendationsJob(block: StopInferenceRecommendationsJobRequest.Builder.() -> Unit) = stopInferenceRecommendationsJob(StopInferenceRecommendationsJobRequest.Builder().apply(block).build())

    /**
     * Stops a running labeling job. A job that is stopped cannot be restarted. Any results obtained before the job is stopped are placed in the Amazon S3 output bucket.
     */
    suspend fun stopLabelingJob(input: StopLabelingJobRequest): StopLabelingJobResponse

    /**
     * Stops a running labeling job. A job that is stopped cannot be restarted. Any results obtained before the job is stopped are placed in the Amazon S3 output bucket.
     */
    suspend fun stopLabelingJob(block: StopLabelingJobRequest.Builder.() -> Unit) = stopLabelingJob(StopLabelingJobRequest.Builder().apply(block).build())

    /**
     * Stops a previously started monitoring schedule.
     */
    suspend fun stopMonitoringSchedule(input: StopMonitoringScheduleRequest): StopMonitoringScheduleResponse

    /**
     * Stops a previously started monitoring schedule.
     */
    suspend fun stopMonitoringSchedule(block: StopMonitoringScheduleRequest.Builder.() -> Unit) = stopMonitoringSchedule(StopMonitoringScheduleRequest.Builder().apply(block).build())

    /**
     * Terminates the ML compute instance. Before terminating the instance, SageMaker disconnects the ML storage volume from it. SageMaker preserves the ML storage volume. SageMaker stops charging you for the ML compute instance when you call `StopNotebookInstance`.
     *
     * To access data on the ML storage volume for a notebook instance that has been terminated, call the `StartNotebookInstance` API. `StartNotebookInstance` launches another ML compute instance, configures it, and attaches the preserved ML storage volume so you can continue your work.
     */
    suspend fun stopNotebookInstance(input: StopNotebookInstanceRequest): StopNotebookInstanceResponse

    /**
     * Terminates the ML compute instance. Before terminating the instance, SageMaker disconnects the ML storage volume from it. SageMaker preserves the ML storage volume. SageMaker stops charging you for the ML compute instance when you call `StopNotebookInstance`.
     *
     * To access data on the ML storage volume for a notebook instance that has been terminated, call the `StartNotebookInstance` API. `StartNotebookInstance` launches another ML compute instance, configures it, and attaches the preserved ML storage volume so you can continue your work.
     */
    suspend fun stopNotebookInstance(block: StopNotebookInstanceRequest.Builder.() -> Unit) = stopNotebookInstance(StopNotebookInstanceRequest.Builder().apply(block).build())

    /**
     * Stops a pipeline execution.
     *
     * **Callback Step**
     *
     * A pipeline execution won't stop while a callback step is running. When you call `StopPipelineExecution` on a pipeline execution with a running callback step, SageMaker Pipelines sends an additional Amazon SQS message to the specified SQS queue. The body of the SQS message contains a "Status" field which is set to "Stopping".
     *
     * You should add logic to your Amazon SQS message consumer to take any needed action (for example, resource cleanup) upon receipt of the message followed by a call to `SendPipelineExecutionStepSuccess` or `SendPipelineExecutionStepFailure`.
     *
     * Only when SageMaker Pipelines receives one of these calls will it stop the pipeline execution.
     *
     * **Lambda Step**
     *
     * A pipeline execution can't be stopped while a lambda step is running because the Lambda function invoked by the lambda step can't be stopped. If you attempt to stop the execution while the Lambda function is running, the pipeline waits for the Lambda function to finish or until the timeout is hit, whichever occurs first, and then stops. If the Lambda function finishes, the pipeline execution status is `Stopped`. If the timeout is hit the pipeline execution status is `Failed`.
     */
    suspend fun stopPipelineExecution(input: StopPipelineExecutionRequest): StopPipelineExecutionResponse

    /**
     * Stops a pipeline execution.
     *
     * **Callback Step**
     *
     * A pipeline execution won't stop while a callback step is running. When you call `StopPipelineExecution` on a pipeline execution with a running callback step, SageMaker Pipelines sends an additional Amazon SQS message to the specified SQS queue. The body of the SQS message contains a "Status" field which is set to "Stopping".
     *
     * You should add logic to your Amazon SQS message consumer to take any needed action (for example, resource cleanup) upon receipt of the message followed by a call to `SendPipelineExecutionStepSuccess` or `SendPipelineExecutionStepFailure`.
     *
     * Only when SageMaker Pipelines receives one of these calls will it stop the pipeline execution.
     *
     * **Lambda Step**
     *
     * A pipeline execution can't be stopped while a lambda step is running because the Lambda function invoked by the lambda step can't be stopped. If you attempt to stop the execution while the Lambda function is running, the pipeline waits for the Lambda function to finish or until the timeout is hit, whichever occurs first, and then stops. If the Lambda function finishes, the pipeline execution status is `Stopped`. If the timeout is hit the pipeline execution status is `Failed`.
     */
    suspend fun stopPipelineExecution(block: StopPipelineExecutionRequest.Builder.() -> Unit) = stopPipelineExecution(StopPipelineExecutionRequest.Builder().apply(block).build())

    /**
     * Stops a processing job.
     */
    suspend fun stopProcessingJob(input: StopProcessingJobRequest): StopProcessingJobResponse

    /**
     * Stops a processing job.
     */
    suspend fun stopProcessingJob(block: StopProcessingJobRequest.Builder.() -> Unit) = stopProcessingJob(StopProcessingJobRequest.Builder().apply(block).build())

    /**
     * Stops a training job. To stop a job, SageMaker sends the algorithm the `SIGTERM` signal, which delays job termination for 120 seconds. Algorithms might use this 120-second window to save the model artifacts, so the results of the training is not lost.
     *
     * When it receives a `StopTrainingJob` request, SageMaker changes the status of the job to `Stopping`. After SageMaker stops the job, it sets the status to `Stopped`.
     */
    suspend fun stopTrainingJob(input: StopTrainingJobRequest): StopTrainingJobResponse

    /**
     * Stops a training job. To stop a job, SageMaker sends the algorithm the `SIGTERM` signal, which delays job termination for 120 seconds. Algorithms might use this 120-second window to save the model artifacts, so the results of the training is not lost.
     *
     * When it receives a `StopTrainingJob` request, SageMaker changes the status of the job to `Stopping`. After SageMaker stops the job, it sets the status to `Stopped`.
     */
    suspend fun stopTrainingJob(block: StopTrainingJobRequest.Builder.() -> Unit) = stopTrainingJob(StopTrainingJobRequest.Builder().apply(block).build())

    /**
     * Stops a batch transform job.
     *
     * When Amazon SageMaker receives a `StopTransformJob` request, the status of the job changes to `Stopping`. After Amazon SageMaker stops the job, the status is set to `Stopped`. When you stop a batch transform job before it is completed, Amazon SageMaker doesn't store the job's output in Amazon S3.
     */
    suspend fun stopTransformJob(input: StopTransformJobRequest): StopTransformJobResponse

    /**
     * Stops a batch transform job.
     *
     * When Amazon SageMaker receives a `StopTransformJob` request, the status of the job changes to `Stopping`. After Amazon SageMaker stops the job, the status is set to `Stopped`. When you stop a batch transform job before it is completed, Amazon SageMaker doesn't store the job's output in Amazon S3.
     */
    suspend fun stopTransformJob(block: StopTransformJobRequest.Builder.() -> Unit) = stopTransformJob(StopTransformJobRequest.Builder().apply(block).build())

    /**
     * Updates an action.
     */
    suspend fun updateAction(input: UpdateActionRequest): UpdateActionResponse

    /**
     * Updates an action.
     */
    suspend fun updateAction(block: UpdateActionRequest.Builder.() -> Unit) = updateAction(UpdateActionRequest.Builder().apply(block).build())

    /**
     * Updates the properties of an AppImageConfig.
     */
    suspend fun updateAppImageConfig(input: UpdateAppImageConfigRequest): UpdateAppImageConfigResponse

    /**
     * Updates the properties of an AppImageConfig.
     */
    suspend fun updateAppImageConfig(block: UpdateAppImageConfigRequest.Builder.() -> Unit) = updateAppImageConfig(UpdateAppImageConfigRequest.Builder().apply(block).build())

    /**
     * Updates an artifact.
     */
    suspend fun updateArtifact(input: UpdateArtifactRequest): UpdateArtifactResponse

    /**
     * Updates an artifact.
     */
    suspend fun updateArtifact(block: UpdateArtifactRequest.Builder.() -> Unit) = updateArtifact(UpdateArtifactRequest.Builder().apply(block).build())

    /**
     * Updates the specified Git repository with the specified values.
     */
    suspend fun updateCodeRepository(input: UpdateCodeRepositoryRequest): UpdateCodeRepositoryResponse

    /**
     * Updates the specified Git repository with the specified values.
     */
    suspend fun updateCodeRepository(block: UpdateCodeRepositoryRequest.Builder.() -> Unit) = updateCodeRepository(UpdateCodeRepositoryRequest.Builder().apply(block).build())

    /**
     * Updates a context.
     */
    suspend fun updateContext(input: UpdateContextRequest): UpdateContextResponse

    /**
     * Updates a context.
     */
    suspend fun updateContext(block: UpdateContextRequest.Builder.() -> Unit) = updateContext(UpdateContextRequest.Builder().apply(block).build())

    /**
     * Updates a fleet of devices.
     */
    suspend fun updateDeviceFleet(input: UpdateDeviceFleetRequest): UpdateDeviceFleetResponse

    /**
     * Updates a fleet of devices.
     */
    suspend fun updateDeviceFleet(block: UpdateDeviceFleetRequest.Builder.() -> Unit) = updateDeviceFleet(UpdateDeviceFleetRequest.Builder().apply(block).build())

    /**
     * Updates one or more devices in a fleet.
     */
    suspend fun updateDevices(input: UpdateDevicesRequest): UpdateDevicesResponse

    /**
     * Updates one or more devices in a fleet.
     */
    suspend fun updateDevices(block: UpdateDevicesRequest.Builder.() -> Unit) = updateDevices(UpdateDevicesRequest.Builder().apply(block).build())

    /**
     * Updates the default settings for new user profiles in the domain.
     */
    suspend fun updateDomain(input: UpdateDomainRequest): UpdateDomainResponse

    /**
     * Updates the default settings for new user profiles in the domain.
     */
    suspend fun updateDomain(block: UpdateDomainRequest.Builder.() -> Unit) = updateDomain(UpdateDomainRequest.Builder().apply(block).build())

    /**
     * Deploys the new `EndpointConfig` specified in the request, switches to using newly created endpoint, and then deletes resources provisioned for the endpoint using the previous `EndpointConfig` (there is no availability loss).
     *
     * When SageMaker receives the request, it sets the endpoint status to `Updating`. After updating the endpoint, it sets the status to `InService`. To check the status of an endpoint, use the DescribeEndpoint API.
     *
     * You must not delete an `EndpointConfig` in use by an endpoint that is live or while the `UpdateEndpoint` or `CreateEndpoint` operations are being performed on the endpoint. To update an endpoint, you must create a new `EndpointConfig`.
     *
     * If you delete the `EndpointConfig` of an endpoint that is active or being created or updated you may lose visibility into the instance type the endpoint is using. The endpoint must be deleted in order to stop incurring charges.
     */
    suspend fun updateEndpoint(input: UpdateEndpointRequest): UpdateEndpointResponse

    /**
     * Deploys the new `EndpointConfig` specified in the request, switches to using newly created endpoint, and then deletes resources provisioned for the endpoint using the previous `EndpointConfig` (there is no availability loss).
     *
     * When SageMaker receives the request, it sets the endpoint status to `Updating`. After updating the endpoint, it sets the status to `InService`. To check the status of an endpoint, use the DescribeEndpoint API.
     *
     * You must not delete an `EndpointConfig` in use by an endpoint that is live or while the `UpdateEndpoint` or `CreateEndpoint` operations are being performed on the endpoint. To update an endpoint, you must create a new `EndpointConfig`.
     *
     * If you delete the `EndpointConfig` of an endpoint that is active or being created or updated you may lose visibility into the instance type the endpoint is using. The endpoint must be deleted in order to stop incurring charges.
     */
    suspend fun updateEndpoint(block: UpdateEndpointRequest.Builder.() -> Unit) = updateEndpoint(UpdateEndpointRequest.Builder().apply(block).build())

    /**
     * Updates variant weight of one or more variants associated with an existing endpoint, or capacity of one variant associated with an existing endpoint. When it receives the request, SageMaker sets the endpoint status to `Updating`. After updating the endpoint, it sets the status to `InService`. To check the status of an endpoint, use the DescribeEndpoint API.
     */
    suspend fun updateEndpointWeightsAndCapacities(input: UpdateEndpointWeightsAndCapacitiesRequest): UpdateEndpointWeightsAndCapacitiesResponse

    /**
     * Updates variant weight of one or more variants associated with an existing endpoint, or capacity of one variant associated with an existing endpoint. When it receives the request, SageMaker sets the endpoint status to `Updating`. After updating the endpoint, it sets the status to `InService`. To check the status of an endpoint, use the DescribeEndpoint API.
     */
    suspend fun updateEndpointWeightsAndCapacities(block: UpdateEndpointWeightsAndCapacitiesRequest.Builder.() -> Unit) = updateEndpointWeightsAndCapacities(UpdateEndpointWeightsAndCapacitiesRequest.Builder().apply(block).build())

    /**
     * Adds, updates, or removes the description of an experiment. Updates the display name of an experiment.
     */
    suspend fun updateExperiment(input: UpdateExperimentRequest): UpdateExperimentResponse

    /**
     * Adds, updates, or removes the description of an experiment. Updates the display name of an experiment.
     */
    suspend fun updateExperiment(block: UpdateExperimentRequest.Builder.() -> Unit) = updateExperiment(UpdateExperimentRequest.Builder().apply(block).build())

    /**
     * Updates the properties of a SageMaker image. To change the image's tags, use the AddTags and DeleteTags APIs.
     */
    suspend fun updateImage(input: UpdateImageRequest): UpdateImageResponse

    /**
     * Updates the properties of a SageMaker image. To change the image's tags, use the AddTags and DeleteTags APIs.
     */
    suspend fun updateImage(block: UpdateImageRequest.Builder.() -> Unit) = updateImage(UpdateImageRequest.Builder().apply(block).build())

    /**
     * Updates a versioned model.
     */
    suspend fun updateModelPackage(input: UpdateModelPackageRequest): UpdateModelPackageResponse

    /**
     * Updates a versioned model.
     */
    suspend fun updateModelPackage(block: UpdateModelPackageRequest.Builder.() -> Unit) = updateModelPackage(UpdateModelPackageRequest.Builder().apply(block).build())

    /**
     * Updates a previously created schedule.
     */
    suspend fun updateMonitoringSchedule(input: UpdateMonitoringScheduleRequest): UpdateMonitoringScheduleResponse

    /**
     * Updates a previously created schedule.
     */
    suspend fun updateMonitoringSchedule(block: UpdateMonitoringScheduleRequest.Builder.() -> Unit) = updateMonitoringSchedule(UpdateMonitoringScheduleRequest.Builder().apply(block).build())

    /**
     * Updates a notebook instance. NotebookInstance updates include upgrading or downgrading the ML compute instance used for your notebook instance to accommodate changes in your workload requirements.
     */
    suspend fun updateNotebookInstance(input: UpdateNotebookInstanceRequest): UpdateNotebookInstanceResponse

    /**
     * Updates a notebook instance. NotebookInstance updates include upgrading or downgrading the ML compute instance used for your notebook instance to accommodate changes in your workload requirements.
     */
    suspend fun updateNotebookInstance(block: UpdateNotebookInstanceRequest.Builder.() -> Unit) = updateNotebookInstance(UpdateNotebookInstanceRequest.Builder().apply(block).build())

    /**
     * Updates a notebook instance lifecycle configuration created with the CreateNotebookInstanceLifecycleConfig API.
     */
    suspend fun updateNotebookInstanceLifecycleConfig(input: UpdateNotebookInstanceLifecycleConfigRequest): UpdateNotebookInstanceLifecycleConfigResponse

    /**
     * Updates a notebook instance lifecycle configuration created with the CreateNotebookInstanceLifecycleConfig API.
     */
    suspend fun updateNotebookInstanceLifecycleConfig(block: UpdateNotebookInstanceLifecycleConfigRequest.Builder.() -> Unit) = updateNotebookInstanceLifecycleConfig(UpdateNotebookInstanceLifecycleConfigRequest.Builder().apply(block).build())

    /**
     * Updates a pipeline.
     */
    suspend fun updatePipeline(input: UpdatePipelineRequest): UpdatePipelineResponse

    /**
     * Updates a pipeline.
     */
    suspend fun updatePipeline(block: UpdatePipelineRequest.Builder.() -> Unit) = updatePipeline(UpdatePipelineRequest.Builder().apply(block).build())

    /**
     * Updates a pipeline execution.
     */
    suspend fun updatePipelineExecution(input: UpdatePipelineExecutionRequest): UpdatePipelineExecutionResponse

    /**
     * Updates a pipeline execution.
     */
    suspend fun updatePipelineExecution(block: UpdatePipelineExecutionRequest.Builder.() -> Unit) = updatePipelineExecution(UpdatePipelineExecutionRequest.Builder().apply(block).build())

    /**
     * Updates a machine learning (ML) project that is created from a template that sets up an ML pipeline from training to deploying an approved model.
     *
     * You must not update a project that is in use. If you update the `ServiceCatalogProvisioningUpdateDetails` of a project that is active or being created, or updated, you may lose resources already created by the project.
     */
    suspend fun updateProject(input: UpdateProjectRequest): UpdateProjectResponse

    /**
     * Updates a machine learning (ML) project that is created from a template that sets up an ML pipeline from training to deploying an approved model.
     *
     * You must not update a project that is in use. If you update the `ServiceCatalogProvisioningUpdateDetails` of a project that is active or being created, or updated, you may lose resources already created by the project.
     */
    suspend fun updateProject(block: UpdateProjectRequest.Builder.() -> Unit) = updateProject(UpdateProjectRequest.Builder().apply(block).build())

    /**
     * Update a model training job to request a new Debugger profiling configuration.
     */
    suspend fun updateTrainingJob(input: UpdateTrainingJobRequest): UpdateTrainingJobResponse

    /**
     * Update a model training job to request a new Debugger profiling configuration.
     */
    suspend fun updateTrainingJob(block: UpdateTrainingJobRequest.Builder.() -> Unit) = updateTrainingJob(UpdateTrainingJobRequest.Builder().apply(block).build())

    /**
     * Updates the display name of a trial.
     */
    suspend fun updateTrial(input: UpdateTrialRequest): UpdateTrialResponse

    /**
     * Updates the display name of a trial.
     */
    suspend fun updateTrial(block: UpdateTrialRequest.Builder.() -> Unit) = updateTrial(UpdateTrialRequest.Builder().apply(block).build())

    /**
     * Updates one or more properties of a trial component.
     */
    suspend fun updateTrialComponent(input: UpdateTrialComponentRequest): UpdateTrialComponentResponse

    /**
     * Updates one or more properties of a trial component.
     */
    suspend fun updateTrialComponent(block: UpdateTrialComponentRequest.Builder.() -> Unit) = updateTrialComponent(UpdateTrialComponentRequest.Builder().apply(block).build())

    /**
     * Updates a user profile.
     */
    suspend fun updateUserProfile(input: UpdateUserProfileRequest): UpdateUserProfileResponse

    /**
     * Updates a user profile.
     */
    suspend fun updateUserProfile(block: UpdateUserProfileRequest.Builder.() -> Unit) = updateUserProfile(UpdateUserProfileRequest.Builder().apply(block).build())

    /**
     * Use this operation to update your workforce. You can use this operation to require that workers use specific IP addresses to work on tasks and to update your OpenID Connect (OIDC) Identity Provider (IdP) workforce configuration.
     *
     *  Use `SourceIpConfig` to restrict worker access to tasks to a specific range of IP addresses. You specify allowed IP addresses by creating a list of up to ten [CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html). By default, a workforce isn't restricted to specific IP addresses. If you specify a range of IP addresses, workers who attempt to access tasks using any IP address outside the specified range are denied and get a `Not Found` error message on the worker portal.
     *
     * Use `OidcConfig` to update the configuration of a workforce created using your own OIDC IdP.
     *
     * You can only update your OIDC IdP configuration when there are no work teams associated with your workforce. You can delete work teams using the operation.
     *
     * After restricting access to a range of IP addresses or updating your OIDC IdP configuration with this operation, you can view details about your update workforce using the operation.
     *
     * This operation only applies to private workforces.
     */
    suspend fun updateWorkforce(input: UpdateWorkforceRequest): UpdateWorkforceResponse

    /**
     * Use this operation to update your workforce. You can use this operation to require that workers use specific IP addresses to work on tasks and to update your OpenID Connect (OIDC) Identity Provider (IdP) workforce configuration.
     *
     *  Use `SourceIpConfig` to restrict worker access to tasks to a specific range of IP addresses. You specify allowed IP addresses by creating a list of up to ten [CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html). By default, a workforce isn't restricted to specific IP addresses. If you specify a range of IP addresses, workers who attempt to access tasks using any IP address outside the specified range are denied and get a `Not Found` error message on the worker portal.
     *
     * Use `OidcConfig` to update the configuration of a workforce created using your own OIDC IdP.
     *
     * You can only update your OIDC IdP configuration when there are no work teams associated with your workforce. You can delete work teams using the operation.
     *
     * After restricting access to a range of IP addresses or updating your OIDC IdP configuration with this operation, you can view details about your update workforce using the operation.
     *
     * This operation only applies to private workforces.
     */
    suspend fun updateWorkforce(block: UpdateWorkforceRequest.Builder.() -> Unit) = updateWorkforce(UpdateWorkforceRequest.Builder().apply(block).build())

    /**
     * Updates an existing work team with new member definitions or description.
     */
    suspend fun updateWorkteam(input: UpdateWorkteamRequest): UpdateWorkteamResponse

    /**
     * Updates an existing work team with new member definitions or description.
     */
    suspend fun updateWorkteam(block: UpdateWorkteamRequest.Builder.() -> Unit) = updateWorkteam(UpdateWorkteamRequest.Builder().apply(block).build())
}
