// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



class AddAssociationRequest private constructor(builder: Builder) {
    /**
     * The type of association. The following are suggested uses for each type. Amazon SageMaker places no restrictions on their use.
     * + ContributedTo - The source contributed to the destination or had a part in enabling the destination. For example, the training data contributed to the training job.
     * + AssociatedWith - The source is connected to the destination. For example, an approval workflow is associated with a model deployment.
     * + DerivedFrom - The destination is a modification of the source. For example, a digest output of a channel input for a processing job is derived from the original inputs.
     * + Produced - The source generated the destination. For example, a training job produced a model artifact.
     */
    val associationType: aws.sdk.kotlin.services.sagemaker.model.AssociationEdgeType? = builder.associationType
    /**
     * The Amazon Resource Name (ARN) of the destination.
     */
    val destinationArn: kotlin.String? = builder.destinationArn
    /**
     * The ARN of the source.
     */
    val sourceArn: kotlin.String? = builder.sourceArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.AddAssociationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AddAssociationRequest(")
        append("associationType=$associationType,")
        append("destinationArn=$destinationArn,")
        append("sourceArn=$sourceArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationType?.hashCode() ?: 0
        result = 31 * result + (destinationArn?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AddAssociationRequest

        if (associationType != other.associationType) return false
        if (destinationArn != other.destinationArn) return false
        if (sourceArn != other.sourceArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.AddAssociationRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The type of association. The following are suggested uses for each type. Amazon SageMaker places no restrictions on their use.
         * + ContributedTo - The source contributed to the destination or had a part in enabling the destination. For example, the training data contributed to the training job.
         * + AssociatedWith - The source is connected to the destination. For example, an approval workflow is associated with a model deployment.
         * + DerivedFrom - The destination is a modification of the source. For example, a digest output of a channel input for a processing job is derived from the original inputs.
         * + Produced - The source generated the destination. For example, a training job produced a model artifact.
         */
        var associationType: aws.sdk.kotlin.services.sagemaker.model.AssociationEdgeType? = null
        /**
         * The Amazon Resource Name (ARN) of the destination.
         */
        var destinationArn: kotlin.String? = null
        /**
         * The ARN of the source.
         */
        var sourceArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.AddAssociationRequest) : this() {
            this.associationType = x.associationType
            this.destinationArn = x.destinationArn
            this.sourceArn = x.sourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.AddAssociationRequest = AddAssociationRequest(this)
    }
}
