// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Lists a summary of the properties of an artifact. An artifact represents a URI addressable object or data. Some examples are a dataset and a model.
 */
class ArtifactSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the artifact.
     */
    val artifactArn: kotlin.String? = builder.artifactArn
    /**
     * The name of the artifact.
     */
    val artifactName: kotlin.String? = builder.artifactName
    /**
     * The type of the artifact.
     */
    val artifactType: kotlin.String? = builder.artifactType
    /**
     * When the artifact was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * When the artifact was last modified.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The source of the artifact.
     */
    val source: aws.sdk.kotlin.services.sagemaker.model.ArtifactSource? = builder.source

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ArtifactSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ArtifactSummary(")
        append("artifactArn=$artifactArn,")
        append("artifactName=$artifactName,")
        append("artifactType=$artifactType,")
        append("creationTime=$creationTime,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("source=$source)")
    }

    override fun hashCode(): kotlin.Int {
        var result = artifactArn?.hashCode() ?: 0
        result = 31 * result + (artifactName?.hashCode() ?: 0)
        result = 31 * result + (artifactType?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ArtifactSummary

        if (artifactArn != other.artifactArn) return false
        if (artifactName != other.artifactName) return false
        if (artifactType != other.artifactType) return false
        if (creationTime != other.creationTime) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (source != other.source) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ArtifactSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the artifact.
         */
        var artifactArn: kotlin.String? = null
        /**
         * The name of the artifact.
         */
        var artifactName: kotlin.String? = null
        /**
         * The type of the artifact.
         */
        var artifactType: kotlin.String? = null
        /**
         * When the artifact was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * When the artifact was last modified.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The source of the artifact.
         */
        var source: aws.sdk.kotlin.services.sagemaker.model.ArtifactSource? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ArtifactSummary) : this() {
            this.artifactArn = x.artifactArn
            this.artifactName = x.artifactName
            this.artifactType = x.artifactType
            this.creationTime = x.creationTime
            this.lastModifiedTime = x.lastModifiedTime
            this.source = x.source
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ArtifactSummary = ArtifactSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ArtifactSource] inside the given [block]
         */
        fun source(block: aws.sdk.kotlin.services.sagemaker.model.ArtifactSource.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.sagemaker.model.ArtifactSource.invoke(block)
        }
    }
}
