// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a candidate produced by an AutoML training job, including its status, steps, and other properties.
 */
class AutoMlCandidate private constructor(builder: Builder) {
    /**
     * The name of the candidate.
     */
    val candidateName: kotlin.String? = builder.candidateName
    /**
     * The properties of an AutoML candidate job.
     */
    val candidateProperties: aws.sdk.kotlin.services.sagemaker.model.CandidateProperties? = builder.candidateProperties
    /**
     * The candidate's status.
     */
    val candidateStatus: aws.sdk.kotlin.services.sagemaker.model.CandidateStatus? = builder.candidateStatus
    /**
     * Information about the candidate's steps.
     */
    val candidateSteps: List<AutoMlCandidateStep>? = builder.candidateSteps
    /**
     * The creation time.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The end time.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The failure reason.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * The best candidate result from an AutoML training job.
     */
    val finalAutoMlJobObjectiveMetric: aws.sdk.kotlin.services.sagemaker.model.FinalAutoMlJobObjectiveMetric? = builder.finalAutoMlJobObjectiveMetric
    /**
     * Information about the inference container definitions.
     */
    val inferenceContainers: List<AutoMlContainerDefinition>? = builder.inferenceContainers
    /**
     * The last modified time.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The objective's status.
     */
    val objectiveStatus: aws.sdk.kotlin.services.sagemaker.model.ObjectiveStatus? = builder.objectiveStatus

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.AutoMlCandidate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoMlCandidate(")
        append("candidateName=$candidateName,")
        append("candidateProperties=$candidateProperties,")
        append("candidateStatus=$candidateStatus,")
        append("candidateSteps=$candidateSteps,")
        append("creationTime=$creationTime,")
        append("endTime=$endTime,")
        append("failureReason=$failureReason,")
        append("finalAutoMlJobObjectiveMetric=$finalAutoMlJobObjectiveMetric,")
        append("inferenceContainers=$inferenceContainers,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("objectiveStatus=$objectiveStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = candidateName?.hashCode() ?: 0
        result = 31 * result + (candidateProperties?.hashCode() ?: 0)
        result = 31 * result + (candidateStatus?.hashCode() ?: 0)
        result = 31 * result + (candidateSteps?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (finalAutoMlJobObjectiveMetric?.hashCode() ?: 0)
        result = 31 * result + (inferenceContainers?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (objectiveStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoMlCandidate

        if (candidateName != other.candidateName) return false
        if (candidateProperties != other.candidateProperties) return false
        if (candidateStatus != other.candidateStatus) return false
        if (candidateSteps != other.candidateSteps) return false
        if (creationTime != other.creationTime) return false
        if (endTime != other.endTime) return false
        if (failureReason != other.failureReason) return false
        if (finalAutoMlJobObjectiveMetric != other.finalAutoMlJobObjectiveMetric) return false
        if (inferenceContainers != other.inferenceContainers) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (objectiveStatus != other.objectiveStatus) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.AutoMlCandidate = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the candidate.
         */
        var candidateName: kotlin.String? = null
        /**
         * The properties of an AutoML candidate job.
         */
        var candidateProperties: aws.sdk.kotlin.services.sagemaker.model.CandidateProperties? = null
        /**
         * The candidate's status.
         */
        var candidateStatus: aws.sdk.kotlin.services.sagemaker.model.CandidateStatus? = null
        /**
         * Information about the candidate's steps.
         */
        var candidateSteps: List<AutoMlCandidateStep>? = null
        /**
         * The creation time.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The end time.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The failure reason.
         */
        var failureReason: kotlin.String? = null
        /**
         * The best candidate result from an AutoML training job.
         */
        var finalAutoMlJobObjectiveMetric: aws.sdk.kotlin.services.sagemaker.model.FinalAutoMlJobObjectiveMetric? = null
        /**
         * Information about the inference container definitions.
         */
        var inferenceContainers: List<AutoMlContainerDefinition>? = null
        /**
         * The last modified time.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The objective's status.
         */
        var objectiveStatus: aws.sdk.kotlin.services.sagemaker.model.ObjectiveStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.AutoMlCandidate) : this() {
            this.candidateName = x.candidateName
            this.candidateProperties = x.candidateProperties
            this.candidateStatus = x.candidateStatus
            this.candidateSteps = x.candidateSteps
            this.creationTime = x.creationTime
            this.endTime = x.endTime
            this.failureReason = x.failureReason
            this.finalAutoMlJobObjectiveMetric = x.finalAutoMlJobObjectiveMetric
            this.inferenceContainers = x.inferenceContainers
            this.lastModifiedTime = x.lastModifiedTime
            this.objectiveStatus = x.objectiveStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.AutoMlCandidate = AutoMlCandidate(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.CandidateProperties] inside the given [block]
         */
        fun candidateProperties(block: aws.sdk.kotlin.services.sagemaker.model.CandidateProperties.Builder.() -> kotlin.Unit) {
            this.candidateProperties = aws.sdk.kotlin.services.sagemaker.model.CandidateProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.FinalAutoMlJobObjectiveMetric] inside the given [block]
         */
        fun finalAutoMlJobObjectiveMetric(block: aws.sdk.kotlin.services.sagemaker.model.FinalAutoMlJobObjectiveMetric.Builder.() -> kotlin.Unit) {
            this.finalAutoMlJobObjectiveMetric = aws.sdk.kotlin.services.sagemaker.model.FinalAutoMlJobObjectiveMetric.invoke(block)
        }
    }
}
