// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Update policy for a blue/green deployment. If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default.
 */
class BlueGreenUpdatePolicy private constructor(builder: Builder) {
    /**
     * Maximum execution timeout for the deployment. Note that the timeout value should be larger than the total waiting time specified in `TerminationWaitInSeconds` and `WaitIntervalInSeconds`.
     */
    val maximumExecutionTimeoutInSeconds: kotlin.Int? = builder.maximumExecutionTimeoutInSeconds
    /**
     * Additional waiting time in seconds after the completion of an endpoint deployment before terminating the old endpoint fleet. Default is 0.
     */
    val terminationWaitInSeconds: kotlin.Int? = builder.terminationWaitInSeconds
    /**
     * Defines the traffic routing strategy to shift traffic from the old fleet to the new fleet during an endpoint deployment.
     */
    val trafficRoutingConfiguration: aws.sdk.kotlin.services.sagemaker.model.TrafficRoutingConfig? = builder.trafficRoutingConfiguration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.BlueGreenUpdatePolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BlueGreenUpdatePolicy(")
        append("maximumExecutionTimeoutInSeconds=$maximumExecutionTimeoutInSeconds,")
        append("terminationWaitInSeconds=$terminationWaitInSeconds,")
        append("trafficRoutingConfiguration=$trafficRoutingConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maximumExecutionTimeoutInSeconds ?: 0
        result = 31 * result + (terminationWaitInSeconds ?: 0)
        result = 31 * result + (trafficRoutingConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BlueGreenUpdatePolicy

        if (maximumExecutionTimeoutInSeconds != other.maximumExecutionTimeoutInSeconds) return false
        if (terminationWaitInSeconds != other.terminationWaitInSeconds) return false
        if (trafficRoutingConfiguration != other.trafficRoutingConfiguration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.BlueGreenUpdatePolicy = Builder(this).apply(block).build()

    class Builder {
        /**
         * Maximum execution timeout for the deployment. Note that the timeout value should be larger than the total waiting time specified in `TerminationWaitInSeconds` and `WaitIntervalInSeconds`.
         */
        var maximumExecutionTimeoutInSeconds: kotlin.Int? = null
        /**
         * Additional waiting time in seconds after the completion of an endpoint deployment before terminating the old endpoint fleet. Default is 0.
         */
        var terminationWaitInSeconds: kotlin.Int? = null
        /**
         * Defines the traffic routing strategy to shift traffic from the old fleet to the new fleet during an endpoint deployment.
         */
        var trafficRoutingConfiguration: aws.sdk.kotlin.services.sagemaker.model.TrafficRoutingConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.BlueGreenUpdatePolicy) : this() {
            this.maximumExecutionTimeoutInSeconds = x.maximumExecutionTimeoutInSeconds
            this.terminationWaitInSeconds = x.terminationWaitInSeconds
            this.trafficRoutingConfiguration = x.trafficRoutingConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.BlueGreenUpdatePolicy = BlueGreenUpdatePolicy(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TrafficRoutingConfig] inside the given [block]
         */
        fun trafficRoutingConfiguration(block: aws.sdk.kotlin.services.sagemaker.model.TrafficRoutingConfig.Builder.() -> kotlin.Unit) {
            this.trafficRoutingConfiguration = aws.sdk.kotlin.services.sagemaker.model.TrafficRoutingConfig.invoke(block)
        }
    }
}
