// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Defines a named input source, called a channel, to be used by an algorithm.
 */
class ChannelSpecification private constructor(builder: Builder) {
    /**
     * A brief description of the channel.
     */
    val description: kotlin.String? = builder.description
    /**
     * Indicates whether the channel is required by the algorithm.
     */
    val isRequired: kotlin.Boolean = builder.isRequired
    /**
     * The name of the channel.
     */
    val name: kotlin.String? = builder.name
    /**
     * The allowed compression types, if data compression is used.
     */
    val supportedCompressionTypes: List<CompressionType>? = builder.supportedCompressionTypes
    /**
     * The supported MIME types for the data.
     */
    val supportedContentTypes: List<String>? = builder.supportedContentTypes
    /**
     * The allowed input mode, either FILE or PIPE.
     *
     * In FILE mode, Amazon SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS) volumes before starting your training algorithm. This is the most commonly used input mode.
     *
     * In PIPE mode, Amazon SageMaker streams input data from the source directly to your algorithm without using the EBS volume.
     */
    val supportedInputModes: List<TrainingInputMode>? = builder.supportedInputModes

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ChannelSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChannelSpecification(")
        append("description=$description,")
        append("isRequired=$isRequired,")
        append("name=$name,")
        append("supportedCompressionTypes=$supportedCompressionTypes,")
        append("supportedContentTypes=$supportedContentTypes,")
        append("supportedInputModes=$supportedInputModes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (isRequired.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (supportedCompressionTypes?.hashCode() ?: 0)
        result = 31 * result + (supportedContentTypes?.hashCode() ?: 0)
        result = 31 * result + (supportedInputModes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChannelSpecification

        if (description != other.description) return false
        if (isRequired != other.isRequired) return false
        if (name != other.name) return false
        if (supportedCompressionTypes != other.supportedCompressionTypes) return false
        if (supportedContentTypes != other.supportedContentTypes) return false
        if (supportedInputModes != other.supportedInputModes) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ChannelSpecification = Builder(this).apply(block).build()

    class Builder {
        /**
         * A brief description of the channel.
         */
        var description: kotlin.String? = null
        /**
         * Indicates whether the channel is required by the algorithm.
         */
        var isRequired: kotlin.Boolean = false
        /**
         * The name of the channel.
         */
        var name: kotlin.String? = null
        /**
         * The allowed compression types, if data compression is used.
         */
        var supportedCompressionTypes: List<CompressionType>? = null
        /**
         * The supported MIME types for the data.
         */
        var supportedContentTypes: List<String>? = null
        /**
         * The allowed input mode, either FILE or PIPE.
         *
         * In FILE mode, Amazon SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS) volumes before starting your training algorithm. This is the most commonly used input mode.
         *
         * In PIPE mode, Amazon SageMaker streams input data from the source directly to your algorithm without using the EBS volume.
         */
        var supportedInputModes: List<TrainingInputMode>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ChannelSpecification) : this() {
            this.description = x.description
            this.isRequired = x.isRequired
            this.name = x.name
            this.supportedCompressionTypes = x.supportedCompressionTypes
            this.supportedContentTypes = x.supportedContentTypes
            this.supportedInputModes = x.supportedInputModes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ChannelSpecification = ChannelSpecification(this)
    }
}
