// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Describes the container, as part of model definition.
 */
class ContainerDefinition private constructor(builder: Builder) {
    /**
     * This parameter is ignored for models that contain only a `PrimaryContainer`.
     *
     * When a `ContainerDefinition` is part of an inference pipeline, the value of the parameter uniquely identifies the container for the purposes of logging and metrics. For information, see [Use Logs and Metrics to Monitor an Inference Pipeline](https://docs.aws.amazon.com/sagemaker/latest/dg/inference-pipeline-logs-metrics.html). If you don't specify a value for this parameter for a `ContainerDefinition` that is part of an inference pipeline, a unique name is automatically assigned based on the position of the `ContainerDefinition` in the pipeline. If you specify a value for the `ContainerHostName` for any `ContainerDefinition` that is part of an inference pipeline, you must specify a value for the `ContainerHostName` parameter of every `ContainerDefinition` in that pipeline.
     */
    val containerHostname: kotlin.String? = builder.containerHostname
    /**
     * The environment variables to set in the Docker container. Each key and value in the `Environment` string to string map can have length of up to 1024. We support up to 16 entries in the map.
     */
    val environment: Map<String, String>? = builder.environment
    /**
     * The path where inference code is stored. This can be either in Amazon EC2 Container Registry or in a Docker registry that is accessible from the same VPC that you configure for your endpoint. If you are using your own custom algorithm instead of an algorithm provided by SageMaker, the inference code must meet SageMaker requirements. SageMaker supports both `registry/repository[:tag]` and `registry/repository[@digest]` image path formats. For more information, see [Using Your Own Algorithms with Amazon SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html)
     */
    val image: kotlin.String? = builder.image
    /**
     * Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). For information about storing containers in a private Docker registry, see [Use a Private Docker Registry for Real-Time Inference Containers](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-containers-inference-private.html)
     */
    val imageConfig: aws.sdk.kotlin.services.sagemaker.model.ImageConfig? = builder.imageConfig
    /**
     * The inference specification name in the model package version.
     */
    val inferenceSpecificationName: kotlin.String? = builder.inferenceSpecificationName
    /**
     * Whether the container hosts a single model or multiple models.
     */
    val mode: aws.sdk.kotlin.services.sagemaker.model.ContainerMode? = builder.mode
    /**
     * The S3 path where the model artifacts, which result from model training, are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix). The S3 path is required for SageMaker built-in algorithms, but not if you use your own algorithms. For more information on built-in algorithms, see [Common Parameters](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html).
     *
     * The model artifacts must be in an S3 bucket that is in the same region as the model or endpoint you are creating.
     *
     * If you provide a value for this parameter, SageMaker uses Amazon Web Services Security Token Service to download model artifacts from the S3 path you provide. Amazon Web Services STS is activated in your IAM user account by default. If you previously deactivated Amazon Web Services STS for a region, you need to reactivate Amazon Web Services STS for that region. For more information, see [Activating and Deactivating Amazon Web Services STS in an Amazon Web Services Region](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html) in the *Amazon Web Services Identity and Access Management User Guide*.
     *
     * If you use a built-in algorithm to create a model, SageMaker requires that you provide a S3 path to the model artifacts in `ModelDataUrl`.
     */
    val modelDataUrl: kotlin.String? = builder.modelDataUrl
    /**
     * The name or Amazon Resource Name (ARN) of the model package to use to create the model.
     */
    val modelPackageName: kotlin.String? = builder.modelPackageName
    /**
     * Specifies additional configuration for multi-model endpoints.
     */
    val multiModelConfig: aws.sdk.kotlin.services.sagemaker.model.MultiModelConfig? = builder.multiModelConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ContainerDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerDefinition(")
        append("containerHostname=$containerHostname,")
        append("environment=$environment,")
        append("image=$image,")
        append("imageConfig=$imageConfig,")
        append("inferenceSpecificationName=$inferenceSpecificationName,")
        append("mode=$mode,")
        append("modelDataUrl=$modelDataUrl,")
        append("modelPackageName=$modelPackageName,")
        append("multiModelConfig=$multiModelConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerHostname?.hashCode() ?: 0
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (image?.hashCode() ?: 0)
        result = 31 * result + (imageConfig?.hashCode() ?: 0)
        result = 31 * result + (inferenceSpecificationName?.hashCode() ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (modelDataUrl?.hashCode() ?: 0)
        result = 31 * result + (modelPackageName?.hashCode() ?: 0)
        result = 31 * result + (multiModelConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerDefinition

        if (containerHostname != other.containerHostname) return false
        if (environment != other.environment) return false
        if (image != other.image) return false
        if (imageConfig != other.imageConfig) return false
        if (inferenceSpecificationName != other.inferenceSpecificationName) return false
        if (mode != other.mode) return false
        if (modelDataUrl != other.modelDataUrl) return false
        if (modelPackageName != other.modelPackageName) return false
        if (multiModelConfig != other.multiModelConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ContainerDefinition = Builder(this).apply(block).build()

    class Builder {
        /**
         * This parameter is ignored for models that contain only a `PrimaryContainer`.
         *
         * When a `ContainerDefinition` is part of an inference pipeline, the value of the parameter uniquely identifies the container for the purposes of logging and metrics. For information, see [Use Logs and Metrics to Monitor an Inference Pipeline](https://docs.aws.amazon.com/sagemaker/latest/dg/inference-pipeline-logs-metrics.html). If you don't specify a value for this parameter for a `ContainerDefinition` that is part of an inference pipeline, a unique name is automatically assigned based on the position of the `ContainerDefinition` in the pipeline. If you specify a value for the `ContainerHostName` for any `ContainerDefinition` that is part of an inference pipeline, you must specify a value for the `ContainerHostName` parameter of every `ContainerDefinition` in that pipeline.
         */
        var containerHostname: kotlin.String? = null
        /**
         * The environment variables to set in the Docker container. Each key and value in the `Environment` string to string map can have length of up to 1024. We support up to 16 entries in the map.
         */
        var environment: Map<String, String>? = null
        /**
         * The path where inference code is stored. This can be either in Amazon EC2 Container Registry or in a Docker registry that is accessible from the same VPC that you configure for your endpoint. If you are using your own custom algorithm instead of an algorithm provided by SageMaker, the inference code must meet SageMaker requirements. SageMaker supports both `registry/repository[:tag]` and `registry/repository[@digest]` image path formats. For more information, see [Using Your Own Algorithms with Amazon SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html)
         */
        var image: kotlin.String? = null
        /**
         * Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). For information about storing containers in a private Docker registry, see [Use a Private Docker Registry for Real-Time Inference Containers](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-containers-inference-private.html)
         */
        var imageConfig: aws.sdk.kotlin.services.sagemaker.model.ImageConfig? = null
        /**
         * The inference specification name in the model package version.
         */
        var inferenceSpecificationName: kotlin.String? = null
        /**
         * Whether the container hosts a single model or multiple models.
         */
        var mode: aws.sdk.kotlin.services.sagemaker.model.ContainerMode? = null
        /**
         * The S3 path where the model artifacts, which result from model training, are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix). The S3 path is required for SageMaker built-in algorithms, but not if you use your own algorithms. For more information on built-in algorithms, see [Common Parameters](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html).
         *
         * The model artifacts must be in an S3 bucket that is in the same region as the model or endpoint you are creating.
         *
         * If you provide a value for this parameter, SageMaker uses Amazon Web Services Security Token Service to download model artifacts from the S3 path you provide. Amazon Web Services STS is activated in your IAM user account by default. If you previously deactivated Amazon Web Services STS for a region, you need to reactivate Amazon Web Services STS for that region. For more information, see [Activating and Deactivating Amazon Web Services STS in an Amazon Web Services Region](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html) in the *Amazon Web Services Identity and Access Management User Guide*.
         *
         * If you use a built-in algorithm to create a model, SageMaker requires that you provide a S3 path to the model artifacts in `ModelDataUrl`.
         */
        var modelDataUrl: kotlin.String? = null
        /**
         * The name or Amazon Resource Name (ARN) of the model package to use to create the model.
         */
        var modelPackageName: kotlin.String? = null
        /**
         * Specifies additional configuration for multi-model endpoints.
         */
        var multiModelConfig: aws.sdk.kotlin.services.sagemaker.model.MultiModelConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ContainerDefinition) : this() {
            this.containerHostname = x.containerHostname
            this.environment = x.environment
            this.image = x.image
            this.imageConfig = x.imageConfig
            this.inferenceSpecificationName = x.inferenceSpecificationName
            this.mode = x.mode
            this.modelDataUrl = x.modelDataUrl
            this.modelPackageName = x.modelPackageName
            this.multiModelConfig = x.multiModelConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ContainerDefinition = ContainerDefinition(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ImageConfig] inside the given [block]
         */
        fun imageConfig(block: aws.sdk.kotlin.services.sagemaker.model.ImageConfig.Builder.() -> kotlin.Unit) {
            this.imageConfig = aws.sdk.kotlin.services.sagemaker.model.ImageConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MultiModelConfig] inside the given [block]
         */
        fun multiModelConfig(block: aws.sdk.kotlin.services.sagemaker.model.MultiModelConfig.Builder.() -> kotlin.Unit) {
            this.multiModelConfig = aws.sdk.kotlin.services.sagemaker.model.MultiModelConfig.invoke(block)
        }
    }
}
