// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



class CreateProcessingJobRequest private constructor(builder: Builder) {
    /**
     * Configures the processing job to run a specified Docker container image.
     */
    val appSpecification: aws.sdk.kotlin.services.sagemaker.model.AppSpecification? = builder.appSpecification
    /**
     * The environment variables to set in the Docker container. Up to 100 key and values entries in the map are supported.
     */
    val environment: Map<String, String>? = builder.environment
    /**
     * Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:
     * + CreateProcessingJob
     * + CreateTrainingJob
     * + CreateTransformJob
     */
    val experimentConfig: aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig? = builder.experimentConfig
    /**
     * Networking options for a processing job, such as whether to allow inbound and outbound network calls to and from processing containers, and the VPC subnets and security groups to use for VPC-enabled processing jobs.
     */
    val networkConfig: aws.sdk.kotlin.services.sagemaker.model.NetworkConfig? = builder.networkConfig
    /**
     * An array of inputs configuring the data to download into the processing container.
     */
    val processingInputs: List<ProcessingInput>? = builder.processingInputs
    /**
     * The name of the processing job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.
     */
    val processingJobName: kotlin.String? = builder.processingJobName
    /**
     * Output configuration for the processing job.
     */
    val processingOutputConfig: aws.sdk.kotlin.services.sagemaker.model.ProcessingOutputConfig? = builder.processingOutputConfig
    /**
     * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.
     */
    val processingResources: aws.sdk.kotlin.services.sagemaker.model.ProcessingResources? = builder.processingResources
    /**
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The time limit for how long the processing job is allowed to run.
     */
    val stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.ProcessingStoppingCondition? = builder.stoppingCondition
    /**
     * (Optional) An array of key-value pairs. For more information, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL) in the *Amazon Web Services Billing and Cost Management User Guide*.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateProcessingJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateProcessingJobRequest(")
        append("appSpecification=$appSpecification,")
        append("environment=$environment,")
        append("experimentConfig=$experimentConfig,")
        append("networkConfig=$networkConfig,")
        append("processingInputs=$processingInputs,")
        append("processingJobName=$processingJobName,")
        append("processingOutputConfig=$processingOutputConfig,")
        append("processingResources=$processingResources,")
        append("roleArn=$roleArn,")
        append("stoppingCondition=$stoppingCondition,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appSpecification?.hashCode() ?: 0
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (experimentConfig?.hashCode() ?: 0)
        result = 31 * result + (networkConfig?.hashCode() ?: 0)
        result = 31 * result + (processingInputs?.hashCode() ?: 0)
        result = 31 * result + (processingJobName?.hashCode() ?: 0)
        result = 31 * result + (processingOutputConfig?.hashCode() ?: 0)
        result = 31 * result + (processingResources?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (stoppingCondition?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateProcessingJobRequest

        if (appSpecification != other.appSpecification) return false
        if (environment != other.environment) return false
        if (experimentConfig != other.experimentConfig) return false
        if (networkConfig != other.networkConfig) return false
        if (processingInputs != other.processingInputs) return false
        if (processingJobName != other.processingJobName) return false
        if (processingOutputConfig != other.processingOutputConfig) return false
        if (processingResources != other.processingResources) return false
        if (roleArn != other.roleArn) return false
        if (stoppingCondition != other.stoppingCondition) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateProcessingJobRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Configures the processing job to run a specified Docker container image.
         */
        var appSpecification: aws.sdk.kotlin.services.sagemaker.model.AppSpecification? = null
        /**
         * The environment variables to set in the Docker container. Up to 100 key and values entries in the map are supported.
         */
        var environment: Map<String, String>? = null
        /**
         * Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:
         * + CreateProcessingJob
         * + CreateTrainingJob
         * + CreateTransformJob
         */
        var experimentConfig: aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig? = null
        /**
         * Networking options for a processing job, such as whether to allow inbound and outbound network calls to and from processing containers, and the VPC subnets and security groups to use for VPC-enabled processing jobs.
         */
        var networkConfig: aws.sdk.kotlin.services.sagemaker.model.NetworkConfig? = null
        /**
         * An array of inputs configuring the data to download into the processing container.
         */
        var processingInputs: List<ProcessingInput>? = null
        /**
         * The name of the processing job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.
         */
        var processingJobName: kotlin.String? = null
        /**
         * Output configuration for the processing job.
         */
        var processingOutputConfig: aws.sdk.kotlin.services.sagemaker.model.ProcessingOutputConfig? = null
        /**
         * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.
         */
        var processingResources: aws.sdk.kotlin.services.sagemaker.model.ProcessingResources? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
         */
        var roleArn: kotlin.String? = null
        /**
         * The time limit for how long the processing job is allowed to run.
         */
        var stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.ProcessingStoppingCondition? = null
        /**
         * (Optional) An array of key-value pairs. For more information, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL) in the *Amazon Web Services Billing and Cost Management User Guide*.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateProcessingJobRequest) : this() {
            this.appSpecification = x.appSpecification
            this.environment = x.environment
            this.experimentConfig = x.experimentConfig
            this.networkConfig = x.networkConfig
            this.processingInputs = x.processingInputs
            this.processingJobName = x.processingJobName
            this.processingOutputConfig = x.processingOutputConfig
            this.processingResources = x.processingResources
            this.roleArn = x.roleArn
            this.stoppingCondition = x.stoppingCondition
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateProcessingJobRequest = CreateProcessingJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AppSpecification] inside the given [block]
         */
        fun appSpecification(block: aws.sdk.kotlin.services.sagemaker.model.AppSpecification.Builder.() -> kotlin.Unit) {
            this.appSpecification = aws.sdk.kotlin.services.sagemaker.model.AppSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig] inside the given [block]
         */
        fun experimentConfig(block: aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig.Builder.() -> kotlin.Unit) {
            this.experimentConfig = aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.NetworkConfig] inside the given [block]
         */
        fun networkConfig(block: aws.sdk.kotlin.services.sagemaker.model.NetworkConfig.Builder.() -> kotlin.Unit) {
            this.networkConfig = aws.sdk.kotlin.services.sagemaker.model.NetworkConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProcessingOutputConfig] inside the given [block]
         */
        fun processingOutputConfig(block: aws.sdk.kotlin.services.sagemaker.model.ProcessingOutputConfig.Builder.() -> kotlin.Unit) {
            this.processingOutputConfig = aws.sdk.kotlin.services.sagemaker.model.ProcessingOutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProcessingResources] inside the given [block]
         */
        fun processingResources(block: aws.sdk.kotlin.services.sagemaker.model.ProcessingResources.Builder.() -> kotlin.Unit) {
            this.processingResources = aws.sdk.kotlin.services.sagemaker.model.ProcessingResources.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProcessingStoppingCondition] inside the given [block]
         */
        fun stoppingCondition(block: aws.sdk.kotlin.services.sagemaker.model.ProcessingStoppingCondition.Builder.() -> kotlin.Unit) {
            this.stoppingCondition = aws.sdk.kotlin.services.sagemaker.model.ProcessingStoppingCondition.invoke(block)
        }
    }
}
