// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

class CreateTrialComponentRequest private constructor(builder: Builder) {
    /**
     * The name of the component as displayed. The name doesn't need to be unique. If `DisplayName` isn't specified, `TrialComponentName` is displayed.
     */
    val displayName: kotlin.String? = builder.displayName
    /**
     * When the component ended.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The input artifacts for the component. Examples of input artifacts are datasets, algorithms, hyperparameters, source code, and instance types.
     */
    val inputArtifacts: Map<String, TrialComponentArtifact>? = builder.inputArtifacts
    /**
     * Metadata properties of the tracking entity, trial, or trial component.
     */
    val metadataProperties: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties? = builder.metadataProperties
    /**
     * The output artifacts for the component. Examples of output artifacts are metrics, snapshots, logs, and images.
     */
    val outputArtifacts: Map<String, TrialComponentArtifact>? = builder.outputArtifacts
    /**
     * The hyperparameters for the component.
     */
    val parameters: Map<String, TrialComponentParameterValue>? = builder.parameters
    /**
     * When the component started.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The status of the component. States include:
     * + InProgress
     * + Completed
     * + Failed
     */
    val status: aws.sdk.kotlin.services.sagemaker.model.TrialComponentStatus? = builder.status
    /**
     * A list of tags to associate with the component. You can use Search API to search on the tags.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The name of the component. The name must be unique in your Amazon Web Services account and is not case-sensitive.
     */
    val trialComponentName: kotlin.String? = builder.trialComponentName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateTrialComponentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTrialComponentRequest(")
        append("displayName=$displayName,")
        append("endTime=$endTime,")
        append("inputArtifacts=$inputArtifacts,")
        append("metadataProperties=$metadataProperties,")
        append("outputArtifacts=$outputArtifacts,")
        append("parameters=$parameters,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("tags=$tags,")
        append("trialComponentName=$trialComponentName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = displayName?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (inputArtifacts?.hashCode() ?: 0)
        result = 31 * result + (metadataProperties?.hashCode() ?: 0)
        result = 31 * result + (outputArtifacts?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trialComponentName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTrialComponentRequest

        if (displayName != other.displayName) return false
        if (endTime != other.endTime) return false
        if (inputArtifacts != other.inputArtifacts) return false
        if (metadataProperties != other.metadataProperties) return false
        if (outputArtifacts != other.outputArtifacts) return false
        if (parameters != other.parameters) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (trialComponentName != other.trialComponentName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateTrialComponentRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the component as displayed. The name doesn't need to be unique. If `DisplayName` isn't specified, `TrialComponentName` is displayed.
         */
        var displayName: kotlin.String? = null
        /**
         * When the component ended.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The input artifacts for the component. Examples of input artifacts are datasets, algorithms, hyperparameters, source code, and instance types.
         */
        var inputArtifacts: Map<String, TrialComponentArtifact>? = null
        /**
         * Metadata properties of the tracking entity, trial, or trial component.
         */
        var metadataProperties: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties? = null
        /**
         * The output artifacts for the component. Examples of output artifacts are metrics, snapshots, logs, and images.
         */
        var outputArtifacts: Map<String, TrialComponentArtifact>? = null
        /**
         * The hyperparameters for the component.
         */
        var parameters: Map<String, TrialComponentParameterValue>? = null
        /**
         * When the component started.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the component. States include:
         * + InProgress
         * + Completed
         * + Failed
         */
        var status: aws.sdk.kotlin.services.sagemaker.model.TrialComponentStatus? = null
        /**
         * A list of tags to associate with the component. You can use Search API to search on the tags.
         */
        var tags: List<Tag>? = null
        /**
         * The name of the component. The name must be unique in your Amazon Web Services account and is not case-sensitive.
         */
        var trialComponentName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateTrialComponentRequest) : this() {
            this.displayName = x.displayName
            this.endTime = x.endTime
            this.inputArtifacts = x.inputArtifacts
            this.metadataProperties = x.metadataProperties
            this.outputArtifacts = x.outputArtifacts
            this.parameters = x.parameters
            this.startTime = x.startTime
            this.status = x.status
            this.tags = x.tags
            this.trialComponentName = x.trialComponentName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateTrialComponentRequest = CreateTrialComponentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MetadataProperties] inside the given [block]
         */
        fun metadataProperties(block: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties.Builder.() -> kotlin.Unit) {
            this.metadataProperties = aws.sdk.kotlin.services.sagemaker.model.MetadataProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TrialComponentStatus] inside the given [block]
         */
        fun status(block: aws.sdk.kotlin.services.sagemaker.model.TrialComponentStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.sagemaker.model.TrialComponentStatus.invoke(block)
        }
    }
}
