// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Configuration to control how SageMaker captures inference data.
 */
class DataCaptureConfig private constructor(builder: Builder) {
    /**
     * Configuration specifying how to treat different headers. If no headers are specified SageMaker will by default base64 encode when capturing the data.
     */
    val captureContentTypeHeader: aws.sdk.kotlin.services.sagemaker.model.CaptureContentTypeHeader? = builder.captureContentTypeHeader
    /**
     * Specifies data Model Monitor will capture. You can configure whether to collect only input, only output, or both
     */
    val captureOptions: List<CaptureOption>? = builder.captureOptions
    /**
     * The Amazon S3 location used to capture the data.
     */
    val destinationS3Uri: kotlin.String? = builder.destinationS3Uri
    /**
     * Whether data capture should be enabled or disabled (defaults to enabled).
     */
    val enableCapture: kotlin.Boolean = builder.enableCapture
    /**
     * The percentage of requests SageMaker will capture. A lower value is recommended for Endpoints with high traffic.
     */
    val initialSamplingPercentage: kotlin.Int? = builder.initialSamplingPercentage
    /**
     * The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
     *
     * The KmsKeyId can be any of the following formats:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Alias name: `alias/ExampleAlias`
     * + Alias name ARN: `arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias`
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataCaptureConfig(")
        append("captureContentTypeHeader=$captureContentTypeHeader,")
        append("captureOptions=$captureOptions,")
        append("destinationS3Uri=$destinationS3Uri,")
        append("enableCapture=$enableCapture,")
        append("initialSamplingPercentage=$initialSamplingPercentage,")
        append("kmsKeyId=$kmsKeyId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = captureContentTypeHeader?.hashCode() ?: 0
        result = 31 * result + (captureOptions?.hashCode() ?: 0)
        result = 31 * result + (destinationS3Uri?.hashCode() ?: 0)
        result = 31 * result + (enableCapture.hashCode())
        result = 31 * result + (initialSamplingPercentage ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataCaptureConfig

        if (captureContentTypeHeader != other.captureContentTypeHeader) return false
        if (captureOptions != other.captureOptions) return false
        if (destinationS3Uri != other.destinationS3Uri) return false
        if (enableCapture != other.enableCapture) return false
        if (initialSamplingPercentage != other.initialSamplingPercentage) return false
        if (kmsKeyId != other.kmsKeyId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * Configuration specifying how to treat different headers. If no headers are specified SageMaker will by default base64 encode when capturing the data.
         */
        var captureContentTypeHeader: aws.sdk.kotlin.services.sagemaker.model.CaptureContentTypeHeader? = null
        /**
         * Specifies data Model Monitor will capture. You can configure whether to collect only input, only output, or both
         */
        var captureOptions: List<CaptureOption>? = null
        /**
         * The Amazon S3 location used to capture the data.
         */
        var destinationS3Uri: kotlin.String? = null
        /**
         * Whether data capture should be enabled or disabled (defaults to enabled).
         */
        var enableCapture: kotlin.Boolean = false
        /**
         * The percentage of requests SageMaker will capture. A lower value is recommended for Endpoints with high traffic.
         */
        var initialSamplingPercentage: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
         *
         * The KmsKeyId can be any of the following formats:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Alias name: `alias/ExampleAlias`
         * + Alias name ARN: `arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias`
         */
        var kmsKeyId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfig) : this() {
            this.captureContentTypeHeader = x.captureContentTypeHeader
            this.captureOptions = x.captureOptions
            this.destinationS3Uri = x.destinationS3Uri
            this.enableCapture = x.enableCapture
            this.initialSamplingPercentage = x.initialSamplingPercentage
            this.kmsKeyId = x.kmsKeyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfig = DataCaptureConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.CaptureContentTypeHeader] inside the given [block]
         */
        fun captureContentTypeHeader(block: aws.sdk.kotlin.services.sagemaker.model.CaptureContentTypeHeader.Builder.() -> kotlin.Unit) {
            this.captureContentTypeHeader = aws.sdk.kotlin.services.sagemaker.model.CaptureContentTypeHeader.invoke(block)
        }
    }
}
