// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Configuration for Dataset Definition inputs. The Dataset Definition input must specify exactly one of either `AthenaDatasetDefinition` or `RedshiftDatasetDefinition` types.
 */
class DatasetDefinition private constructor(builder: Builder) {
    /**
     * Configuration for Athena Dataset Definition input.
     */
    val athenaDatasetDefinition: aws.sdk.kotlin.services.sagemaker.model.AthenaDatasetDefinition? = builder.athenaDatasetDefinition
    /**
     * Whether the generated dataset is `FullyReplicated` or `ShardedByS3Key` (default).
     */
    val dataDistributionType: aws.sdk.kotlin.services.sagemaker.model.DataDistributionType? = builder.dataDistributionType
    /**
     * Whether to use `File` or `Pipe` input mode. In `File` (default) mode, Amazon SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS) volumes before starting your training algorithm. This is the most commonly used input mode. In `Pipe` mode, Amazon SageMaker streams input data from the source directly to your algorithm without using the EBS volume.
     */
    val inputMode: aws.sdk.kotlin.services.sagemaker.model.InputMode? = builder.inputMode
    /**
     * The local path where you want Amazon SageMaker to download the Dataset Definition inputs to run a processing job. `LocalPath` is an absolute path to the input data. This is a required parameter when `AppManaged` is `False` (default).
     */
    val localPath: kotlin.String? = builder.localPath
    /**
     * Configuration for Redshift Dataset Definition input.
     */
    val redshiftDatasetDefinition: aws.sdk.kotlin.services.sagemaker.model.RedshiftDatasetDefinition? = builder.redshiftDatasetDefinition

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DatasetDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetDefinition(")
        append("athenaDatasetDefinition=$athenaDatasetDefinition,")
        append("dataDistributionType=$dataDistributionType,")
        append("inputMode=$inputMode,")
        append("localPath=$localPath,")
        append("redshiftDatasetDefinition=$redshiftDatasetDefinition)")
    }

    override fun hashCode(): kotlin.Int {
        var result = athenaDatasetDefinition?.hashCode() ?: 0
        result = 31 * result + (dataDistributionType?.hashCode() ?: 0)
        result = 31 * result + (inputMode?.hashCode() ?: 0)
        result = 31 * result + (localPath?.hashCode() ?: 0)
        result = 31 * result + (redshiftDatasetDefinition?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatasetDefinition

        if (athenaDatasetDefinition != other.athenaDatasetDefinition) return false
        if (dataDistributionType != other.dataDistributionType) return false
        if (inputMode != other.inputMode) return false
        if (localPath != other.localPath) return false
        if (redshiftDatasetDefinition != other.redshiftDatasetDefinition) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DatasetDefinition = Builder(this).apply(block).build()

    class Builder {
        /**
         * Configuration for Athena Dataset Definition input.
         */
        var athenaDatasetDefinition: aws.sdk.kotlin.services.sagemaker.model.AthenaDatasetDefinition? = null
        /**
         * Whether the generated dataset is `FullyReplicated` or `ShardedByS3Key` (default).
         */
        var dataDistributionType: aws.sdk.kotlin.services.sagemaker.model.DataDistributionType? = null
        /**
         * Whether to use `File` or `Pipe` input mode. In `File` (default) mode, Amazon SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS) volumes before starting your training algorithm. This is the most commonly used input mode. In `Pipe` mode, Amazon SageMaker streams input data from the source directly to your algorithm without using the EBS volume.
         */
        var inputMode: aws.sdk.kotlin.services.sagemaker.model.InputMode? = null
        /**
         * The local path where you want Amazon SageMaker to download the Dataset Definition inputs to run a processing job. `LocalPath` is an absolute path to the input data. This is a required parameter when `AppManaged` is `False` (default).
         */
        var localPath: kotlin.String? = null
        /**
         * Configuration for Redshift Dataset Definition input.
         */
        var redshiftDatasetDefinition: aws.sdk.kotlin.services.sagemaker.model.RedshiftDatasetDefinition? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DatasetDefinition) : this() {
            this.athenaDatasetDefinition = x.athenaDatasetDefinition
            this.dataDistributionType = x.dataDistributionType
            this.inputMode = x.inputMode
            this.localPath = x.localPath
            this.redshiftDatasetDefinition = x.redshiftDatasetDefinition
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DatasetDefinition = DatasetDefinition(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AthenaDatasetDefinition] inside the given [block]
         */
        fun athenaDatasetDefinition(block: aws.sdk.kotlin.services.sagemaker.model.AthenaDatasetDefinition.Builder.() -> kotlin.Unit) {
            this.athenaDatasetDefinition = aws.sdk.kotlin.services.sagemaker.model.AthenaDatasetDefinition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.RedshiftDatasetDefinition] inside the given [block]
         */
        fun redshiftDatasetDefinition(block: aws.sdk.kotlin.services.sagemaker.model.RedshiftDatasetDefinition.Builder.() -> kotlin.Unit) {
            this.redshiftDatasetDefinition = aws.sdk.kotlin.services.sagemaker.model.RedshiftDatasetDefinition.invoke(block)
        }
    }
}
