// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeDomainResponse private constructor(builder: Builder) {
    /**
     * Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly`.
     * + `PublicInternetOnly` - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows direct internet access
     * + `VpcOnly` - All Studio traffic is through the specified VPC and subnets
     */
    val appNetworkAccessType: aws.sdk.kotlin.services.sagemaker.model.AppNetworkAccessType? = builder.appNetworkAccessType
    /**
     * The entity that creates and manages the required security groups for inter-app communication in `VPCOnly` mode. Required when `CreateDomain.AppNetworkAccessType` is `VPCOnly` and `DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn` is provided.
     */
    val appSecurityGroupManagement: aws.sdk.kotlin.services.sagemaker.model.AppSecurityGroupManagement? = builder.appSecurityGroupManagement
    /**
     * The domain's authentication mode.
     */
    val authMode: aws.sdk.kotlin.services.sagemaker.model.AuthMode? = builder.authMode
    /**
     * The creation time.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Settings which are applied to UserProfiles in this domain if settings are not explicitly specified in a given UserProfile.
     */
    val defaultUserSettings: aws.sdk.kotlin.services.sagemaker.model.UserSettings? = builder.defaultUserSettings
    /**
     * The domain's Amazon Resource Name (ARN).
     */
    val domainArn: kotlin.String? = builder.domainArn
    /**
     * The domain ID.
     */
    val domainId: kotlin.String? = builder.domainId
    /**
     * The domain name.
     */
    val domainName: kotlin.String? = builder.domainName
    /**
     * A collection of `Domain` settings.
     */
    val domainSettings: aws.sdk.kotlin.services.sagemaker.model.DomainSettings? = builder.domainSettings
    /**
     * The failure reason.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * The ID of the Amazon Elastic File System (EFS) managed by this Domain.
     */
    val homeEfsFileSystemId: kotlin.String? = builder.homeEfsFileSystemId
    /**
     * Use `KmsKeyId`.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    val homeEfsFileSystemKmsKeyId: kotlin.String? = builder.homeEfsFileSystemKmsKeyId
    /**
     * The Amazon Web Services KMS customer managed key used to encrypt the EFS volume attached to the domain.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The last modified time.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The ID of the security group that authorizes traffic between the `RSessionGateway` apps and the `RStudioServerPro` app.
     */
    val securityGroupIdForDomainBoundary: kotlin.String? = builder.securityGroupIdForDomainBoundary
    /**
     * The SSO managed application instance ID.
     */
    val singleSignOnManagedApplicationInstanceId: kotlin.String? = builder.singleSignOnManagedApplicationInstanceId
    /**
     * The status.
     */
    val status: aws.sdk.kotlin.services.sagemaker.model.DomainStatus? = builder.status
    /**
     * The VPC subnets that Studio uses for communication.
     */
    val subnetIds: List<String>? = builder.subnetIds
    /**
     * The domain's URL.
     */
    val url: kotlin.String? = builder.url
    /**
     * The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DescribeDomainResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDomainResponse(")
        append("appNetworkAccessType=$appNetworkAccessType,")
        append("appSecurityGroupManagement=$appSecurityGroupManagement,")
        append("authMode=$authMode,")
        append("creationTime=$creationTime,")
        append("defaultUserSettings=$defaultUserSettings,")
        append("domainArn=$domainArn,")
        append("domainId=$domainId,")
        append("domainName=$domainName,")
        append("domainSettings=$domainSettings,")
        append("failureReason=$failureReason,")
        append("homeEfsFileSystemId=$homeEfsFileSystemId,")
        append("homeEfsFileSystemKmsKeyId=$homeEfsFileSystemKmsKeyId,")
        append("kmsKeyId=$kmsKeyId,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("securityGroupIdForDomainBoundary=$securityGroupIdForDomainBoundary,")
        append("singleSignOnManagedApplicationInstanceId=$singleSignOnManagedApplicationInstanceId,")
        append("status=$status,")
        append("subnetIds=$subnetIds,")
        append("url=$url,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appNetworkAccessType?.hashCode() ?: 0
        result = 31 * result + (appSecurityGroupManagement?.hashCode() ?: 0)
        result = 31 * result + (authMode?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (defaultUserSettings?.hashCode() ?: 0)
        result = 31 * result + (domainArn?.hashCode() ?: 0)
        result = 31 * result + (domainId?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (domainSettings?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (homeEfsFileSystemId?.hashCode() ?: 0)
        result = 31 * result + (homeEfsFileSystemKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIdForDomainBoundary?.hashCode() ?: 0)
        result = 31 * result + (singleSignOnManagedApplicationInstanceId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDomainResponse

        if (appNetworkAccessType != other.appNetworkAccessType) return false
        if (appSecurityGroupManagement != other.appSecurityGroupManagement) return false
        if (authMode != other.authMode) return false
        if (creationTime != other.creationTime) return false
        if (defaultUserSettings != other.defaultUserSettings) return false
        if (domainArn != other.domainArn) return false
        if (domainId != other.domainId) return false
        if (domainName != other.domainName) return false
        if (domainSettings != other.domainSettings) return false
        if (failureReason != other.failureReason) return false
        if (homeEfsFileSystemId != other.homeEfsFileSystemId) return false
        if (homeEfsFileSystemKmsKeyId != other.homeEfsFileSystemKmsKeyId) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (securityGroupIdForDomainBoundary != other.securityGroupIdForDomainBoundary) return false
        if (singleSignOnManagedApplicationInstanceId != other.singleSignOnManagedApplicationInstanceId) return false
        if (status != other.status) return false
        if (subnetIds != other.subnetIds) return false
        if (url != other.url) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DescribeDomainResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly`.
         * + `PublicInternetOnly` - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows direct internet access
         * + `VpcOnly` - All Studio traffic is through the specified VPC and subnets
         */
        var appNetworkAccessType: aws.sdk.kotlin.services.sagemaker.model.AppNetworkAccessType? = null
        /**
         * The entity that creates and manages the required security groups for inter-app communication in `VPCOnly` mode. Required when `CreateDomain.AppNetworkAccessType` is `VPCOnly` and `DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn` is provided.
         */
        var appSecurityGroupManagement: aws.sdk.kotlin.services.sagemaker.model.AppSecurityGroupManagement? = null
        /**
         * The domain's authentication mode.
         */
        var authMode: aws.sdk.kotlin.services.sagemaker.model.AuthMode? = null
        /**
         * The creation time.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Settings which are applied to UserProfiles in this domain if settings are not explicitly specified in a given UserProfile.
         */
        var defaultUserSettings: aws.sdk.kotlin.services.sagemaker.model.UserSettings? = null
        /**
         * The domain's Amazon Resource Name (ARN).
         */
        var domainArn: kotlin.String? = null
        /**
         * The domain ID.
         */
        var domainId: kotlin.String? = null
        /**
         * The domain name.
         */
        var domainName: kotlin.String? = null
        /**
         * A collection of `Domain` settings.
         */
        var domainSettings: aws.sdk.kotlin.services.sagemaker.model.DomainSettings? = null
        /**
         * The failure reason.
         */
        var failureReason: kotlin.String? = null
        /**
         * The ID of the Amazon Elastic File System (EFS) managed by this Domain.
         */
        var homeEfsFileSystemId: kotlin.String? = null
        /**
         * Use `KmsKeyId`.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        var homeEfsFileSystemKmsKeyId: kotlin.String? = null
        /**
         * The Amazon Web Services KMS customer managed key used to encrypt the EFS volume attached to the domain.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The last modified time.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the security group that authorizes traffic between the `RSessionGateway` apps and the `RStudioServerPro` app.
         */
        var securityGroupIdForDomainBoundary: kotlin.String? = null
        /**
         * The SSO managed application instance ID.
         */
        var singleSignOnManagedApplicationInstanceId: kotlin.String? = null
        /**
         * The status.
         */
        var status: aws.sdk.kotlin.services.sagemaker.model.DomainStatus? = null
        /**
         * The VPC subnets that Studio uses for communication.
         */
        var subnetIds: List<String>? = null
        /**
         * The domain's URL.
         */
        var url: kotlin.String? = null
        /**
         * The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
         */
        var vpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DescribeDomainResponse) : this() {
            this.appNetworkAccessType = x.appNetworkAccessType
            this.appSecurityGroupManagement = x.appSecurityGroupManagement
            this.authMode = x.authMode
            this.creationTime = x.creationTime
            this.defaultUserSettings = x.defaultUserSettings
            this.domainArn = x.domainArn
            this.domainId = x.domainId
            this.domainName = x.domainName
            this.domainSettings = x.domainSettings
            this.failureReason = x.failureReason
            this.homeEfsFileSystemId = x.homeEfsFileSystemId
            this.homeEfsFileSystemKmsKeyId = x.homeEfsFileSystemKmsKeyId
            this.kmsKeyId = x.kmsKeyId
            this.lastModifiedTime = x.lastModifiedTime
            this.securityGroupIdForDomainBoundary = x.securityGroupIdForDomainBoundary
            this.singleSignOnManagedApplicationInstanceId = x.singleSignOnManagedApplicationInstanceId
            this.status = x.status
            this.subnetIds = x.subnetIds
            this.url = x.url
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DescribeDomainResponse = DescribeDomainResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserSettings] inside the given [block]
         */
        fun defaultUserSettings(block: aws.sdk.kotlin.services.sagemaker.model.UserSettings.Builder.() -> kotlin.Unit) {
            this.defaultUserSettings = aws.sdk.kotlin.services.sagemaker.model.UserSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DomainSettings] inside the given [block]
         */
        fun domainSettings(block: aws.sdk.kotlin.services.sagemaker.model.DomainSettings.Builder.() -> kotlin.Unit) {
            this.domainSettings = aws.sdk.kotlin.services.sagemaker.model.DomainSettings.invoke(block)
        }
    }
}
