// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Amazon SageMaker Feature Store stores features in a collection called Feature Group. A Feature Group can be visualized as a table which has rows, with a unique identifier for each row where each column in the table is a feature. In principle, a Feature Group is composed of features and values per features.
 */
class FeatureGroup private constructor(builder: Builder) {
    /**
     * The time a `FeatureGroup` was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * A free form description of a `FeatureGroup`.
     */
    val description: kotlin.String? = builder.description
    /**
     * The name of the feature that stores the `EventTime` of a Record in a `FeatureGroup`.
     *
     * A `EventTime` is point in time when a new event occurs that corresponds to the creation or update of a `Record` in `FeatureGroup`. All `Records` in the `FeatureGroup` must have a corresponding `EventTime`.
     */
    val eventTimeFeatureName: kotlin.String? = builder.eventTimeFeatureName
    /**
     * The reason that the `FeatureGroup` failed to be replicated in the `OfflineStore`. This is failure may be due to a failure to create a `FeatureGroup` in or delete a `FeatureGroup` from the `OfflineStore`.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * A list of `Feature`s. Each `Feature` must include a `FeatureName` and a `FeatureType`.
     *
     * Valid `FeatureType`s are `Integral`, `Fractional` and `String`.
     *
     * `FeatureName`s cannot be any of the following: `is_deleted`, `write_time`, `api_invocation_time`.
     *
     * You can create up to 2,500 `FeatureDefinition`s per `FeatureGroup`.
     */
    val featureDefinitions: List<FeatureDefinition>? = builder.featureDefinitions
    /**
     * The Amazon Resource Name (ARN) of a `FeatureGroup`.
     */
    val featureGroupArn: kotlin.String? = builder.featureGroupArn
    /**
     * The name of the `FeatureGroup`.
     */
    val featureGroupName: kotlin.String? = builder.featureGroupName
    /**
     * A `FeatureGroup` status.
     */
    val featureGroupStatus: aws.sdk.kotlin.services.sagemaker.model.FeatureGroupStatus? = builder.featureGroupStatus
    /**
     * The configuration of an `OfflineStore`.
     *
     * Provide an `OfflineStoreConfig` in a request to `CreateFeatureGroup` to create an `OfflineStore`.
     *
     * To encrypt an `OfflineStore` using at rest data encryption, specify Amazon Web Services Key Management Service (KMS) key ID, or `KMSKeyId`, in `S3StorageConfig`.
     */
    val offlineStoreConfig: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig? = builder.offlineStoreConfig
    /**
     * The status of `OfflineStore`.
     */
    val offlineStoreStatus: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreStatus? = builder.offlineStoreStatus
    /**
     * Use this to specify the Amazon Web Services Key Management Service (KMS) Key ID, or `KMSKeyId`, for at rest data encryption. You can turn `OnlineStore` on or off by specifying the `EnableOnlineStore` flag at General Assembly; the default value is `False`.
     */
    val onlineStoreConfig: aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig? = builder.onlineStoreConfig
    /**
     * The name of the `Feature` whose value uniquely identifies a `Record` defined in the `FeatureGroup``FeatureDefinitions`.
     */
    val recordIdentifierFeatureName: kotlin.String? = builder.recordIdentifierFeatureName
    /**
     * The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * Tags used to define a `FeatureGroup`.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.FeatureGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FeatureGroup(")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("eventTimeFeatureName=$eventTimeFeatureName,")
        append("failureReason=$failureReason,")
        append("featureDefinitions=$featureDefinitions,")
        append("featureGroupArn=$featureGroupArn,")
        append("featureGroupName=$featureGroupName,")
        append("featureGroupStatus=$featureGroupStatus,")
        append("offlineStoreConfig=$offlineStoreConfig,")
        append("offlineStoreStatus=$offlineStoreStatus,")
        append("onlineStoreConfig=$onlineStoreConfig,")
        append("recordIdentifierFeatureName=$recordIdentifierFeatureName,")
        append("roleArn=$roleArn,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (eventTimeFeatureName?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (featureDefinitions?.hashCode() ?: 0)
        result = 31 * result + (featureGroupArn?.hashCode() ?: 0)
        result = 31 * result + (featureGroupName?.hashCode() ?: 0)
        result = 31 * result + (featureGroupStatus?.hashCode() ?: 0)
        result = 31 * result + (offlineStoreConfig?.hashCode() ?: 0)
        result = 31 * result + (offlineStoreStatus?.hashCode() ?: 0)
        result = 31 * result + (onlineStoreConfig?.hashCode() ?: 0)
        result = 31 * result + (recordIdentifierFeatureName?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FeatureGroup

        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (eventTimeFeatureName != other.eventTimeFeatureName) return false
        if (failureReason != other.failureReason) return false
        if (featureDefinitions != other.featureDefinitions) return false
        if (featureGroupArn != other.featureGroupArn) return false
        if (featureGroupName != other.featureGroupName) return false
        if (featureGroupStatus != other.featureGroupStatus) return false
        if (offlineStoreConfig != other.offlineStoreConfig) return false
        if (offlineStoreStatus != other.offlineStoreStatus) return false
        if (onlineStoreConfig != other.onlineStoreConfig) return false
        if (recordIdentifierFeatureName != other.recordIdentifierFeatureName) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.FeatureGroup = Builder(this).apply(block).build()

    class Builder {
        /**
         * The time a `FeatureGroup` was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A free form description of a `FeatureGroup`.
         */
        var description: kotlin.String? = null
        /**
         * The name of the feature that stores the `EventTime` of a Record in a `FeatureGroup`.
         *
         * A `EventTime` is point in time when a new event occurs that corresponds to the creation or update of a `Record` in `FeatureGroup`. All `Records` in the `FeatureGroup` must have a corresponding `EventTime`.
         */
        var eventTimeFeatureName: kotlin.String? = null
        /**
         * The reason that the `FeatureGroup` failed to be replicated in the `OfflineStore`. This is failure may be due to a failure to create a `FeatureGroup` in or delete a `FeatureGroup` from the `OfflineStore`.
         */
        var failureReason: kotlin.String? = null
        /**
         * A list of `Feature`s. Each `Feature` must include a `FeatureName` and a `FeatureType`.
         *
         * Valid `FeatureType`s are `Integral`, `Fractional` and `String`.
         *
         * `FeatureName`s cannot be any of the following: `is_deleted`, `write_time`, `api_invocation_time`.
         *
         * You can create up to 2,500 `FeatureDefinition`s per `FeatureGroup`.
         */
        var featureDefinitions: List<FeatureDefinition>? = null
        /**
         * The Amazon Resource Name (ARN) of a `FeatureGroup`.
         */
        var featureGroupArn: kotlin.String? = null
        /**
         * The name of the `FeatureGroup`.
         */
        var featureGroupName: kotlin.String? = null
        /**
         * A `FeatureGroup` status.
         */
        var featureGroupStatus: aws.sdk.kotlin.services.sagemaker.model.FeatureGroupStatus? = null
        /**
         * The configuration of an `OfflineStore`.
         *
         * Provide an `OfflineStoreConfig` in a request to `CreateFeatureGroup` to create an `OfflineStore`.
         *
         * To encrypt an `OfflineStore` using at rest data encryption, specify Amazon Web Services Key Management Service (KMS) key ID, or `KMSKeyId`, in `S3StorageConfig`.
         */
        var offlineStoreConfig: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig? = null
        /**
         * The status of `OfflineStore`.
         */
        var offlineStoreStatus: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreStatus? = null
        /**
         * Use this to specify the Amazon Web Services Key Management Service (KMS) Key ID, or `KMSKeyId`, for at rest data encryption. You can turn `OnlineStore` on or off by specifying the `EnableOnlineStore` flag at General Assembly; the default value is `False`.
         */
        var onlineStoreConfig: aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig? = null
        /**
         * The name of the `Feature` whose value uniquely identifies a `Record` defined in the `FeatureGroup``FeatureDefinitions`.
         */
        var recordIdentifierFeatureName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.
         */
        var roleArn: kotlin.String? = null
        /**
         * Tags used to define a `FeatureGroup`.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.FeatureGroup) : this() {
            this.creationTime = x.creationTime
            this.description = x.description
            this.eventTimeFeatureName = x.eventTimeFeatureName
            this.failureReason = x.failureReason
            this.featureDefinitions = x.featureDefinitions
            this.featureGroupArn = x.featureGroupArn
            this.featureGroupName = x.featureGroupName
            this.featureGroupStatus = x.featureGroupStatus
            this.offlineStoreConfig = x.offlineStoreConfig
            this.offlineStoreStatus = x.offlineStoreStatus
            this.onlineStoreConfig = x.onlineStoreConfig
            this.recordIdentifierFeatureName = x.recordIdentifierFeatureName
            this.roleArn = x.roleArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.FeatureGroup = FeatureGroup(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig] inside the given [block]
         */
        fun offlineStoreConfig(block: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig.Builder.() -> kotlin.Unit) {
            this.offlineStoreConfig = aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OfflineStoreStatus] inside the given [block]
         */
        fun offlineStoreStatus(block: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreStatus.Builder.() -> kotlin.Unit) {
            this.offlineStoreStatus = aws.sdk.kotlin.services.sagemaker.model.OfflineStoreStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig] inside the given [block]
         */
        fun onlineStoreConfig(block: aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig.Builder.() -> kotlin.Unit) {
            this.onlineStoreConfig = aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig.invoke(block)
        }
    }
}
