// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Describes the work to be performed by human workers.
 */
class HumanLoopConfig private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the human task user interface.
     *
     * You can use standard HTML and Crowd HTML Elements to create a custom worker task template. You use this template to create a human task UI.
     *
     * To learn how to create a custom HTML template, see [Create Custom Worker Task Template](https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-custom-templates.html).
     *
     * To learn how to create a human task UI, which is a worker task template that can be used in a flow definition, see [Create and Delete a Worker Task Templates](https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-worker-template-console.html).
     */
    val humanTaskUiArn: kotlin.String? = builder.humanTaskUiArn
    /**
     * Defines the amount of money paid to an Amazon Mechanical Turk worker for each task performed.
     *
     * Use one of the following prices for bounding box tasks. Prices are in US dollars and should be based on the complexity of the task; the longer it takes in your initial testing, the more you should offer.
     * + 0.036
     * + 0.048
     * + 0.060
     * + 0.072
     * + 0.120
     * + 0.240
     * + 0.360
     * + 0.480
     * + 0.600
     * + 0.720
     * + 0.840
     * + 0.960
     * + 1.080
     * + 1.200
     *
     * Use one of the following prices for image classification, text classification, and custom tasks. Prices are in US dollars.
     * + 0.012
     * + 0.024
     * + 0.036
     * + 0.048
     * + 0.060
     * + 0.072
     * + 0.120
     * + 0.240
     * + 0.360
     * + 0.480
     * + 0.600
     * + 0.720
     * + 0.840
     * + 0.960
     * + 1.080
     * + 1.200
     *
     * Use one of the following prices for semantic segmentation tasks. Prices are in US dollars.
     * + 0.840
     * + 0.960
     * + 1.080
     * + 1.200
     *
     * Use one of the following prices for Textract AnalyzeDocument Important Form Key Amazon Augmented AI review tasks. Prices are in US dollars.
     * + 2.400
     * + 2.280
     * + 2.160
     * + 2.040
     * + 1.920
     * + 1.800
     * + 1.680
     * + 1.560
     * + 1.440
     * + 1.320
     * + 1.200
     * + 1.080
     * + 0.960
     * + 0.840
     * + 0.720
     * + 0.600
     * + 0.480
     * + 0.360
     * + 0.240
     * + 0.120
     * + 0.072
     * + 0.060
     * + 0.048
     * + 0.036
     * + 0.024
     * + 0.012
     *
     * Use one of the following prices for Rekognition DetectModerationLabels Amazon Augmented AI review tasks. Prices are in US dollars.
     * + 1.200
     * + 1.080
     * + 0.960
     * + 0.840
     * + 0.720
     * + 0.600
     * + 0.480
     * + 0.360
     * + 0.240
     * + 0.120
     * + 0.072
     * + 0.060
     * + 0.048
     * + 0.036
     * + 0.024
     * + 0.012
     *
     * Use one of the following prices for Amazon Augmented AI custom human review tasks. Prices are in US dollars.
     * + 1.200
     * + 1.080
     * + 0.960
     * + 0.840
     * + 0.720
     * + 0.600
     * + 0.480
     * + 0.360
     * + 0.240
     * + 0.120
     * + 0.072
     * + 0.060
     * + 0.048
     * + 0.036
     * + 0.024
     * + 0.012
     */
    val publicWorkforceTaskPrice: aws.sdk.kotlin.services.sagemaker.model.PublicWorkforceTaskPrice? = builder.publicWorkforceTaskPrice
    /**
     * The length of time that a task remains available for review by human workers.
     */
    val taskAvailabilityLifetimeInSeconds: kotlin.Int? = builder.taskAvailabilityLifetimeInSeconds
    /**
     * The number of distinct workers who will perform the same task on each object. For example, if `TaskCount` is set to `3` for an image classification labeling job, three workers will classify each input image. Increasing `TaskCount` can improve label accuracy.
     */
    val taskCount: kotlin.Int? = builder.taskCount
    /**
     * A description for the human worker task.
     */
    val taskDescription: kotlin.String? = builder.taskDescription
    /**
     * Keywords used to describe the task so that workers can discover the task.
     */
    val taskKeywords: List<String>? = builder.taskKeywords
    /**
     * The amount of time that a worker has to complete a task. The default value is 3,600 seconds (1 hour).
     */
    val taskTimeLimitInSeconds: kotlin.Int? = builder.taskTimeLimitInSeconds
    /**
     * A title for the human worker task.
     */
    val taskTitle: kotlin.String? = builder.taskTitle
    /**
     * Amazon Resource Name (ARN) of a team of workers. To learn more about the types of workforces and work teams you can create and use with Amazon A2I, see [Create and Manage Workforces](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-management.html).
     */
    val workteamArn: kotlin.String? = builder.workteamArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.HumanLoopConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HumanLoopConfig(")
        append("humanTaskUiArn=$humanTaskUiArn,")
        append("publicWorkforceTaskPrice=$publicWorkforceTaskPrice,")
        append("taskAvailabilityLifetimeInSeconds=$taskAvailabilityLifetimeInSeconds,")
        append("taskCount=$taskCount,")
        append("taskDescription=$taskDescription,")
        append("taskKeywords=$taskKeywords,")
        append("taskTimeLimitInSeconds=$taskTimeLimitInSeconds,")
        append("taskTitle=$taskTitle,")
        append("workteamArn=$workteamArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = humanTaskUiArn?.hashCode() ?: 0
        result = 31 * result + (publicWorkforceTaskPrice?.hashCode() ?: 0)
        result = 31 * result + (taskAvailabilityLifetimeInSeconds ?: 0)
        result = 31 * result + (taskCount ?: 0)
        result = 31 * result + (taskDescription?.hashCode() ?: 0)
        result = 31 * result + (taskKeywords?.hashCode() ?: 0)
        result = 31 * result + (taskTimeLimitInSeconds ?: 0)
        result = 31 * result + (taskTitle?.hashCode() ?: 0)
        result = 31 * result + (workteamArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HumanLoopConfig

        if (humanTaskUiArn != other.humanTaskUiArn) return false
        if (publicWorkforceTaskPrice != other.publicWorkforceTaskPrice) return false
        if (taskAvailabilityLifetimeInSeconds != other.taskAvailabilityLifetimeInSeconds) return false
        if (taskCount != other.taskCount) return false
        if (taskDescription != other.taskDescription) return false
        if (taskKeywords != other.taskKeywords) return false
        if (taskTimeLimitInSeconds != other.taskTimeLimitInSeconds) return false
        if (taskTitle != other.taskTitle) return false
        if (workteamArn != other.workteamArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.HumanLoopConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the human task user interface.
         *
         * You can use standard HTML and Crowd HTML Elements to create a custom worker task template. You use this template to create a human task UI.
         *
         * To learn how to create a custom HTML template, see [Create Custom Worker Task Template](https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-custom-templates.html).
         *
         * To learn how to create a human task UI, which is a worker task template that can be used in a flow definition, see [Create and Delete a Worker Task Templates](https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-worker-template-console.html).
         */
        var humanTaskUiArn: kotlin.String? = null
        /**
         * Defines the amount of money paid to an Amazon Mechanical Turk worker for each task performed.
         *
         * Use one of the following prices for bounding box tasks. Prices are in US dollars and should be based on the complexity of the task; the longer it takes in your initial testing, the more you should offer.
         * + 0.036
         * + 0.048
         * + 0.060
         * + 0.072
         * + 0.120
         * + 0.240
         * + 0.360
         * + 0.480
         * + 0.600
         * + 0.720
         * + 0.840
         * + 0.960
         * + 1.080
         * + 1.200
         *
         * Use one of the following prices for image classification, text classification, and custom tasks. Prices are in US dollars.
         * + 0.012
         * + 0.024
         * + 0.036
         * + 0.048
         * + 0.060
         * + 0.072
         * + 0.120
         * + 0.240
         * + 0.360
         * + 0.480
         * + 0.600
         * + 0.720
         * + 0.840
         * + 0.960
         * + 1.080
         * + 1.200
         *
         * Use one of the following prices for semantic segmentation tasks. Prices are in US dollars.
         * + 0.840
         * + 0.960
         * + 1.080
         * + 1.200
         *
         * Use one of the following prices for Textract AnalyzeDocument Important Form Key Amazon Augmented AI review tasks. Prices are in US dollars.
         * + 2.400
         * + 2.280
         * + 2.160
         * + 2.040
         * + 1.920
         * + 1.800
         * + 1.680
         * + 1.560
         * + 1.440
         * + 1.320
         * + 1.200
         * + 1.080
         * + 0.960
         * + 0.840
         * + 0.720
         * + 0.600
         * + 0.480
         * + 0.360
         * + 0.240
         * + 0.120
         * + 0.072
         * + 0.060
         * + 0.048
         * + 0.036
         * + 0.024
         * + 0.012
         *
         * Use one of the following prices for Rekognition DetectModerationLabels Amazon Augmented AI review tasks. Prices are in US dollars.
         * + 1.200
         * + 1.080
         * + 0.960
         * + 0.840
         * + 0.720
         * + 0.600
         * + 0.480
         * + 0.360
         * + 0.240
         * + 0.120
         * + 0.072
         * + 0.060
         * + 0.048
         * + 0.036
         * + 0.024
         * + 0.012
         *
         * Use one of the following prices for Amazon Augmented AI custom human review tasks. Prices are in US dollars.
         * + 1.200
         * + 1.080
         * + 0.960
         * + 0.840
         * + 0.720
         * + 0.600
         * + 0.480
         * + 0.360
         * + 0.240
         * + 0.120
         * + 0.072
         * + 0.060
         * + 0.048
         * + 0.036
         * + 0.024
         * + 0.012
         */
        var publicWorkforceTaskPrice: aws.sdk.kotlin.services.sagemaker.model.PublicWorkforceTaskPrice? = null
        /**
         * The length of time that a task remains available for review by human workers.
         */
        var taskAvailabilityLifetimeInSeconds: kotlin.Int? = null
        /**
         * The number of distinct workers who will perform the same task on each object. For example, if `TaskCount` is set to `3` for an image classification labeling job, three workers will classify each input image. Increasing `TaskCount` can improve label accuracy.
         */
        var taskCount: kotlin.Int? = null
        /**
         * A description for the human worker task.
         */
        var taskDescription: kotlin.String? = null
        /**
         * Keywords used to describe the task so that workers can discover the task.
         */
        var taskKeywords: List<String>? = null
        /**
         * The amount of time that a worker has to complete a task. The default value is 3,600 seconds (1 hour).
         */
        var taskTimeLimitInSeconds: kotlin.Int? = null
        /**
         * A title for the human worker task.
         */
        var taskTitle: kotlin.String? = null
        /**
         * Amazon Resource Name (ARN) of a team of workers. To learn more about the types of workforces and work teams you can create and use with Amazon A2I, see [Create and Manage Workforces](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-management.html).
         */
        var workteamArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.HumanLoopConfig) : this() {
            this.humanTaskUiArn = x.humanTaskUiArn
            this.publicWorkforceTaskPrice = x.publicWorkforceTaskPrice
            this.taskAvailabilityLifetimeInSeconds = x.taskAvailabilityLifetimeInSeconds
            this.taskCount = x.taskCount
            this.taskDescription = x.taskDescription
            this.taskKeywords = x.taskKeywords
            this.taskTimeLimitInSeconds = x.taskTimeLimitInSeconds
            this.taskTitle = x.taskTitle
            this.workteamArn = x.workteamArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.HumanLoopConfig = HumanLoopConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.PublicWorkforceTaskPrice] inside the given [block]
         */
        fun publicWorkforceTaskPrice(block: aws.sdk.kotlin.services.sagemaker.model.PublicWorkforceTaskPrice.Builder.() -> kotlin.Unit) {
            this.publicWorkforceTaskPrice = aws.sdk.kotlin.services.sagemaker.model.PublicWorkforceTaskPrice.invoke(block)
        }
    }
}
