// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Defines the training jobs launched by a hyperparameter tuning job.
 */
class HyperParameterTrainingJobDefinition private constructor(builder: Builder) {
    /**
     * The HyperParameterAlgorithmSpecification object that specifies the resource algorithm to use for the training jobs that the tuning job launches.
     */
    val algorithmSpecification: aws.sdk.kotlin.services.sagemaker.model.HyperParameterAlgorithmSpecification? = builder.algorithmSpecification
    /**
     * Contains information about the output location for managed spot training checkpoint data.
     */
    val checkpointConfig: aws.sdk.kotlin.services.sagemaker.model.CheckpointConfig? = builder.checkpointConfig
    /**
     * The job definition name.
     */
    val definitionName: kotlin.String? = builder.definitionName
    /**
     * To encrypt all communications between ML compute instances in distributed training, choose `True`. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithm in distributed training.
     */
    val enableInterContainerTrafficEncryption: kotlin.Boolean = builder.enableInterContainerTrafficEncryption
    /**
     * A Boolean indicating whether managed spot training is enabled (`True`) or not (`False`).
     */
    val enableManagedSpotTraining: kotlin.Boolean = builder.enableManagedSpotTraining
    /**
     * Isolates the training container. No inbound or outbound network calls can be made, except for calls between peers within a training cluster for distributed training. If network isolation is used for training jobs that are configured to use a VPC, SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.
     */
    val enableNetworkIsolation: kotlin.Boolean = builder.enableNetworkIsolation
    /**
     * Specifies ranges of integer, continuous, and categorical hyperparameters that a hyperparameter tuning job searches. The hyperparameter tuning job launches training jobs with hyperparameter values within these ranges to find the combination of values that result in the training job with the best performance as measured by the objective metric of the hyperparameter tuning job.
     *
     * You can specify a maximum of 20 hyperparameters that a hyperparameter tuning job can search over. Every possible value of a categorical parameter range counts against this limit.
     */
    val hyperParameterRanges: aws.sdk.kotlin.services.sagemaker.model.ParameterRanges? = builder.hyperParameterRanges
    /**
     * An array of Channel objects that specify the input for the training jobs that the tuning job launches.
     */
    val inputDataConfig: List<Channel>? = builder.inputDataConfig
    /**
     * Specifies the path to the Amazon S3 bucket where you store model artifacts from the training jobs that the tuning job launches.
     */
    val outputDataConfig: aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig? = builder.outputDataConfig
    /**
     * The resources, including the compute instances and storage volumes, to use for the training jobs that the tuning job launches.
     *
     * Storage volumes store model artifacts and incremental states. Training algorithms might also use storage volumes for scratch space. If you want SageMaker to use the storage volume to store the training data, choose `File` as the `TrainingInputMode` in the algorithm specification. For distributed training algorithms, specify an instance count greater than 1.
     */
    val resourceConfig: aws.sdk.kotlin.services.sagemaker.model.ResourceConfig? = builder.resourceConfig
    /**
     * The number of times to retry the job when the job fails due to an `InternalServerError`.
     */
    val retryStrategy: aws.sdk.kotlin.services.sagemaker.model.RetryStrategy? = builder.retryStrategy
    /**
     * The Amazon Resource Name (ARN) of the IAM role associated with the training jobs that the tuning job launches.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * Specifies the values of hyperparameters that do not change for the tuning job.
     */
    val staticHyperParameters: Map<String, String>? = builder.staticHyperParameters
    /**
     * Specifies a limit to how long a model hyperparameter training job can run. It also specifies how long a managed spot training job has to complete. When the job reaches the time limit, SageMaker ends the training job. Use this API to cap model training costs.
     */
    val stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.StoppingCondition? = builder.stoppingCondition
    /**
     * Defines the objective metric for a hyperparameter tuning job. Hyperparameter tuning uses the value of this metric to evaluate the training jobs it launches, and returns the training job that results in either the highest or lowest value for this metric, depending on the value you specify for the `Type` parameter.
     */
    val tuningObjective: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobObjective? = builder.tuningObjective
    /**
     * The VpcConfig object that specifies the VPC that you want the training jobs that this hyperparameter tuning job launches to connect to. Control access to and from your training container by configuring the VPC. For more information, see [Protect Training Jobs by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
     */
    val vpcConfig: aws.sdk.kotlin.services.sagemaker.model.VpcConfig? = builder.vpcConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HyperParameterTrainingJobDefinition(")
        append("algorithmSpecification=$algorithmSpecification,")
        append("checkpointConfig=$checkpointConfig,")
        append("definitionName=$definitionName,")
        append("enableInterContainerTrafficEncryption=$enableInterContainerTrafficEncryption,")
        append("enableManagedSpotTraining=$enableManagedSpotTraining,")
        append("enableNetworkIsolation=$enableNetworkIsolation,")
        append("hyperParameterRanges=$hyperParameterRanges,")
        append("inputDataConfig=$inputDataConfig,")
        append("outputDataConfig=$outputDataConfig,")
        append("resourceConfig=$resourceConfig,")
        append("retryStrategy=$retryStrategy,")
        append("roleArn=$roleArn,")
        append("staticHyperParameters=$staticHyperParameters,")
        append("stoppingCondition=$stoppingCondition,")
        append("tuningObjective=$tuningObjective,")
        append("vpcConfig=$vpcConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithmSpecification?.hashCode() ?: 0
        result = 31 * result + (checkpointConfig?.hashCode() ?: 0)
        result = 31 * result + (definitionName?.hashCode() ?: 0)
        result = 31 * result + (enableInterContainerTrafficEncryption.hashCode())
        result = 31 * result + (enableManagedSpotTraining.hashCode())
        result = 31 * result + (enableNetworkIsolation.hashCode())
        result = 31 * result + (hyperParameterRanges?.hashCode() ?: 0)
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (resourceConfig?.hashCode() ?: 0)
        result = 31 * result + (retryStrategy?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (staticHyperParameters?.hashCode() ?: 0)
        result = 31 * result + (stoppingCondition?.hashCode() ?: 0)
        result = 31 * result + (tuningObjective?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HyperParameterTrainingJobDefinition

        if (algorithmSpecification != other.algorithmSpecification) return false
        if (checkpointConfig != other.checkpointConfig) return false
        if (definitionName != other.definitionName) return false
        if (enableInterContainerTrafficEncryption != other.enableInterContainerTrafficEncryption) return false
        if (enableManagedSpotTraining != other.enableManagedSpotTraining) return false
        if (enableNetworkIsolation != other.enableNetworkIsolation) return false
        if (hyperParameterRanges != other.hyperParameterRanges) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (resourceConfig != other.resourceConfig) return false
        if (retryStrategy != other.retryStrategy) return false
        if (roleArn != other.roleArn) return false
        if (staticHyperParameters != other.staticHyperParameters) return false
        if (stoppingCondition != other.stoppingCondition) return false
        if (tuningObjective != other.tuningObjective) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition = Builder(this).apply(block).build()

    class Builder {
        /**
         * The HyperParameterAlgorithmSpecification object that specifies the resource algorithm to use for the training jobs that the tuning job launches.
         */
        var algorithmSpecification: aws.sdk.kotlin.services.sagemaker.model.HyperParameterAlgorithmSpecification? = null
        /**
         * Contains information about the output location for managed spot training checkpoint data.
         */
        var checkpointConfig: aws.sdk.kotlin.services.sagemaker.model.CheckpointConfig? = null
        /**
         * The job definition name.
         */
        var definitionName: kotlin.String? = null
        /**
         * To encrypt all communications between ML compute instances in distributed training, choose `True`. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithm in distributed training.
         */
        var enableInterContainerTrafficEncryption: kotlin.Boolean = false
        /**
         * A Boolean indicating whether managed spot training is enabled (`True`) or not (`False`).
         */
        var enableManagedSpotTraining: kotlin.Boolean = false
        /**
         * Isolates the training container. No inbound or outbound network calls can be made, except for calls between peers within a training cluster for distributed training. If network isolation is used for training jobs that are configured to use a VPC, SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.
         */
        var enableNetworkIsolation: kotlin.Boolean = false
        /**
         * Specifies ranges of integer, continuous, and categorical hyperparameters that a hyperparameter tuning job searches. The hyperparameter tuning job launches training jobs with hyperparameter values within these ranges to find the combination of values that result in the training job with the best performance as measured by the objective metric of the hyperparameter tuning job.
         *
         * You can specify a maximum of 20 hyperparameters that a hyperparameter tuning job can search over. Every possible value of a categorical parameter range counts against this limit.
         */
        var hyperParameterRanges: aws.sdk.kotlin.services.sagemaker.model.ParameterRanges? = null
        /**
         * An array of Channel objects that specify the input for the training jobs that the tuning job launches.
         */
        var inputDataConfig: List<Channel>? = null
        /**
         * Specifies the path to the Amazon S3 bucket where you store model artifacts from the training jobs that the tuning job launches.
         */
        var outputDataConfig: aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig? = null
        /**
         * The resources, including the compute instances and storage volumes, to use for the training jobs that the tuning job launches.
         *
         * Storage volumes store model artifacts and incremental states. Training algorithms might also use storage volumes for scratch space. If you want SageMaker to use the storage volume to store the training data, choose `File` as the `TrainingInputMode` in the algorithm specification. For distributed training algorithms, specify an instance count greater than 1.
         */
        var resourceConfig: aws.sdk.kotlin.services.sagemaker.model.ResourceConfig? = null
        /**
         * The number of times to retry the job when the job fails due to an `InternalServerError`.
         */
        var retryStrategy: aws.sdk.kotlin.services.sagemaker.model.RetryStrategy? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role associated with the training jobs that the tuning job launches.
         */
        var roleArn: kotlin.String? = null
        /**
         * Specifies the values of hyperparameters that do not change for the tuning job.
         */
        var staticHyperParameters: Map<String, String>? = null
        /**
         * Specifies a limit to how long a model hyperparameter training job can run. It also specifies how long a managed spot training job has to complete. When the job reaches the time limit, SageMaker ends the training job. Use this API to cap model training costs.
         */
        var stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.StoppingCondition? = null
        /**
         * Defines the objective metric for a hyperparameter tuning job. Hyperparameter tuning uses the value of this metric to evaluate the training jobs it launches, and returns the training job that results in either the highest or lowest value for this metric, depending on the value you specify for the `Type` parameter.
         */
        var tuningObjective: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobObjective? = null
        /**
         * The VpcConfig object that specifies the VPC that you want the training jobs that this hyperparameter tuning job launches to connect to. Control access to and from your training container by configuring the VPC. For more information, see [Protect Training Jobs by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
         */
        var vpcConfig: aws.sdk.kotlin.services.sagemaker.model.VpcConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition) : this() {
            this.algorithmSpecification = x.algorithmSpecification
            this.checkpointConfig = x.checkpointConfig
            this.definitionName = x.definitionName
            this.enableInterContainerTrafficEncryption = x.enableInterContainerTrafficEncryption
            this.enableManagedSpotTraining = x.enableManagedSpotTraining
            this.enableNetworkIsolation = x.enableNetworkIsolation
            this.hyperParameterRanges = x.hyperParameterRanges
            this.inputDataConfig = x.inputDataConfig
            this.outputDataConfig = x.outputDataConfig
            this.resourceConfig = x.resourceConfig
            this.retryStrategy = x.retryStrategy
            this.roleArn = x.roleArn
            this.staticHyperParameters = x.staticHyperParameters
            this.stoppingCondition = x.stoppingCondition
            this.tuningObjective = x.tuningObjective
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition = HyperParameterTrainingJobDefinition(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterAlgorithmSpecification] inside the given [block]
         */
        fun algorithmSpecification(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterAlgorithmSpecification.Builder.() -> kotlin.Unit) {
            this.algorithmSpecification = aws.sdk.kotlin.services.sagemaker.model.HyperParameterAlgorithmSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.CheckpointConfig] inside the given [block]
         */
        fun checkpointConfig(block: aws.sdk.kotlin.services.sagemaker.model.CheckpointConfig.Builder.() -> kotlin.Unit) {
            this.checkpointConfig = aws.sdk.kotlin.services.sagemaker.model.CheckpointConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ParameterRanges] inside the given [block]
         */
        fun hyperParameterRanges(block: aws.sdk.kotlin.services.sagemaker.model.ParameterRanges.Builder.() -> kotlin.Unit) {
            this.hyperParameterRanges = aws.sdk.kotlin.services.sagemaker.model.ParameterRanges.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig] inside the given [block]
         */
        fun outputDataConfig(block: aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ResourceConfig] inside the given [block]
         */
        fun resourceConfig(block: aws.sdk.kotlin.services.sagemaker.model.ResourceConfig.Builder.() -> kotlin.Unit) {
            this.resourceConfig = aws.sdk.kotlin.services.sagemaker.model.ResourceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.RetryStrategy] inside the given [block]
         */
        fun retryStrategy(block: aws.sdk.kotlin.services.sagemaker.model.RetryStrategy.Builder.() -> kotlin.Unit) {
            this.retryStrategy = aws.sdk.kotlin.services.sagemaker.model.RetryStrategy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.StoppingCondition] inside the given [block]
         */
        fun stoppingCondition(block: aws.sdk.kotlin.services.sagemaker.model.StoppingCondition.Builder.() -> kotlin.Unit) {
            this.stoppingCondition = aws.sdk.kotlin.services.sagemaker.model.StoppingCondition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobObjective] inside the given [block]
         */
        fun tuningObjective(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobObjective.Builder.() -> kotlin.Unit) {
            this.tuningObjective = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobObjective.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.VpcConfig] inside the given [block]
         */
        fun vpcConfig(block: aws.sdk.kotlin.services.sagemaker.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.sagemaker.model.VpcConfig.invoke(block)
        }
    }
}
