// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The container for the summary information about a training job.
 */
class HyperParameterTrainingJobSummary private constructor(builder: Builder) {
    /**
     * The date and time that the training job was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The reason that the training job failed.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * The FinalHyperParameterTuningJobObjectiveMetric object that specifies the value of the objective metric of the tuning job that launched this training job.
     */
    val finalHyperParameterTuningJobObjectiveMetric: aws.sdk.kotlin.services.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric? = builder.finalHyperParameterTuningJobObjectiveMetric
    /**
     * The status of the objective metric for the training job:
     * + Succeeded: The final objective metric for the training job was evaluated by the hyperparameter tuning job and used in the hyperparameter tuning process.
     *
     * + Pending: The training job is in progress and evaluation of its final objective metric is pending.
     *
     * + Failed: The final objective metric for the training job was not evaluated, and was not used in the hyperparameter tuning process. This typically occurs when the training job failed or did not emit an objective metric.
     */
    val objectiveStatus: aws.sdk.kotlin.services.sagemaker.model.ObjectiveStatus? = builder.objectiveStatus
    /**
     * Specifies the time when the training job ends on training instances. You are billed for the time interval between the value of `TrainingStartTime` and this time. For successful jobs and stopped jobs, this is the time after model artifacts are uploaded. For failed jobs, this is the time when SageMaker detects a job failure.
     */
    val trainingEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.trainingEndTime
    /**
     * The Amazon Resource Name (ARN) of the training job.
     */
    val trainingJobArn: kotlin.String? = builder.trainingJobArn
    /**
     * The training job definition name.
     */
    val trainingJobDefinitionName: kotlin.String? = builder.trainingJobDefinitionName
    /**
     * The name of the training job.
     */
    val trainingJobName: kotlin.String? = builder.trainingJobName
    /**
     * The status of the training job.
     */
    val trainingJobStatus: aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatus? = builder.trainingJobStatus
    /**
     * The date and time that the training job started.
     */
    val trainingStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.trainingStartTime
    /**
     * A list of the hyperparameters for which you specified ranges to search.
     */
    val tunedHyperParameters: Map<String, String>? = builder.tunedHyperParameters
    /**
     * The HyperParameter tuning job that launched the training job.
     */
    val tuningJobName: kotlin.String? = builder.tuningJobName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HyperParameterTrainingJobSummary(")
        append("creationTime=$creationTime,")
        append("failureReason=$failureReason,")
        append("finalHyperParameterTuningJobObjectiveMetric=$finalHyperParameterTuningJobObjectiveMetric,")
        append("objectiveStatus=$objectiveStatus,")
        append("trainingEndTime=$trainingEndTime,")
        append("trainingJobArn=$trainingJobArn,")
        append("trainingJobDefinitionName=$trainingJobDefinitionName,")
        append("trainingJobName=$trainingJobName,")
        append("trainingJobStatus=$trainingJobStatus,")
        append("trainingStartTime=$trainingStartTime,")
        append("tunedHyperParameters=$tunedHyperParameters,")
        append("tuningJobName=$tuningJobName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (finalHyperParameterTuningJobObjectiveMetric?.hashCode() ?: 0)
        result = 31 * result + (objectiveStatus?.hashCode() ?: 0)
        result = 31 * result + (trainingEndTime?.hashCode() ?: 0)
        result = 31 * result + (trainingJobArn?.hashCode() ?: 0)
        result = 31 * result + (trainingJobDefinitionName?.hashCode() ?: 0)
        result = 31 * result + (trainingJobName?.hashCode() ?: 0)
        result = 31 * result + (trainingJobStatus?.hashCode() ?: 0)
        result = 31 * result + (trainingStartTime?.hashCode() ?: 0)
        result = 31 * result + (tunedHyperParameters?.hashCode() ?: 0)
        result = 31 * result + (tuningJobName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HyperParameterTrainingJobSummary

        if (creationTime != other.creationTime) return false
        if (failureReason != other.failureReason) return false
        if (finalHyperParameterTuningJobObjectiveMetric != other.finalHyperParameterTuningJobObjectiveMetric) return false
        if (objectiveStatus != other.objectiveStatus) return false
        if (trainingEndTime != other.trainingEndTime) return false
        if (trainingJobArn != other.trainingJobArn) return false
        if (trainingJobDefinitionName != other.trainingJobDefinitionName) return false
        if (trainingJobName != other.trainingJobName) return false
        if (trainingJobStatus != other.trainingJobStatus) return false
        if (trainingStartTime != other.trainingStartTime) return false
        if (tunedHyperParameters != other.tunedHyperParameters) return false
        if (tuningJobName != other.tuningJobName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time that the training job was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The reason that the training job failed.
         */
        var failureReason: kotlin.String? = null
        /**
         * The FinalHyperParameterTuningJobObjectiveMetric object that specifies the value of the objective metric of the tuning job that launched this training job.
         */
        var finalHyperParameterTuningJobObjectiveMetric: aws.sdk.kotlin.services.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric? = null
        /**
         * The status of the objective metric for the training job:
         * + Succeeded: The final objective metric for the training job was evaluated by the hyperparameter tuning job and used in the hyperparameter tuning process.
         *
         * + Pending: The training job is in progress and evaluation of its final objective metric is pending.
         *
         * + Failed: The final objective metric for the training job was not evaluated, and was not used in the hyperparameter tuning process. This typically occurs when the training job failed or did not emit an objective metric.
         */
        var objectiveStatus: aws.sdk.kotlin.services.sagemaker.model.ObjectiveStatus? = null
        /**
         * Specifies the time when the training job ends on training instances. You are billed for the time interval between the value of `TrainingStartTime` and this time. For successful jobs and stopped jobs, this is the time after model artifacts are uploaded. For failed jobs, this is the time when SageMaker detects a job failure.
         */
        var trainingEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the training job.
         */
        var trainingJobArn: kotlin.String? = null
        /**
         * The training job definition name.
         */
        var trainingJobDefinitionName: kotlin.String? = null
        /**
         * The name of the training job.
         */
        var trainingJobName: kotlin.String? = null
        /**
         * The status of the training job.
         */
        var trainingJobStatus: aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatus? = null
        /**
         * The date and time that the training job started.
         */
        var trainingStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of the hyperparameters for which you specified ranges to search.
         */
        var tunedHyperParameters: Map<String, String>? = null
        /**
         * The HyperParameter tuning job that launched the training job.
         */
        var tuningJobName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary) : this() {
            this.creationTime = x.creationTime
            this.failureReason = x.failureReason
            this.finalHyperParameterTuningJobObjectiveMetric = x.finalHyperParameterTuningJobObjectiveMetric
            this.objectiveStatus = x.objectiveStatus
            this.trainingEndTime = x.trainingEndTime
            this.trainingJobArn = x.trainingJobArn
            this.trainingJobDefinitionName = x.trainingJobDefinitionName
            this.trainingJobName = x.trainingJobName
            this.trainingJobStatus = x.trainingJobStatus
            this.trainingStartTime = x.trainingStartTime
            this.tunedHyperParameters = x.tunedHyperParameters
            this.tuningJobName = x.tuningJobName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary = HyperParameterTrainingJobSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric] inside the given [block]
         */
        fun finalHyperParameterTuningJobObjectiveMetric(block: aws.sdk.kotlin.services.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric.Builder.() -> kotlin.Unit) {
            this.finalHyperParameterTuningJobObjectiveMetric = aws.sdk.kotlin.services.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric.invoke(block)
        }
    }
}
