// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A SageMaker image. A SageMaker image represents a set of container images that are derived from a common base container image. Each of these container images is represented by a SageMaker `ImageVersion`.
 */
class Image private constructor(builder: Builder) {
    /**
     * When the image was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The description of the image.
     */
    val description: kotlin.String? = builder.description
    /**
     * The name of the image as displayed.
     */
    val displayName: kotlin.String? = builder.displayName
    /**
     * When a create, update, or delete operation fails, the reason for the failure.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * The Amazon Resource Name (ARN) of the image.
     */
    val imageArn: kotlin.String? = builder.imageArn
    /**
     * The name of the image.
     */
    val imageName: kotlin.String? = builder.imageName
    /**
     * The status of the image.
     */
    val imageStatus: aws.sdk.kotlin.services.sagemaker.model.ImageStatus? = builder.imageStatus
    /**
     * When the image was last modified.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.Image = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Image(")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("displayName=$displayName,")
        append("failureReason=$failureReason,")
        append("imageArn=$imageArn,")
        append("imageName=$imageName,")
        append("imageStatus=$imageStatus,")
        append("lastModifiedTime=$lastModifiedTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (imageArn?.hashCode() ?: 0)
        result = 31 * result + (imageName?.hashCode() ?: 0)
        result = 31 * result + (imageStatus?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Image

        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (failureReason != other.failureReason) return false
        if (imageArn != other.imageArn) return false
        if (imageName != other.imageName) return false
        if (imageStatus != other.imageStatus) return false
        if (lastModifiedTime != other.lastModifiedTime) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.Image = Builder(this).apply(block).build()

    class Builder {
        /**
         * When the image was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the image.
         */
        var description: kotlin.String? = null
        /**
         * The name of the image as displayed.
         */
        var displayName: kotlin.String? = null
        /**
         * When a create, update, or delete operation fails, the reason for the failure.
         */
        var failureReason: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the image.
         */
        var imageArn: kotlin.String? = null
        /**
         * The name of the image.
         */
        var imageName: kotlin.String? = null
        /**
         * The status of the image.
         */
        var imageStatus: aws.sdk.kotlin.services.sagemaker.model.ImageStatus? = null
        /**
         * When the image was last modified.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.Image) : this() {
            this.creationTime = x.creationTime
            this.description = x.description
            this.displayName = x.displayName
            this.failureReason = x.failureReason
            this.imageArn = x.imageArn
            this.imageName = x.imageName
            this.imageStatus = x.imageStatus
            this.lastModifiedTime = x.lastModifiedTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.Image = Image(this)
    }
}
