// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.
 */
class ModelDeployConfig private constructor(builder: Builder) {
    /**
     * Set to `True` to automatically generate an endpoint name for a one-click Autopilot model deployment; set to `False` otherwise. The default value is `False`.
     *
     * If you set `AutoGenerateEndpointName` to `True`, do not specify the `EndpointName`; otherwise a 400 error is thrown.
     */
    val autoGenerateEndpointName: kotlin.Boolean = builder.autoGenerateEndpointName
    /**
     * Specifies the endpoint name to use for a one-click Autopilot model deployment if the endpoint name is not generated automatically.
     *
     * Specify the `EndpointName` if and only if you set `AutoGenerateEndpointName` to `False`; otherwise a 400 error is thrown.
     */
    val endpointName: kotlin.String? = builder.endpointName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ModelDeployConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelDeployConfig(")
        append("autoGenerateEndpointName=$autoGenerateEndpointName,")
        append("endpointName=$endpointName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoGenerateEndpointName.hashCode()
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelDeployConfig

        if (autoGenerateEndpointName != other.autoGenerateEndpointName) return false
        if (endpointName != other.endpointName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ModelDeployConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * Set to `True` to automatically generate an endpoint name for a one-click Autopilot model deployment; set to `False` otherwise. The default value is `False`.
         *
         * If you set `AutoGenerateEndpointName` to `True`, do not specify the `EndpointName`; otherwise a 400 error is thrown.
         */
        var autoGenerateEndpointName: kotlin.Boolean = false
        /**
         * Specifies the endpoint name to use for a one-click Autopilot model deployment if the endpoint name is not generated automatically.
         *
         * Specify the `EndpointName` if and only if you set `AutoGenerateEndpointName` to `False`; otherwise a 400 error is thrown.
         */
        var endpointName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ModelDeployConfig) : this() {
            this.autoGenerateEndpointName = x.autoGenerateEndpointName
            this.endpointName = x.endpointName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ModelDeployConfig = ModelDeployConfig(this)
    }
}
