// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Configuration for monitoring constraints and monitoring statistics. These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.
 */
class MonitoringBaselineConfig private constructor(builder: Builder) {
    /**
     * The name of the job that performs baselining for the monitoring job.
     */
    val baseliningJobName: kotlin.String? = builder.baseliningJobName
    /**
     * The baseline constraint file in Amazon S3 that the current monitoring job should validated against.
     */
    val constraintsResource: aws.sdk.kotlin.services.sagemaker.model.MonitoringConstraintsResource? = builder.constraintsResource
    /**
     * The baseline statistics file in Amazon S3 that the current monitoring job should be validated against.
     */
    val statisticsResource: aws.sdk.kotlin.services.sagemaker.model.MonitoringStatisticsResource? = builder.statisticsResource

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.MonitoringBaselineConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MonitoringBaselineConfig(")
        append("baseliningJobName=$baseliningJobName,")
        append("constraintsResource=$constraintsResource,")
        append("statisticsResource=$statisticsResource)")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseliningJobName?.hashCode() ?: 0
        result = 31 * result + (constraintsResource?.hashCode() ?: 0)
        result = 31 * result + (statisticsResource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MonitoringBaselineConfig

        if (baseliningJobName != other.baseliningJobName) return false
        if (constraintsResource != other.constraintsResource) return false
        if (statisticsResource != other.statisticsResource) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.MonitoringBaselineConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the job that performs baselining for the monitoring job.
         */
        var baseliningJobName: kotlin.String? = null
        /**
         * The baseline constraint file in Amazon S3 that the current monitoring job should validated against.
         */
        var constraintsResource: aws.sdk.kotlin.services.sagemaker.model.MonitoringConstraintsResource? = null
        /**
         * The baseline statistics file in Amazon S3 that the current monitoring job should be validated against.
         */
        var statisticsResource: aws.sdk.kotlin.services.sagemaker.model.MonitoringStatisticsResource? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.MonitoringBaselineConfig) : this() {
            this.baseliningJobName = x.baseliningJobName
            this.constraintsResource = x.constraintsResource
            this.statisticsResource = x.statisticsResource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.MonitoringBaselineConfig = MonitoringBaselineConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MonitoringConstraintsResource] inside the given [block]
         */
        fun constraintsResource(block: aws.sdk.kotlin.services.sagemaker.model.MonitoringConstraintsResource.Builder.() -> kotlin.Unit) {
            this.constraintsResource = aws.sdk.kotlin.services.sagemaker.model.MonitoringConstraintsResource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MonitoringStatisticsResource] inside the given [block]
         */
        fun statisticsResource(block: aws.sdk.kotlin.services.sagemaker.model.MonitoringStatisticsResource.Builder.() -> kotlin.Unit) {
            this.statisticsResource = aws.sdk.kotlin.services.sagemaker.model.MonitoringStatisticsResource.invoke(block)
        }
    }
}
