// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * The output configuration for monitoring jobs.
 */
class MonitoringOutputConfig private constructor(builder: Builder) {
    /**
     * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
     */
    val monitoringOutputs: List<MonitoringOutput>? = builder.monitoringOutputs

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MonitoringOutputConfig(")
        append("kmsKeyId=$kmsKeyId,")
        append("monitoringOutputs=$monitoringOutputs)")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (monitoringOutputs?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MonitoringOutputConfig

        if (kmsKeyId != other.kmsKeyId) return false
        if (monitoringOutputs != other.monitoringOutputs) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
         */
        var monitoringOutputs: List<MonitoringOutput>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.monitoringOutputs = x.monitoringOutputs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig = MonitoringOutputConfig(this)
    }
}
