// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Specifies the number of training jobs that this hyperparameter tuning job launched, categorized by the status of their objective metric. The objective metric status shows whether the final objective metric for the training job has been evaluated by the tuning job and used in the hyperparameter tuning process.
 */
class ObjectiveStatusCounters private constructor(builder: Builder) {
    /**
     * The number of training jobs whose final objective metric was not evaluated and used in the hyperparameter tuning process. This typically occurs when the training job failed or did not emit an objective metric.
     */
    val failed: kotlin.Int = builder.failed
    /**
     * The number of training jobs that are in progress and pending evaluation of their final objective metric.
     */
    val pending: kotlin.Int = builder.pending
    /**
     * The number of training jobs whose final objective metric was evaluated by the hyperparameter tuning job and used in the hyperparameter tuning process.
     */
    val succeeded: kotlin.Int = builder.succeeded

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ObjectiveStatusCounters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ObjectiveStatusCounters(")
        append("failed=$failed,")
        append("pending=$pending,")
        append("succeeded=$succeeded)")
    }

    override fun hashCode(): kotlin.Int {
        var result = failed
        result = 31 * result + (pending)
        result = 31 * result + (succeeded)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ObjectiveStatusCounters

        if (failed != other.failed) return false
        if (pending != other.pending) return false
        if (succeeded != other.succeeded) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ObjectiveStatusCounters = Builder(this).apply(block).build()

    class Builder {
        /**
         * The number of training jobs whose final objective metric was not evaluated and used in the hyperparameter tuning process. This typically occurs when the training job failed or did not emit an objective metric.
         */
        var failed: kotlin.Int = 0
        /**
         * The number of training jobs that are in progress and pending evaluation of their final objective metric.
         */
        var pending: kotlin.Int = 0
        /**
         * The number of training jobs whose final objective metric was evaluated by the hyperparameter tuning job and used in the hyperparameter tuning process.
         */
        var succeeded: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ObjectiveStatusCounters) : this() {
            this.failed = x.failed
            this.pending = x.pending
            this.succeeded = x.succeeded
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ObjectiveStatusCounters = ObjectiveStatusCounters(this)
    }
}
