// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * The configuration of an `OfflineStore`.
 *
 * Provide an `OfflineStoreConfig` in a request to `CreateFeatureGroup` to create an `OfflineStore`.
 *
 * To encrypt an `OfflineStore` using at rest data encryption, specify Amazon Web Services Key Management Service (KMS) key ID, or `KMSKeyId`, in `S3StorageConfig`.
 */
class OfflineStoreConfig private constructor(builder: Builder) {
    /**
     * The meta data of the Glue table that is autogenerated when an `OfflineStore` is created.
     */
    val dataCatalogConfig: aws.sdk.kotlin.services.sagemaker.model.DataCatalogConfig? = builder.dataCatalogConfig
    /**
     * Set to `True` to disable the automatic creation of an Amazon Web Services Glue table when configuring an `OfflineStore`.
     */
    val disableGlueTableCreation: kotlin.Boolean = builder.disableGlueTableCreation
    /**
     * The Amazon Simple Storage (Amazon S3) location of `OfflineStore`.
     */
    val s3StorageConfig: aws.sdk.kotlin.services.sagemaker.model.S3StorageConfig? = builder.s3StorageConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OfflineStoreConfig(")
        append("dataCatalogConfig=$dataCatalogConfig,")
        append("disableGlueTableCreation=$disableGlueTableCreation,")
        append("s3StorageConfig=$s3StorageConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataCatalogConfig?.hashCode() ?: 0
        result = 31 * result + (disableGlueTableCreation.hashCode())
        result = 31 * result + (s3StorageConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OfflineStoreConfig

        if (dataCatalogConfig != other.dataCatalogConfig) return false
        if (disableGlueTableCreation != other.disableGlueTableCreation) return false
        if (s3StorageConfig != other.s3StorageConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The meta data of the Glue table that is autogenerated when an `OfflineStore` is created.
         */
        var dataCatalogConfig: aws.sdk.kotlin.services.sagemaker.model.DataCatalogConfig? = null
        /**
         * Set to `True` to disable the automatic creation of an Amazon Web Services Glue table when configuring an `OfflineStore`.
         */
        var disableGlueTableCreation: kotlin.Boolean = false
        /**
         * The Amazon Simple Storage (Amazon S3) location of `OfflineStore`.
         */
        var s3StorageConfig: aws.sdk.kotlin.services.sagemaker.model.S3StorageConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig) : this() {
            this.dataCatalogConfig = x.dataCatalogConfig
            this.disableGlueTableCreation = x.disableGlueTableCreation
            this.s3StorageConfig = x.s3StorageConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig = OfflineStoreConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DataCatalogConfig] inside the given [block]
         */
        fun dataCatalogConfig(block: aws.sdk.kotlin.services.sagemaker.model.DataCatalogConfig.Builder.() -> kotlin.Unit) {
            this.dataCatalogConfig = aws.sdk.kotlin.services.sagemaker.model.DataCatalogConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.S3StorageConfig] inside the given [block]
         */
        fun s3StorageConfig(block: aws.sdk.kotlin.services.sagemaker.model.S3StorageConfig.Builder.() -> kotlin.Unit) {
            this.s3StorageConfig = aws.sdk.kotlin.services.sagemaker.model.S3StorageConfig.invoke(block)
        }
    }
}
