// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary of information about a processing job.
 */
class ProcessingJobSummary private constructor(builder: Builder) {
    /**
     * The time at which the processing job was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * An optional string, up to one KB in size, that contains metadata from the processing container when the processing job exits.
     */
    val exitMessage: kotlin.String? = builder.exitMessage
    /**
     * A string, up to one KB in size, that contains the reason a processing job failed, if it failed.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * A timestamp that indicates the last time the processing job was modified.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The time at which the processing job completed.
     */
    val processingEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.processingEndTime
    /**
     * The Amazon Resource Name (ARN) of the processing job..
     */
    val processingJobArn: kotlin.String? = builder.processingJobArn
    /**
     * The name of the processing job.
     */
    val processingJobName: kotlin.String? = builder.processingJobName
    /**
     * The status of the processing job.
     */
    val processingJobStatus: aws.sdk.kotlin.services.sagemaker.model.ProcessingJobStatus? = builder.processingJobStatus

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ProcessingJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProcessingJobSummary(")
        append("creationTime=$creationTime,")
        append("exitMessage=$exitMessage,")
        append("failureReason=$failureReason,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("processingEndTime=$processingEndTime,")
        append("processingJobArn=$processingJobArn,")
        append("processingJobName=$processingJobName,")
        append("processingJobStatus=$processingJobStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (exitMessage?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (processingEndTime?.hashCode() ?: 0)
        result = 31 * result + (processingJobArn?.hashCode() ?: 0)
        result = 31 * result + (processingJobName?.hashCode() ?: 0)
        result = 31 * result + (processingJobStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProcessingJobSummary

        if (creationTime != other.creationTime) return false
        if (exitMessage != other.exitMessage) return false
        if (failureReason != other.failureReason) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (processingEndTime != other.processingEndTime) return false
        if (processingJobArn != other.processingJobArn) return false
        if (processingJobName != other.processingJobName) return false
        if (processingJobStatus != other.processingJobStatus) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ProcessingJobSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The time at which the processing job was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An optional string, up to one KB in size, that contains metadata from the processing container when the processing job exits.
         */
        var exitMessage: kotlin.String? = null
        /**
         * A string, up to one KB in size, that contains the reason a processing job failed, if it failed.
         */
        var failureReason: kotlin.String? = null
        /**
         * A timestamp that indicates the last time the processing job was modified.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time at which the processing job completed.
         */
        var processingEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the processing job..
         */
        var processingJobArn: kotlin.String? = null
        /**
         * The name of the processing job.
         */
        var processingJobName: kotlin.String? = null
        /**
         * The status of the processing job.
         */
        var processingJobStatus: aws.sdk.kotlin.services.sagemaker.model.ProcessingJobStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ProcessingJobSummary) : this() {
            this.creationTime = x.creationTime
            this.exitMessage = x.exitMessage
            this.failureReason = x.failureReason
            this.lastModifiedTime = x.lastModifiedTime
            this.processingEndTime = x.processingEndTime
            this.processingJobArn = x.processingJobArn
            this.processingJobName = x.processingJobName
            this.processingJobStatus = x.processingJobStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ProcessingJobSummary = ProcessingJobSummary(this)
    }
}
