// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Identifies a model that you want to host and the resources chosen to deploy for hosting it. If you are deploying multiple models, tell SageMaker how to distribute traffic among the models by specifying variant weights.
 */
class ProductionVariant private constructor(builder: Builder) {
    /**
     * The size of the Elastic Inference (EI) instance to use for the production variant. EI instances provide on-demand GPU computing for inference. For more information, see [Using Elastic Inference in Amazon SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html).
     */
    val acceleratorType: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantAcceleratorType? = builder.acceleratorType
    /**
     * Specifies configuration for a core dump from the model container when the process crashes.
     */
    val coreDumpConfig: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantCoreDumpConfig? = builder.coreDumpConfig
    /**
     * Number of instances to launch initially.
     */
    val initialInstanceCount: kotlin.Int? = builder.initialInstanceCount
    /**
     * Determines initial traffic distribution among all of the models that you specify in the endpoint configuration. The traffic to a production variant is determined by the ratio of the `VariantWeight` to the sum of all `VariantWeight` values across all ProductionVariants. If unspecified, it defaults to 1.0.
     */
    val initialVariantWeight: kotlin.Float? = builder.initialVariantWeight
    /**
     * The ML compute instance type.
     */
    val instanceType: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantInstanceType? = builder.instanceType
    /**
     * The name of the model that you want to host. This is the name that you specified when creating the model.
     */
    val modelName: kotlin.String? = builder.modelName
    /**
     * The serverless configuration for an endpoint. Specifies a serverless endpoint configuration instead of an instance-based endpoint configuration.
     */
    val serverlessConfig: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig? = builder.serverlessConfig
    /**
     * The name of the production variant.
     */
    val variantName: kotlin.String? = builder.variantName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ProductionVariant = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProductionVariant(")
        append("acceleratorType=$acceleratorType,")
        append("coreDumpConfig=$coreDumpConfig,")
        append("initialInstanceCount=$initialInstanceCount,")
        append("initialVariantWeight=$initialVariantWeight,")
        append("instanceType=$instanceType,")
        append("modelName=$modelName,")
        append("serverlessConfig=$serverlessConfig,")
        append("variantName=$variantName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceleratorType?.hashCode() ?: 0
        result = 31 * result + (coreDumpConfig?.hashCode() ?: 0)
        result = 31 * result + (initialInstanceCount ?: 0)
        result = 31 * result + (initialVariantWeight?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (modelName?.hashCode() ?: 0)
        result = 31 * result + (serverlessConfig?.hashCode() ?: 0)
        result = 31 * result + (variantName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProductionVariant

        if (acceleratorType != other.acceleratorType) return false
        if (coreDumpConfig != other.coreDumpConfig) return false
        if (initialInstanceCount != other.initialInstanceCount) return false
        if (initialVariantWeight != other.initialVariantWeight) return false
        if (instanceType != other.instanceType) return false
        if (modelName != other.modelName) return false
        if (serverlessConfig != other.serverlessConfig) return false
        if (variantName != other.variantName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ProductionVariant = Builder(this).apply(block).build()

    class Builder {
        /**
         * The size of the Elastic Inference (EI) instance to use for the production variant. EI instances provide on-demand GPU computing for inference. For more information, see [Using Elastic Inference in Amazon SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html).
         */
        var acceleratorType: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantAcceleratorType? = null
        /**
         * Specifies configuration for a core dump from the model container when the process crashes.
         */
        var coreDumpConfig: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantCoreDumpConfig? = null
        /**
         * Number of instances to launch initially.
         */
        var initialInstanceCount: kotlin.Int? = null
        /**
         * Determines initial traffic distribution among all of the models that you specify in the endpoint configuration. The traffic to a production variant is determined by the ratio of the `VariantWeight` to the sum of all `VariantWeight` values across all ProductionVariants. If unspecified, it defaults to 1.0.
         */
        var initialVariantWeight: kotlin.Float? = null
        /**
         * The ML compute instance type.
         */
        var instanceType: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantInstanceType? = null
        /**
         * The name of the model that you want to host. This is the name that you specified when creating the model.
         */
        var modelName: kotlin.String? = null
        /**
         * The serverless configuration for an endpoint. Specifies a serverless endpoint configuration instead of an instance-based endpoint configuration.
         */
        var serverlessConfig: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig? = null
        /**
         * The name of the production variant.
         */
        var variantName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ProductionVariant) : this() {
            this.acceleratorType = x.acceleratorType
            this.coreDumpConfig = x.coreDumpConfig
            this.initialInstanceCount = x.initialInstanceCount
            this.initialVariantWeight = x.initialVariantWeight
            this.instanceType = x.instanceType
            this.modelName = x.modelName
            this.serverlessConfig = x.serverlessConfig
            this.variantName = x.variantName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ProductionVariant = ProductionVariant(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProductionVariantCoreDumpConfig] inside the given [block]
         */
        fun coreDumpConfig(block: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantCoreDumpConfig.Builder.() -> kotlin.Unit) {
            this.coreDumpConfig = aws.sdk.kotlin.services.sagemaker.model.ProductionVariantCoreDumpConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig] inside the given [block]
         */
        fun serverlessConfig(block: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig.Builder.() -> kotlin.Unit) {
            this.serverlessConfig = aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig.invoke(block)
        }
    }
}
