// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Specifies the ARN's of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
 */
class ResourceSpec private constructor(builder: Builder) {
    /**
     * The instance type that the image version runs on.
     *
     * JupyterServer Apps only support the `system` value. KernelGateway Apps do not support the `system` value, but support all other values for available instance types.
     */
    val instanceType: aws.sdk.kotlin.services.sagemaker.model.AppInstanceType? = builder.instanceType
    /**
     * The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
     */
    val lifecycleConfigArn: kotlin.String? = builder.lifecycleConfigArn
    /**
     * The ARN of the SageMaker image that the image version belongs to.
     */
    val sageMakerImageArn: kotlin.String? = builder.sageMakerImageArn
    /**
     * The ARN of the image version created on the instance.
     */
    val sageMakerImageVersionArn: kotlin.String? = builder.sageMakerImageVersionArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ResourceSpec = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceSpec(")
        append("instanceType=$instanceType,")
        append("lifecycleConfigArn=$lifecycleConfigArn,")
        append("sageMakerImageArn=$sageMakerImageArn,")
        append("sageMakerImageVersionArn=$sageMakerImageVersionArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceType?.hashCode() ?: 0
        result = 31 * result + (lifecycleConfigArn?.hashCode() ?: 0)
        result = 31 * result + (sageMakerImageArn?.hashCode() ?: 0)
        result = 31 * result + (sageMakerImageVersionArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceSpec

        if (instanceType != other.instanceType) return false
        if (lifecycleConfigArn != other.lifecycleConfigArn) return false
        if (sageMakerImageArn != other.sageMakerImageArn) return false
        if (sageMakerImageVersionArn != other.sageMakerImageVersionArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ResourceSpec = Builder(this).apply(block).build()

    class Builder {
        /**
         * The instance type that the image version runs on.
         *
         * JupyterServer Apps only support the `system` value. KernelGateway Apps do not support the `system` value, but support all other values for available instance types.
         */
        var instanceType: aws.sdk.kotlin.services.sagemaker.model.AppInstanceType? = null
        /**
         * The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
         */
        var lifecycleConfigArn: kotlin.String? = null
        /**
         * The ARN of the SageMaker image that the image version belongs to.
         */
        var sageMakerImageArn: kotlin.String? = null
        /**
         * The ARN of the image version created on the instance.
         */
        var sageMakerImageVersionArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ResourceSpec) : this() {
            this.instanceType = x.instanceType
            this.lifecycleConfigArn = x.lifecycleConfigArn
            this.sageMakerImageArn = x.sageMakerImageArn
            this.sageMakerImageVersionArn = x.sageMakerImageVersionArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ResourceSpec = ResourceSpec(this)
    }
}
