// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides summary information about a training job.
 */
class TrainingJobSummary private constructor(builder: Builder) {
    /**
     * A timestamp that shows when the training job was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Timestamp when the training job was last modified.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * A timestamp that shows when the training job ended. This field is set only if the training job has one of the terminal statuses (`Completed`, `Failed`, or `Stopped`).
     */
    val trainingEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.trainingEndTime
    /**
     * The Amazon Resource Name (ARN) of the training job.
     */
    val trainingJobArn: kotlin.String? = builder.trainingJobArn
    /**
     * The name of the training job that you want a summary for.
     */
    val trainingJobName: kotlin.String? = builder.trainingJobName
    /**
     * The status of the training job.
     */
    val trainingJobStatus: aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatus? = builder.trainingJobStatus

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.TrainingJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrainingJobSummary(")
        append("creationTime=$creationTime,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("trainingEndTime=$trainingEndTime,")
        append("trainingJobArn=$trainingJobArn,")
        append("trainingJobName=$trainingJobName,")
        append("trainingJobStatus=$trainingJobStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (trainingEndTime?.hashCode() ?: 0)
        result = 31 * result + (trainingJobArn?.hashCode() ?: 0)
        result = 31 * result + (trainingJobName?.hashCode() ?: 0)
        result = 31 * result + (trainingJobStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrainingJobSummary

        if (creationTime != other.creationTime) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (trainingEndTime != other.trainingEndTime) return false
        if (trainingJobArn != other.trainingJobArn) return false
        if (trainingJobName != other.trainingJobName) return false
        if (trainingJobStatus != other.trainingJobStatus) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.TrainingJobSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * A timestamp that shows when the training job was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Timestamp when the training job was last modified.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A timestamp that shows when the training job ended. This field is set only if the training job has one of the terminal statuses (`Completed`, `Failed`, or `Stopped`).
         */
        var trainingEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the training job.
         */
        var trainingJobArn: kotlin.String? = null
        /**
         * The name of the training job that you want a summary for.
         */
        var trainingJobName: kotlin.String? = null
        /**
         * The status of the training job.
         */
        var trainingJobStatus: aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.TrainingJobSummary) : this() {
            this.creationTime = x.creationTime
            this.lastModifiedTime = x.lastModifiedTime
            this.trainingEndTime = x.trainingEndTime
            this.trainingJobArn = x.trainingJobArn
            this.trainingJobName = x.trainingJobName
            this.trainingJobStatus = x.trainingJobStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.TrainingJobSummary = TrainingJobSummary(this)
    }
}
