// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides a summary of a transform job. Multiple `TransformJobSummary` objects are returned as a list after in response to a ListTransformJobs call.
 */
class TransformJobSummary private constructor(builder: Builder) {
    /**
     * A timestamp that shows when the transform Job was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * If the transform job failed, the reason it failed.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * Indicates when the transform job was last modified.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * Indicates when the transform job ends on compute instances. For successful jobs and stopped jobs, this is the exact time recorded after the results are uploaded. For failed jobs, this is when Amazon SageMaker detected that the job failed.
     */
    val transformEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.transformEndTime
    /**
     * The Amazon Resource Name (ARN) of the transform job.
     */
    val transformJobArn: kotlin.String? = builder.transformJobArn
    /**
     * The name of the transform job.
     */
    val transformJobName: kotlin.String? = builder.transformJobName
    /**
     * The status of the transform job.
     */
    val transformJobStatus: aws.sdk.kotlin.services.sagemaker.model.TransformJobStatus? = builder.transformJobStatus

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.TransformJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TransformJobSummary(")
        append("creationTime=$creationTime,")
        append("failureReason=$failureReason,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("transformEndTime=$transformEndTime,")
        append("transformJobArn=$transformJobArn,")
        append("transformJobName=$transformJobName,")
        append("transformJobStatus=$transformJobStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (transformEndTime?.hashCode() ?: 0)
        result = 31 * result + (transformJobArn?.hashCode() ?: 0)
        result = 31 * result + (transformJobName?.hashCode() ?: 0)
        result = 31 * result + (transformJobStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TransformJobSummary

        if (creationTime != other.creationTime) return false
        if (failureReason != other.failureReason) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (transformEndTime != other.transformEndTime) return false
        if (transformJobArn != other.transformJobArn) return false
        if (transformJobName != other.transformJobName) return false
        if (transformJobStatus != other.transformJobStatus) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.TransformJobSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * A timestamp that shows when the transform Job was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If the transform job failed, the reason it failed.
         */
        var failureReason: kotlin.String? = null
        /**
         * Indicates when the transform job was last modified.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates when the transform job ends on compute instances. For successful jobs and stopped jobs, this is the exact time recorded after the results are uploaded. For failed jobs, this is when Amazon SageMaker detected that the job failed.
         */
        var transformEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the transform job.
         */
        var transformJobArn: kotlin.String? = null
        /**
         * The name of the transform job.
         */
        var transformJobName: kotlin.String? = null
        /**
         * The status of the transform job.
         */
        var transformJobStatus: aws.sdk.kotlin.services.sagemaker.model.TransformJobStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.TransformJobSummary) : this() {
            this.creationTime = x.creationTime
            this.failureReason = x.failureReason
            this.lastModifiedTime = x.lastModifiedTime
            this.transformEndTime = x.transformEndTime
            this.transformJobArn = x.transformJobArn
            this.transformJobName = x.transformJobName
            this.transformJobStatus = x.transformJobStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.TransformJobSummary = TransformJobSummary(this)
    }
}
