// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Represents an input or output artifact of a trial component. You specify `TrialComponentArtifact` as part of the `InputArtifacts` and `OutputArtifacts` parameters in the CreateTrialComponent request.
 *
 * Examples of input artifacts are datasets, algorithms, hyperparameters, source code, and instance types. Examples of output artifacts are metrics, snapshots, logs, and images.
 */
class TrialComponentArtifact private constructor(builder: Builder) {
    /**
     * The media type of the artifact, which indicates the type of data in the artifact file. The media type consists of a *type* and a *subtype* concatenated with a slash (/) character, for example, text/csv, image/jpeg, and s3/uri. The type specifies the category of the media. The subtype specifies the kind of data.
     */
    val mediaType: kotlin.String? = builder.mediaType
    /**
     * The location of the artifact.
     */
    val value: kotlin.String? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.TrialComponentArtifact = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrialComponentArtifact(")
        append("mediaType=$mediaType,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = mediaType?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrialComponentArtifact

        if (mediaType != other.mediaType) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.TrialComponentArtifact = Builder(this).apply(block).build()

    class Builder {
        /**
         * The media type of the artifact, which indicates the type of data in the artifact file. The media type consists of a *type* and a *subtype* concatenated with a slash (/) character, for example, text/csv, image/jpeg, and s3/uri. The type specifies the category of the media. The subtype specifies the kind of data.
         */
        var mediaType: kotlin.String? = null
        /**
         * The location of the artifact.
         */
        var value: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.TrialComponentArtifact) : this() {
            this.mediaType = x.mediaType
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.TrialComponentArtifact = TrialComponentArtifact(this)
    }
}
