// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



class UpdateWorkteamRequest private constructor(builder: Builder) {
    /**
     * An updated description for the work team.
     */
    val description: kotlin.String? = builder.description
    /**
     * A list of `MemberDefinition` objects that contains objects that identify the workers that make up the work team.
     *
     * Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `CognitoMemberDefinition`. For workforces created using your own OIDC identity provider (IdP) use `OidcMemberDefinition`. You should not provide input for both of these parameters in a single request.
     *
     * For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito *user groups* within the user pool used to create a workforce. All of the `CognitoMemberDefinition` objects that make up the member definition must have the same `ClientId` and `UserPool` values. To add a Amazon Cognito user group to an existing worker pool, see Adding groups to a User Pool. For more information about user pools, see [Amazon Cognito User Pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html).
     *
     * For workforces created using your own OIDC IdP, specify the user groups that you want to include in your private work team in `OidcMemberDefinition` by listing those groups in `Groups`. Be aware that user groups that are already in the work team must also be listed in `Groups` when you make this request to remain on the work team. If you do not include these user groups, they will no longer be associated with the work team you update.
     */
    val memberDefinitions: List<MemberDefinition>? = builder.memberDefinitions
    /**
     * Configures SNS topic notifications for available or expiring work items
     */
    val notificationConfiguration: aws.sdk.kotlin.services.sagemaker.model.NotificationConfiguration? = builder.notificationConfiguration
    /**
     * The name of the work team to update.
     */
    val workteamName: kotlin.String? = builder.workteamName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.UpdateWorkteamRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateWorkteamRequest(")
        append("description=$description,")
        append("memberDefinitions=$memberDefinitions,")
        append("notificationConfiguration=$notificationConfiguration,")
        append("workteamName=$workteamName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (memberDefinitions?.hashCode() ?: 0)
        result = 31 * result + (notificationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (workteamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateWorkteamRequest

        if (description != other.description) return false
        if (memberDefinitions != other.memberDefinitions) return false
        if (notificationConfiguration != other.notificationConfiguration) return false
        if (workteamName != other.workteamName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.UpdateWorkteamRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * An updated description for the work team.
         */
        var description: kotlin.String? = null
        /**
         * A list of `MemberDefinition` objects that contains objects that identify the workers that make up the work team.
         *
         * Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `CognitoMemberDefinition`. For workforces created using your own OIDC identity provider (IdP) use `OidcMemberDefinition`. You should not provide input for both of these parameters in a single request.
         *
         * For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito *user groups* within the user pool used to create a workforce. All of the `CognitoMemberDefinition` objects that make up the member definition must have the same `ClientId` and `UserPool` values. To add a Amazon Cognito user group to an existing worker pool, see Adding groups to a User Pool. For more information about user pools, see [Amazon Cognito User Pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html).
         *
         * For workforces created using your own OIDC IdP, specify the user groups that you want to include in your private work team in `OidcMemberDefinition` by listing those groups in `Groups`. Be aware that user groups that are already in the work team must also be listed in `Groups` when you make this request to remain on the work team. If you do not include these user groups, they will no longer be associated with the work team you update.
         */
        var memberDefinitions: List<MemberDefinition>? = null
        /**
         * Configures SNS topic notifications for available or expiring work items
         */
        var notificationConfiguration: aws.sdk.kotlin.services.sagemaker.model.NotificationConfiguration? = null
        /**
         * The name of the work team to update.
         */
        var workteamName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.UpdateWorkteamRequest) : this() {
            this.description = x.description
            this.memberDefinitions = x.memberDefinitions
            this.notificationConfiguration = x.notificationConfiguration
            this.workteamName = x.workteamName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.UpdateWorkteamRequest = UpdateWorkteamRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.NotificationConfiguration] inside the given [block]
         */
        fun notificationConfiguration(block: aws.sdk.kotlin.services.sagemaker.model.NotificationConfiguration.Builder.() -> kotlin.Unit) {
            this.notificationConfiguration = aws.sdk.kotlin.services.sagemaker.model.NotificationConfiguration.invoke(block)
        }
    }
}
