// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.services.sagemaker.model.AppNetworkAccessType
import aws.sdk.kotlin.services.sagemaker.model.AppSecurityGroupManagement
import aws.sdk.kotlin.services.sagemaker.model.AuthMode
import aws.sdk.kotlin.services.sagemaker.model.CreateDomainRequest
import aws.sdk.kotlin.services.sagemaker.model.DomainSettings
import aws.sdk.kotlin.services.sagemaker.model.Tag
import aws.sdk.kotlin.services.sagemaker.model.UserSettings
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDomainOperationSerializer: HttpSerialize<CreateDomainRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateDomainRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCreateDomainOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCreateDomainOperationBody(context: ExecutionContext, input: CreateDomainRequest): ByteArray {
    val serializer = JsonSerializer()
    val APPNETWORKACCESSTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AppNetworkAccessType"))
    val APPSECURITYGROUPMANAGEMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AppSecurityGroupManagement"))
    val AUTHMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AuthMode"))
    val DEFAULTUSERSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DefaultUserSettings"))
    val DOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainName"))
    val DOMAINSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DomainSettings"))
    val HOMEEFSFILESYSTEMKMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HomeEfsFileSystemKmsKeyId"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyId"))
    val SUBNETIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SubnetIds"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val VPCID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VpcId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPNETWORKACCESSTYPE_DESCRIPTOR)
        field(APPSECURITYGROUPMANAGEMENT_DESCRIPTOR)
        field(AUTHMODE_DESCRIPTOR)
        field(DEFAULTUSERSETTINGS_DESCRIPTOR)
        field(DOMAINNAME_DESCRIPTOR)
        field(DOMAINSETTINGS_DESCRIPTOR)
        field(HOMEEFSFILESYSTEMKMSKEYID_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(SUBNETIDS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VPCID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.appNetworkAccessType?.let { field(APPNETWORKACCESSTYPE_DESCRIPTOR, it.value) }
        input.appSecurityGroupManagement?.let { field(APPSECURITYGROUPMANAGEMENT_DESCRIPTOR, it.value) }
        input.authMode?.let { field(AUTHMODE_DESCRIPTOR, it.value) }
        input.defaultUserSettings?.let { field(DEFAULTUSERSETTINGS_DESCRIPTOR, it, ::serializeUserSettingsDocument) }
        input.domainName?.let { field(DOMAINNAME_DESCRIPTOR, it) }
        input.domainSettings?.let { field(DOMAINSETTINGS_DESCRIPTOR, it, ::serializeDomainSettingsDocument) }
        input.homeEfsFileSystemKmsKeyId?.let { field(HOMEEFSFILESYSTEMKMSKEYID_DESCRIPTOR, it) }
        input.kmsKeyId?.let { field(KMSKEYID_DESCRIPTOR, it) }
        if (input.subnetIds != null) {
            listField(SUBNETIDS_DESCRIPTOR) {
                for (el0 in input.subnetIds) {
                    serializeString(el0)
                }
            }
        }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.vpcId?.let { field(VPCID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
