// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.CreateHumanTaskUiResponse
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateHumanTaskUiOperationDeserializer: HttpDeserialize<CreateHumanTaskUiResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateHumanTaskUiResponse {
        if (!response.status.isSuccess()) {
            throwCreateHumanTaskUiError(context, response)
        }
        val builder = CreateHumanTaskUiResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateHumanTaskUiOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateHumanTaskUiError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceInUse" -> ResourceInUseDeserializer().deserialize(context, wrappedResponse)
        "ResourceLimitExceeded" -> ResourceLimitExceededDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateHumanTaskUiOperationBody(builder: CreateHumanTaskUiResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HUMANTASKUIARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HumanTaskUiArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HUMANTASKUIARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HUMANTASKUIARN_DESCRIPTOR.index -> builder.humanTaskUiArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
