// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.services.sagemaker.model.AppSpecification
import aws.sdk.kotlin.services.sagemaker.model.CreateProcessingJobRequest
import aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig
import aws.sdk.kotlin.services.sagemaker.model.NetworkConfig
import aws.sdk.kotlin.services.sagemaker.model.ProcessingInput
import aws.sdk.kotlin.services.sagemaker.model.ProcessingOutputConfig
import aws.sdk.kotlin.services.sagemaker.model.ProcessingResources
import aws.sdk.kotlin.services.sagemaker.model.ProcessingStoppingCondition
import aws.sdk.kotlin.services.sagemaker.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateProcessingJobOperationSerializer: HttpSerialize<CreateProcessingJobRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateProcessingJobRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCreateProcessingJobOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCreateProcessingJobOperationBody(context: ExecutionContext, input: CreateProcessingJobRequest): ByteArray {
    val serializer = JsonSerializer()
    val APPSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AppSpecification"))
    val ENVIRONMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Environment"))
    val EXPERIMENTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExperimentConfig"))
    val NETWORKCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("NetworkConfig"))
    val PROCESSINGINPUTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProcessingInputs"))
    val PROCESSINGJOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProcessingJobName"))
    val PROCESSINGOUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProcessingOutputConfig"))
    val PROCESSINGRESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProcessingResources"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val STOPPINGCONDITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("StoppingCondition"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPSPECIFICATION_DESCRIPTOR)
        field(ENVIRONMENT_DESCRIPTOR)
        field(EXPERIMENTCONFIG_DESCRIPTOR)
        field(NETWORKCONFIG_DESCRIPTOR)
        field(PROCESSINGINPUTS_DESCRIPTOR)
        field(PROCESSINGJOBNAME_DESCRIPTOR)
        field(PROCESSINGOUTPUTCONFIG_DESCRIPTOR)
        field(PROCESSINGRESOURCES_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STOPPINGCONDITION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.appSpecification?.let { field(APPSPECIFICATION_DESCRIPTOR, it, ::serializeAppSpecificationDocument) }
        if (input.environment != null) {
            mapField(ENVIRONMENT_DESCRIPTOR) {
                input.environment.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.experimentConfig?.let { field(EXPERIMENTCONFIG_DESCRIPTOR, it, ::serializeExperimentConfigDocument) }
        input.networkConfig?.let { field(NETWORKCONFIG_DESCRIPTOR, it, ::serializeNetworkConfigDocument) }
        if (input.processingInputs != null) {
            listField(PROCESSINGINPUTS_DESCRIPTOR) {
                for (el0 in input.processingInputs) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeProcessingInputDocument))
                }
            }
        }
        input.processingJobName?.let { field(PROCESSINGJOBNAME_DESCRIPTOR, it) }
        input.processingOutputConfig?.let { field(PROCESSINGOUTPUTCONFIG_DESCRIPTOR, it, ::serializeProcessingOutputConfigDocument) }
        input.processingResources?.let { field(PROCESSINGRESOURCES_DESCRIPTOR, it, ::serializeProcessingResourcesDocument) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        input.stoppingCondition?.let { field(STOPPINGCONDITION_DESCRIPTOR, it, ::serializeProcessingStoppingConditionDocument) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
