// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.DescribeDeviceResponse
import aws.sdk.kotlin.services.sagemaker.model.EdgeModel
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeDeviceOperationDeserializer: HttpDeserialize<DescribeDeviceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeDeviceResponse {
        if (!response.status.isSuccess()) {
            throwDescribeDeviceError(context, response)
        }
        val builder = DescribeDeviceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeDeviceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeDeviceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDeviceOperationBody(builder: DescribeDeviceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AGENTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AgentVersion"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DEVICEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeviceArn"))
    val DEVICEFLEETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeviceFleetName"))
    val DEVICENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeviceName"))
    val IOTTHINGNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IotThingName"))
    val LATESTHEARTBEAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LatestHeartbeat"))
    val MAXMODELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxModels"))
    val MODELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Models"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val REGISTRATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("RegistrationTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGENTVERSION_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DEVICEARN_DESCRIPTOR)
        field(DEVICEFLEETNAME_DESCRIPTOR)
        field(DEVICENAME_DESCRIPTOR)
        field(IOTTHINGNAME_DESCRIPTOR)
        field(LATESTHEARTBEAT_DESCRIPTOR)
        field(MAXMODELS_DESCRIPTOR)
        field(MODELS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(REGISTRATIONTIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AGENTVERSION_DESCRIPTOR.index -> builder.agentVersion = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DEVICEARN_DESCRIPTOR.index -> builder.deviceArn = deserializeString()
                DEVICEFLEETNAME_DESCRIPTOR.index -> builder.deviceFleetName = deserializeString()
                DEVICENAME_DESCRIPTOR.index -> builder.deviceName = deserializeString()
                IOTTHINGNAME_DESCRIPTOR.index -> builder.iotThingName = deserializeString()
                LATESTHEARTBEAT_DESCRIPTOR.index -> builder.latestHeartbeat = deserializeString().let { Instant.fromEpochSeconds(it) }
                MAXMODELS_DESCRIPTOR.index -> builder.maxModels = deserializeInt()
                MODELS_DESCRIPTOR.index -> builder.models =
                    deserializer.deserializeList(MODELS_DESCRIPTOR) {
                        val col0 = mutableListOf<EdgeModel>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEdgeModelDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                REGISTRATIONTIME_DESCRIPTOR.index -> builder.registrationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
